/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.auth.controller;

import com.ruoyi.auth.form.LoginBody;
import com.ruoyi.auth.form.RegisterBody;
import com.ruoyi.auth.service.SysLoginService;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.utils.JwtUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.auth.AuthUtil;
import com.ruoyi.common.security.service.TokenService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.model.LoginUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6388\u6743\u63a5\u53e3"})
@RestController
public class TokenController {
    @Autowired
    private TokenService tokenService;
    @Autowired
    private SysLoginService sysLoginService;

    @ApiOperation(value="\u767b\u5f55")
    @PostMapping(value={"login"})
    public R<?> login(@RequestBody LoginBody form) {
        LoginUser userInfo = this.sysLoginService.login(form.getUsername(), form.getPassword());
        return R.ok((Object)this.tokenService.createToken(userInfo));
    }

    @ApiOperation(value="\u6ce8\u9500")
    @DeleteMapping(value={"logout"})
    public R<?> logout(HttpServletRequest request) {
        String token = SecurityUtils.getToken((HttpServletRequest)request);
        if (StringUtils.isNotEmpty((String)token)) {
            String username = JwtUtils.getUserName((String)token);
            AuthUtil.logoutByToken((String)token);
            this.sysLoginService.logout(username);
        }
        return R.ok();
    }

    @ApiOperation(value="\u5237\u65b0token")
    @PostMapping(value={"refresh"})
    public R<?> refresh(HttpServletRequest request) {
        LoginUser loginUser = this.tokenService.getLoginUser(request);
        if (StringUtils.isNotNull((Object)loginUser)) {
            this.tokenService.refreshToken(loginUser);
            return R.ok();
        }
        return R.ok();
    }

    @ApiOperation(value="\u6ce8\u518c")
    @PostMapping(value={"register"})
    public R<?> register(@RequestBody RegisterBody registerBody) {
        this.sysLoginService.register(registerBody.getUsername(), registerBody.getPassword());
        return R.ok();
    }
}

