/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.auth.service;

import com.ruoyi.auth.service.SysRecordLogService;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.domain.SysUser;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysPasswordService {
    @Autowired
    private RedisService redisService;
    private int maxRetryCount = 5;
    private Long lockTime = 10L;
    @Autowired
    private SysRecordLogService recordLogService;

    private String getCacheKey(String username) {
        return "pwd_err_cnt:" + username;
    }

    public void validate(SysUser user, String password) {
        String username = user.getUserName();
        Integer retryCount = (Integer)this.redisService.getCacheObject(this.getCacheKey(username));
        if (retryCount == null) {
            retryCount = 0;
        }
        if (retryCount >= Integer.valueOf(this.maxRetryCount)) {
            String errMsg = String.format("\u5bc6\u7801\u8f93\u5165\u9519\u8bef%s\u6b21\uff0c\u5e10\u6237\u9501\u5b9a%s\u5206\u949f", this.maxRetryCount, this.lockTime);
            this.recordLogService.recordLogininfor(username, "Error", errMsg);
            throw new ServiceException(errMsg);
        }
        if (!this.matches(user, password)) {
            retryCount = retryCount + 1;
            this.recordLogService.recordLogininfor(username, "Error", String.format("\u5bc6\u7801\u8f93\u5165\u9519\u8bef%s\u6b21", retryCount));
            this.redisService.setCacheObject(this.getCacheKey(username), (Object)retryCount, this.lockTime, TimeUnit.MINUTES);
            throw new ServiceException("\u7528\u6237\u4e0d\u5b58\u5728/\u5bc6\u7801\u9519\u8bef");
        }
        this.clearLoginRecordCache(username);
    }

    public boolean matches(SysUser user, String rawPassword) {
        return SecurityUtils.matchesPassword((String)rawPassword, (String)user.getPassword());
    }

    public void clearLoginRecordCache(String loginName) {
        if (this.redisService.hasKey(this.getCacheKey(loginName)).booleanValue()) {
            this.redisService.deleteObject(this.getCacheKey(loginName));
        }
    }
}

