/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.controller.PaymentApplyController;
import com.ruoyi.dto.FlowNoticeEvent;
import com.ruoyi.dto.PaymentApplyBroadbandExcel;
import com.ruoyi.dto.PaymentApplyDailyExcel;
import com.ruoyi.dto.PaymentApplyExcel;
import com.ruoyi.dto.PaymentApplyMaterialExcel;
import com.ruoyi.dto.PaymentApplyPhoneExcel;
import com.ruoyi.dto.PaymentApplyQueryRequest;
import com.ruoyi.dto.PaymentApplyRequest;
import com.ruoyi.dto.WorkFlowCallBackVO;
import com.ruoyi.entity.PaymentApply;
import com.ruoyi.entity.PaymentApplyDetail;
import com.ruoyi.entity.PaymentApplyDetailThree;
import com.ruoyi.entity.PaymentApplyDetailTwo;
import com.ruoyi.feignClientApi.MaterialNameListVO;
import com.ruoyi.feignClientApi.MaterialsApplicationMaterialOrderClient;
import com.ruoyi.service.IPaymentApplyDetailService;
import com.ruoyi.service.IPaymentApplyDetailThreeService;
import com.ruoyi.service.IPaymentApplyDetailTwoService;
import com.ruoyi.service.IPaymentApplyService;
import com.ruoyi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u4ed8\u6b3e\u7533\u8bf7"})
@RestController
@RequestMapping(value={"/financial-management/payment-apply"})
public class PaymentApplyController {
    private static final Logger log = LoggerFactory.getLogger(PaymentApplyController.class);
    @Resource
    private IPaymentApplyService paymentApplyService;
    @Resource
    private MaterialsApplicationMaterialOrderClient materialsApplicationMaterialOrderClient;
    @Resource
    private IPaymentApplyDetailService paymentApplyDetailService;
    @Resource
    private IPaymentApplyDetailTwoService paymentApplyDetailTwoService;
    @Resource
    private IPaymentApplyDetailThreeService paymentApplyDetailThreeService;

    @ApiOperation(value="\u67e5\u8be2\u4ed8\u6b3e\u7533\u8bf7\u5206\u9875")
    @PostMapping(value={"/queryPaymentApplyPage"})
    public R<Page<PaymentApply>> queryPaymentApplyPage(@RequestBody PaymentApplyQueryRequest paymentApplyQueryRequest) {
        return R.ok((Object)this.paymentApplyService.queryPaymentApplyPage(paymentApplyQueryRequest));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/queryDetail"})
    public R<PaymentApplyRequest> queryDetail(@RequestParam(value="id") Long id) {
        return R.ok((Object)this.paymentApplyService.queryDetail(id));
    }

    @ApiOperation(value="\u6253\u5370")
    @PostMapping(value={"/print"})
    public R<Boolean> print(@RequestBody List<Long> id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.setSql("print_num = print_num +1")).in(PaymentApply::getId, id);
        return R.ok((Object)this.paymentApplyService.update((Wrapper)updateWrapper));
    }

    @ApiOperation(value="\u65b0\u5efa\u4ed8\u6b3e\u7533\u8bf7")
    @PostMapping(value={"/addPaymentApply"})
    public R<Boolean> addPaymentApply(@RequestBody PaymentApplyRequest paymentApply) {
        try {
            return R.ok((Object)this.paymentApplyService.addPaymentApply(paymentApply));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("PaymentApplyController-addPaymentApply:{}", (Object)JSON.toJSONString((Object)e));
            return R.failed((String)"\u4ed8\u6b3e\u7533\u8bf7\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u67e5\u770b\u4e0a\u7ea7\u9886\u5bfc")
    @GetMapping(value={"/leaderByPaymentApply"})
    public R<String> leaderByPaymentApply(Long id) {
        return R.ok((Object)this.paymentApplyService.leaderByPaymentApply(id));
    }

    @ApiOperation(value="\u5de5\u4f5c\u6d41\u6284\u9001")
    @GetMapping(value={"/fwd"})
    public R<Boolean> fwd(Long id) {
        return R.ok((Object)this.paymentApplyService.fwd(id));
    }

    @ApiOperation(value="\u8865\u7968\u7533\u8bf7")
    @PostMapping(value={"/invoiceFile"})
    public R<Boolean> invoiceFile(@RequestBody PaymentApply paymentApply) {
        return R.ok((Object)this.paymentApplyService.invoiceFile(paymentApply));
    }

    @PostMapping(value={"/downPaymentApplyExcel"})
    @ApiOperation(value="\u4ed8\u6b3e\u7533\u8bf7-\u5bfc\u51fa")
    public void downPaymentApplyExcel(@RequestBody PaymentApplyQueryRequest paymentApplyQueryRequest, HttpServletResponse response) {
        try {
            List packageGroupManagerExcelList = this.paymentApplyService.downData2Excel(paymentApplyQueryRequest);
            ArrayList sheetsList = new ArrayList();
            List<String> paymentTypes = Arrays.asList("\u624b\u673a\u5145\u503c", "\u5bbd\u5e26\u4ed8\u6b3e", "\u7269\u8d44\u91c7\u8d2d", "\u65e5\u5e38\u4ed8\u6b3e");
            for (String paymentType : paymentTypes) {
                List excels = packageGroupManagerExcelList.stream().filter(f -> paymentType.equals(f.getPaymentType())).collect(Collectors.toList());
                List ids = excels.stream().map(PaymentApplyExcel::getId).collect(Collectors.toList());
                HashMap<String, Object> exportMap = new HashMap<String, Object>();
                switch (paymentType) {
                    case "\u624b\u673a\u5145\u503c": {
                        List collect;
                        List paymentApplyDetailTwo;
                        ArrayList<Object> dataList = new ArrayList<Object>();
                        if (ObjectUtil.isNotEmpty(ids)) {
                            paymentApplyDetailTwo = this.paymentApplyDetailTwoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().in(PaymentApplyDetailTwo::getPaymentApplyId, ids)).eq(PaymentApplyDetailTwo::getIsDeleted, (Object)0));
                            for (PaymentApplyExcel excel : excels) {
                                collect = paymentApplyDetailTwo.stream().filter(f -> f.getPaymentApplyId().equals(excel.getId())).collect(Collectors.toList());
                                for (PaymentApplyDetailTwo applyDetailTwo : collect) {
                                    PaymentApplyPhoneExcel phoneExcel = new PaymentApplyPhoneExcel();
                                    BeanUtils.copyProperties((Object)excel, (Object)phoneExcel);
                                    BeanUtils.copyProperties((Object)applyDetailTwo, (Object)phoneExcel);
                                    dataList.add(phoneExcel);
                                }
                            }
                        }
                        exportMap.put("data", dataList);
                        exportMap.put("entity", PaymentApplyPhoneExcel.class);
                        break;
                    }
                    case "\u5bbd\u5e26\u4ed8\u6b3e": {
                        List collect;
                        List paymentApplyDetailTwo;
                        ArrayList<Object> dataList = new ArrayList();
                        if (ObjectUtil.isNotEmpty(ids)) {
                            paymentApplyDetailTwo = this.paymentApplyDetailTwoService.list((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().in(PaymentApplyDetailTwo::getPaymentApplyId, ids)).eq(PaymentApplyDetailTwo::getIsDeleted, (Object)0));
                            for (PaymentApplyExcel excel : excels) {
                                collect = paymentApplyDetailTwo.stream().filter(f -> f.getPaymentApplyId().equals(excel.getId())).collect(Collectors.toList());
                                for (PaymentApplyDetailTwo applyDetailTwo : collect) {
                                    PaymentApplyBroadbandExcel broadbandExcel = new PaymentApplyBroadbandExcel();
                                    BeanUtils.copyProperties((Object)excel, (Object)broadbandExcel);
                                    BeanUtils.copyProperties((Object)applyDetailTwo, (Object)broadbandExcel);
                                    dataList.add(broadbandExcel);
                                }
                            }
                        }
                        exportMap.put("entity", PaymentApplyBroadbandExcel.class);
                        exportMap.put("data", dataList);
                        break;
                    }
                    case "\u7269\u8d44\u91c7\u8d2d": {
                        List collect;
                        ArrayList<Object> dataList = new ArrayList();
                        if (ObjectUtil.isNotEmpty(ids)) {
                            List paymentApplyDetailThreeList = this.paymentApplyDetailThreeService.list((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().in(PaymentApplyDetailThree::getPaymentApplyId, ids)).eq(PaymentApplyDetailThree::getIsDeleted, (Object)0));
                            for (PaymentApplyExcel excel : excels) {
                                collect = paymentApplyDetailThreeList.stream().filter(f -> f.getPaymentApplyId().equals(excel.getId())).collect(Collectors.toList());
                                for (PaymentApplyDetailThree applyDetail : collect) {
                                    PaymentApplyMaterialExcel materialExcel = new PaymentApplyMaterialExcel();
                                    BeanUtils.copyProperties((Object)excel, (Object)materialExcel);
                                    BeanUtils.copyProperties((Object)applyDetail, (Object)materialExcel);
                                    dataList.add(materialExcel);
                                }
                            }
                        }
                        exportMap.put("entity", PaymentApplyMaterialExcel.class);
                        exportMap.put("data", dataList);
                        break;
                    }
                    case "\u65e5\u5e38\u4ed8\u6b3e": {
                        List collect;
                        ArrayList<Object> dataList = new ArrayList();
                        if (ObjectUtil.isNotEmpty(ids)) {
                            List paymentApplyDetailList = this.paymentApplyDetailService.list((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().in(PaymentApplyDetail::getPaymentApplyId, ids)).eq(PaymentApplyDetail::getIsDeleted, (Object)0));
                            for (PaymentApplyExcel excel : excels) {
                                collect = paymentApplyDetailList.stream().filter(f -> f.getPaymentApplyId().equals(excel.getId())).collect(Collectors.toList());
                                for (PaymentApplyDetailThree applyDetail : collect) {
                                    PaymentApplyDailyExcel dailyExcel = new PaymentApplyDailyExcel();
                                    BeanUtils.copyProperties((Object)excel, (Object)dailyExcel);
                                    BeanUtils.copyProperties((Object)applyDetail, (Object)dailyExcel);
                                    dataList.add(dailyExcel);
                                }
                            }
                        }
                        exportMap.put("entity", PaymentApplyDailyExcel.class);
                        exportMap.put("data", dataList);
                    }
                }
                ExportParams exportParamsOne = new ExportParams("\u4ed8\u6b3e\u7533\u8bf7", paymentType, ExcelType.XSSF);
                exportMap.put("title", exportParamsOne);
                sheetsList.add(exportMap);
            }
            Workbook workbook = ExcelExportUtil.exportExcel(sheetsList, (ExcelType)ExcelType.XSSF);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u4ed8\u6b3e\u7533\u8bf7");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/workFlowCallBack"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03-\u7533\u8bf7")
    public R<String> workFlowCallBack(@RequestBody FlowNoticeEvent vo) {
        try {
            log.info("workFlowCallBack:" + JSON.toJSON((Object)vo));
            String event = vo.getEvent();
            String businessKey = vo.getBody().getBusinessKey();
            PaymentApply paymentApply = new PaymentApply();
            paymentApply.setId(Long.valueOf(businessKey));
            Map map = vo.getBody().getTaskVariables();
            String approveStatus = null;
            if (MapUtils.isNotEmpty((Map)map) && map.get("approveStatus") != null) {
                approveStatus = map.get("approveStatus").toString();
            }
            switch (1.$SwitchMap$com$ruoyi$dto$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)approveStatus, (CharSequence)"2")) break;
                    paymentApply.setState("3");
                    paymentApply.setRejectReason(org.apache.commons.lang3.StringUtils.replace((String)vo.getBody().getTaskComment(), (String)"_\u9a73\u56de\u8df3\u8f6c\u8282\u70b9", (String)""));
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 3: {
                    paymentApply.setState("2");
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 4: {
                    paymentApply.setState("1");
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 5: {
                    paymentApply.setState("4");
                    this.paymentApplyService.updateById((Object)paymentApply);
                }
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFlowCallBackRepair"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03-\u8865\u7968")
    public R<String> workFlowCallBackRepair(@RequestBody FlowNoticeEvent vo) {
        try {
            log.info("workFlowCallBackRepair:" + JSON.toJSON((Object)vo));
            String event = vo.getEvent();
            String businessKey = vo.getBody().getBusinessKey();
            PaymentApply paymentApply = new PaymentApply();
            paymentApply.setId(Long.valueOf(businessKey));
            Map map = vo.getBody().getTaskVariables();
            String approveStatus = null;
            if (MapUtils.isNotEmpty((Map)map) && map.get("approveStatus") != null) {
                approveStatus = map.get("approveStatus").toString();
            }
            switch (1.$SwitchMap$com$ruoyi$dto$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)approveStatus, (CharSequence)"2")) break;
                    paymentApply.setRepairState("3");
                    paymentApply.setRepairRejectReason(org.apache.commons.lang3.StringUtils.replace((String)vo.getBody().getTaskComment(), (String)"_\u9a73\u56de\u8df3\u8f6c\u8282\u70b9", (String)""));
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 3: {
                    paymentApply.setRepairState("2");
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 4: {
                    paymentApply.setRepairState("1");
                    paymentApply.setInvoiceFlag(Boolean.valueOf(false));
                    paymentApply.setInvoiceState("1");
                    this.paymentApplyService.updateById((Object)paymentApply);
                    break;
                }
                case 5: {
                    paymentApply.setRepairState("4");
                    this.paymentApplyService.updateById((Object)paymentApply);
                }
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate/{type}"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="type") Integer type) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u4ed8\u6b3e\u660e\u7ec6.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = null;
            switch (type) {
                case 1: {
                    classPathResource = new ClassPathResource("1.xls");
                    break;
                }
                case 2: {
                    classPathResource = new ClassPathResource("2.xls");
                    break;
                }
                case 3: {
                    classPathResource = new ClassPathResource("3.xls");
                    break;
                }
                case 4: {
                    classPathResource = new ClassPathResource("4.xls");
                }
            }
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/import/{type}"})
    @ApiOperation(value="\u4ed8\u6b3e\u660e\u7ec6\u5bfc\u5165")
    public R<Object> uniqueCodeStock(MultipartFile file, @PathVariable(value="type") Integer type) {
        try {
            ImportParams importParams = new ImportParams();
            importParams.setNeedVerify(true);
            switch (type) {
                case 1: 
                case 2: {
                    ExcelImportResult importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), PaymentApplyRequest.PayDetailTwo.class, (ImportParams)importParams);
                    return R.ok((Object)importResult.getList());
                }
                case 3: {
                    ExcelImportResult importResult3 = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), PaymentApplyRequest.PayDetailThree.class, (ImportParams)importParams);
                    List payDetailThrees = importResult3.getList();
                    List materialNameListVOList = (List)this.materialsApplicationMaterialOrderClient.getMaterialNameList().getData();
                    for (int i = 0; i < payDetailThrees.size(); ++i) {
                        if (StringUtils.isBlank((CharSequence)((PaymentApplyRequest.PayDetailThree)payDetailThrees.get(i)).getMaterialName())) {
                            return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u65e0\u6570\u636e"));
                        }
                        String[] materialName = ((PaymentApplyRequest.PayDetailThree)payDetailThrees.get(i)).getMaterialName().split(">>");
                        List<String> materialNames = Arrays.asList(materialName);
                        List materialList = materialNameListVOList;
                        for (int j = 0; j < materialNames.size(); ++j) {
                            int finalJ = j;
                            MaterialNameListVO materialNameListVO = materialList.stream().filter(f -> ((String)materialNames.get(finalJ)).equals(f.getMaterialName())).findFirst().orElse(null);
                            if (ObjectUtil.isEmpty((Object)materialNameListVO)) {
                                return R.failed((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u672a\u914d\u7f6e\u7cfb\u7edf\u6570\u636e"));
                            }
                            materialList = materialNameListVO.getMaterialNameListVOList();
                            if (j != materialNames.size() - 1) continue;
                            ((PaymentApplyRequest.PayDetailThree)payDetailThrees.get(i)).setMaterialCode(materialNameListVO.getMaterialId().toString());
                        }
                    }
                    return R.ok((Object)payDetailThrees);
                }
                case 4: {
                    ExcelImportResult importResult4 = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), PaymentApplyRequest.PayDetail.class, (ImportParams)importParams);
                    return R.ok((Object)importResult4.getList());
                }
            }
            return R.ok((Object)"\u5bfc\u5165\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

