/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.order;

import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.entity.order.Order;
import com.ruoyi.query.OrderQuery;
import com.ruoyi.service.order.OrderService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8ba2\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/order"})
public class OrderController {
    private static final Logger log = LoggerFactory.getLogger(OrderController.class);
    @Resource
    private OrderService orderService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u8ba2\u5355\u5217\u8868\u9875\u9762")
    public R<Page<Order>> getPage(@RequestBody OrderQuery orderQuery) {
        try {
            Page contractDTOListPage = this.orderService.getPageList(orderQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u8ba2\u5355-\u8be6\u60c5")
    public R<Order> getById(Long id) {
        try {
            Order detailVo = this.orderService.getDetails(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u8ba2\u5355-\u5220\u9664")
    public R<Boolean> delete(@PathVariable(value="id") Long id) {
        try {
            boolean b = this.orderService.removeById((Serializable)id);
            return R.ok((Object)b);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u8ba2\u5355")
    @PostMapping(value={"/export"})
    public R exportByCondition(@RequestBody OrderQuery OrderQuery2, HttpServletResponse response) {
        this.orderService.export(OrderQuery2, response);
        return R.ok((Object)"\u5bfc\u51fa\u8ba2\u5355\u6210\u529f");
    }
}

