/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.order;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.dto.FlowNoticeEvent;
import com.ruoyi.entity.order.RefunOrderExportVO;
import com.ruoyi.entity.order.RefundOrderDTO;
import com.ruoyi.query.RefundOrderQuery;
import com.ruoyi.service.order.RefundOrderService;
import com.ruoyi.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9000\u6b3e\u8ba2\u5355", tags={"\u9000\u6b3e\u8ba2\u5355"})
@RequestMapping(value={"/refundOrder"})
@RestController
public class RefundOrderController {
    private static final Logger log = LoggerFactory.getLogger(RefundOrderController.class);
    @Resource
    private RefundOrderService refundOrderService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u9000\u6b3e\u8ba2\u5355\u5217\u8868\u9875\u9762")
    public R<Page<RefundOrderDTO>> getPage(@RequestBody RefundOrderQuery refundOrderQuery) {
        try {
            Page contractDTOListPage = this.refundOrderService.getPage(refundOrderQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u9000\u6b3e\u8ba2\u5355")
    public void export(@RequestBody RefundOrderQuery refundOrderQuery, HttpServletResponse response) {
        try {
            List contractProjectList = this.refundOrderService.list(refundOrderQuery);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u9000\u6b3e\u8ba2\u5355", "\u9000\u6b3e\u8ba2\u5355", ExcelType.XSSF), RefunOrderExportVO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9000\u6b3e\u8ba2\u5355");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u9000\u6b3e\u8ba2\u5355-\u8be6\u60c5")
    public R<RefundOrderDTO> getById(Long id) {
        try {
            RefundOrderDTO detailVo = this.refundOrderService.getDetails(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFlowCallBackBoYu"})
    @ApiOperation(value="\u5de5\u4f5c\u6d41\u56de\u8c03")
    public void workFlowCallBack(@RequestBody FlowNoticeEvent vo) {
        try {
            this.refundOrderService.workFlowCallBackBoYu(vo);
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

