/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.feignClientApi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.feignClientApi.SystemClient;
import com.ruoyi.feignClientApi.SystemService;
import com.ruoyi.feignClientApi.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SystemServiceImpl
implements SystemService {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceImpl.class);
    @Resource
    private SystemClient systemClient;

    @Transactional(rollbackFor={Exception.class})
    public List<String> getUserIdsByRoleId(Integer roleId) {
        block5: {
            JSONObject jsonObject = null;
            try {
                jsonObject = this.systemClient.getUserIdsByRoleId(Integer.valueOf(1), Integer.valueOf(9999), roleId);
                if ("200".equals(jsonObject.getString("code"))) {
                    JSONArray rows = jsonObject.getJSONArray("rows");
                    List userInfos = JSON.parseArray((String)JSON.toJSONString((Object)rows), UserInfo.class);
                    if (ObjectUtil.isNotEmpty((Object)userInfos)) {
                        List collect = userInfos.stream().filter(f -> "0".equals(f.getStatus())).map(UserInfo::getUserId).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(collect)) {
                            return collect.stream().map(Objects::toString).collect(Collectors.toList());
                        }
                        return new ArrayList<String>();
                    }
                    break block5;
                }
                log.info("SystemServiceImpl-getUserIdsByRoleId:{}", (Object)JSON.toJSONString((Object)jsonObject));
                return new ArrayList<String>();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("SystemServiceImpl-getUserIdsByRoleId-err:{}", (Object)JSON.toJSONString(jsonObject));
            }
        }
        return new ArrayList<String>();
    }

    @Transactional(rollbackFor={Exception.class})
    public List<String> getUserListByDeptCascadeId(String companyId, String deptCascadeId) {
        block5: {
            JSONObject jsonObject = null;
            try {
                jsonObject = this.systemClient.getUserListByDeptCascadeId(Integer.valueOf(1), Integer.valueOf(9999), companyId, deptCascadeId);
                if ("200".equals(jsonObject.getString("code"))) {
                    JSONArray rows = jsonObject.getJSONArray("rows");
                    List userInfos = JSON.parseArray((String)JSON.toJSONString((Object)rows), UserInfo.class);
                    if (ObjectUtil.isNotEmpty((Object)userInfos)) {
                        List collect = userInfos.stream().filter(f -> "0".equals(f.getStatus())).map(UserInfo::getUserId).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(collect)) {
                            return collect.stream().map(Objects::toString).collect(Collectors.toList());
                        }
                        return new ArrayList<String>();
                    }
                    break block5;
                }
                log.info("SystemServiceImpl-getUserListByDeptCascadeId:{}", (Object)JSON.toJSONString((Object)jsonObject));
                return new ArrayList<String>();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("SystemServiceImpl-getUserListByDeptCascadeId-err:{}", (Object)JSON.toJSONString(jsonObject));
            }
        }
        return new ArrayList<String>();
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<String, String> getDictMap(String dictType) {
        HashMap<String, String> map;
        block4: {
            map = new HashMap<String, String>();
            JSONObject dictList = null;
            try {
                dictList = this.systemClient.getDictListByDictType(Integer.valueOf(1), Integer.valueOf(9999), dictType);
                if ("200".equals(dictList.getString("code"))) {
                    JSONArray rows = dictList.getJSONArray("rows");
                    for (int i = 0; i < rows.size(); ++i) {
                        JSONObject jsonObject = rows.getJSONObject(i);
                        map.put(jsonObject.getString("dictValue"), jsonObject.getString("dictLabel"));
                    }
                    break block4;
                }
                log.info("SystemServiceImpl-getDictMap:{}", (Object)JSON.toJSONString((Object)dictList));
                return map;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.info("SystemServiceImpl-getDictMap-err:{}", (Object)JSON.toJSONString(dictList));
            }
        }
        return map;
    }
}

