/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.feignClientApi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ruoyi.dto.ProcessDTO;
import com.ruoyi.feignClientApi.JsonRootDTO;
import com.ruoyi.feignClientApi.WorkFlowClient;
import com.ruoyi.feignClientApi.WorkFlowService;
import com.ruoyi.util.Result;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceImpl.class);
    @Resource
    private WorkFlowClient workFlowClient;

    @Transactional(rollbackFor={Exception.class})
    public String startProcess(ProcessDTO processDTO) throws Exception {
        log.info("WorkFlowServiceImpl-startProcess:Parameter:{}", (Object)processDTO);
        JSONObject jsonObject = this.workFlowClient.startProcessInstance(processDTO);
        log.info("WorkFlowServiceImpl-startProcess:Result:{}", (Object)jsonObject);
        String code = jsonObject.getString("code");
        if (!"0".equals(code)) {
            throw new Exception(jsonObject.getString("msg"));
        }
        JSONObject data = jsonObject.getJSONObject("data");
        return data.getString("id");
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject pushUndoTask(JsonRootDTO jsonRootDTO) {
        log.info("WorkFlowServiceImpl-pushUndoTask:Parameter:{}", (Object)jsonRootDTO);
        JSONObject jsonObject = this.workFlowClient.pushUndoTask(jsonRootDTO);
        log.info("WorkFlowServiceImpl-pushUndoTask:Result:{}", (Object)jsonObject);
        return jsonObject;
    }

    @Transactional(rollbackFor={Exception.class})
    public JSONObject doCancel(String processInstanceId) {
        log.info("WorkFlowServiceImpl-doCancel:Parameter:{}", (Object)processInstanceId);
        JSONObject jsonObject = this.workFlowClient.doCancel(processInstanceId);
        log.info("WorkFlowServiceImpl-doCancel:Result:{}", (Object)jsonObject);
        return jsonObject;
    }

    public Result<JSONObject> instanceInfoByKey(String processDefinitionKey, String businessKey) {
        log.info("WorkFlowServiceImpl-instanceInfoByKey:Parameter:{},{}", (Object)processDefinitionKey, (Object)businessKey);
        Result result = this.workFlowClient.instanceInfoByKey(processDefinitionKey, businessKey);
        log.info("WorkFlowServiceImpl-instanceInfoByKey:Result:{}", (Object)result);
        return result;
    }

    public JSONObject termination(String taskId) {
        log.info("WorkFlowServiceImpl-termination:Parameter:{}", (Object)taskId);
        JSONObject jsonObject = this.workFlowClient.termination(taskId);
        log.info("WorkFlowServiceImpl-termination:Result:{}", (Object)jsonObject);
        return jsonObject;
    }
}

