/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.inboyu.iot.comm;

import com.alibaba.fastjson.JSON;
import com.ruoyi.inboyu.iot.ClientConfig;
import com.ruoyi.inboyu.iot.IotException;
import com.ruoyi.inboyu.iot.model.response.BaseResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class ServiceClient {
    private CloseableHttpClient httpClient;
    private ClientConfig clientConfig;

    public ServiceClient(ClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.httpClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        PoolingHttpClientConnectionManager manager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(this.clientConfig.getMaxConnections()).setMaxConnTotal(this.clientConfig.getMaxConnections()).build();
        RequestConfig config = RequestConfig.custom().setConnectTimeout(Timeout.of((long)this.clientConfig.getConnectionTimeout(), (TimeUnit)TimeUnit.SECONDS)).setConnectionRequestTimeout(Timeout.of((long)this.clientConfig.getConnectionRequestTimeout(), (TimeUnit)TimeUnit.SECONDS)).setResponseTimeout(Timeout.of((long)this.clientConfig.getResponseTimeout(), (TimeUnit)TimeUnit.SECONDS)).build();
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)manager).setUserAgent(this.clientConfig.getUserAgent()).setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResponse sendPostRequest(String uri, String requestMsg) {
        BaseResponse result;
        block16: {
            result = null;
            HttpPost httpPost = new HttpPost(uri);
            StringEntity entity = new StringEntity(requestMsg, StandardCharsets.UTF_8);
            httpPost.setHeader("Content-Type", (Object)"application/json");
            httpPost.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = null;
            try {
                response = this.httpClient.execute((ClassicHttpRequest)httpPost);
                if (null == response) {
                    throw new IotException("\u8bf7\u6c42\u5931\u8d25\uff0c\u54cd\u5e94\u4e3a\u7a7a");
                }
                if (200 != response.getCode()) {
                    throw new IotException("\u8bf7\u6c42\u5931\u8d25,response:" + response.toString());
                }
                String jsonStr = EntityUtils.toString((HttpEntity)response.getEntity());
                result = (BaseResponse)JSON.parseObject((String)jsonStr, BaseResponse.class);
                try {
                    response.close();
                }
                catch (IOException e) {
                    throw new IotException("\u5173\u95edresponse\u5f02\u5e38", (Throwable)e);
                }
            }
            catch (Exception e) {
                if (null == response) break block16;
                try {
                    response.close();
                }
                catch (IOException e2) {
                    throw new IotException("\u5173\u95edresponse\u5f02\u5e38", (Throwable)e2);
                }
            }
            finally {
                if (null != response) {
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        throw new IotException("\u5173\u95edresponse\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public void shutdown() {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new IotException("httpclient\u5173\u95ed\u5f02\u5e38", (Throwable)e);
        }
    }
}

