/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.portal;

import com.ruoyi.portal.PortalException;
import com.ruoyi.portal.packet.PortalPacket;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.apache.mina.core.buffer.IoBuffer;
import org.springframework.stereotype.Component;

@Component
public class PortalClient {
    private int timeout = 5000;

    public PortalPacket sendToAc(PortalPacket request, String ipaddr, int port) throws PortalException {
        DatagramSocket sock = null;
        try {
            sock = new DatagramSocket();
            IoBuffer buff = request.encodePacket();
            byte[] data = new byte[buff.remaining()];
            buff.get(data);
            DatagramPacket packetOut = new DatagramPacket(data, data.length, new InetSocketAddress(ipaddr, port));
            DatagramPacket packetIn = new DatagramPacket(new byte[1024], 1024);
            sock.setSoTimeout(this.timeout);
            sock.send(packetOut);
            sock.receive(packetIn);
            PortalPacket resp = new PortalPacket(packetIn.getData());
            resp.checkResponseAuthenticator(request.getSecret(), request.getAuthenticator());
            return resp;
        }
        catch (SocketException e) {
            throw new PortalException("\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            throw new PortalException("IO\u5f02\u5e38", (Throwable)e);
        }
    }

    public void sendToAcNoReply(PortalPacket request, String ipaddr, int port) throws PortalException {
        try (DatagramSocket sock = new DatagramSocket();){
            IoBuffer buff = request.encodePacket();
            byte[] data = new byte[buff.remaining()];
            buff.get(data);
            DatagramPacket packetOut = new DatagramPacket(data, data.length, new InetSocketAddress(ipaddr, port));
            sock.setSoTimeout(this.timeout);
            sock.send(packetOut);
        }
        catch (SocketException e) {
            throw new PortalException("\u7f51\u7edc\u5f02\u5e38", (Throwable)e);
        }
        catch (IOException e) {
            throw new PortalException("IO\u5f02\u5e38", (Throwable)e);
        }
    }
}

