/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.portal;

import java.util.Collection;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidateUtil {
    private static final boolean DEFAULT_EMPTY_OK = false;
    private static final String DIGITS = "0123456789";
    public static final String LETTERS_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String LETTERS_LOWERCASE_DIGITS = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String LETTERS_UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LETTERS_UPPERCASE_DIGITS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    public static final String LETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String LETTERS_DIGITS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final String WHITE_SPACE = " \t\n\r";
    private static final String DECIMAL_POING_DELIMITER = ".";
    private static final String PHONE_NUMBER_DELIMITERS = "()- ";
    private static final String VALID_PHONE_CHARS_WORLD = "+0123456789()- ";
    private static final String VALID_MSISDN_CHARS = "0123456789";
    private static final int VALID_MSISDN_MAXLEN = 21;
    private static final int VALID_MSISDN_MINLEN = 11;
    private static final int[] DAYS_IN_MONTH = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static boolean isEqual(Object obj, Object obj2) {
        return obj == null ? obj2 == null : obj.equals(obj2);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return ValidateUtil.isEmpty((String)((String)obj));
        }
        return false;
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isNotEmpty(Collection<?> c) {
        return c != null && c.size() > 0;
    }

    public static boolean isCharInString(char c, String s) {
        return s.indexOf(c) != -1;
    }

    public static boolean isLetterUppercase(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) != -1;
    }

    public static boolean isLetterUppercaseDigits(char c) {
        return "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(c) != -1;
    }

    public static boolean isLetterLowercase(char c) {
        return "abcdefghijklmnopqrstuvwxyz".indexOf(c) != -1;
    }

    public static boolean isLetterLowercaseDigits(char c) {
        return "abcdefghijklmnopqrstuvwxyz0123456789".indexOf(c) != -1;
    }

    public static boolean isLetter(char c) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) != -1;
    }

    public static boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    public static boolean isLetterOrDigit(char c) {
        return "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(c) != -1;
    }

    public static boolean isWhitespace(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (" \t\n\r".indexOf(c) != -1) continue;
            return false;
        }
        return true;
    }

    public static boolean isLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isByteLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        int len = 0;
        try {
            len = s.getBytes("GBK").length;
        }
        catch (Exception e) {
            len = s.getBytes().length;
        }
        return len >= min && len <= max;
    }

    public static boolean isByteLen(String s, int min, int max, String encoding) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        int len = 0;
        try {
            len = s.getBytes(encoding).length;
        }
        catch (Exception e) {
            len = s.getBytes().length;
        }
        return len >= min && len <= max;
    }

    public static boolean isInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (ValidateUtil.isDigit((char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isSignedInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSignedLong(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            Long.parseLong(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isPositiveInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            long temp = Long.parseLong(s);
            return temp > 0L;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNonnegativeInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp >= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNegativeInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp < 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isNonpositiveInteger(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            int temp = Integer.parseInt(s);
            return temp <= 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isIntegerInRange(String s, int a, int b) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (!ValidateUtil.isSignedInteger((String)s)) {
            return false;
        }
        int num = Integer.parseInt(s);
        return num >= a && num <= b;
    }

    public static boolean isIntegerInRangeLen(String s, int a, int b) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (!ValidateUtil.isInteger((String)s)) {
            return false;
        }
        return s.length() >= a && s.length() <= b;
    }

    public static final boolean isUnicode(String str) {
        if (ValidateUtil.isEmpty((String)str)) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) <= '\u0080') continue;
            return true;
        }
        return str.length() == 1 && str.charAt(0) > '\u0080';
    }

    public static boolean isFloat(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (s.startsWith(".")) {
            return false;
        }
        boolean seenDecimalPoint = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isDigit((char)c)) continue;
            if (c == ".".charAt(0) && !seenDecimalPoint) {
                seenDecimalPoint = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isSignedFloat(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            float temp = Float.parseFloat(s);
            return temp <= 0.0f;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSignedDouble(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        try {
            Double.parseDouble(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isAlphabetic(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetter((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticLowercase(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetterLowercase((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticUppercase(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetterUppercase((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphabeticLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphabetic((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphabeticLowercaseLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphabeticLowercase((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphabeticUpperLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphabeticUppercase((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphanumeric(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetterOrDigit((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphanumericLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphanumeric((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaUpperNumeric(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetterUppercaseDigits((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaLowerNumeric(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isLetterLowercaseDigits((char)c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaUpperNumericLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphaUpperNumeric((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isAlphaLowerNumericLen(String s, int min, int max) {
        if (ValidateUtil.isEmpty((String)s)) {
            return min == 0;
        }
        if (!ValidateUtil.isAlphaLowerNumeric((String)s)) {
            return false;
        }
        return s.length() >= min && s.length() <= max;
    }

    public static boolean isZipCode(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return s.length() == 6 && ValidateUtil.isInteger((String)s);
    }

    public static boolean isMoneyTwoRadix(String s) {
        int ind;
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        if ((ind = s.indexOf(".")) == -1) {
            return ValidateUtil.isInteger((String)s);
        }
        if (ind == 0) {
            return false;
        }
        String integer = s.substring(0, ind);
        String radix = s.substring(ind + 1);
        return ValidateUtil.isInteger((String)integer) && ValidateUtil.isIntegerInRangeLen((String)radix, (int)2, (int)2);
    }

    public static boolean isEmail(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (ValidateUtil.isWhitespace((String)s)) {
            return false;
        }
        int indexLeft = s.indexOf(64);
        int indexRight = s.lastIndexOf(64);
        return indexLeft >= 1 && indexLeft == indexRight && indexLeft != s.length();
    }

    public static boolean isYear(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (!ValidateUtil.isNonnegativeInteger((String)s)) {
            return false;
        }
        return s.length() == 2 || s.length() == 4;
    }

    public static boolean isMonthQuarter(String date) {
        String day;
        String month;
        if (!ValidateUtil.isDate((String)date)) {
            return false;
        }
        String year = date.substring(0, 4);
        if (!ValidateUtil.isMonthLastDay((String)year, (String)(month = date.substring(5, 7)), (String)(day = date.substring(8)))) {
            return false;
        }
        return month.equals("03") || month.equals("06") || month.equals("09") || month.equals("12");
    }

    public static boolean isYearLastDay(String date) {
        String day;
        String month;
        if (!ValidateUtil.isDate((String)date)) {
            return false;
        }
        String year = date.substring(0, 4);
        if (!ValidateUtil.isMonthLastDay((String)year, (String)(month = date.substring(5, 7)), (String)(day = date.substring(8)))) {
            return false;
        }
        return month.equals("12");
    }

    public static boolean isMonth(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return ValidateUtil.isIntegerInRange((String)s, (int)1, (int)12);
    }

    public static boolean isDay(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return ValidateUtil.isIntegerInRange((String)s, (int)1, (int)31);
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public static boolean isMonthLastDay(String date) {
        if (!ValidateUtil.isDate((String)date)) {
            return false;
        }
        String year = date.substring(0, 4);
        String month = date.substring(5, 7);
        String day = date.substring(8);
        return ValidateUtil.isMonthLastDay((String)year, (String)month, (String)day);
    }

    public static boolean isMonthLastDay(String year, String month, String day) {
        if (!ValidateUtil.isDate((String)year, (String)month, (String)day)) {
            return false;
        }
        int yearInt = Integer.parseInt(year);
        int monthInt = Integer.parseInt(month);
        int dayInt = Integer.parseInt(day);
        return ValidateUtil.isMonthLastDay((int)yearInt, (int)monthInt, (int)dayInt);
    }

    public static boolean isMonthLastDay(int year, int month, int day) {
        if (year < 1000 || year > 9999 || month > 12 || month < 1 || day > 31 || day < 1) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return day == 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day == 30;
            }
        }
        boolean isLeapYear = ValidateUtil.isLeapYear((int)year);
        return isLeapYear ? day == 29 : day == 28;
    }

    public static boolean isHour(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return ValidateUtil.isIntegerInRange((String)s, (int)0, (int)23);
    }

    public static boolean isMinute(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return ValidateUtil.isIntegerInRange((String)s, (int)0, (int)59);
    }

    public static boolean isSecond(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        return ValidateUtil.isIntegerInRange((String)s, (int)0, (int)59);
    }

    public static boolean isDate(String year, String month, String day) {
        if (!(ValidateUtil.isYear((String)year) && ValidateUtil.isMonth((String)month) && ValidateUtil.isDay((String)day))) {
            return false;
        }
        int intYear = Integer.parseInt(year);
        int intMonth = Integer.parseInt(month);
        int intDay = Integer.parseInt(day);
        if (intDay > DAYS_IN_MONTH[intMonth - 1]) {
            return false;
        }
        return intMonth != 2 || intDay <= (ValidateUtil.isLeapYear((int)intYear) ? 29 : 28);
    }

    public static boolean isDate(String date) {
        if (ValidateUtil.isEmpty((String)date)) {
            return false;
        }
        if (date.length() != 10) {
            return false;
        }
        int dateSlash1 = date.indexOf("-");
        int dateSlash2 = date.lastIndexOf("-");
        if (dateSlash1 <= 0 || dateSlash1 == dateSlash2) {
            return false;
        }
        String year = date.substring(0, dateSlash1);
        String month = date.substring(dateSlash1 + 1, dateSlash2);
        String day = date.substring(dateSlash2 + 1);
        return ValidateUtil.isDate((String)year, (String)month, (String)day);
    }

    public static boolean isDateTime(String datetime) {
        if (ValidateUtil.isEmpty((String)datetime)) {
            return false;
        }
        String[] strs = (datetime = datetime.trim()).split(" ");
        if (strs.length != 2) {
            return false;
        }
        return ValidateUtil.isDate((String)strs[0]) && ValidateUtil.isTime((String)strs[1]);
    }

    public static boolean isDateTime(String datetime, String spe) {
        if (ValidateUtil.isEmpty((String)datetime)) {
            return false;
        }
        String[] strs = (datetime = datetime.trim()).split(" ");
        if (strs.length != 2) {
            return false;
        }
        return ValidateUtil.isDate((String)strs[0].replaceAll(spe, "-")) && ValidateUtil.isTime((String)strs[1]);
    }

    public static boolean isEnglishDate(String date) {
        if (ValidateUtil.isEmpty((String)date)) {
            return false;
        }
        int dateSlash1 = date.indexOf("/");
        int dateSlash2 = date.lastIndexOf("/");
        if (dateSlash1 <= 0 || dateSlash1 == dateSlash2) {
            return false;
        }
        String month = date.substring(0, dateSlash1);
        String day = date.substring(dateSlash1 + 1, dateSlash2);
        String year = date.substring(dateSlash2 + 1);
        return ValidateUtil.isDate((String)year, (String)month, (String)day);
    }

    public static boolean isTime(String hour, String minute, String second) {
        return ValidateUtil.isHour((String)hour) && ValidateUtil.isMinute((String)minute) && ValidateUtil.isSecond((String)second);
    }

    public static boolean isTime(String time) {
        if (ValidateUtil.isEmpty((String)time)) {
            return false;
        }
        int timeColon1 = time.indexOf(":");
        int timeColon2 = time.lastIndexOf(":");
        if (timeColon1 <= 0 || timeColon1 == timeColon2) {
            return false;
        }
        String hour = time.substring(0, timeColon1);
        String minute = time.substring(timeColon1 + 1, timeColon2);
        String second = time.substring(timeColon2 + 1);
        return ValidateUtil.isTime((String)hour, (String)minute, (String)second);
    }

    public static boolean isPhone(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isCharInString((char)c, (String)"+0123456789()- ")) continue;
            return false;
        }
        return true;
    }

    public static boolean isMsisdn(String s) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        if (s.charAt(0) == '+') {
            s = s.substring(1);
        }
        if (s.length() > 21 || s.length() < 11) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isCharInString((char)c, (String)"0123456789")) continue;
            return false;
        }
        return true;
    }

    public static boolean isMsisdn11(String phone, String prefixs) {
        if (!ValidateUtil.isIntegerInRangeLen((String)phone, (int)11, (int)11)) {
            return false;
        }
        String[] prefixArr = prefixs.split(",");
        for (int i = 0; i < prefixArr.length; ++i) {
            if (!phone.startsWith(prefixArr[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isMsisdn21(String phone, String prefixs) {
        if (!ValidateUtil.isMsisdn((String)phone)) {
            return false;
        }
        String[] prefixArr = prefixs.split(",");
        for (int i = 0; i < prefixArr.length; ++i) {
            if (phone.length() != prefixArr[i].length() + 8 || !phone.startsWith(prefixArr[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean isIP(String ip) {
        return ValidateUtil.isIP((String)ip, (boolean)false);
    }

    public static boolean isIP(String ip, boolean allowEmpty) {
        if (ValidateUtil.isEmpty((String)ip)) {
            return allowEmpty;
        }
        try {
            int ind1 = ip.indexOf(46);
            if (ind1 == -1) {
                return false;
            }
            String str1 = ip.substring(0, ind1);
            if (!ValidateUtil.isIntegerInRange((String)str1, (int)0, (int)255)) {
                return false;
            }
            int ind2 = ip.indexOf(46, ind1 + 1);
            if (ind2 == -1) {
                return false;
            }
            String str2 = ip.substring(ind1 + 1, ind2);
            if (!ValidateUtil.isIntegerInRange((String)str2, (int)0, (int)255)) {
                return false;
            }
            int ind3 = ip.indexOf(46, ind2 + 1);
            if (ind3 == -1) {
                return false;
            }
            String str3 = ip.substring(ind2 + 1, ind3);
            if (!ValidateUtil.isIntegerInRange((String)str3, (int)0, (int)255)) {
                return false;
            }
            String str4 = ip.substring(ind3 + 1);
            if (!ValidateUtil.isIntegerInRange((String)str4, (int)0, (int)255)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isMacAddress(String macAddress) {
        return ValidateUtil.isMacAddress((String)macAddress, (boolean)false);
    }

    public static boolean isMacAddress(String macAddress, boolean allowEmpty) {
        if (ValidateUtil.isEmpty((String)macAddress)) {
            return allowEmpty;
        }
        return ValidateUtil.isRegExp((String)macAddress, (String)"^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$");
    }

    public static boolean isPostalCode(String s) {
        return ValidateUtil.isInteger((String)s) && s.trim().length() == 6;
    }

    public static boolean isScope(String s, String scope) {
        if (ValidateUtil.isEmpty((String)s)) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ValidateUtil.isCharInString((char)c, (String)scope)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRegExp(String value, String regExp) {
        if (regExp.startsWith("/")) {
            regExp = regExp.substring(1);
        }
        if (regExp.endsWith("/")) {
            regExp = regExp.substring(0, regExp.length() - 1);
        }
        return Pattern.matches(regExp, value);
    }

    public static boolean isStrContainStrArr(String src, String[] strs) {
        for (String str : strs) {
            if (!src.contains(str.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean isStrContainStrArr(String src, String strArr, String delm) {
        return ValidateUtil.isStrContainStrArr((String)src, (String[])strArr.split(delm));
    }
}

