/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.portal.utils;

import com.ruoyi.portal.utils.OffSet;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class NetBits {
    public static String encoding = "UTF-8";

    public static int getByteLen(String str) {
        if (str == null) {
            return 0;
        }
        try {
            return str.getBytes(encoding).length;
        }
        catch (Exception e) {
            return str.getBytes().length;
        }
    }

    public static byte getByte(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 1);
        return b[off];
    }

    public static boolean getBoolean(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 1);
        return b[off] != 0;
    }

    public static char getChar1(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 1);
        return (char)(b[off + 0] & 0xFF);
    }

    public static char getChar2(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 2);
        return (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 2);
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 4);
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static float getFloat(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 4);
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 8);
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static double getDouble(byte[] b, OffSet offset) {
        int off = offset.getOff();
        offset.setOff(off + 8);
        long j = (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(j);
    }

    public static byte[] getBytes(byte[] b, OffSet offset, int len) {
        int off = offset.getOff();
        byte[] bytes = new byte[len];
        if (len + off <= b.length) {
            System.arraycopy(b, off, bytes, 0, len);
        } else {
            System.arraycopy(b, off, bytes, 0, b.length - off);
        }
        offset.setOff(off + len);
        return bytes;
    }

    public static byte[] getBytes(byte[] b, OffSet offset) {
        int off = offset.getOff();
        byte[] bytes = new byte[b.length - off];
        System.arraycopy(b, off, bytes, 0, b.length - off);
        offset.setOff(off + bytes.length);
        return bytes;
    }

    public static String getString(byte[] b, OffSet offset, byte value) {
        int off;
        int i;
        int allLen = b.length;
        for (i = off = offset.getOff(); i < allLen && b[i] != value; ++i) {
        }
        byte[] tmp = new byte[i - off];
        System.arraycopy(b, off, tmp, 0, i - off);
        String str = null;
        try {
            str = new String(tmp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = new String(tmp);
        }
        offset.setOff(i + 1);
        return str;
    }

    public static String getString(byte[] b, OffSet offset, int len) {
        int i;
        int off = offset.getOff();
        for (i = 0; i < len && off + i < b.length && 0 != b[off + i]; ++i) {
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, off, tmp, 0, i);
        String str = null;
        try {
            str = new String(tmp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = new String(tmp);
        }
        offset.setOff(off + len);
        return str;
    }

    public static String getString(byte[] b, OffSet offset, int len, boolean hasEnd) {
        int i;
        int off = offset.getOff();
        for (i = 0; i < len && off + i < b.length && 0 != b[off + i]; ++i) {
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, off, tmp, 0, i);
        String str = null;
        try {
            str = new String(tmp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = new String(tmp);
        }
        if (hasEnd) {
            offset.setOff(off + len + 1);
        } else {
            offset.setOff(off + len);
        }
        return str;
    }

    public static void putByte(byte[] b, OffSet offset, byte val) {
        int off = offset.getOff();
        b[off] = val;
        offset.setOff(off + 1);
    }

    public static void putBoolean(byte[] b, OffSet offset, boolean val) {
        int off = offset.getOff();
        b[off] = (byte)(val ? 1 : 0);
        offset.setOff(off + 1);
    }

    public static void putChar1(byte[] b, OffSet offset, char val) {
        int off = offset.getOff();
        b[off + 0] = (byte)(val & 0xFF);
        offset.setOff(off + 1);
    }

    public static void putChar2(byte[] b, OffSet offset, char val) {
        int off = offset.getOff();
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
        offset.setOff(off + 2);
    }

    public static void putShort(byte[] b, OffSet offset, short val) {
        int off = offset.getOff();
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
        offset.setOff(off + 2);
    }

    public static void putInt(byte[] b, OffSet offset, int val) {
        int off = offset.getOff();
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
        offset.setOff(off + 4);
    }

    public static void putFloat(byte[] b, OffSet offset, float val) {
        int off = offset.getOff();
        int i = Float.floatToIntBits(val);
        b[off + 3] = (byte)(i >>> 0);
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
        offset.setOff(off + 4);
    }

    public static void putLong(byte[] b, OffSet offset, long val) {
        int off = offset.getOff();
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
        offset.setOff(off + 8);
    }

    public static void putDouble(byte[] b, OffSet offset, double val) {
        int off = offset.getOff();
        long j = Double.doubleToLongBits(val);
        b[off + 7] = (byte)(j >>> 0);
        b[off + 6] = (byte)(j >>> 8);
        b[off + 5] = (byte)(j >>> 16);
        b[off + 4] = (byte)(j >>> 24);
        b[off + 3] = (byte)(j >>> 32);
        b[off + 2] = (byte)(j >>> 40);
        b[off + 1] = (byte)(j >>> 48);
        b[off + 0] = (byte)(j >>> 56);
        offset.setOff(off + 8);
    }

    public static void putBytes(byte[] b, OffSet offset, byte[] src) {
        int off = offset.getOff();
        System.arraycopy(src, 0, b, off, src.length);
        offset.setOff(off + src.length);
    }

    public static void putBytes(byte[] b, OffSet offset, byte[] src, int len) {
        int off = offset.getOff();
        System.arraycopy(src, 0, b, off, len);
        offset.setOff(off + len);
    }

    public static void putString(byte[] b, OffSet offset, String str) {
        int off = offset.getOff();
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        System.arraycopy(ret, 0, b, off, ret.length);
        offset.setOff(off + ret.length);
    }

    public static void putString(byte[] b, OffSet offset, String str, byte endValue) {
        int off = offset.getOff();
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        System.arraycopy(ret, 0, b, off, ret.length);
        b[off + ret.length] = endValue;
        offset.setOff(off + ret.length + 1);
    }

    public static void putString(byte[] b, OffSet offset, String str, int len) {
        int off = offset.getOff();
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off, len);
        } else {
            System.arraycopy(ret, 0, b, off, ret.length);
        }
        offset.setOff(off + len);
    }

    public static void putString(byte[] b, OffSet offset, String str, int len, byte endValue) {
        int off = offset.getOff();
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off, len);
        } else {
            System.arraycopy(ret, 0, b, off, ret.length);
        }
        b[off + ret.length] = endValue;
        offset.setOff(off + len + 1);
    }

    public static boolean getBoolean(byte[] b, int off) {
        return b[off] != 0;
    }

    public static char getChar1(byte[] b, int off) {
        return (char)(b[off + 0] & 0xFF);
    }

    public static char getChar2(byte[] b, int off) {
        return (char)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static short getShort(byte[] b, int off) {
        return (short)(((b[off + 1] & 0xFF) << 0) + ((b[off + 0] & 0xFF) << 8));
    }

    public static int getInt(byte[] b, int off) {
        return ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
    }

    public static float getFloat(byte[] b, int off) {
        int i = ((b[off + 3] & 0xFF) << 0) + ((b[off + 2] & 0xFF) << 8) + ((b[off + 1] & 0xFF) << 16) + ((b[off + 0] & 0xFF) << 24);
        return Float.intBitsToFloat(i);
    }

    public static long getLong(byte[] b, int off) {
        return (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
    }

    public static double getDouble(byte[] b, int off) {
        long j = (((long)b[off + 7] & 0xFFL) << 0) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 0] & 0xFFL) << 56);
        return Double.longBitsToDouble(j);
    }

    public static String getString(byte[] b, int off, byte value) {
        int i;
        int allLen = b.length;
        for (i = off; i < allLen && b[i] != value; ++i) {
        }
        byte[] tmp = new byte[i - off];
        System.arraycopy(b, off, tmp, 0, i - off);
        String str = null;
        try {
            str = new String(tmp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = new String();
        }
        return str;
    }

    public static String getString(byte[] b, int off, int len) {
        int i;
        for (i = 0; i < len && off + i < b.length && 0 != b[off + i]; ++i) {
        }
        byte[] tmp = new byte[i];
        System.arraycopy(b, off, tmp, 0, i);
        String str = null;
        try {
            str = new String(tmp, encoding);
        }
        catch (UnsupportedEncodingException e) {
            str = new String();
        }
        return str;
    }

    public static byte getByte(byte[] b, int off) {
        return b[off];
    }

    public static byte[] getBytes(byte[] b, int off, int len) {
        byte[] bytes = new byte[len];
        if (len + off <= b.length) {
            System.arraycopy(b, off, bytes, 0, len);
        } else {
            System.arraycopy(b, off, bytes, 0, b.length - off);
        }
        return bytes;
    }

    public static byte[] getBytes(byte[] b, int off) {
        byte[] bytes = new byte[b.length - off];
        System.arraycopy(b, off, bytes, 0, b.length - off);
        return bytes;
    }

    public static int putBoolean(byte[] b, int off, boolean val) {
        b[off] = (byte)(val ? 1 : 0);
        return off + 1;
    }

    public static int putChar1(byte[] b, int off, char val) {
        b[off + 0] = (byte)(val & 0xFF);
        return off + 1;
    }

    public static int putChar2(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
        return off + 2;
    }

    public static int putShort(byte[] b, int off, short val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off + 0] = (byte)(val >>> 8);
        return off + 2;
    }

    public static int putInt(byte[] b, int off, int val) {
        b[off + 3] = (byte)(val >>> 0);
        b[off + 2] = (byte)(val >>> 8);
        b[off + 1] = (byte)(val >>> 16);
        b[off + 0] = (byte)(val >>> 24);
        return off + 4;
    }

    public static int putFloat(byte[] b, int off, float val) {
        int i = Float.floatToIntBits(val);
        b[off + 3] = (byte)(i >>> 0);
        b[off + 2] = (byte)(i >>> 8);
        b[off + 1] = (byte)(i >>> 16);
        b[off + 0] = (byte)(i >>> 24);
        return off + 4;
    }

    public static int putLong(byte[] b, int off, long val) {
        b[off + 7] = (byte)(val >>> 0);
        b[off + 6] = (byte)(val >>> 8);
        b[off + 5] = (byte)(val >>> 16);
        b[off + 4] = (byte)(val >>> 24);
        b[off + 3] = (byte)(val >>> 32);
        b[off + 2] = (byte)(val >>> 40);
        b[off + 1] = (byte)(val >>> 48);
        b[off + 0] = (byte)(val >>> 56);
        return off + 8;
    }

    public static int putDouble(byte[] b, int off, double val) {
        long j = Double.doubleToLongBits(val);
        b[off + 7] = (byte)(j >>> 0);
        b[off + 6] = (byte)(j >>> 8);
        b[off + 5] = (byte)(j >>> 16);
        b[off + 4] = (byte)(j >>> 24);
        b[off + 3] = (byte)(j >>> 32);
        b[off + 2] = (byte)(j >>> 40);
        b[off + 1] = (byte)(j >>> 48);
        b[off + 0] = (byte)(j >>> 56);
        return off + 8;
    }

    public static int putByte(byte[] b, int off, byte val) {
        b[off] = val;
        return off + 1;
    }

    public static int putBytes(byte[] b, int off, byte[] src) {
        System.arraycopy(src, 0, b, off, src.length);
        return off + src.length;
    }

    public static int putBytes(byte[] b, int off, byte[] src, int len) {
        System.arraycopy(src, 0, b, off, len);
        return off + len;
    }

    public static int putString(byte[] b, int off, String str) {
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        System.arraycopy(ret, 0, b, off, ret.length);
        return off + ret.length;
    }

    public static int putString(byte[] b, int off, String str, int len) {
        if (str == null) {
            str = "";
        }
        byte[] ret = null;
        try {
            ret = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ret = str.getBytes();
        }
        if (ret.length > len) {
            System.arraycopy(ret, 0, b, off, len);
        } else {
            System.arraycopy(ret, 0, b, off, ret.length);
        }
        return off + len;
    }

    public static String toString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static byte[] toBytes(String str) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding error");
        }
    }

    public static byte[] toBytes(String str, int len) {
        if (str == null) {
            return new byte[0];
        }
        byte[] buf = null;
        try {
            buf = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding error");
        }
        byte[] bytes = new byte[len];
        if (buf.length > len) {
            System.arraycopy(buf, 0, bytes, 0, len);
        } else {
            System.arraycopy(buf, 0, bytes, 0, buf.length);
        }
        return bytes;
    }

    public static byte[] toBytes(String str, String aEncoding) {
        if (str == null) {
            return new byte[0];
        }
        try {
            return str.getBytes(aEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding error");
        }
    }

    public static byte[] toBytes(String str, int len, String aEncoding) {
        if (str == null) {
            return new byte[0];
        }
        try {
            byte[] buf = str.getBytes(aEncoding);
            byte[] bytes = new byte[len];
            if (buf.length > len) {
                System.arraycopy(buf, 0, bytes, 0, len);
            } else {
                System.arraycopy(buf, 0, bytes, 0, buf.length);
            }
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encoding error");
        }
    }

    public static String toHEXString(byte[] b) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer s = new StringBuffer();
        char[] ob = new char[2];
        for (int i = 0; i < b.length; ++i) {
            byte ib = b[i];
            ob[0] = Digit[ib >>> 4 & 0xF];
            ob[1] = Digit[ib & 0xF];
            s.append(new String(ob) + " ");
        }
        return s.toString();
    }

    public static byte[] toBytesByHEX(String hex) {
        hex = hex.replaceAll(" ", "");
        hex = hex.toUpperCase();
        byte[] bytes = new byte[hex.length() / 2];
        int i = 0;
        int v = 0;
        while (i < hex.length()) {
            byte b;
            byte a = (byte)(hex.charAt(i) - 48);
            if (a > 15) {
                a = (byte)(a - 7);
            }
            if ((b = (byte)(hex.charAt(i + 1) - 48)) > 15) {
                b = (byte)(b - 7);
            }
            bytes[v] = (byte)(a * 16 + b);
            i += 2;
            ++v;
        }
        return bytes;
    }

    public static byte[] toBytesByHex(String hex) {
        hex = hex.replaceAll(" ", "");
        String[] hexArr = new String[hex.length() / 2];
        for (int i = 0; i < hexArr.length * 2; i += 2) {
            hexArr[i / 2] = hex.substring(i, i + 2);
        }
        byte[] dest = new byte[hexArr.length];
        for (int i = 0; i < hexArr.length; ++i) {
            dest[i] = (byte)Integer.parseInt(hexArr[i], 16);
        }
        return dest;
    }

    public static String toHEXStringNoSpace(byte[] b) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuffer s = new StringBuffer();
        char[] ob = new char[2];
        for (int i = b.length - 1; i >= 0; --i) {
            byte ib = b[i];
            ob[0] = Digit[ib >>> 4 & 0xF];
            ob[1] = Digit[ib & 0xF];
            s.append(new String(ob));
        }
        return s.toString();
    }

    public static String toHexString(byte[] b) {
        StringBuffer strb = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            String str = Integer.toString((b[i] & 0xFF) + 256, 16).substring(1).toUpperCase();
            strb.append(str);
        }
        return strb.toString();
    }

    public static byte[] readStream(InputStream input, int len) throws IOException {
        int ret = 0;
        byte[] buf = new byte[len];
        for (int readcount = 0; readcount < len; readcount += ret) {
            ret = input.read(buf, readcount, len - readcount);
            if (-1 != ret) continue;
            throw new EOFException("\u6309\u957f\u5ea6\u8bfb\u6d88\u606f\u65f6,\u957f\u5ea6\u4e0d\u591f\u5373\u5230\u8fbe\u6d41\u5c3e\u7aef");
        }
        return buf;
    }
}

