/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.radius;

import com.ruoyi.radius.ReWriteRadiusPacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tinyradius.packet.RadiusPacket;
import org.tinyradius.util.RadiusClient;
import org.tinyradius.util.RadiusException;

public class ReWriteRadiusClient
extends RadiusClient {
    private static Log logger = LogFactory.getLog(ReWriteRadiusClient.class);

    public ReWriteRadiusClient(String hostName, String sharedSecret) {
        super(hostName, sharedSecret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RadiusPacket communicate(RadiusPacket request, int port) throws IOException, RadiusException {
        DatagramPacket packetIn = new DatagramPacket(new byte[4096], 4096);
        DatagramPacket packetOut = this.makeDatagramPacket(request, port);
        try (DatagramSocket socket = this.getSocket();){
            for (int i = 1; i <= this.getRetryCount(); ++i) {
                try {
                    RadiusPacket var7;
                    socket.send(packetOut);
                    socket.receive(packetIn);
                    RadiusPacket radiusPacket = var7 = this.makeRadiusPacket(packetIn, request);
                    return radiusPacket;
                }
                catch (IOException var11) {
                    try {
                        if (i == this.getRetryCount()) {
                            if (!logger.isErrorEnabled()) throw var11;
                            if (var11 instanceof SocketTimeoutException) {
                                logger.error((Object)"communication failure (timeout), no more retries");
                                throw var11;
                            } else {
                                logger.error((Object)"communication failure, no more retries", (Throwable)var11);
                            }
                            throw var11;
                        }
                        if (!logger.isInfoEnabled()) continue;
                        logger.info((Object)("communication failure, retry " + i));
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return null;
                    }
                }
            }
        }
    }

    protected RadiusPacket makeRadiusPacket(DatagramPacket packet, RadiusPacket request) throws IOException, RadiusException {
        ByteArrayInputStream in = new ByteArrayInputStream(packet.getData());
        return ReWriteRadiusPacket.decodeResponsePacket((InputStream)in, (String)this.getSharedSecret(), (RadiusPacket)request);
    }
}

