/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.sa.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.ruoyi.config.PayConfig;
import com.ruoyi.sa.DTO.BalanceRefundDTO;
import com.ruoyi.sa.DTO.BalanceRefundQueryDTO;
import com.ruoyi.sa.DTO.BalanceRefundResponse;
import com.ruoyi.sa.DTO.BalanceSplitDTO;
import com.ruoyi.sa.DTO.BalanceSplitQueryDTO;
import com.ruoyi.sa.DTO.BalanceSplitResponse;
import com.ruoyi.sa.DTO.BillApplyUrlDTO;
import com.ruoyi.sa.DTO.BillApplyUrlResponse;
import com.ruoyi.sa.IJialPayBalanceService;
import com.ruoyi.util.CipherCache;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class JialPayBalanceServiceImpl
implements IJialPayBalanceService {
    private static final Logger log = LoggerFactory.getLogger(JialPayBalanceServiceImpl.class);
    @Autowired
    private PayConfig payConfig;
    private final RestTemplate restTemplate;
    private final String balanceSplitUrl = "https://openapi-uat.jlpay.com/open/ledger/balance/split";
    private final String balanceSplitQueryUrl = "https://openapi-uat.jlpay.com/open/ledger/balance/split/query";
    private final String balanceRefundUrl = "https://openapi-uat.jlpay.com/open/ledger/balance/refund";
    private final String balanceRefundQueryUrl = "https://openapi.jlpay.com/open/ledger/balance/refund/query";
    private final String billApplyUrl = "https://openapi-uat.jlpay.com/open/ledger/bill/apply/url";

    public BalanceSplitResponse balanceSplit(BalanceSplitDTO dto) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)dto));
        String result = this.doPayPost("https://openapi-uat.jlpay.com/open/ledger/balance/split", jsonObject);
        BalanceSplitResponse response = (BalanceSplitResponse)JSONObject.parseObject((String)result, BalanceSplitResponse.class);
        return response;
    }

    public BalanceSplitResponse balanceSplitQuery(BalanceSplitQueryDTO dto) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)dto));
        String result = this.doPayPost("https://openapi-uat.jlpay.com/open/ledger/balance/split", jsonObject);
        BalanceSplitResponse response = (BalanceSplitResponse)JSONObject.parseObject((String)result, BalanceSplitResponse.class);
        return response;
    }

    public BalanceRefundResponse balanceRefund(BalanceRefundDTO dto) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)dto));
        String result = this.doPayPost("https://openapi-uat.jlpay.com/open/ledger/balance/split", jsonObject);
        BalanceRefundResponse response = (BalanceRefundResponse)JSONObject.parseObject((String)result, BalanceRefundResponse.class);
        return response;
    }

    public BalanceRefundResponse balanceRefundQuery(BalanceRefundQueryDTO dto) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)dto));
        String result = this.doPayPost("https://openapi-uat.jlpay.com/open/ledger/balance/split", jsonObject);
        BalanceRefundResponse response = (BalanceRefundResponse)JSONObject.parseObject((String)result, BalanceRefundResponse.class);
        return response;
    }

    public BillApplyUrlResponse billApplyUrl(BillApplyUrlDTO dto) {
        JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)dto));
        String result = this.doPayPost("https://openapi-uat.jlpay.com/open/ledger/balance/split", jsonObject);
        BillApplyUrlResponse response = (BillApplyUrlResponse)JSONObject.parseObject((String)result, BillApplyUrlResponse.class);
        return response;
    }

    public String sign(String data) {
        return this.sign(this.getPayPrivateKey(), data);
    }

    private String doPayPost(String url, JSONObject object) {
        object.remove((Object)"sign");
        if (object.containsKey("notify_url")) {
            object.put((Object)"notify_url", (Object)this.payConfig.getPayNotifyAddress());
        }
        object.put((Object)"org_code", (Object)this.payConfig.getOrgCode());
        String sign = this.sign(object.toJSONString(new JSONWriter.Feature[0]));
        object.put((Object)"sign", (Object)sign);
        return this.doPost(url, object.toJSONString(new JSONWriter.Feature[0]));
    }

    private String doPost(String url, String data) {
        log.info("url:{}", (Object)url);
        log.info("request data:{}", (Object)data);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAcceptCharset(Collections.singletonList(StandardCharsets.UTF_8));
        HttpEntity request = new HttpEntity((Object)data, (MultiValueMap)headers);
        String result = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
        log.info("request result:{}", (Object)result);
        if (result == null) {
            throw new RuntimeException("[\u5609\u8054\u652f\u4ed8]\u8bbf\u95ee\u5931\u8d25");
        }
        return result;
    }

    private String sign(PrivateKey privateKey, String data) {
        if (JSONUtil.isTypeJSON((String)data)) {
            JSONObject object = JSONObject.parseObject((String)data);
            TreeSet keys = new TreeSet(object.keySet());
            Iterator i = keys.iterator();
            LinkedHashMap<String, Object> dMap = new LinkedHashMap<String, Object>();
            while (i.hasNext()) {
                String key = (String)i.next();
                dMap.put(key, object.get(key));
            }
            data = JSONObject.toJSONString(dMap, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
        }
        String signature = null;
        byte[] signed = null;
        try {
            Signature Sign = Signature.getInstance("SHA256withRSA");
            Sign.initSign(privateKey);
            Sign.update(data.getBytes());
            signed = Sign.sign();
            signature = Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u7b7e\u540d\u5931\u8d25");
        }
        return signature;
    }

    private PrivateKey getPayPrivateKey() {
        if (CipherCache.PRIVATE_KEY == null && CipherCache.PRIVATE_KEY == null) {
            CipherCache.PRIVATE_KEY = this.getPrivateKey(this.payConfig.getPrivateKey());
        }
        return CipherCache.PRIVATE_KEY;
    }

    private PrivateKey getPrivateKey(String key) {
        try {
            byte[] byteKey = Base64.decode((CharSequence)key);
            PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(byteKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(pkcs8EncodedKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public JialPayBalanceServiceImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

