/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.dto.CallPayDto;
import com.ruoyi.dto.Package2PersonDto;
import com.ruoyi.dto.PayAccountManagerVo;
import com.ruoyi.dto.PaymentDetailExcel;
import com.ruoyi.dto.PaymentDetailQueryRequest;
import com.ruoyi.dto.PaymentDetailVo;
import com.ruoyi.dto.RefundPayDto;
import com.ruoyi.entity.PackageGroupManager;
import com.ruoyi.entity.PaymentDetail;
import com.ruoyi.entity.SubPackageGroupManager;
import com.ruoyi.entity.UserManager;
import com.ruoyi.enums.OrderTypeEnum;
import com.ruoyi.mapper.PaymentDetailMapper;
import com.ruoyi.mapper.SubPackageGroupManagerMapper;
import com.ruoyi.mapper.UserManagerMapper;
import com.ruoyi.pay.AuthBind;
import com.ruoyi.pay.OrderInfo2Jialian;
import com.ruoyi.pay.PayAuthbindRequest;
import com.ruoyi.pay.PayService;
import com.ruoyi.pay.PaymentRequest;
import com.ruoyi.pay.PaymentRequestTest;
import com.ruoyi.pay.PaymentResponse;
import com.ruoyi.pay.RefundRequest;
import com.ruoyi.pay.RefundResponse;
import com.ruoyi.pay.SHA256WithRSAUtil;
import com.ruoyi.service.IPayAccountManagerService;
import com.ruoyi.service.IPaymentDetailService;
import com.ruoyi.service.order.OrderService;
import com.ruoyi.util.CommonUtil;
import com.ruoyi.util.SignUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PaymentDetailServiceImpl
extends ServiceImpl<PaymentDetailMapper, PaymentDetail>
implements IPaymentDetailService {
    private static final Logger log = LoggerFactory.getLogger(PaymentDetailServiceImpl.class);
    @Value(value="${pay.notifyUrl:}")
    private String notifyUrl;
    @Autowired
    private IPayAccountManagerService payAccountManagerService;
    @Autowired
    private PayService payService;
    @Autowired
    private UserManagerMapper managerMapper;
    @Autowired
    private SubPackageGroupManagerMapper packageGroupManagerMapper;
    @Resource
    private OrderService orderService;

    public Page<PaymentDetail> queryPaymentDetailPage(PaymentDetailQueryRequest r) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().ge(r.getBeginTransactionTime() != null, PaymentDetail::getTransactionTime, (Object)r.getBeginTransactionTime())).le(r.getEndTransactionTime() != null, PaymentDetail::getTransactionTime, (Object)r.getEndTransactionTime())).eq(StringUtils.isNotBlank((CharSequence)r.getCity()), PaymentDetail::getCity, (Object)r.getCity())).eq(StringUtils.isNotBlank((CharSequence)r.getBrandName()), PaymentDetail::getBrandName, (Object)r.getBrandName())).eq(StringUtils.isNotBlank((CharSequence)r.getProjectName()), PaymentDetail::getProjectName, (Object)r.getProjectName())).eq(StringUtils.isNotBlank((CharSequence)r.getProjectType()), PaymentDetail::getProjectType, (Object)r.getProjectType())).eq(StringUtils.isNotBlank((CharSequence)r.getSaleTargetName()), PaymentDetail::getSaleTargetName, (Object)r.getSaleTargetName())).eq(StringUtils.isNotBlank((CharSequence)r.getBroadbandUser()), PaymentDetail::getBroadbandUser, (Object)r.getBroadbandUser())).eq(ObjectUtil.isNotEmpty((Object)r.getBroadbandUserId()), PaymentDetail::getBroadbandUserId, (Object)r.getBroadbandUserId())).eq(StringUtils.isNotBlank((CharSequence)r.getBuyPackageType()), PaymentDetail::getBuyPackageType, (Object)r.getBuyPackageType())).eq(StringUtils.isNotBlank((CharSequence)r.getPaymentType()), PaymentDetail::getPaymentType, (Object)r.getPaymentType())).eq(StringUtils.isNotBlank((CharSequence)r.getOrderNo()), PaymentDetail::getOrderNo, (Object)r.getOrderNo())).eq(StringUtils.isNotBlank((CharSequence)r.getRefundOrderNo()), PaymentDetail::getRefundOrderNo, (Object)r.getRefundOrderNo())).eq(PaymentDetail::getIsDeleted, (Object)0)).eq(ObjectUtil.isNotEmpty((Object)r.getInvoiceFlag()), PaymentDetail::getInvoiceFlag, (Object)r.getInvoiceFlag())).like(ObjectUtil.isNotEmpty((Object)r.getRefundUser()), PaymentDetail::getRefundUser, (Object)r.getRefundUser())).ge(r.getBeginRefundTime() != null, PaymentDetail::getRefundTime, (Object)r.getBeginRefundTime())).le(r.getEndRefundTime() != null, PaymentDetail::getRefundTime, (Object)r.getEndRefundTime())).orderByDesc(PaymentDetail::getId);
        return (Page)this.page((IPage)new Page(r.getPageNum(), r.getPageSize()), (Wrapper)wrapper);
    }

    public List<PaymentDetailVo> queryPaymentDetailList(PaymentDetailQueryRequest r) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(ObjectUtil.isNotEmpty((Object)r.getCreateUser()), PaymentDetail::getCreateUser, (Object)r.getCreateUser())).eq(ObjectUtil.isNotEmpty((Object)r.getBroadbandUserId()), PaymentDetail::getBroadbandUserId, (Object)r.getBroadbandUserId())).orderByDesc(PaymentDetail::getCreateTime);
        List list = this.list((Wrapper)wrapper);
        ArrayList<PaymentDetailVo> paymentDetailVos = new ArrayList<PaymentDetailVo>();
        list.forEach(a -> {
            PaymentDetailVo paymentDetailVo = new PaymentDetailVo();
            BeanUtils.copyProperties((Object)a, (Object)paymentDetailVo);
            paymentDetailVos.add(paymentDetailVo);
        });
        return paymentDetailVos;
    }

    public Package2PersonDto queryPaymentDetail2Package(Long id) {
        Package2PersonDto package2PersonDto = new Package2PersonDto();
        PaymentDetail paymentDetail = (PaymentDetail)this.getById((Serializable)id);
        package2PersonDto.setCurrentPackageInfo(Package2PersonDto.XPackageInfo.builder().name(paymentDetail.getSubPackageGroupName()).expireTime(paymentDetail.getExpireTime()).build());
        String user = paymentDetail.getBroadbandUser();
        List paymentDetailList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentDetail::getBroadbandUser, (Object)user)).eq(PaymentDetail::getIsDeleted, (Object)0)).orderByDesc(PaymentDetail::getId));
        if (paymentDetailList.size() > 1) {
            PaymentDetail o = (PaymentDetail)paymentDetailList.get(1);
            Package2PersonDto.XPackageInfo oldPackageInfo = Package2PersonDto.XPackageInfo.builder().name(o.getSubPackageGroupName()).expireTime(o.getExpireTime()).build();
            package2PersonDto.setOldPackageInfo(oldPackageInfo);
        }
        return package2PersonDto;
    }

    public Boolean refund(PaymentDetailQueryRequest p) throws UnknownHostException {
        PaymentDetail paymentDetail = (PaymentDetail)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentDetail::getOrderNo, (Object)p.getOrderNo())).eq(PaymentDetail::getIsDeleted, (Object)0));
        String paymentAmount = paymentDetail.getPaymentAmount();
        if (new BigDecimal(paymentAmount).compareTo(new BigDecimal(p.getRefundAmount())) < 0) {
            throw new RuntimeException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u91d1\u989d\uff01");
        }
        String refundOrderNo = CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.REFUND, (String)paymentDetail.getProjectCode());
        PaymentDetail updatePaymentDetail = new PaymentDetail();
        updatePaymentDetail.setId(paymentDetail.getId());
        updatePaymentDetail.setRefundAmount(p.getRefundAmount());
        updatePaymentDetail.setRefundOrderNo(refundOrderNo);
        RefundResponse refundResponse = this.refundPay(RefundPayDto.builder().ip(this.getAddress()).projectCode(paymentDetail.getProjectCode()).oriOutTradeNo(p.getOrderNo()).totalFee(new BigDecimal(paymentAmount).multiply(new BigDecimal("100")).longValue()).refundOrderNo(refundOrderNo).build());
        if (!StringUtils.equals((CharSequence)refundResponse.getStatus(), (CharSequence)"2")) {
            throw new RuntimeException("\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        updatePaymentDetail.setJlRefundOrderNo(refundResponse.getTransaction_id());
        return this.updateById((Object)updatePaymentDetail);
    }

    public Boolean refundByBoYu(PaymentDetailQueryRequest pp) throws UnknownHostException {
        PaymentDetail paymentDetail = (PaymentDetail)this.getById((Serializable)pp.getId());
        String paymentAmount = paymentDetail.getPaymentAmount();
        if (new BigDecimal(paymentAmount).compareTo(new BigDecimal(pp.getRefundAmount())) < 0) {
            throw new RuntimeException("\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u91d1\u989d\uff01");
        }
        String refundOrderNo = CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.REFUND, (String)paymentDetail.getProjectCode());
        PaymentDetail updatePaymentDetail = new PaymentDetail();
        updatePaymentDetail.setId(paymentDetail.getId());
        updatePaymentDetail.setRefundAmount(pp.getRefundAmount());
        updatePaymentDetail.setRefundOrderNo(refundOrderNo);
        RefundResponse refundResponse = this.refundPay(RefundPayDto.builder().ip(this.getAddress()).projectCode(paymentDetail.getProjectCode()).oriOutTradeNo(pp.getOrderNo()).totalFee(new BigDecimal(paymentAmount).multiply(new BigDecimal("100")).longValue()).refundOrderNo(refundOrderNo).build());
        if (!StringUtils.equals((CharSequence)refundResponse.getStatus(), (CharSequence)"2")) {
            throw new RuntimeException("\u9000\u6b3e\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
        }
        updatePaymentDetail.setJlRefundOrderNo(refundResponse.getTransaction_id());
        return this.updateById((Object)updatePaymentDetail);
    }

    public List<PaymentDetailExcel> downPaymentDetailExcel(PaymentDetailQueryRequest r) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().ge(r.getBeginTransactionTime() != null, PaymentDetail::getTransactionTime, (Object)r.getBeginTransactionTime())).le(r.getEndTransactionTime() != null, PaymentDetail::getTransactionTime, (Object)r.getEndTransactionTime())).eq(StringUtils.isNotBlank((CharSequence)r.getCity()), PaymentDetail::getCity, (Object)r.getCity())).eq(StringUtils.isNotBlank((CharSequence)r.getBrandName()), PaymentDetail::getBrandName, (Object)r.getBrandName())).eq(StringUtils.isNotBlank((CharSequence)r.getProjectName()), PaymentDetail::getProjectName, (Object)r.getProjectName())).eq(StringUtils.isNotBlank((CharSequence)r.getProjectType()), PaymentDetail::getProjectType, (Object)r.getProjectType())).eq(StringUtils.isNotBlank((CharSequence)r.getSaleTargetName()), PaymentDetail::getSaleTargetName, (Object)r.getSaleTargetName())).eq(StringUtils.isNotBlank((CharSequence)r.getBroadbandUser()), PaymentDetail::getBroadbandUser, (Object)r.getBroadbandUser())).eq(StringUtils.isNotBlank((CharSequence)r.getBuyPackageType()), PaymentDetail::getBuyPackageType, (Object)r.getBuyPackageType())).eq(StringUtils.isNotBlank((CharSequence)r.getPaymentType()), PaymentDetail::getPaymentType, (Object)r.getPaymentType())).eq(StringUtils.isNotBlank((CharSequence)r.getOrderNo()), PaymentDetail::getOrderNo, (Object)r.getOrderNo())).eq(StringUtils.isNotBlank((CharSequence)r.getRefundOrderNo()), PaymentDetail::getRefundOrderNo, (Object)r.getRefundOrderNo())).eq(PaymentDetail::getIsDeleted, (Object)0)).orderByDesc(PaymentDetail::getId);
        List paymentDetailList = this.list((Wrapper)wrapper);
        return paymentDetailList.stream().map(m -> {
            String projectTypeStr = "";
            if (StringUtils.equals((CharSequence)m.getProjectType(), (CharSequence)"0")) {
                projectTypeStr = "\u516c\u5bd3\u5bbd\u5e26\u9879\u76ee";
            } else if (StringUtils.equals((CharSequence)m.getProjectType(), (CharSequence)"1")) {
                projectTypeStr = "\u5546\u5199\u5bbd\u5e26\u9879\u76ee";
            }
            return PaymentDetailExcel.builder().transactionTime(m.getTransactionTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"))).city(m.getCity()).brandName(m.getBrandName()).projectName(m.getProjectName()).projectType(projectTypeStr).saleTargetName(m.getSaleTargetName()).orderNo(m.getOrderNo()).broadbandUser(m.getBroadbandUser()).buyPackageType(m.getBuyPackageType()).paymentAmount(m.getPaymentAmount()).paymentType(m.getPaymentType()).refundStatus(m.getRefundStatus()).refundAmount(m.getRefundAmount()).refundOrderNo(m.getRefundOrderNo()).createName(m.getCreateName()).build();
        }).collect(Collectors.toList());
    }

    public JSONObject callPay(CallPayDto callPayDto) {
        PayAccountManagerVo payAccountManagerVo = this.payAccountManagerService.queryAccount();
        List subAccountManagerVoList = payAccountManagerVo.getProjectPayAccountList().stream().filter(f -> StringUtils.equals((CharSequence)f.getProjectCode(), (CharSequence)callPayDto.getProjectCode())).collect(Collectors.toList());
        PayAccountManagerVo.SubAccountManagerVo smv = CollectionUtils.isEmpty(subAccountManagerVoList) ? payAccountManagerVo.getDefaultPayAccount() : (PayAccountManagerVo.SubAccountManagerVo)subAccountManagerVoList.get(0);
        PaymentRequest paymentRequest = PaymentRequest.builder().mch_id(smv.getMchId()).nonce_str(CommonUtil.generateRandomString()).charset("UTF-8").sign_type("RSA").pay_type("wxpay").open_id(callPayDto.getOpenId()).sub_appid("wx43cacc6dc7d3bce2").out_trade_no(CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.ORDER, (String)callPayDto.getProjectCode())).body(callPayDto.getProductTitle()).attach(callPayDto.getAttach()).total_fee(new BigDecimal(callPayDto.getTotalFee()).multiply(new BigDecimal("100")).toBigInteger().toString()).notify_url(this.notifyUrl).mch_create_ip("49.74.248.198").build();
        String paramJson = new Gson().toJson((Object)paymentRequest);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)smv.getPrivateKey());
        paymentRequest.setSign(sign);
        String result = this.payService.sendMessage2Http(new Gson().toJson((Object)paymentRequest), "/pay/officialpay");
        log.info("=====" + result);
        PaymentResponse paymentResponse = (PaymentResponse)new Gson().fromJson(result, PaymentResponse.class);
        String payInfo = paymentResponse.getPay_info();
        return JSONObject.parseObject((String)payInfo);
    }

    public JSONObject callPaytest(String sss) {
        PaymentRequestTest paymentRequest = PaymentRequestTest.builder().org_code("50868071").mch_id("849331748160028").nonce_str(CommonUtil.generateRandomString()).charset("UTF-8").sign_type("RSA").pay_type("wxpay").open_id("ojnEj7ZpXEsY8jKxb81sUDLRKFlU").sub_appid("wx43cacc6dc7d3bce2").out_trade_no("dfsd" + System.currentTimeMillis()).body("\u6d4b\u8bd5\u5546\u54c1").attach("\u5f88\u7b80\u5355\u5eb7\u5e08\u5085SDK").total_fee(new BigDecimal(0.1).multiply(new BigDecimal("100")).toBigInteger().toString()).notify_url(this.notifyUrl).mch_create_ip("49.74.248.198").term_no("S3367006").build();
        String paramJson = new Gson().toJson((Object)paymentRequest);
        String sign = SignUtil.sign((String)paramJson);
        paymentRequest.setSign(sign);
        String result = this.payService.sendMessage2Http1(new Gson().toJson((Object)paymentRequest), "https://qrcode.jlpay.com/api/pay/officialpay");
        log.info("=====" + result);
        PaymentResponse paymentResponse = (PaymentResponse)new Gson().fromJson(result, PaymentResponse.class);
        String payInfo = paymentResponse.getPay_info();
        return JSONObject.parseObject((String)payInfo);
    }

    public JSONObject payAuthbind(String sss) {
        PayAuthbindRequest paymentRequest = PayAuthbindRequest.builder().org_code("50868071").mch_id("849331748160028").nonce_str(CommonUtil.generateRandomString()).charset("UTF-8").sign_type("RSA").pay_type("wxpay").jsapi_path("https://yiyang.njhuiming.com/").mch_create_ip("49.74.248.198").build();
        String paramJson = new Gson().toJson((Object)paymentRequest);
        String sign = SignUtil.sign((String)paramJson);
        paymentRequest.setSign(sign);
        String result = this.payService.sendMessage2Http1(new Gson().toJson((Object)paymentRequest), "https://qrcode.jlpay.com/api/pay/authbind");
        log.info("=====" + result);
        return JSONObject.parseObject((String)result);
    }

    public PaymentResponse callBindPay(CallPayDto callPayDto) {
        PayAccountManagerVo payAccountManagerVo = this.payAccountManagerService.queryAccount();
        List subAccountManagerVoList = payAccountManagerVo.getProjectPayAccountList().stream().filter(f -> StringUtils.equals((CharSequence)f.getProjectCode(), (CharSequence)callPayDto.getProjectCode())).collect(Collectors.toList());
        PayAccountManagerVo.SubAccountManagerVo smv = CollectionUtils.isEmpty(subAccountManagerVoList) ? payAccountManagerVo.getDefaultPayAccount() : (PayAccountManagerVo.SubAccountManagerVo)subAccountManagerVoList.get(0);
        AuthBind paymentRequest = AuthBind.builder().mch_id(smv.getMchId()).nonce_str(CommonUtil.generateRandomString()).charset("UTF-8").sign_type("RSA").pay_type("wxpay").sub_appid("wxb41d8756b53dff27").mch_create_ip("49.74.248.198").build();
        String paramJson = new Gson().toJson((Object)paymentRequest);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)smv.getPrivateKey());
        paymentRequest.setSign(sign);
        String result = this.payService.sendMessage2Http(new Gson().toJson((Object)paymentRequest), "/pay/authbind");
        log.info("===" + result);
        return null;
    }

    public PaymentResponse newcallPay(CallPayDto callPayDto) {
        PayAccountManagerVo payAccountManagerVo = this.payAccountManagerService.queryAccount();
        List subAccountManagerVoList = payAccountManagerVo.getProjectPayAccountList().stream().filter(f -> StringUtils.equals((CharSequence)f.getProjectCode(), (CharSequence)callPayDto.getProjectCode())).collect(Collectors.toList());
        PayAccountManagerVo.SubAccountManagerVo smv = CollectionUtils.isEmpty(subAccountManagerVoList) ? payAccountManagerVo.getDefaultPayAccount() : (PayAccountManagerVo.SubAccountManagerVo)subAccountManagerVoList.get(0);
        PaymentRequest paymentRequest = PaymentRequest.builder().mch_id(smv.getMchId()).nonce_str(callPayDto.getProjectCode()).charset("UTF-8").sign_type("RSA").pay_type("wxpay").out_trade_no(CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.ORDER, (String)callPayDto.getProjectCode())).body(callPayDto.getProductTitle()).attach(callPayDto.getAttach()).mch_create_ip(this.getAddress()).notify_url(this.notifyUrl).total_fee(new BigDecimal(callPayDto.getTotalFee()).multiply(new BigDecimal("100")).toBigInteger().toString()).build();
        String paramJson = new Gson().toJson((Object)paymentRequest);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)smv.getPrivateKey());
        paymentRequest.setSign(sign);
        String result = this.payService.sendMessage2Http(new Gson().toJson((Object)paymentRequest), "/pay/cashier");
        log.info("====" + result);
        PaymentResponse paymentResponse = (PaymentResponse)new Gson().fromJson(result, PaymentResponse.class);
        String h5Url = paymentResponse.getH5_url();
        String[] pays = h5Url.split("/");
        paymentResponse.setOut_trade_no(pays[pays.length - 1]);
        UserManager u = (UserManager)this.managerMapper.selectById((Serializable)callPayDto.getUserId());
        PaymentDetail paymentDetail = PaymentDetail.builder().transactionTime(LocalDateTime.now()).city(u.getCity()).roomNo(u.getRoomNo()).projectName(u.getProjectName()).projectCode(u.getProjectCode()).projectType(u.getProjectType()).beginTime(LocalDateTime.now()).saleTargetName(u.getSaleTargetName()).orderNo(paymentRequest.getOut_trade_no()).broadbandUser(u.getBroadbandUser()).broadbandUserId(callPayDto.getUserId()).orderState("0").buyPackageType("\u5fae\u4fe1").paymentType("\u5fae\u4fe1").paymentAmount(callPayDto.getTotalFee()).subPackageGroupName(callPayDto.getSubPackageGroupName()).subPackageGroupCode(callPayDto.getSubPackageGroupCode()).billDuration(callPayDto.getBillDuration()).billDurationUnit(callPayDto.getBillDurationUnit()).createName(SecurityUtils.getLoginUser().getUsername()).createUser(SecurityUtils.getLoginUser().getUserid()).build();
        if (u.getEndTime().compareTo(LocalDateTime.now()) < 0) {
            paymentDetail.setBeginTime(LocalDateTime.now());
            LocalDateTime endTime = this.getEndTime(LocalDateTime.now(), Integer.valueOf(callPayDto.getBillDuration()), callPayDto.getBillDurationUnit());
            paymentDetail.setEndTime(endTime);
            paymentDetail.setExpireTime(endTime);
        } else {
            paymentDetail.setBeginTime(u.getBeginTime());
            LocalDateTime endTime = this.getEndTime(u.getEndTime(), Integer.valueOf(callPayDto.getBillDuration()), callPayDto.getBillDurationUnit());
            paymentDetail.setEndTime(endTime);
            paymentDetail.setExpireTime(endTime);
        }
        this.save((Object)paymentDetail);
        this.orderService.saveOrder(paymentDetail, Integer.valueOf(2));
        return paymentResponse;
    }

    public RefundResponse refundPay(RefundPayDto refundPayDto) {
        PayAccountManagerVo payAccountManagerVo = this.payAccountManagerService.queryAccount();
        List subAccountManagerVoList = payAccountManagerVo.getProjectPayAccountList().stream().filter(f -> StringUtils.equals((CharSequence)f.getProjectCode(), (CharSequence)refundPayDto.getProjectCode())).collect(Collectors.toList());
        PayAccountManagerVo.SubAccountManagerVo smv = CollectionUtils.isEmpty(subAccountManagerVoList) ? payAccountManagerVo.getDefaultPayAccount() : (PayAccountManagerVo.SubAccountManagerVo)subAccountManagerVoList.get(0);
        String fee = new BigDecimal(refundPayDto.getTotalFee()).toBigInteger().toString();
        RefundRequest refundRequest = RefundRequest.builder().mch_id(smv.getMchId()).nonce_str(refundPayDto.getProjectCode()).charset("UTF-8").sign_type("RSA").out_trade_no(refundPayDto.getRefundOrderNo()).ori_out_trade_no(refundPayDto.getOriOutTradeNo()).total_fee(fee).mch_create_ip(refundPayDto.getIp()).build();
        String paramJson = new Gson().toJson((Object)refundRequest);
        log.info("refund\u2014\u2014\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\uff1a" + paramJson);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)smv.getPrivateKey());
        refundRequest.setSign(sign);
        String result = this.payService.sendMessage2Http(new Gson().toJson((Object)refundRequest), "/pay/refund");
        log.info("refund\u2014\u2014\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        RefundResponse refundResponse = (RefundResponse)new Gson().fromJson(result, RefundResponse.class);
        String refundStatus = "0";
        if (refundResponse.getRet_code().equals("00")) {
            refundStatus = "1";
        }
        this.update((Object)PaymentDetail.builder().refundStatus(refundStatus).build(), (Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentDetail::getOrderNo, (Object)refundPayDto.getOriOutTradeNo())).eq(PaymentDetail::getIsDeleted, (Object)0));
        return refundResponse;
    }

    public RefundResponse refundPayNew(RefundPayDto refundPayDto) {
        PayAccountManagerVo payAccountManagerVo = this.payAccountManagerService.queryAccount();
        List subAccountManagerVoList = payAccountManagerVo.getProjectPayAccountList().stream().filter(f -> StringUtils.equals((CharSequence)f.getProjectCode(), (CharSequence)refundPayDto.getProjectCode())).collect(Collectors.toList());
        PayAccountManagerVo.SubAccountManagerVo smv = CollectionUtils.isEmpty(subAccountManagerVoList) ? payAccountManagerVo.getDefaultPayAccount() : (PayAccountManagerVo.SubAccountManagerVo)subAccountManagerVoList.get(0);
        RefundRequest refundRequest = RefundRequest.builder().mch_id(smv.getMchId()).nonce_str(refundPayDto.getProjectCode()).charset("UTF-8").sign_type("RSA").out_trade_no(refundPayDto.getRefundOrderNo()).ori_out_trade_no(refundPayDto.getOriOutTradeNo()).total_fee(refundPayDto.getTotalFeeStr()).mch_create_ip(refundPayDto.getIp()).build();
        String paramJson = new Gson().toJson((Object)refundRequest);
        log.info("refund\u2014\u2014\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\uff1a" + paramJson);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)smv.getPrivateKey());
        refundRequest.setSign(sign);
        String result = this.payService.sendMessage2Http(new Gson().toJson((Object)refundRequest), "/pay/refund");
        log.info("refund\u2014\u2014\u9000\u6b3e\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c\uff1a" + result);
        RefundResponse refundResponse = (RefundResponse)new Gson().fromJson(result, RefundResponse.class);
        String refundStatus = "0";
        if (refundResponse.getRet_code().equals("00")) {
            refundStatus = "1";
        }
        this.update((Object)PaymentDetail.builder().refundStatus(refundStatus).build(), (Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(PaymentDetail::getOrderNo, (Object)refundPayDto.getOriOutTradeNo())).eq(PaymentDetail::getIsDeleted, (Object)0));
        return refundResponse;
    }

    public void queryOrderInfo(String orderNo) {
        OrderInfo2Jialian orderInfo2Jialian = OrderInfo2Jialian.builder().mch_id("849331748160028").nonce_str(CommonUtil.generateRandomString()).charset("UTF-8").sign_type("RSA").out_trade_no(orderNo).build();
        String paramJson = JSONObject.toJSONString((Object)orderInfo2Jialian);
        String sign = SHA256WithRSAUtil.sign((String)paramJson, (String)"MIICdQIBADANBgkqhkiG9w0BAQEFAASCAl8wggJbAgEAAoGBANuRNpq4QiVQczkZ/VkZviPYDc1DDWozddr/AQ24FXFfCn19ayKLt+W8rT5SzvzyGTZBwDeybyu1t9fRsiMxhQwAClJenjkLYsFzyKcg4McyKPUXLqTSWGCcu2dzxdsHwiDnVQyzxsneIesm+hVI0qJJCXdSM35vsZuTlJdjLmC/AgMBAAECgYAd0NjU5suYrJWQ/f4A0PWYgXjSVFYog0dwTyuR9Nr4k7rlcpgPT2DQEjCGY5FXGPsieohDJ/hfu6P06zVhARL7X0tO2LCYZZ17yCpKY6yd8NGtNGf/8nxbdmLwv8DTpA5LCu0TePokLKaQgD/K297czHvWhwZc20MY5yLSQCkxnQJBAO9+zi65JWRTGUht6iU3gd3AoAFKc6Gat5dR1NNN1av678BF3+LxwW0COmJDDE8dGHeSSrBsnLaGAtOHf1jOpdMCQQDqstXAjxusEd/0wVCjYRSAeSF97k64AKvcp3yonyjfgyiLmzHggZRV1SsvoOWTGHzDVnBOnlcGrkKMFFxJnenlAkBscWOU3nri6Ym6NSLfhTnFmlIZI4gmNbNJzmDq6QSGYhKrYjhVP5iQ7oBXO/rX29nXUqOFLTjsoNOoymLMaI3HAkBlJIqvgDzJq65bGRA6SHUAZLNFRPTRoSBvaBJ1zJldsXVArLIS8WTOlJ4W2Xz2JkBmIhMmHmCctW5iVcfrxcztAkBMLD7Zw3z+IC5jcj9TNmB4abmwd2Zh7D5frFDYMjP/2fYaUMk5PI7eNMWkFStiK6WyTx18rZp09NcLbszgFTlZ");
        orderInfo2Jialian.setSign(sign);
        String result = this.payService.sendMessage2Http(JSONObject.toJSONString((Object)orderInfo2Jialian), "/pay/chnquery");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getAddress() {
        OkHttpClient client = new OkHttpClient();
        Request request = new Request.Builder().url("https://api.ipify.org").build();
        String address = "";
        try (Response response = client.newCall(request).execute();){
            if (response.isSuccessful()) {
                String publicIP = response.body().string();
                log.info("========publicIP " + publicIP);
                String string2 = publicIP;
                return string2;
            }
            address = InetAddress.getLocalHost().getHostAddress();
            log.info("========address " + address);
            String string = address;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e2) {
                throw new RuntimeException(e2);
            }
            log.info("========address " + address);
            return address;
        }
    }

    @Transactional
    public boolean updateState(String orderNo, String state) {
        if (!StringUtils.equals((CharSequence)state, (CharSequence)"2")) {
            return false;
        }
        try {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(PaymentDetail::getOrderNo, (Object)orderNo);
            PaymentDetail paymentDetail = (PaymentDetail)((PaymentDetailMapper)this.baseMapper).selectOne((Wrapper)wrapper);
            if (ObjectUtil.isNotEmpty((Object)paymentDetail) && paymentDetail.getOrderState().equals("0")) {
                paymentDetail.setOrderState("1");
                this.updateById((Object)paymentDetail);
                LambdaQueryWrapper packageWrapper = new LambdaQueryWrapper();
                packageWrapper.eq(SubPackageGroupManager::getSubPackageGroupCode, (Object)paymentDetail.getSubPackageGroupCode());
                SubPackageGroupManager subPackageGroupManager = (SubPackageGroupManager)this.packageGroupManagerMapper.selectOne((Wrapper)packageWrapper);
                PackageGroupManager packageGroupManager = this.packageGroupManagerMapper.querySubPackageList(paymentDetail.getSubPackageGroupCode());
                UserManager userManager = (UserManager)this.managerMapper.selectById((Serializable)paymentDetail.getBroadbandUserId());
                if (packageGroupManager.getPackageGroupType().equals("1")) {
                    userManager.setPackageCode(subPackageGroupManager.getSubPackageGroupCode());
                    userManager.setPackageName(subPackageGroupManager.getSubPackageGroupName());
                    userManager.setBillDuration(subPackageGroupManager.getBillDuration());
                    userManager.setPrice(subPackageGroupManager.getStandardTariff());
                    if (userManager.getEndTime().compareTo(LocalDateTime.now()) < 0) {
                        userManager.setBeginTime(LocalDateTime.now());
                        LocalDateTime endTime = this.getEndTime(LocalDateTime.now(), Integer.valueOf(subPackageGroupManager.getBillDuration()), subPackageGroupManager.getBillDurationUnit());
                        userManager.setEndTime(endTime);
                    } else {
                        LocalDateTime endTime = this.getEndTime(userManager.getEndTime(), Integer.valueOf(subPackageGroupManager.getBillDuration()), subPackageGroupManager.getBillDurationUnit());
                        userManager.setEndTime(endTime);
                    }
                } else if (packageGroupManager.getPackageGroupType().equals("2")) {
                    userManager.setSpeedPackageCode(subPackageGroupManager.getSubPackageGroupCode());
                    userManager.setSpeedPackageName(subPackageGroupManager.getSubPackageGroupName());
                    userManager.setBillDuration(subPackageGroupManager.getBillDuration());
                    userManager.setSpeedPackagePrice(subPackageGroupManager.getStandardTariff());
                    LocalDateTime endTime = this.getEndTime(userManager.getEndTime(), Integer.valueOf(subPackageGroupManager.getBillDuration()), subPackageGroupManager.getBillDurationUnit());
                    userManager.setSpeedPackageEndTime(endTime);
                    userManager.setSpeedPackageBeginTime(LocalDateTime.now());
                }
                userManager.setDownload(subPackageGroupManager.getDownload());
                userManager.setUpload(subPackageGroupManager.getUpload());
                userManager.setCUpload(subPackageGroupManager.getCUpload());
                this.managerMapper.updateById((Object)userManager);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u9000\u6b3e\u72b6\u6001\u4fee\u6539\u5931\u8d25");
        }
        return true;
    }

    private LocalDateTime getEndTime(LocalDateTime endTime, Integer billDuration, String billDurationUnit) {
        int daysToAdd = 0;
        switch (billDurationUnit) {
            case "y": {
                daysToAdd = billDuration * 12 * 30;
                break;
            }
            case "m": {
                daysToAdd = billDuration * 30;
                break;
            }
            case "d": {
                daysToAdd = billDuration;
                break;
            }
        }
        LocalDateTime localDateTime = endTime.plusDays(daysToAdd);
        return localDateTime;
    }
}

