/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.entity.SeparateAccountsAllocation;
import com.ruoyi.entity.SeparateAccountsAllocationDetail;
import com.ruoyi.entity.SeparateAccountsAllocationLog;
import com.ruoyi.mapper.SeparateAccountsAllocationMapper;
import com.ruoyi.query.SeparateAccountsAllocationQuery;
import com.ruoyi.service.SeparateAccountsAllocationDetailService;
import com.ruoyi.service.SeparateAccountsAllocationLogService;
import com.ruoyi.service.SeparateAccountsAllocationService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.UserUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SeparateAccountsAllocationServiceImpl
extends ServiceImpl<SeparateAccountsAllocationMapper, SeparateAccountsAllocation>
implements SeparateAccountsAllocationService {
    private static final Logger log = LoggerFactory.getLogger(SeparateAccountsAllocationServiceImpl.class);
    @Resource
    private SeparateAccountsAllocationDetailService separateAccountsAllocationDetailService;
    @Resource
    private SeparateAccountsAllocationLogService separateAccountsAllocationLogService;
    @Resource
    private SeparateAccountsAllocationMapper accountsAllocationMapper;

    public Page<SeparateAccountsAllocation> getPage(SeparateAccountsAllocationQuery query) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)query.getStatus()), SeparateAccountsAllocation::getStatus, (Object)query.getStatus())).and(ObjectUtil.isNotEmpty((Object)query.getBrandName()), wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(SeparateAccountsAllocation::getBrandName, (Object)query.getBrandName())).or()).like(SeparateAccountsAllocation::getSubbrandName, (Object)query.getBrandName()))).like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), SeparateAccountsAllocation::getProjectName, (Object)query.getProjectName())).orderByAsc(SeparateAccountsAllocation::getBrandCode)).orderByAsc(SeparateAccountsAllocation::getSubbrandCode)).orderByAsc(SeparateAccountsAllocation::getProjectCode);
        Page page = (Page)this.page((IPage)new Page(query.getPageNum(), query.getPageSize()), (Wrapper)wrapper);
        if (CollectionUtil.isNotEmpty((Collection)page.getRecords())) {
            for (SeparateAccountsAllocation record : page.getRecords()) {
                String brandName = this.accountsAllocationMapper.getBrandName(record.getBrandCode());
                record.setBrandName(brandName);
                if (ObjectUtil.isNotEmpty((Object)record.getSubbrandCode())) {
                    String subbrandName = this.accountsAllocationMapper.getSubBrandName(record.getSubbrandCode());
                    record.setSubbrandName(subbrandName);
                }
                if (!ObjectUtil.isNotEmpty((Object)record.getProjectCode())) continue;
                String projectName = this.accountsAllocationMapper.getProjectName(record.getProjectCode());
                record.setProjectName(projectName);
            }
        }
        return page;
    }

    public SeparateAccountsAllocation getDetails(Long id) {
        SeparateAccountsAllocation allocation = (SeparateAccountsAllocation)this.getById((Serializable)id);
        List detailList = this.separateAccountsAllocationDetailService.list((Wrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocationDetail::getSeparateId, (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            allocation.setDetailList(detailList);
        }
        return allocation;
    }

    public R create(SeparateAccountsAllocation allocation) {
        R failed = this.checkAdd(allocation);
        if (failed != null) {
            return failed;
        }
        LoginUser loginUser = UserUtils.getLoginUser();
        allocation.setCreateName(loginUser.getUsername());
        allocation.setCreateUser(loginUser.getUserid());
        allocation.setUpdateUser(loginUser.getUserid());
        allocation.setUpdateName(loginUser.getUsername());
        allocation.setCreateTime(new Date());
        allocation.setUpdateTime(new Date());
        allocation.setStatus(Integer.valueOf(0));
        this.save((Object)allocation);
        List detailList = allocation.getDetailList();
        detailList.stream().forEach(f -> {
            f.setSeparateId(allocation.getId());
            f.setCreateName(loginUser.getUsername());
            f.setCreateUser(loginUser.getUserid());
            f.setUpdateUser(loginUser.getUserid());
            f.setUpdateName(loginUser.getUsername());
            f.setCreateTime(new Date());
            f.setUpdateTime(new Date());
            f.setStatus(Integer.valueOf(0));
        });
        this.separateAccountsAllocationDetailService.saveBatch((Collection)detailList);
        SeparateAccountsAllocationLog log = new SeparateAccountsAllocationLog();
        log.setSeparateId(allocation.getId());
        log.setCreateName(loginUser.getUsername());
        log.setCreateUser(loginUser.getUserid());
        log.setUpdateUser(loginUser.getUserid());
        log.setUpdateName(loginUser.getUsername());
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setSeparateCount(Integer.valueOf(1));
        log.setSeparateInfo(JSONObject.toJSONString((Object)allocation));
        this.separateAccountsAllocationLogService.save((Object)log);
        return R.ok((Object)allocation.getId());
    }

    @Nullable
    private R<Object> checkAdd(SeparateAccountsAllocation allocation) {
        int count;
        if (StringUtils.isEmpty((String)allocation.getSubbrandCode()) && StringUtils.isEmpty((String)allocation.getProjectCode()) && (count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).isNull(SeparateAccountsAllocation::getSubbrandCode)).isNull(SeparateAccountsAllocation::getProjectCode))) > 0) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (StringUtils.isNotEmpty((String)allocation.getSubbrandCode()) && StringUtils.isEmpty((String)allocation.getProjectCode()) && (count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).eq(SeparateAccountsAllocation::getSubbrandCode, (Object)allocation.getSubbrandCode())).isNull(SeparateAccountsAllocation::getProjectCode))) > 0) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (StringUtils.isEmpty((String)allocation.getSubbrandCode()) && StringUtils.isNotEmpty((String)allocation.getProjectCode()) && (count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).isNull(SeparateAccountsAllocation::getSubbrandCode)).eq(SeparateAccountsAllocation::getProjectCode, (Object)allocation.getProjectCode()))) > 0) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (StringUtils.isNotEmpty((String)allocation.getSubbrandCode()) && StringUtils.isNotEmpty((String)allocation.getProjectCode()) && (count = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).eq(SeparateAccountsAllocation::getSubbrandCode, (Object)allocation.getSubbrandCode())).eq(SeparateAccountsAllocation::getProjectCode, (Object)allocation.getProjectCode()))) > 0) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        return null;
    }

    public R update(SeparateAccountsAllocation allocation) {
        R failed = this.checkUpdate(allocation);
        if (failed != null) {
            return failed;
        }
        LoginUser loginUser = UserUtils.getLoginUser();
        allocation.setUpdateUser(loginUser.getUserid());
        allocation.setUpdateName(loginUser.getUsername());
        allocation.setUpdateTime(new Date());
        Boolean update = this.updateById((Object)allocation);
        this.separateAccountsAllocationDetailService.remove((Wrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocationDetail::getSeparateId, (Object)allocation.getId()));
        List detailList = allocation.getDetailList();
        detailList.stream().forEach(f -> {
            f.setSeparateId(allocation.getId());
            f.setCreateName(loginUser.getUsername());
            f.setCreateUser(loginUser.getUserid());
            f.setUpdateUser(loginUser.getUserid());
            f.setUpdateName(loginUser.getUsername());
            f.setCreateTime(new Date());
            f.setUpdateTime(new Date());
        });
        this.separateAccountsAllocationDetailService.saveBatch((Collection)detailList);
        int count = this.separateAccountsAllocationLogService.count((Wrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocationLog::getSeparateId, (Object)allocation.getId()));
        SeparateAccountsAllocationLog log = new SeparateAccountsAllocationLog();
        log.setSeparateId(allocation.getId());
        log.setCreateName(loginUser.getUsername());
        log.setCreateUser(loginUser.getUserid());
        log.setUpdateUser(loginUser.getUserid());
        log.setUpdateName(loginUser.getUsername());
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setSeparateCount(Integer.valueOf(count + 1));
        log.setSeparateInfo(JSONObject.toJSONString((Object)allocation));
        this.separateAccountsAllocationLogService.save((Object)log);
        return R.ok((Object)update);
    }

    @Nullable
    private R<Object> checkUpdate(SeparateAccountsAllocation allocation) {
        SeparateAccountsAllocation setting;
        if (StringUtils.isEmpty((String)allocation.getSubbrandCode()) && StringUtils.isEmpty((String)allocation.getProjectCode()) && null != (setting = (SeparateAccountsAllocation)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).isNull(SeparateAccountsAllocation::getSubbrandCode)).isNull(SeparateAccountsAllocation::getProjectCode))) && setting.getId() != setting.getId()) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (ObjectUtil.isNotEmpty((Object)allocation.getSubbrandCode()) && StringUtils.isEmpty((String)allocation.getProjectCode()) && null != (setting = (SeparateAccountsAllocation)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).eq(SeparateAccountsAllocation::getSubbrandCode, (Object)allocation.getSubbrandCode())).isNull(SeparateAccountsAllocation::getProjectCode))) && setting.getId() != setting.getId()) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (StringUtils.isEmpty((String)allocation.getSubbrandCode()) && ObjectUtil.isNotEmpty((Object)allocation.getProjectCode()) && null != (setting = (SeparateAccountsAllocation)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).isNull(SeparateAccountsAllocation::getSubbrandCode)).eq(SeparateAccountsAllocation::getProjectCode, (Object)allocation.getProjectCode()))) && setting.getId() != setting.getId()) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        if (ObjectUtil.isNotEmpty((Object)allocation.getSubbrandCode()) && ObjectUtil.isNotEmpty((Object)allocation.getProjectCode()) && null != (setting = (SeparateAccountsAllocation)this.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SeparateAccountsAllocation::getBrandCode, (Object)allocation.getBrandCode())).eq(SeparateAccountsAllocation::getSubbrandCode, (Object)allocation.getSubbrandCode())).eq(SeparateAccountsAllocation::getProjectCode, (Object)allocation.getProjectCode()))) && setting.getId() != setting.getId()) {
            return R.failed((String)"\u6b64\u5206\u8d26\u89c4\u5219\u5df2\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4\uff01");
        }
        return null;
    }

    public void export(SeparateAccountsAllocationQuery query, HttpServletResponse response) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)query.getStatus()), SeparateAccountsAllocation::getStatus, (Object)query.getStatus())).and(ObjectUtil.isNotEmpty((Object)query.getBrandName()), wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(SeparateAccountsAllocation::getBrandName, (Object)query.getBrandName())).or()).like(SeparateAccountsAllocation::getSubbrandName, (Object)query.getBrandName()))).like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), SeparateAccountsAllocation::getProjectName, (Object)query.getProjectName())).orderByAsc(SeparateAccountsAllocation::getBrandCode)).orderByAsc(SeparateAccountsAllocation::getSubbrandCode)).orderByAsc(SeparateAccountsAllocation::getProjectCode);
        Page page = (Page)this.page((IPage)new Page(query.getPageNum(), 9999L), (Wrapper)wrapper);
        List records = page.getRecords();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExcelWriter writer = null;
        ServletOutputStream outputStream = null;
        try {
            if (CollectionUtil.isNotEmpty((Collection)records)) {
                writer = ExcelUtil.getWriterWithSheet((String)"\u5206\u8d26\u914d\u7f6e");
                writer.writeCellValue(0, 0, (Object)"\u54c1\u724c");
                writer.writeCellValue(1, 0, (Object)"\u5b50\u54c1\u724c");
                writer.writeCellValue(2, 0, (Object)"\u9879\u76ee");
                writer.writeCellValue(3, 0, (Object)"\u72b6\u6001");
                writer.writeCellValue(4, 0, (Object)"\u64cd\u4f5c\u4eba");
                writer.writeCellValue(5, 0, (Object)"\u64cd\u4f5c\u65f6\u95f4");
                writer.setColumnWidth(0, 22);
                writer.setColumnWidth(1, 22);
                writer.setColumnWidth(2, 22);
                writer.setColumnWidth(3, 22);
                writer.setColumnWidth(4, 22);
                writer.setColumnWidth(5, 22);
                int num = 0;
                for (SeparateAccountsAllocation allocation : records) {
                    writer.writeCellValue(0, num + 1, (Object)allocation.getBrandName());
                    writer.writeCellValue(1, num + 1, (Object)(Objects.isNull(allocation.getSubbrandName()) ? "" : allocation.getSubbrandName()));
                    writer.writeCellValue(2, num + 1, (Object)(Objects.isNull(allocation.getProjectName()) ? "" : allocation.getProjectName()));
                    writer.writeCellValue(3, num + 1, (Object)(!allocation.getStatus().toString().equals("1") ? "\u672a\u751f\u6548" : "\u751f\u6548\u4e2d"));
                    writer.writeCellValue(4, num + 1, (Object)(Objects.isNull(allocation.getUpdateName()) ? "admin" : allocation.getUpdateName()));
                    writer.writeCellValue(5, num + 1, (Object)(Objects.isNull(allocation.getUpdateTime()) ? sdf.format(new Date()) : sdf.format(allocation.getUpdateTime())));
                    ++num;
                }
                String fileName = URLEncoder.encode("\u5206\u8d26\u914d\u7f6e", "UTF-8");
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
                outputStream = response.getOutputStream();
                writer.flush((OutputStream)outputStream, true);
            }
        }
        catch (IOException e) {
            log.error("\u5206\u8d26\u914d\u7f6e\u5bfc\u51fa\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

