/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.dto.SubPackageGroupQueryRequest;
import com.ruoyi.dto.SubPackageGroupRequest;
import com.ruoyi.dto.SubPackageManagerExcel;
import com.ruoyi.entity.PackageGroupManager;
import com.ruoyi.entity.SubPackageGroupManager;
import com.ruoyi.mapper.PackageGroupManagerMapper;
import com.ruoyi.mapper.SubPackageGroupManagerMapper;
import com.ruoyi.service.ISubPackageGroupManagerService;
import com.ruoyi.service.IUserManagerService;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SubPackageGroupManagerServiceImpl
extends ServiceImpl<SubPackageGroupManagerMapper, SubPackageGroupManager>
implements ISubPackageGroupManagerService {
    private static final Logger log = LoggerFactory.getLogger(SubPackageGroupManagerServiceImpl.class);
    @Autowired
    private SubPackageGroupManagerMapper subPackageGroupManagerMapper;
    @Autowired
    private PackageGroupManagerMapper packageGroupManagerMapper;
    @Resource
    private IUserManagerService iUserManagerService;

    public Page<SubPackageGroupManager> querySubPackagePage(SubPackageGroupQueryRequest subPackageGroupQueryRequest) {
        Page pageCondition = new Page(subPackageGroupQueryRequest.getPageNum(), subPackageGroupQueryRequest.getPageSize());
        return this.subPackageGroupManagerMapper.querySubPackagePageList(pageCondition, subPackageGroupQueryRequest);
    }

    public SubPackageGroupRequest queryDetail(Long id) {
        SubPackageGroupManager sgm = (SubPackageGroupManager)this.getById((Serializable)id);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PackageGroupManager::getPackageGroupCode, (Object)sgm.getRelPackageGroupCode());
        PackageGroupManager packageGroupManager = (PackageGroupManager)this.packageGroupManagerMapper.selectOne((Wrapper)wrapper);
        SubPackageGroupRequest.PersonInfo p = SubPackageGroupRequest.PersonInfo.builder().createTime(Date.from(sgm.getCreateTime().atZone(ZoneId.systemDefault()).toInstant())).createUser(sgm.getCreateName()).build();
        SubPackageGroupRequest.SubPackageGroupInfo s = SubPackageGroupRequest.SubPackageGroupInfo.builder().billDuration(sgm.getBillDuration()).billDurationUnit(sgm.getBillDurationUnit()).bindArea(sgm.getBindArea()).bindProject(StringUtils.isBlank((CharSequence)sgm.getBindProject()) ? null : Arrays.asList(StringUtils.split((String)sgm.getBindProject(), (String)","))).buyType(sgm.getBuyType()).relPackageGroupCode(sgm.getRelPackageGroupCode()).shareNumber(sgm.getShareNumber()).subPackageGroupCode(sgm.getSubPackageGroupCode()).subPackageGroupName(sgm.getSubPackageGroupName()).upload(sgm.getUpload()).cUpload(sgm.getCUpload()).download(sgm.getDownload()).standardTariff(sgm.getStandardTariff()).standardTariffMain(packageGroupManager.getStandardTariff()).subPackageGroupType(sgm.getSubPackageGroupType()).subPackageGroupCode(sgm.getSubPackageGroupCode()).subSort(sgm.getSubSort()).userVisible(sgm.getUserVisible()).build();
        return SubPackageGroupRequest.builder().id(sgm.getId()).personInfo(p).subPackageGroupInfo(s).build();
    }

    public boolean addSubPackage(SubPackageGroupRequest subPackageGroupRequest) {
        SubPackageGroupRequest.PersonInfo p = subPackageGroupRequest.getPersonInfo();
        SubPackageGroupRequest.SubPackageGroupInfo sp = subPackageGroupRequest.getSubPackageGroupInfo();
        SubPackageGroupManager subPackageGroupManager = SubPackageGroupManager.builder().status("0").billDuration(sp.getBillDuration()).billDurationUnit(sp.getBillDurationUnit()).bindArea(sp.getBindArea()).bindProject(CollectionUtils.isEmpty((Collection)sp.getBindProject()) ? null : String.join((CharSequence)",", sp.getBindProject())).buyType(sp.getBuyType()).relPackageGroupCode(sp.getRelPackageGroupCode()).shareNumber(sp.getShareNumber()).subPackageGroupCode(sp.getRelPackageGroupCode() + this.randomNum()).subPackageGroupName(sp.getSubPackageGroupName()).createUser(SecurityUtils.getLoginUser().getUserid()).createName(SecurityUtils.getLoginUser().getUsername()).upload(sp.getUpload()).cUpload(sp.getCUpload()).download(sp.getDownload()).standardTariff(sp.getStandardTariff()).subPackageGroupType(sp.getSubPackageGroupType()).subSort(sp.getSubSort()).userVisible(sp.getUserVisible()).build();
        this.save((Object)subPackageGroupManager);
        SubPackageGroupManager update = SubPackageGroupManager.builder().id(subPackageGroupManager.getId()).subPackageGroupCode(sp.getRelPackageGroupCode() + SubPackageGroupManagerServiceImpl.processNumber((int)Math.toIntExact(subPackageGroupManager.getId()))).build();
        return this.updateById((Object)update);
    }

    public static String processNumber(int number) {
        String numStr = String.valueOf(number);
        if (numStr.length() < 3) {
            StringBuilder sb = new StringBuilder();
            for (int i = numStr.length(); i < 3; ++i) {
                sb.append('0');
            }
            sb.append(numStr);
            return sb.toString();
        }
        if (numStr.length() > 4) {
            return numStr.substring(numStr.length() - 3);
        }
        return numStr;
    }

    public boolean editSubPackage(SubPackageGroupRequest subPackageGroupRequest) {
        SubPackageGroupRequest.SubPackageGroupInfo sp = subPackageGroupRequest.getSubPackageGroupInfo();
        String subPackageGroupType = sp.getSubPackageGroupType();
        String bindArea = "";
        String bindProject = "";
        if (StringUtils.equals((CharSequence)subPackageGroupType, (CharSequence)"\u533a\u57df\u5957\u9910")) {
            bindArea = sp.getBindArea();
        }
        if (StringUtils.equals((CharSequence)subPackageGroupType, (CharSequence)"\u9879\u76ee\u5957\u9910")) {
            bindProject = CollectionUtils.isEmpty((Collection)sp.getBindProject()) ? null : String.join((CharSequence)",", sp.getBindProject());
        }
        return this.updateById((Object)SubPackageGroupManager.builder().id(subPackageGroupRequest.getId()).billDuration(sp.getBillDuration()).billDurationUnit(sp.getBillDurationUnit()).bindArea(bindArea).bindProject(bindProject).download(sp.getDownload()).upload(sp.getUpload()).cUpload(sp.getCUpload()).buyType(sp.getBuyType()).subPackageGroupType(subPackageGroupType).relPackageGroupCode(sp.getRelPackageGroupCode()).shareNumber(sp.getShareNumber()).userVisible(sp.getUserVisible()).subSort(sp.getSubSort()).standardTariff(sp.getStandardTariff()).subPackageGroupName(sp.getSubPackageGroupName()).updateUser(SecurityUtils.getLoginUser().getUserid()).updateName(SecurityUtils.getLoginUser().getUsername()).standardTariff(sp.getStandardTariff()).build());
    }

    public R deleteSubPackage(String subPackageGroupCode) {
        List packageCode = this.iUserManagerService.list((Wrapper)new QueryWrapper().eq((Object)"package_code", (Object)subPackageGroupCode));
        if (ObjectUtil.isNotEmpty((Object)packageCode)) {
            return R.failed((String)"\u5220\u9664\u5931\u8d25\uff0c\u5b58\u5728\u7528\u6237\u7ed1\u5b9a\u8be5\u5957\u9910\uff01");
        }
        this.remove((Wrapper)new QueryWrapper().eq((Object)"sub_package_group_code", (Object)subPackageGroupCode));
        return R.ok((Object)"\u5220\u9664\u6210\u529f");
    }

    public boolean updateSate(Long id, String state) {
        return this.updateById((Object)SubPackageGroupManager.builder().id(id).status(state).build());
    }

    public List<SubPackageManagerExcel> downData2Excel(SubPackageGroupQueryRequest subPackageGroupQueryRequest) {
        Page pageCondition = new Page(0L, 10000L);
        Page result = this.subPackageGroupManagerMapper.querySubPackagePageList(pageCondition, subPackageGroupQueryRequest);
        if (result != null && CollectionUtils.isNotEmpty((Collection)result.getRecords())) {
            return result.getRecords().stream().map(m -> {
                SubPackageManagerExcel s = new SubPackageManagerExcel();
                BeanUtils.copyProperties((Object)m, (Object)s);
                if (StringUtils.equals((CharSequence)s.getBuyType(), (CharSequence)"0")) {
                    s.setBuyType("\u5168\u90e8");
                } else if (StringUtils.equals((CharSequence)s.getBuyType(), (CharSequence)"1")) {
                    s.setBuyType("\u65b0\u88c5");
                } else if (StringUtils.equals((CharSequence)s.getBuyType(), (CharSequence)"2")) {
                    s.setBuyType("\u7eed\u8d39");
                }
                if (StringUtils.equals((CharSequence)s.getStatus(), (CharSequence)"0")) {
                    s.setStatus("\u4e0b\u67b6");
                } else if (StringUtils.equals((CharSequence)s.getStatus(), (CharSequence)"1")) {
                    s.setStatus("\u4e0a\u67b6");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)m.getBillDurationUnit(), (CharSequence)"y")) {
                    s.setBillDuration(s.getBillDuration() + " \u5e74");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)m.getBillDurationUnit(), (CharSequence)"m")) {
                    s.setBillDuration(s.getBillDuration() + " \u6708");
                } else if (StringUtils.equalsIgnoreCase((CharSequence)m.getBillDurationUnit(), (CharSequence)"d")) {
                    s.setBillDuration(s.getBillDuration() + " \u65e5");
                }
                if (StringUtils.equals((CharSequence)s.getPackageGroupType(), (CharSequence)"1")) {
                    s.setPackageGroupType("\u6807\u51c6\u5957\u9910");
                } else if (StringUtils.equals((CharSequence)s.getPackageGroupType(), (CharSequence)"2")) {
                    s.setPackageGroupType("\u52a0\u901f\u5957\u9910");
                }
                return s;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public int randomNum() {
        Random random = new Random();
        return random.nextInt(900) + 100;
    }
}

