/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.dto.EditPackageInfoRequest;
import com.ruoyi.dto.SimpleUserManagerQueryRequest;
import com.ruoyi.dto.SpeedPackageRequest;
import com.ruoyi.dto.TempProjectDto;
import com.ruoyi.dto.UserManagerExcel;
import com.ruoyi.dto.UserManagerQueryRequest;
import com.ruoyi.dto.UserManagerRequest;
import com.ruoyi.dto.UserManagerVo;
import com.ruoyi.entity.NasManager;
import com.ruoyi.entity.NasSetUp;
import com.ruoyi.entity.PackageGroupManager;
import com.ruoyi.entity.PaymentDetail;
import com.ruoyi.entity.SmsSetUp;
import com.ruoyi.entity.SubPackageGroupManager;
import com.ruoyi.entity.UserManager;
import com.ruoyi.enums.OrderTypeEnum;
import com.ruoyi.mapper.PackageGroupManagerMapper;
import com.ruoyi.mapper.SubPackageGroupManagerMapper;
import com.ruoyi.mapper.UserManagerMapper;
import com.ruoyi.radius.RadiusClient;
import com.ruoyi.service.INasManagerService;
import com.ruoyi.service.INasSetUpService;
import com.ruoyi.service.IPaymentDetailService;
import com.ruoyi.service.ISmsSetUpService;
import com.ruoyi.service.IUserManagerService;
import com.ruoyi.service.order.OrderService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.telentcloudsms.SendSmsCloud;
import com.ruoyi.util.CommonUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserManagerServiceImpl
extends ServiceImpl<UserManagerMapper, UserManager>
implements IUserManagerService {
    private static final Logger log = LoggerFactory.getLogger(UserManagerServiceImpl.class);
    @Autowired
    private INasSetUpService nasSetUpService;
    @Autowired
    private IPaymentDetailService paymentDetailService;
    @Autowired
    private SubPackageGroupManagerMapper subPackageGroupManagerMapper;
    @Autowired
    private PackageGroupManagerMapper packageGroupManagerMapper;
    @Autowired
    private RadiusClient radiusClient;
    @Autowired
    private INasManagerService nasManagerService;
    @Autowired
    private SendSmsCloud sendSmsCloud;
    @Autowired
    private ISmsSetUpService smsSetUpService;
    @Autowired
    private UserManagerMapper userManagerMapper;
    @Resource
    private OrderService orderService;

    public Page<UserManager> queryUserManagerPage(UserManagerQueryRequest userManagerQueryRequest) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getProjectType, (Object)userManagerQueryRequest.getProjectType())).like(StringUtils.isNotBlank((CharSequence)userManagerQueryRequest.getProjectName()), UserManager::getProjectName, (Object)userManagerQueryRequest.getProjectName())).like(StringUtils.isNotBlank((CharSequence)userManagerQueryRequest.getCity()), UserManager::getCity, (Object)userManagerQueryRequest.getCity())).like(ObjectUtil.isNotEmpty((Object)userManagerQueryRequest.getBroadbandUser()), UserManager::getBroadbandUser, (Object)userManagerQueryRequest.getBroadbandUser())).like(ObjectUtil.isNotEmpty((Object)userManagerQueryRequest.getRoomNo()), UserManager::getRoomNo, (Object)userManagerQueryRequest.getRoomNo())).ge(userManagerQueryRequest.getBeginTime() != null, UserManager::getEndTime, (Object)userManagerQueryRequest.getBeginTime())).le(userManagerQueryRequest.getEndTime() != null, UserManager::getEndTime, (Object)userManagerQueryRequest.getEndTime())).eq(UserManager::getIsDeleted, (Object)0)).orderByDesc(UserManager::getCreateTime);
        return (Page)this.page((IPage)new Page(userManagerQueryRequest.getPageNum(), userManagerQueryRequest.getPageSize()), (Wrapper)wrapper);
    }

    public UserManager queryUserManagerPageUser(UserManagerQueryRequest userManagerQueryRequest) {
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysUser sysUser = loginUser.getSysUser();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UserManager::getBroadbandUser, (Object)userManagerQueryRequest.getBroadbandUser());
        UserManager one = (UserManager)this.getOne((Wrapper)wrapper);
        if (null != one && StringUtils.isNotBlank((CharSequence)one.getBroadbandUser())) {
            if (StringUtils.isNotBlank((CharSequence)one.getBroadbandPassword()) && one.getBroadbandPassword().equals(userManagerQueryRequest.getBroadbandPassword())) {
                LambdaQueryWrapper wrappers = new LambdaQueryWrapper();
                wrappers.eq(UserManager::getUserCode, (Object)userManagerQueryRequest.getUserId());
                UserManager one2 = (UserManager)this.getOne((Wrapper)wrappers);
                if (null == one2) {
                    one.setUserCode(userManagerQueryRequest.getUserId());
                    one.setPhone(sysUser.getPhonenumber());
                    this.updateById((Object)one);
                } else {
                    one2.setUserCode(null);
                    UpdateWrapper userManagerLambdaQueryWrapper = new UpdateWrapper();
                    userManagerLambdaQueryWrapper.set((Object)"user_code", null);
                    userManagerLambdaQueryWrapper.eq((Object)"id", (Object)one2.getId());
                    this.update(null, (Wrapper)userManagerLambdaQueryWrapper);
                    one.setPhone(sysUser.getPhonenumber());
                    one.setUserCode(userManagerQueryRequest.getUserId());
                    this.updateById((Object)one);
                }
                return one;
            }
            throw new RuntimeException("\u5bbd\u5e26\u5bc6\u7801\u4e0d\u5b58\u5728");
        }
        throw new RuntimeException("\u5bbd\u5e26\u7528\u6237\u540d\u4e0d\u5b58\u5728");
    }

    public UserManagerVo queryUserManagerPageCode(UserManagerQueryRequest userManagerQueryRequest) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(UserManager::getUserCode, (Object)userManagerQueryRequest.getUserId());
        UserManager one = (UserManager)this.getOne((Wrapper)wrapper);
        UserManagerVo userManagerVo = new UserManagerVo();
        if (null != one && StringUtils.isNotBlank((CharSequence)one.getBroadbandUser())) {
            BeanUtils.copyProperties((Object)one, (Object)userManagerVo);
            if (ObjectUtil.isNotEmpty((Object)one.getSpeedPackageName())) {
                LocalDateTime speedPackageEndTime = one.getSpeedPackageEndTime();
                if (speedPackageEndTime.isAfter(LocalDateTime.now())) {
                    userManagerVo.setSpeedPackStatus("2");
                } else {
                    userManagerVo.setSpeedPackStatus("1");
                }
            } else {
                userManagerVo.setSpeedPackStatus("0");
            }
            if (ObjectUtil.isNotEmpty((Object)one.getPackageName())) {
                long daysUntilExpiry = ChronoUnit.DAYS.between(LocalDateTime.now(), one.getEndTime());
                if (daysUntilExpiry <= 3L && daysUntilExpiry >= 0L) {
                    userManagerVo.setPackStatus("2");
                } else if (daysUntilExpiry < 0L) {
                    userManagerVo.setPackStatus("3");
                } else {
                    userManagerVo.setPackStatus("1");
                }
            } else {
                userManagerVo.setPackStatus("0");
            }
            PackageGroupManager packageGroupManager1 = this.subPackageGroupManagerMapper.querySubPackageList(one.getPackageCode());
            userManagerVo.setPackageGroupManager(packageGroupManager1);
            LambdaQueryWrapper subPackageGroupManagerLambdaQueryWrapper = new LambdaQueryWrapper();
            subPackageGroupManagerLambdaQueryWrapper.eq(SubPackageGroupManager::getStatus, (Object)1);
            if (StringUtils.isNotBlank((CharSequence)userManagerVo.getProjectCode())) {
                subPackageGroupManagerLambdaQueryWrapper.like(SubPackageGroupManager::getBindProject, (Object)one.getProjectCode());
                List subPackageGroupManagers = this.subPackageGroupManagerMapper.selectList((Wrapper)subPackageGroupManagerLambdaQueryWrapper);
                if (null != subPackageGroupManagers && subPackageGroupManagers.size() > 0) {
                    subPackageGroupManagers.forEach(a -> {
                        PackageGroupManager packageGroupManager = (PackageGroupManager)this.packageGroupManagerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(PackageGroupManager::getPackageGroupCode, (Object)a.getRelPackageGroupCode()));
                        a.setPackageGroupType(packageGroupManager.getPackageGroupType());
                        a.setPackageGroupName(packageGroupManager.getPackageGroupName());
                    });
                    userManagerVo.setSubPackageGroupManagers(subPackageGroupManagers);
                    return userManagerVo;
                }
                if (StringUtils.isNotBlank((CharSequence)userManagerVo.getCity())) {
                    subPackageGroupManagerLambdaQueryWrapper.like(SubPackageGroupManager::getBindArea, (Object)one.getCity());
                    List subPackageGroupManager = this.subPackageGroupManagerMapper.selectList((Wrapper)subPackageGroupManagerLambdaQueryWrapper);
                    subPackageGroupManager.forEach(a -> {
                        PackageGroupManager packageGroupManager = (PackageGroupManager)this.packageGroupManagerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(PackageGroupManager::getPackageGroupCode, (Object)a.getRelPackageGroupCode()));
                        a.setPackageGroupType(packageGroupManager.getPackageGroupType());
                        a.setPackageGroupName(packageGroupManager.getPackageGroupName());
                    });
                    userManagerVo.setSubPackageGroupManagers(subPackageGroupManager);
                    return userManagerVo;
                }
            } else if (StringUtils.isNotBlank((CharSequence)userManagerVo.getCity())) {
                subPackageGroupManagerLambdaQueryWrapper.like(SubPackageGroupManager::getBindArea, (Object)one.getCity());
                List subPackageGroupManagers = this.subPackageGroupManagerMapper.selectList((Wrapper)subPackageGroupManagerLambdaQueryWrapper);
                subPackageGroupManagers.forEach(a -> {
                    PackageGroupManager packageGroupManager = (PackageGroupManager)this.packageGroupManagerMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(PackageGroupManager::getPackageGroupCode, (Object)a.getRelPackageGroupCode()));
                    a.setPackageGroupType(packageGroupManager.getPackageGroupType());
                    a.setPackageGroupName(packageGroupManager.getPackageGroupName());
                });
                userManagerVo.setSubPackageGroupManagers(subPackageGroupManagers);
                return userManagerVo;
            }
        }
        return userManagerVo;
    }

    public Boolean logOn(SimpleUserManagerQueryRequest s) {
        return this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getBroadbandUser, (Object)s.getBroadbandUser())).eq(UserManager::getBroadbandPassword, (Object)s.getBroadbandPassword())).eq(UserManager::getIsDeleted, (Object)0)) > 0;
    }

    public boolean addUserManager(UserManagerRequest userManagerRequest) {
        UserManagerRequest.PersonInfo p = userManagerRequest.getPersonInfo();
        UserManagerRequest.BaseInfo b = userManagerRequest.getBaseInfo();
        UserManagerRequest.PackageInfo pk = userManagerRequest.getPackageInfo();
        if (this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getBroadbandUser, (Object)b.getBroadbandUser())).eq(UserManager::getProjectType, (Object)b.getProjectType())).eq(UserManager::getIsDeleted, (Object)0)) > 0) {
            throw new RuntimeException("\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u7528\u6237\u540d\uff01");
        }
        return this.save((Object)UserManager.builder().beginTime(pk.getBeginTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).billDuration(pk.getBillDuration()).broadbandPassword(b.getBroadbandPassword()).broadbandUser(b.getBroadbandUser()).city(b.getCity()).createUser(Long.valueOf(SecurityUtils.getLoginUser() == null ? 9999999L : SecurityUtils.getLoginUser().getUserid())).createName(SecurityUtils.getLoginUser() == null ? b.getBroadbandUser() : SecurityUtils.getLoginUser().getUsername()).endTime(pk.getEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).packageName(pk.getPackageName()).packageCode(pk.getPackageCode()).projectCode(b.getProjectCode()).projectName(b.getProjectName()).projectType(b.getProjectType()).download(pk.getDownload()).cUpload(pk.getCUpload()).upload(pk.getUpload()).price(pk.getPrice()).roomNo(b.getRoomNo()).saleTargetName(b.getSaleTargetName()).status("0").phone(b.getPhone()).remark(pk.getRemark()).build());
    }

    public boolean editUserManager(UserManagerRequest userManagerRequest) {
        UserManagerRequest.BaseInfo b = userManagerRequest.getBaseInfo();
        UserManagerRequest.PackageInfo p = userManagerRequest.getPackageInfo();
        UserManagerRequest.NetWorkInfo n = userManagerRequest.getNetWorkInfo();
        return this.updateById((Object)UserManager.builder().id(userManagerRequest.getId()).saleTargetName(b.getSaleTargetName()).roomNo(b.getRoomNo()).price(p.getPrice()).projectType(b.getProjectType()).projectCode(b.getProjectCode()).projectName(b.getProjectName()).packageName(p.getPackageName()).packageCode(p.getPackageCode()).beginTime(p.getBeginTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).endTime(p.getEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).city(b.getCity()).broadbandPassword(b.getBroadbandPassword()).billDuration(p.getBillDuration()).download(p.getDownload()).cUpload(p.getCUpload()).upload(p.getUpload()).bindMac(Boolean.valueOf(n.isMacFlag())).bindNasId(Boolean.valueOf(n.isNasFlag())).bindNasIp(Boolean.valueOf(n.isNasIpFlag())).updateUser(SecurityUtils.getLoginUser().getUserid()).updateName(SecurityUtils.getLoginUser().getUsername()).phone(b.getPhone()).remark(p.getRemark()).build());
    }

    public UserManagerRequest queryDetail(Long id) {
        UserManager userManager = (UserManager)this.getById((Serializable)id);
        UserManagerRequest.PersonInfo p = UserManagerRequest.PersonInfo.builder().createTime(Date.from(userManager.getCreateTime().atZone(ZoneId.systemDefault()).toInstant())).createUser(userManager.getCreateName()).build();
        UserManagerRequest.BaseInfo b = UserManagerRequest.BaseInfo.builder().broadbandPassword(userManager.getBroadbandPassword()).broadbandUser(userManager.getBroadbandUser()).city(userManager.getCity()).projectCode(userManager.getProjectCode()).projectName(userManager.getProjectName()).projectType(userManager.getProjectType()).roomNo(userManager.getRoomNo()).saleTargetName(userManager.getSaleTargetName()).phone(userManager.getPhone()).build();
        UserManagerRequest.PackageInfo pi = UserManagerRequest.PackageInfo.builder().beginTime(Date.from(userManager.getBeginTime().atZone(ZoneId.systemDefault()).toInstant())).endTime(Date.from(userManager.getEndTime().atZone(ZoneId.systemDefault()).toInstant())).billDuration(userManager.getBillDuration()).packageName(userManager.getPackageName()).packageCode(userManager.getPackageCode()).price(userManager.getPrice()).upload(userManager.getUpload()).cUpload(userManager.getCUpload()).download(userManager.getDownload()).remark(userManager.getRemark()).build();
        NasSetUp nasSetUp = (NasSetUp)this.nasSetUpService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(NasSetUp::getProjectCode, (Object)userManager.getProjectCode())).eq(NasSetUp::getIsDeleted, (Object)0));
        UserManagerRequest.NetWorkInfo netWorkInfo = UserManagerRequest.NetWorkInfo.builder().macFlag(userManager.getBindMac() == null ? nasSetUp != null && nasSetUp.getBindMac().booleanValue() : userManager.getBindMac()).nasFlag(userManager.getBindNasId() == null ? nasSetUp != null && nasSetUp.getBindNasId().booleanValue() : userManager.getBindNasId()).nasIpFlag(userManager.getBindNasIp() == null ? nasSetUp != null && nasSetUp.getBindNasIp().booleanValue() : userManager.getBindNasIp()).build();
        return UserManagerRequest.builder().personInfo(p).baseInfo(b).packageInfo(pi).netWorkInfo(netWorkInfo).build();
    }

    public boolean addSpeedPackage(SpeedPackageRequest speedPackageRequest) {
        UserManager userManager = (UserManager)this.getById((Serializable)speedPackageRequest.getId());
        if (userManager == null || StringUtils.isNotBlank((CharSequence)userManager.getSpeedPackageCode())) {
            throw new RuntimeException("\u7528\u6237\u7ba1\u7406\u4e3a\u7a7a\u6216\u8005\u5df2\u7ecf\u5b58\u5728\u8be5\u52a0\u901f\u5957\u9910\uff01");
        }
        this.updateById((Object)UserManager.builder().id(speedPackageRequest.getId()).speedPackageCode(speedPackageRequest.getSpeedPackageCode()).speedPackageName(speedPackageRequest.getSpeedPackageName()).speedPackagePrice(speedPackageRequest.getSpeedPackagePrice()).speedPackageBeginTime(speedPackageRequest.getSpeedPackageBeginTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).speedPackageEndTime(speedPackageRequest.getSpeedPackageEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).speedRemark(speedPackageRequest.getSpeedRemark()).build());
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysUser sysUser = loginUser.getSysUser();
        UserManager u = (UserManager)this.getById((Serializable)speedPackageRequest.getId());
        PaymentDetail paymentDetail = PaymentDetail.builder().transactionTime(LocalDateTime.now()).city(u.getCity()).city(u.getRoomNo()).projectName(u.getProjectName()).projectCode(u.getProjectCode()).projectType(u.getProjectType()).saleTargetName(u.getSaleTargetName()).subPackageGroupName(speedPackageRequest.getSpeedPackageName()).subPackageGroupCode(speedPackageRequest.getSpeedPackageCode()).orderNo(CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.ORDER, (String)u.getProjectCode())).broadbandUser(u.getBroadbandUser()).broadbandUserId(u.getId()).beginTime(speedPackageRequest.getSpeedPackageBeginTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).endTime(speedPackageRequest.getSpeedPackageEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).expireTime(speedPackageRequest.getSpeedPackageEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()).buyPackageType("\u624b\u5de5\u4fee\u6539").paymentType("\u4eba\u5de5").paymentAmount(speedPackageRequest.getSpeedPackagePrice()).createName(sysUser.getNickName()).createUser(SecurityUtils.getLoginUser().getUserid()).build();
        this.paymentDetailService.save((Object)paymentDetail);
        this.orderService.saveOrder(paymentDetail, Integer.valueOf(1));
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public Boolean editPackage(EditPackageInfoRequest e) {
        this.updateById((Object)UserManager.builder().id(e.getId()).packageCode(e.getPackageCode()).packageName(e.getPackageName()).price(e.getPrice()).remark(e.getRemark()).download(e.getDownload()).cUpload(e.getCUpload()).upload(e.getUpload()).endTime(e.getExpireDate()).build());
        LoginUser loginUser = SecurityUtils.getLoginUser();
        SysUser sysUser = loginUser.getSysUser();
        UserManager u = (UserManager)this.getById((Serializable)e.getId());
        PaymentDetail paymentDetail = PaymentDetail.builder().transactionTime(LocalDateTime.now()).city(u.getCity()).roomNo(u.getRoomNo()).projectName(u.getProjectName()).projectCode(u.getProjectCode()).projectType(u.getProjectType()).saleTargetName(u.getSaleTargetName()).subPackageGroupName(e.getPackageName()).subPackageGroupCode(e.getPackageCode()).orderNo(CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.ORDER, (String)u.getProjectCode())).broadbandUser(u.getBroadbandUser()).broadbandUserId(u.getId()).beginTime(LocalDateTime.now()).endTime(e.getExpireDate()).expireTime(e.getExpireDate()).buyPackageType("\u624b\u5de5\u4fee\u6539").paymentType("\u4eba\u5de5").paymentAmount(u.getPrice()).createName(sysUser.getNickName()).createUser(SecurityUtils.getLoginUser().getUserid()).build();
        this.paymentDetailService.save((Object)paymentDetail);
        this.orderService.saveOrder(paymentDetail, Integer.valueOf(1));
        return true;
    }

    public Boolean kickOffLine(Long id) {
        UserManager u = (UserManager)this.getById((Serializable)id);
        try {
            NasManager nasManager = (NasManager)this.nasManagerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(NasManager::getIdentification, (Object)u.getNasIdentifier())).eq(NasManager::getIsDeleted, (Object)0));
            this.radiusClient.kickOffLine(u, nasManager.getKeystr());
        }
        catch (Exception e) {
            log.error("\u8e22\u4e0b\u7ebf\u5f02\u5e38\uff0c\u9519\u8bef\u4fe1\u606f\u662f:", (Throwable)e);
        }
        u.setStatus("0");
        return this.updateById((Object)u);
    }

    public List<UserManagerExcel> downData2Excel(UserManagerQueryRequest userManagerQueryRequest) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(UserManager::getProjectType, (Object)userManagerQueryRequest.getProjectType())).like(StringUtils.isNotBlank((CharSequence)userManagerQueryRequest.getProjectName()), UserManager::getProjectName, (Object)userManagerQueryRequest.getProjectName())).like(StringUtils.isNotBlank((CharSequence)userManagerQueryRequest.getCity()), UserManager::getCity, (Object)userManagerQueryRequest.getCity())).like(ObjectUtil.isNotEmpty((Object)userManagerQueryRequest.getBroadbandUser()), UserManager::getBroadbandUser, (Object)userManagerQueryRequest.getBroadbandUser())).like(ObjectUtil.isNotEmpty((Object)userManagerQueryRequest.getRoomNo()), UserManager::getRoomNo, (Object)userManagerQueryRequest.getRoomNo())).ge(userManagerQueryRequest.getBeginTime() != null, UserManager::getEndTime, (Object)userManagerQueryRequest.getBeginTime())).le(userManagerQueryRequest.getEndTime() != null, UserManager::getEndTime, (Object)userManagerQueryRequest.getEndTime())).eq(UserManager::getIsDeleted, (Object)0)).orderByDesc(UserManager::getCreateTime);
        List userManagerList = this.list((Wrapper)wrapper);
        return userManagerList.stream().map(m -> {
            UserManagerExcel userManagerExcel = new UserManagerExcel();
            BeanUtils.copyProperties((Object)m, (Object)userManagerExcel);
            if (StringUtils.equals((CharSequence)m.getStatus(), (CharSequence)"0")) {
                userManagerExcel.setStatus("\u79bb\u7ebf");
            } else if (StringUtils.equals((CharSequence)m.getStatus(), (CharSequence)"1")) {
                userManagerExcel.setStatus("\u5728\u7ebf");
            }
            if (StringUtils.equals((CharSequence)String.valueOf(m.getBoyuBroadbandStatus()), (CharSequence)"0")) {
                userManagerExcel.setBoyuBroadbandStatus("\u6b63\u5e38");
            } else if (StringUtils.equals((CharSequence)String.valueOf(m.getBoyuBroadbandStatus()), (CharSequence)"1")) {
                userManagerExcel.setBoyuBroadbandStatus("\u505c\u7528");
            }
            if (m.getBeginTime() != null) {
                userManagerExcel.setBeginTime(m.getBeginTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
            }
            if (m.getEndTime() != null) {
                userManagerExcel.setEndTime(m.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
            }
            if (m.getSpeedPackageBeginTime() != null) {
                userManagerExcel.setSpeedPackageBeginTime(m.getSpeedPackageBeginTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
            }
            if (m.getSpeedPackageEndTime() != null) {
                userManagerExcel.setSpeedPackageEndTime(m.getSpeedPackageEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm")));
            }
            return userManagerExcel;
        }).collect(Collectors.toList());
    }

    public Boolean sendCheckCode(String phone) {
        SmsSetUp s = (SmsSetUp)this.smsSetUpService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SmsSetUp::getTemplateName, (Object)"\u9a8c\u8bc1\u7801")).eq(SmsSetUp::getIsDeleted, (Object)0), false);
        if (s == null) {
            return false;
        }
        int randomNumber = new Random().nextInt(9000) + 1000;
        RedisTemplate redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate");
        redisTemplate.opsForValue().set((Object)phone, (Object)String.valueOf(randomNumber), 300L, TimeUnit.SECONDS);
        this.sendSmsCloud.sendSms(new String[]{phone}, new String[]{phone, String.valueOf(randomNumber)}, s.getSmsTemplateId());
        return null;
    }

    public Boolean register(SimpleUserManagerQueryRequest s) {
        String phone = s.getPhone();
        String checkCode = s.getCheckCode();
        RedisTemplate redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate");
        String redisCheckCode = (String)redisTemplate.opsForValue().get((Object)phone);
        if (!CommonUtil.validateMobileNumber((String)phone) || !StringUtils.equals((CharSequence)redisCheckCode, (CharSequence)checkCode)) {
            throw new RuntimeException("\u624b\u673a\u53f7\u7801\u6216\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\uff01");
        }
        NasSetUp nasSetUp = (NasSetUp)this.nasSetUpService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(NasSetUp::getNasId, (Object)s.getNasName())).eq(NasSetUp::getIsDeleted, (Object)0), false);
        if (nasSetUp == null) {
            throw new RuntimeException("\u670d\u52a1\u5f02\u5e38\u7528\u6237\u6ce8\u518c\u5931\u8d25\uff01");
        }
        String projectCode = nasSetUp.getProjectCode();
        TempProjectDto t = this.userManagerMapper.queryProject(projectCode);
        if (t == null) {
            throw new RuntimeException("\u975e\u6cd5\u9879\u76ee\u53c2\u6570\uff01");
        }
        String passWord = s.getPassWord();
        UserManager u = UserManager.builder().broadbandUser(phone).projectCode(t.getProjectCode()).projectName(t.getProjectName()).city(t.getCity()).projectType(StringUtils.equalsIgnoreCase((CharSequence)t.getProjectType(), (CharSequence)"gy") ? "\u516c\u5bd3" : "\u5546\u5199").broadbandPassword(passWord).phone(phone).build();
        this.save((Object)u);
        return true;
    }

    public TempProjectDto queryProjectNameService(String projectName) {
        return this.userManagerMapper.queryProjectName(projectName);
    }

    @Transactional
    public void updateEndTime(List<Long> ids, Date endTime) {
        try {
            for (Long id : ids) {
                UpdateWrapper userUpdateWrapper = new UpdateWrapper();
                userUpdateWrapper.set((Object)"end_time", (Object)endTime);
                userUpdateWrapper.eq((Object)"id", (Object)id);
                this.update((Wrapper)userUpdateWrapper);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u6279\u91cf\u4fee\u6539\u5931\u8d25");
        }
    }
}

