/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.order.impl;

import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.dto.order.OrderPayDTO;
import com.ruoyi.entity.order.OrderPay;
import com.ruoyi.mapper.order.OrderPayMapper;
import com.ruoyi.query.OrderPayQuery;
import com.ruoyi.service.order.OrderPayService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderPayServiceImpl
extends ServiceImpl<OrderPayMapper, OrderPay>
implements OrderPayService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayServiceImpl.class);
    @Autowired
    private OrderPayMapper orderPayMapper;

    public Page<OrderPayDTO> getPageList(OrderPayQuery query) {
        Page page = new Page();
        query.setPageNum((query.getPageNum() - 1L) * query.getPageSize());
        Integer orderCount = this.orderPayMapper.getPageCount(query);
        List orderList = this.orderPayMapper.getPage(query);
        page.setRecords(orderList);
        page.setTotal((long)orderCount.intValue());
        page.setCurrent(query.getPageNum());
        page.setSize(query.getPageSize());
        return page;
    }

    public void export(OrderPayQuery query, HttpServletResponse response) {
        query.setPageNum((query.getPageNum() - 1L) * query.getPageSize());
        List orderList = this.orderPayMapper.getPage(query);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        ExcelWriter writer = null;
        ServletOutputStream outputStream = null;
        try {
            writer = ExcelUtil.getWriterWithSheet((String)"\u652f\u4ed8\u6d41\u6c34\u660e\u7ec6");
            writer.writeCellValue(0, 0, (Object)"\u8ba2\u5355\u53f7");
            writer.writeCellValue(1, 0, (Object)"\u652f\u4ed8\u91d1\u989d");
            writer.writeCellValue(2, 0, (Object)"\u6e20\u9053");
            writer.writeCellValue(3, 0, (Object)"\u6765\u6e90");
            writer.writeCellValue(4, 0, (Object)"\u652f\u4ed8\u65b9\u5f0f");
            writer.writeCellValue(5, 0, (Object)"\u652f\u4ed8\u72b6\u6001");
            writer.writeCellValue(6, 0, (Object)"\u652f\u4ed8\u6d41\u6c34\u53f7");
            writer.writeCellValue(7, 0, (Object)"\u4e91\u548c\u652f\u4ed8\u53f7");
            writer.writeCellValue(8, 0, (Object)"\u5e73\u53f0\u6d41\u6c34\u53f7");
            writer.writeCellValue(9, 0, (Object)"\u652f\u4ed8\u53d1\u8d77\u65f6\u95f4");
            writer.writeCellValue(10, 0, (Object)"\u652f\u4ed8\u5b8c\u6210\u65f6\u95f4");
            writer.setColumnWidth(0, 25);
            writer.setColumnWidth(1, 18);
            writer.setColumnWidth(2, 18);
            writer.setColumnWidth(3, 18);
            writer.setColumnWidth(4, 18);
            writer.setColumnWidth(5, 18);
            writer.setColumnWidth(6, 20);
            writer.setColumnWidth(7, 20);
            writer.setColumnWidth(8, 25);
            writer.setColumnWidth(9, 20);
            writer.setColumnWidth(10, 20);
            int num = 0;
            for (OrderPayDTO order : orderList) {
                String source;
                writer.writeCellValue(0, num + 1, (Object)(StringUtils.isEmpty((String)order.getOrderNo()) ? "" : order.getOrderNo()));
                writer.writeCellValue(1, num + 1, Objects.isNull(order.getPaymentMoney()) ? "" : order.getPaymentMoney());
                writer.writeCellValue(2, num + 1, (Object)(StringUtils.isEmpty((String)order.getChannel()) ? "" : (order.getChannel().equals("0") ? "\u81ea\u8425" : "\u6cca\u5bd3")));
                switch (source = order.getSource()) {
                    case "0": {
                        source = "PC";
                        break;
                    }
                    case "1": {
                        source = "APP";
                        break;
                    }
                    case "2": {
                        source = "\u5c0f\u7a0b\u5e8f";
                    }
                }
                writer.writeCellValue(3, num + 1, (Object)(Objects.isNull(source) ? "" : source));
                writer.writeCellValue(4, num + 1, (Object)(StringUtils.isEmpty((String)order.getPaymentName()) ? "" : order.getPaymentName()));
                String orderState = order.getOrderState();
                String status = "\u5f85\u652f\u4ed8";
                switch (orderState) {
                    case "0": {
                        status = "\u5f85\u652f\u4ed8";
                        break;
                    }
                    case "1": {
                        status = "\u5df2\u652f\u4ed8";
                        break;
                    }
                    case "2": {
                        status = "\u9000\u6b3e\u4e2d";
                        break;
                    }
                    case "4": {
                        status = "\u5df2\u9000\u6b3e";
                        break;
                    }
                    case "5": {
                        status = "\u5df2\u53d6\u6d88";
                    }
                }
                writer.writeCellValue(5, num + 1, (Object)status);
                writer.writeCellValue(6, num + 1, (Object)(StringUtils.isEmpty((String)order.getThirdOrderNo()) ? "" : order.getThirdOrderNo()));
                writer.writeCellValue(7, num + 1, (Object)(StringUtils.isEmpty((String)order.getTransactionNo()) ? "" : order.getTransactionNo()));
                writer.writeCellValue(8, num + 1, (Object)(Objects.isNull(order.getOrderPayNo()) ? "" : order.getOrderPayNo()));
                writer.writeCellValue(9, num + 1, (Object)(Objects.isNull(order.getCreateTime()) ? "" : sdf.format(order.getCreateTime())));
                writer.writeCellValue(10, num + 1, (Object)(Objects.isNull(order.getPayTime()) ? "" : sdf.format(order.getCreateTime())));
                ++num;
            }
            String fileName = URLEncoder.encode("\u652f\u4ed8\u6d41\u6c34\u660e\u7ec6", "UTF-8");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
            outputStream = response.getOutputStream();
            writer.flush((OutputStream)outputStream, true);
        }
        catch (IOException e) {
            log.error("\u652f\u4ed8\u6d41\u6c34\u660e\u7ec6\u5bfc\u51fa\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

