/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.order.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.boyu.PaymentstatuscallbackAsynchronousNotificationRequest;
import com.ruoyi.entity.BoYuApiLog;
import com.ruoyi.entity.PaymentDetail;
import com.ruoyi.entity.UserManager;
import com.ruoyi.entity.order.Order;
import com.ruoyi.entity.order.OrderDetail;
import com.ruoyi.entity.order.OrderPay;
import com.ruoyi.enums.OrderTypeEnum;
import com.ruoyi.mapper.BoYuApiMapper;
import com.ruoyi.mapper.UserManagerMapper;
import com.ruoyi.mapper.order.OrderDetailMapper;
import com.ruoyi.mapper.order.OrderMapper;
import com.ruoyi.mapper.order.OrderPayMapper;
import com.ruoyi.query.OrderQuery;
import com.ruoyi.service.order.OrderService;
import com.ruoyi.util.CommonUtil;
import com.ruoyi.util.UserUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderServiceImpl
extends ServiceImpl<OrderMapper, Order>
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Resource
    private OrderDetailMapper orderDetailMapper;
    @Resource
    private OrderPayMapper orderPayMapper;
    @Resource
    private OrderMapper orderMapper;
    @Resource
    private BoYuApiMapper boYuApiMapper;
    @Resource
    private UserManagerMapper userManagerMapper;

    public Order saveOrder(PaymentDetail paymentDetail, Integer type) {
        List userManagers = this.userManagerMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UserManager::getBroadbandUser, (Object)paymentDetail.getBroadbandUser()));
        if (userManagers.size() != 1) {
            log.info("\u6839\u636e\u5bbd\u5e26\u8d26\u6237\u67e5\u8be2{}\u5bbd\u5e26\u4fe1\u606f\u9519\u8bef\uff1a{}", (Object)paymentDetail.getBroadbandUser(), (Object)paymentDetail);
            return new Order();
        }
        UserManager userManager = (UserManager)userManagers.get(0);
        Order order = Order.builder().paymentDetailId(paymentDetail.getId()).orderNo(CommonUtil.generateOrderNumber((OrderTypeEnum)OrderTypeEnum.ORDER, null)).city(paymentDetail.getCity()).roomNo(paymentDetail.getRoomNo()).brandName(paymentDetail.getBrandName()).projectCode(paymentDetail.getProjectCode()).projectName(paymentDetail.getProjectName()).projectType(paymentDetail.getProjectType()).orderState("0").payTime(null).broadbandId(paymentDetail.getBroadbandUserId()).broadbandAccount(paymentDetail.getBroadbandUser()).paymentMoney(paymentDetail.getPaymentAmount() != null ? new BigDecimal(paymentDetail.getPaymentAmount()) : BigDecimal.ZERO).orderMoney(paymentDetail.getPaymentAmount() != null ? new BigDecimal(paymentDetail.getPaymentAmount()) : BigDecimal.ZERO).discountMoney(BigDecimal.ZERO).memberId(null).orderMethod("1").invoiceFlag(Integer.valueOf(0)).thirdOrderNo(paymentDetail.getOrderNo()).createTime(new Date()).build();
        Calendar cal = Calendar.getInstance();
        order.setCreateTime(cal.getTime());
        cal.add(12, 30);
        order.setExpireTime(cal.getTime());
        switch (type) {
            case 0: {
                order.setChannel(Integer.valueOf(1));
                order.setSource(Integer.valueOf(1));
                order.setCreateName("\u6cca\u5bd3");
                break;
            }
            case 1: {
                order.setChannel(Integer.valueOf(0));
                order.setSource(Integer.valueOf(0));
                order.setCreateName(UserUtils.getLoginUser().getUsername());
                order.setCreateUser(UserUtils.getLoginUser().getUserid().toString());
                break;
            }
            case 2: {
                order.setChannel(Integer.valueOf(0));
                order.setSource(Integer.valueOf(2));
                order.setCreateName(UserUtils.getLoginUser().getUsername());
                order.setCreateUser(UserUtils.getLoginUser().getUserid().toString());
            }
        }
        boolean boo = false;
        LambdaQueryWrapper wrapperOrder = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(Order::getThirdOrderNo, (Object)paymentDetail.getOrderNo())).orderByDesc(Order::getCreateTime);
        List orders = this.list((Wrapper)wrapperOrder);
        if (ObjectUtil.isNotEmpty((Object)orders)) {
            order.setId(((Order)orders.get(0)).getId());
            boo = this.updateById((Object)order);
        } else {
            boo = this.save((Object)order);
        }
        if (boo) {
            LambdaQueryWrapper wrapperOrderDetail = (LambdaQueryWrapper)Wrappers.query().lambda().eq(OrderDetail::getOrderId, (Object)order.getId());
            List orderDetails = this.orderDetailMapper.selectList((Wrapper)wrapperOrderDetail);
            if (ObjectUtil.isNotEmpty((Object)orderDetails)) {
                this.orderDetailMapper.delete((Wrapper)wrapperOrderDetail);
            }
            OrderDetail orderDetail = OrderDetail.builder().orderId(order.getId()).goodsCode(userManager.getPackageCode()).goodsName(userManager.getPackageName()).beginTime(Date.from(paymentDetail.getBeginTime().atZone(ZoneId.systemDefault()).toInstant())).endTime(Date.from(paymentDetail.getEndTime().atZone(ZoneId.systemDefault()).toInstant())).goodsPrice(paymentDetail.getPaymentAmount() != null ? new BigDecimal(paymentDetail.getPaymentAmount()) : BigDecimal.ZERO).goodsCount(Integer.valueOf(1)).goodsMoney(paymentDetail.getPaymentAmount() != null ? new BigDecimal(paymentDetail.getPaymentAmount()) : BigDecimal.ZERO).goodsDiscount(BigDecimal.ZERO).refundGoodsAmont(Integer.valueOf(0)).createTime(new Date()).build();
            switch (type) {
                case 0: {
                    orderDetail.setCreateName("\u6cca\u5bd3");
                    break;
                }
                case 1: 
                case 2: {
                    orderDetail.setCreateName(UserUtils.getLoginUser().getUsername());
                    orderDetail.setCreateUser(UserUtils.getLoginUser().getUserid().toString());
                }
            }
            this.orderDetailMapper.insert((Object)orderDetail);
        }
        return order;
    }

    public Boolean cancelOrder(String thirdOrderNo) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"order_state", (Object)"5");
        wrapper.eq((Object)"third_order_no", (Object)thirdOrderNo);
        return this.update(null, (Wrapper)wrapper);
    }

    public Boolean applyRefundOrder(String thirdOrderNo) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"order_state", (Object)"2");
        wrapper.eq((Object)"third_order_no", (Object)thirdOrderNo);
        return this.update(null, (Wrapper)wrapper);
    }

    public Boolean refundOrder(String thirdOrderNo) {
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.set((Object)"order_state", (Object)"4");
        wrapper.eq((Object)"third_order_no", (Object)thirdOrderNo);
        return this.update(null, (Wrapper)wrapper);
    }

    public Order paymentOrderByBuYo(PaymentstatuscallbackAsynchronousNotificationRequest requestBody, Order order) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List boYuApiLogList = this.boYuApiMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"order_number", (Object)requestBody.getOut_trade_no()));
        OrderPay orderPay = OrderPay.builder().orderId(order.getId()).orderPayNo(requestBody.getChn_transaction_id()).thirdOrderNo(requestBody.getOut_trade_no()).transactionNo(requestBody.getTransaction_id()).paymentMoney(requestBody.getTotal_fee() != null ? new BigDecimal(requestBody.getTotal_fee()) : BigDecimal.ZERO).createTime(new Date()).build();
        LambdaQueryWrapper wrapperOrderPay = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(OrderPay::getThirdOrderNo, (Object)requestBody.getOut_trade_no())).orderByDesc(OrderPay::getCreateTime);
        List orderPayS = this.orderPayMapper.selectList((Wrapper)wrapperOrderPay);
        if (ObjectUtil.isNotEmpty((Object)orderPayS)) {
            orderPay.setId(((OrderPay)orderPayS.get(0)).getId());
        }
        if (boYuApiLogList.size() == 1) {
            BoYuApiLog boYuApiLog = (BoYuApiLog)boYuApiLogList.get(0);
            orderPay.setPaymentName(ObjectUtil.equals((Object)boYuApiLog.getPayType(), (Object)"alipay") ? "\u652f\u4ed8\u5b9d" : "\u5fae\u4fe1");
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.getTrans_time())) {
            try {
                orderPay.setPayTime(formatter.parse(requestBody.getTrans_time()));
                order.setPayTime(formatter.parse(requestBody.getTrans_time()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (orderPay.getId() == null) {
            this.orderPayMapper.insert((Object)orderPay);
        } else {
            this.orderPayMapper.updateById((Object)orderPay);
        }
        order.setOrderState("1");
        this.updateById((Object)order);
        return order;
    }

    public Page<Order> getPageList(OrderQuery query) {
        Page page = new Page();
        query.setPageNum((query.getPageNum() - 1L) * query.getPageSize());
        Integer orderCount = this.orderMapper.getPageCount(query);
        List orderList = this.orderMapper.getPage(query);
        page.setRecords(orderList);
        page.setTotal((long)orderCount.intValue());
        page.setCurrent(query.getPageNum());
        page.setSize(query.getPageSize());
        return page;
    }

    public Order getDetails(Long id) {
        Order order = (Order)this.getById((Serializable)id);
        List orderDetails = this.orderDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(OrderDetail::getOrderId, (Object)id));
        order.setDetailList(orderDetails);
        List orderPays = this.orderPayMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(OrderPay::getOrderId, (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)orderPays)) {
            orderPays.stream().forEach(f -> f.setOrderNo(order.getOrderNo()));
        }
        order.setPayList(orderPays);
        return order;
    }

    public void export(OrderQuery query, HttpServletResponse response) {
        query.setPageNum((query.getPageNum() - 1L) * query.getPageSize());
        List orderList = this.orderMapper.getPage(query);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd HH:mm");
        ExcelWriter writer = null;
        ServletOutputStream outputStream = null;
        try {
            writer = ExcelUtil.getWriterWithSheet((String)"\u652f\u4ed8\u8ba2\u5355");
            writer.writeCellValue(0, 0, (Object)"\u8ba2\u5355\u53f7");
            writer.writeCellValue(1, 0, (Object)"\u5bbd\u5e26\u8d26\u53f7");
            writer.writeCellValue(2, 0, (Object)"\u623f\u95f4");
            writer.writeCellValue(3, 0, (Object)"\u7f34\u8d39\u7c7b\u578b");
            writer.writeCellValue(4, 0, (Object)"\u7f34\u8d39\u91d1\u989d");
            writer.writeCellValue(5, 0, (Object)"\u652f\u4ed8\u65b9\u5f0f");
            writer.writeCellValue(6, 0, (Object)"\u652f\u4ed8\u72b6\u6001");
            writer.writeCellValue(7, 0, (Object)"\u9879\u76ee\u540d\u79f0");
            writer.writeCellValue(8, 0, (Object)"\u57ce\u5e02");
            writer.writeCellValue(9, 0, (Object)"\u4e09\u65b9\u8ba2\u5355\u53f7");
            writer.writeCellValue(10, 0, (Object)"\u8ba2\u5355\u521b\u5efa\u65f6\u95f4");
            writer.setColumnWidth(0, 25);
            writer.setColumnWidth(1, 20);
            writer.setColumnWidth(2, 20);
            writer.setColumnWidth(3, 18);
            writer.setColumnWidth(4, 18);
            writer.setColumnWidth(5, 18);
            writer.setColumnWidth(6, 18);
            writer.setColumnWidth(7, 20);
            writer.setColumnWidth(8, 25);
            writer.setColumnWidth(9, 20);
            writer.setColumnWidth(10, 20);
            int num = 0;
            for (Order order : orderList) {
                String orderMethod;
                writer.writeCellValue(0, num + 1, (Object)(Objects.isNull(order.getOrderNo()) ? "" : order.getOrderNo()));
                writer.writeCellValue(1, num + 1, (Object)(Objects.isNull(order.getBroadbandAccount()) ? "" : order.getBroadbandAccount()));
                writer.writeCellValue(2, num + 1, (Object)(Objects.isNull(order.getRoomNo()) ? "" : order.getRoomNo()));
                switch (orderMethod = order.getOrderMethod()) {
                    case "1": {
                        orderMethod = "\u81ea\u4e3b\u4e0b\u5355";
                        break;
                    }
                    case "2": {
                        orderMethod = "2\u6cca\u5bd3\u63a8\u9001";
                    }
                }
                writer.writeCellValue(3, num + 1, (Object)(Objects.isNull(orderMethod) ? "\u81ea\u4e3b\u4e0b\u5355" : orderMethod));
                writer.writeCellValue(4, num + 1, Objects.isNull(order.getPaymentMoney()) ? "" : order.getPaymentMoney());
                writer.writeCellValue(5, num + 1, (Object)(Objects.isNull(order.getPaymentName()) ? "" : order.getPaymentName()));
                String orderState = order.getOrderState();
                String status = "\u5f85\u652f\u4ed8";
                switch (orderState) {
                    case "0": {
                        status = "\u5f85\u652f\u4ed8";
                        break;
                    }
                    case "1": {
                        status = "\u5df2\u652f\u4ed8";
                        break;
                    }
                    case "2": {
                        status = "\u9000\u6b3e\u4e2d";
                        break;
                    }
                    case "4": {
                        status = "\u5df2\u9000\u6b3e";
                        break;
                    }
                    case "5": {
                        status = "\u5df2\u53d6\u6d88";
                    }
                }
                writer.writeCellValue(6, num + 1, (Object)status);
                writer.writeCellValue(7, num + 1, (Object)(Objects.isNull(order.getProjectName()) ? "" : order.getProjectName()));
                writer.writeCellValue(8, num + 1, (Object)(Objects.isNull(order.getCity()) ? "" : order.getCity()));
                writer.writeCellValue(9, num + 1, (Object)(Objects.isNull(order.getThirdOrderNo()) ? "" : order.getThirdOrderNo()));
                writer.writeCellValue(10, num + 1, (Object)(Objects.isNull(order.getCreateTime()) ? "" : sdf.format(order.getCreateTime())));
                ++num;
            }
            String fileName = URLEncoder.encode("\u652f\u4ed8\u8ba2\u5355", "UTF-8");
            response.setContentType("application/vnd.ms-excel;charset=utf-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
            outputStream = response.getOutputStream();
            writer.flush((OutputStream)outputStream, true);
        }
        catch (IOException e) {
            log.error("\u652f\u4ed8\u8ba2\u5355\u5bfc\u51fa\u5f02\u5e38:{}", (Object)e.getMessage());
        }
    }
}

