/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ruoyi.entity.SmsMessageList;
import com.ruoyi.entity.SmsSetUp;
import com.ruoyi.entity.UserManager;
import com.ruoyi.service.ISmsMessageListService;
import com.ruoyi.service.ISmsSetUpService;
import com.ruoyi.service.IUserManagerService;
import com.ruoyi.telentcloudsms.SendSmsCloud;
import com.ruoyi.util.CommonUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class SpringTask {
    @Autowired
    private SendSmsCloud sendSmsCloud;
    @Autowired
    private IUserManagerService userManagerService;
    @Autowired
    private ISmsSetUpService smsSetUpService;
    @Autowired
    private ISmsMessageListService smsMessageListService;

    public void sendSms() {
        SmsSetUp expireTip;
        List userManagerList = this.userManagerService.list((Wrapper)Wrappers.query().lambda().eq(UserManager::getIsDeleted, (Object)0));
        if (CollectionUtils.isEmpty((Collection)userManagerList)) {
            return;
        }
        List smsSetUpList = this.smsSetUpService.list((Wrapper)((LambdaQueryWrapper)Wrappers.query().lambda().eq(SmsSetUp::getIsDeleted, (Object)0)).eq(SmsSetUp::getEnable, (Object)true)).stream().filter(f -> StringUtils.equalsAny((CharSequence)f.getTemplateName(), (CharSequence[])new CharSequence[]{"\u5feb\u8981\u8fc7\u671f\u63d0\u9192", "\u5df2\u7ecf\u8fc7\u671f\u63d0\u9192"})).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(smsSetUpList)) {
            return;
        }
        Map<String, SmsSetUp> templateName2SetUp = smsSetUpList.stream().collect(Collectors.toMap(SmsSetUp::getTemplateName, x -> x, (v1, v2) -> v1));
        SmsSetUp preExpireTip = templateName2SetUp.getOrDefault("\u5feb\u8981\u8fc7\u671f\u63d0\u9192", null);
        if (preExpireTip != null && StringUtils.isNotBlank((CharSequence)preExpireTip.getSmsTemplateId())) {
            int day = preExpireTip.getSmsNoticeDay();
            List<UserManager> userManagerListBak1 = userManagerList.stream().filter(f -> Duration.between(f.getEndTime(), LocalDateTime.now()).get(ChronoUnit.DAYS) == (long)day).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(userManagerListBak1)) {
                userManagerListBak1.forEach(f -> {
                    if (CommonUtil.validateMobileNumber((String)f.getPhone())) {
                        this.sendSmsCloud.sendSms(new String[]{f.getPhone()}, new String[]{f.getBroadbandUser(), f.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), "1234567890"}, preExpireTip.getSmsTemplateId());
                        SmsMessageList smsMessageList = SmsMessageList.builder().sendTime(LocalDateTime.now()).phone(f.getPhone()).userAccount(f.getBroadbandUser()).content(preExpireTip.getContent()).status("1").sender("\u7cfb\u7edf\u4efb\u52a1\uff0c\u9a8c\u8bc1\u7801").build();
                        this.smsMessageListService.save((Object)smsMessageList);
                    }
                });
            }
        }
        if ((expireTip = (SmsSetUp)templateName2SetUp.getOrDefault("\u5df2\u7ecf\u8fc7\u671f\u63d0\u9192", null)) != null && StringUtils.isNotBlank((CharSequence)expireTip.getSmsTemplateId())) {
            int day = expireTip.getSmsNoticeDay();
            List<UserManager> userManagerListBak2 = userManagerList.stream().filter(f -> Duration.between(LocalDateTime.now(), f.getEndTime()).get(ChronoUnit.DAYS) == (long)day).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(userManagerListBak2)) {
                userManagerListBak2.forEach(f -> {
                    if (CommonUtil.validateMobileNumber((String)f.getPhone())) {
                        this.sendSmsCloud.sendSms(new String[]{f.getPhone()}, new String[]{f.getBroadbandUser(), "1234567890"}, expireTip.getSmsTemplateId());
                        SmsMessageList smsMessageList = SmsMessageList.builder().sendTime(LocalDateTime.now()).phone(f.getPhone()).userAccount(f.getBroadbandUser()).content(expireTip.getContent()).status("1").sender("\u7cfb\u7edf\u4efb\u52a1\uff0c\u9a8c\u8bc1\u7801").build();
                        this.smsMessageListService.save((Object)smsMessageList);
                    }
                });
            }
        }
    }
}

