/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.wx;

import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.ruoyi.wx.WeChatAccessToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeChatAccessToken {
    private static final Logger log = LoggerFactory.getLogger(WeChatAccessToken.class);
    @Value(value="${wx.account.appid:wxb0173fab30364385}")
    private String APPID;
    @Value(value="${wx.account.appsecret:3f4df09131b9e357a1978dd893952d1f}")
    private String APPSECRET;
    @Value(value="${wx.account.applet.appid:wxb0173fab30364385}")
    private String APPLET_APPID;
    @Value(value="${wx.account.applet.appsecret:3f4df09131b9e357a1978dd893952d1f}")
    private String APPLET_APPSECRET;

    public String getAccessToken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.APPID + "&secret=" + this.APPSECRET;
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            int responseCode = con.getResponseCode();
            System.out.println("Response Code : " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            String jsonResponse = response.toString();
            int startIndex = jsonResponse.indexOf("\"access_token\":\"") + 16;
            int endIndex = jsonResponse.indexOf("\"", startIndex);
            return jsonResponse.substring(startIndex, endIndex);
        }
        catch (IOException e) {
            log.error("\u8c03\u7528getAccessToken\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u662f:", (Throwable)e);
            return null;
        }
    }

    public WxUser queryAllUserList() throws IOException {
        OkHttpClient client = new OkHttpClient();
        String url = " https://api.weixin.qq.com/cgi-bin/user/get?access_token=" + this.getAccessToken() + "&next_openid=";
        Request request = new Request.Builder().url(url).build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String resultStr = response.body().string();
            return (WxUser)new Gson().fromJson(resultStr, WxUser.class);
        }
        return null;
    }

    public String queryOpenId(String code) throws IOException {
        OkHttpClient client = new OkHttpClient();
        String url = "https://api.weixin.qq.com/sns/jscode2session?appid=" + this.APPLET_APPID + "&secret=" + this.APPLET_APPSECRET + "&js_code=" + code + "&grant_type=authorization_code";
        Request request = new Request.Builder().url(url).build();
        Response response = client.newCall(request).execute();
        if (response.isSuccessful()) {
            String body = response.body().string();
            AppletResult appletResult = (AppletResult)new Gson().fromJson(body, AppletResult.class);
            return appletResult.getOpenid();
        }
        return null;
    }
}

