/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.aspect;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.huimin.common.Enum.OperationStatusEnum;
import com.huimin.common.annotation.LogOperation;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.HttpContextUtils;
import com.huimin.common.utils.IpUtils;
import com.huimin.common.utils.LoginUser;
import com.huimin.entity.SysLogOperationEntity;
import com.huimin.service.SysLogOperationService;
import java.io.BufferedReader;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LogOperationAspect {
    @Autowired
    private SysLogOperationService sysLogOperationService;

    @Pointcut(value="@annotation(com.huimin.common.annotation.LogOperation)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        long beginTime = System.currentTimeMillis();
        try {
            Object result = point.proceed();
            long time = System.currentTimeMillis() - beginTime;
            this.saveLog(point, time, Integer.valueOf(OperationStatusEnum.SUCCESS.value()));
            return result;
        }
        catch (Exception e) {
            long time = System.currentTimeMillis() - beginTime;
            this.saveLog(point, time, Integer.valueOf(OperationStatusEnum.FAIL.value()));
            throw e;
        }
    }

    private void saveLog(ProceedingJoinPoint joinPoint, long time, Integer status) throws Exception {
        LoginUser loginUser = AuthUtil.getLoginUser();
        if (!ObjectUtil.isNotEmpty((Object)loginUser) && null != loginUser) {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            SysLogOperationEntity log = new SysLogOperationEntity();
            LogOperation annotation = method.getAnnotation(LogOperation.class);
            if (annotation != null) {
                log.setOperation(annotation.value());
            }
            log.setCreater(AuthUtil.getLoginUser().getUserId().toString());
            log.setCreaterName(AuthUtil.getLoginUser().getNickName());
            log.setCreaterDate(new Date());
            log.setStatus(status);
            log.setRequestTime(Integer.valueOf((int)time));
            HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
            log.setIp(IpUtils.getIpAddr((HttpServletRequest)request));
            log.setUserAgent(request.getHeader("User-Agent"));
            log.setRequestUri(request.getRequestURI());
            log.setRequestMethod(request.getMethod());
            Map params = HttpContextUtils.getParameterMap((HttpServletRequest)request);
            if (MapUtil.isNotEmpty((Map)params)) {
                log.setRequestParams(JSON.toJSONString((Object)params));
            } else {
                try {
                    String line;
                    BufferedReader reader = request.getReader();
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        stringBuilder.append(line);
                    }
                    log.setRequestParams(stringBuilder.toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.sysLogOperationService.save(log);
        }
    }
}

