/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.interceptors;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import com.huimin.common.annotation.NoNeedLogin;
import com.huimin.common.exception.RenException;
import com.huimin.common.result.Result;
import com.huimin.common.utils.LoginUser;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthorizationInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationInterceptor.class);
    private static final String X_TOKEN = "x-token";

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        NoNeedLogin annotation = (NoNeedLogin)((HandlerMethod)handler).getMethodAnnotation(NoNeedLogin.class);
        if (annotation != null) {
            return true;
        }
        try {
            String token = this.getAuthToken(request);
            if (StrUtil.isBlank((CharSequence)token)) {
                throw new RenException(10021);
            }
            JWT jwt = JWT.of((String)token.replaceFirst("Bearer ", ""));
            JWTPayload payload = jwt.getPayload();
            JSONObject claimsJson = payload.getClaimsJson();
            LoginUser loginUser = (LoginUser)claimsJson.toBean(LoginUser.class);
            request.setAttribute("LOGIN_USER", (Object)loginUser);
            log.debug("\u5f53\u524d\u7684\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)claimsJson.toString());
        }
        catch (RenException e) {
            Result error = new Result().error(e.getCode(), e.getMsg());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            response.getWriter().println(JSONUtil.toJsonStr((Object)error));
            return false;
        }
        return true;
    }

    private String getAuthToken(HttpServletRequest request) {
        String token = request.getHeader(X_TOKEN);
        return token;
    }
}

