/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateFormatUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIMEPATTERN = "yyyyMMddHHmmss";
    public static final String DATE_IOS8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS+08:00";

    public static Date parseToDate(String ds) {
        try {
            String[] formatters = new String[]{"yyyy/MM/dd HH:mm", "yyyy/MM/dd HH:mm:ss", "yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss", DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.getPattern(), DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.getPattern(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.getPattern()};
            return org.apache.commons.lang3.time.DateUtils.parseDate((String)ds, (String[])formatters);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static String format(Date date) {
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    public static String format(Date date, String pattern) {
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            return df.format(date);
        }
        return null;
    }

    public static String formatISO8601(Date date) {
        return DateUtils.format((Date)date, (String)"yyyy-MM-dd'T'HH:mm:ss.SSS+08:00");
    }

    public static Date parse(String date, String pattern) {
        try {
            return new SimpleDateFormat(pattern).parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date getFirstOfDate(Date someDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(someDate);
        c.set(13, 0);
        c.set(11, 0);
        c.set(12, 0);
        return c.getTime();
    }

    public static Date getLastOfDate(Date someDate) {
        Calendar c = Calendar.getInstance();
        c.setTime(someDate);
        c.set(13, 59);
        c.set(11, 23);
        c.set(12, 59);
        return c.getTime();
    }

    public static Date getFirstOfToday() {
        Calendar c = Calendar.getInstance();
        c.set(13, 0);
        c.set(11, 0);
        c.set(12, 0);
        return c.getTime();
    }

    public static Date getLastOfToday() {
        Calendar c = Calendar.getInstance();
        c.set(13, 59);
        c.set(11, 23);
        c.set(12, 59);
        return c.getTime();
    }

    public static Date getFirstOfThisWeek() {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.set(13, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(7, 2);
        return c.getTime();
    }

    public static Date getLastOfThisWeek() {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.set(13, 59);
        c.set(11, 23);
        c.set(12, 59);
        c.set(7, 1);
        return c.getTime();
    }

    public static Date getLastOfThisMonth() {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.set(13, 59);
        c.set(11, 23);
        c.set(12, 59);
        c.set(5, c.getActualMaximum(5));
        return c.getTime();
    }

    public static Date getFirstOfThisMonth() {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(2);
        c.set(13, 0);
        c.set(11, 0);
        c.set(12, 0);
        c.set(5, c.getActualMinimum(5));
        return c.getTime();
    }

    public static String[] getThisMothDays() {
        Calendar c = Calendar.getInstance();
        int lastDay = c.getActualMaximum(5);
        String[] days = new String[lastDay];
        for (int i = 1; i <= lastDay; ++i) {
            days[i - 1] = String.format("%02d", i);
        }
        return days;
    }
}

