/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.common.utils;

import com.huimin.common.utils.HttpUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static String CHARSET = "UTF-8";
    private static final SSLSocketFactory sslSocketFactory = HttpUtil.initSSLSocketFactory();
    private static final TrustAnyHostnameVerifier trustAnyHostnameVerifier = new TrustAnyHostnameVerifier(null);

    private HttpUtil() {
    }

    private static SSLSocketFactory initSSLSocketFactory() {
        try {
            TrustManager[] tm = new TrustManager[]{new TrustAnyTrustManager(null)};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tm, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setCharSet(String charSet) {
        if (StringUtils.isEmpty((Object)charSet)) {
            throw new IllegalArgumentException("charSet can not be blank.");
        }
        CHARSET = charSet;
    }

    private static HttpURLConnection getHttpConnection(String url, String method, Map<String, String> headers) throws IOException, NoSuchAlgorithmException, NoSuchProviderException, KeyManagementException {
        URL _url = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)_url.openConnection();
        if (conn instanceof HttpsURLConnection) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(sslSocketFactory);
            ((HttpsURLConnection)conn).setHostnameVerifier((HostnameVerifier)trustAnyHostnameVerifier);
        }
        conn.setRequestMethod(method);
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(19000);
        conn.setReadTimeout(19000);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    public static String get(String url, Map<String, String> queryParas, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            conn = HttpUtil.getHttpConnection((String)HttpUtil.buildUrlWithQueryString((String)url, queryParas), (String)"GET", headers);
            conn.connect();
            String string = HttpUtil.readResponseString((HttpURLConnection)conn);
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String get(String url, Map<String, String> queryParas) {
        return HttpUtil.get((String)url, queryParas, null);
    }

    public static String get(String url) {
        return HttpUtil.get((String)url, null, null);
    }

    public static String post(String url, Map<String, String> queryParas, String data, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            Object out;
            conn = HttpUtil.getHttpConnection((String)HttpUtil.buildUrlWithQueryString((String)url, queryParas), (String)"POST", headers);
            conn.connect();
            if (data != null) {
                out = conn.getOutputStream();
                ((OutputStream)out).write(data.getBytes(CHARSET));
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            out = HttpUtil.readResponseString((HttpURLConnection)conn);
            return out;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static String post(String url, Map<String, String> queryParas, String data) {
        return HttpUtil.post((String)url, queryParas, (String)data, null);
    }

    public static String post(String url, String data, Map<String, String> headers) {
        return HttpUtil.post((String)url, null, (String)data, headers);
    }

    public static String post(String url, String data) {
        return HttpUtil.post((String)url, null, (String)data, null);
    }

    private static String readResponseString(HttpURLConnection conn) {
        BufferedReader reader = null;
        try {
            StringBuilder ret;
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), CHARSET));
            String line = reader.readLine();
            if (line != null) {
                ret = new StringBuilder();
                ret.append(line);
            } else {
                String string = "";
                return string;
            }
            while ((line = reader.readLine()) != null) {
                ret.append('\n').append(line);
            }
            String string = ret.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static Map<String, String> parseQueryParas(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)url)) {
            String[] ps;
            if (url.startsWith("?")) {
                url = url.substring(1);
            }
            for (String p : ps = StringUtils.split((String)url, (String)"&")) {
                String[] pa = StringUtils.split((String)p, (String)"=");
                if (pa == null || pa.length != 2) continue;
                params.put(pa[0], pa[1]);
            }
        }
        return params;
    }

    public static String buildUrlWithQueryString(String url, Map<String, String> queryParas) {
        boolean isFirst;
        if (queryParas == null || queryParas.isEmpty()) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            isFirst = true;
            sb.append('?');
        } else {
            isFirst = false;
        }
        for (Map.Entry<String, String> entry : queryParas.entrySet()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append('&');
            }
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isEmpty((Object)value)) {
                try {
                    value = URLEncoder.encode(value, CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
            sb.append(key).append('=').append(value);
        }
        return sb.toString();
    }

    public static String readData(HttpServletRequest request) {
        BufferedReader br = null;
        try {
            StringBuilder ret;
            br = request.getReader();
            String line = br.readLine();
            if (line != null) {
                ret = new StringBuilder();
                ret.append(line);
            } else {
                return "";
            }
            while ((line = br.readLine()) != null) {
                ret.append('\n').append(line);
            }
            return ret.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public static String readIncommingRequestData(HttpServletRequest request) {
        return HttpUtil.readData((HttpServletRequest)request);
    }
}

