/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.config;

import com.huimin.config.DatabaseConfig;
import com.huimin.config.DynamicDataSource;
import com.zaxxer.hikari.HikariDataSource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ConfigurationProperties(prefix="spring.datasource.dynamic")
@EnableTransactionManagement
public class DatabaseConfig {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConfig.class);
    Map<String, Map<String, Object>> datasource;
    private String primary;
    private final List<DataSouceList> dataSourceMap;

    @Bean(name={"dynamicDataSource"})
    public DynamicDataSource dynamicDataSource() {
        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        HashMap targetDataSources = new HashMap();
        for (Map.Entry entry : this.datasource.entrySet()) {
            DataSouceList dataSouceList = new DataSouceList(this);
            DataSources source = new DataSources(this);
            Map value = (Map)entry.getValue();
            HikariDataSource dataSource = (HikariDataSource)DataSourceBuilder.create().build();
            dataSource.setJdbcUrl(MapUtils.getString((Map)value, (Object)"url"));
            dataSource.setUsername(MapUtils.getString((Map)value, (Object)"username"));
            dataSource.setDriverClassName("com.mysql.cj.jdbc.Driver");
            dataSource.setMaximumPoolSize(10);
            dataSource.setConnectionTimeout(30000L);
            dataSource.setPassword(MapUtils.getString((Map)value, (Object)"password"));
            if (((String)entry.getKey()).equals(this.primary)) {
                dynamicDataSource.setDefaultTargetDataSource((Object)dataSource);
            }
            String[] split = dataSource.getJdbcUrl().split("/");
            source.setUrl(split[2]);
            source.setUsername(dataSource.getUsername());
            dataSouceList.setDbName((String)entry.getKey());
            dataSouceList.setDataSource(source);
            this.dataSourceMap.add(dataSouceList);
            targetDataSources.put(entry.getKey(), dataSource);
        }
        dynamicDataSource.setTargetDataSources(targetDataSources);
        return dynamicDataSource;
    }

    @Bean(name={"transactionManagerA"})
    public PlatformTransactionManager transactionManagerA(@Qualifier(value="dynamicDataSource") DynamicDataSource dataSource) {
        return new DataSourceTransactionManager((DataSource)dataSource);
    }

    public DatabaseConfig(List<DataSouceList> dataSourceMap) {
        this.dataSourceMap = dataSourceMap;
    }

    public Map<String, Map<String, Object>> getDatasource() {
        return this.datasource;
    }

    public String getPrimary() {
        return this.primary;
    }

    public List<DataSouceList> getDataSourceMap() {
        return this.dataSourceMap;
    }

    public void setDatasource(Map<String, Map<String, Object>> datasource) {
        this.datasource = datasource;
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseConfig)) {
            return false;
        }
        DatabaseConfig other = (DatabaseConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Map this$datasource = this.getDatasource();
        Map other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !((Object)this$datasource).equals(other$datasource)) {
            return false;
        }
        String this$primary = this.getPrimary();
        String other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !this$primary.equals(other$primary)) {
            return false;
        }
        List this$dataSourceMap = this.getDataSourceMap();
        List other$dataSourceMap = other.getDataSourceMap();
        return !(this$dataSourceMap == null ? other$dataSourceMap != null : !((Object)this$dataSourceMap).equals(other$dataSourceMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : ((Object)$datasource).hashCode());
        String $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : $primary.hashCode());
        List $dataSourceMap = this.getDataSourceMap();
        result = result * 59 + ($dataSourceMap == null ? 43 : ((Object)$dataSourceMap).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseConfig(datasource=" + this.getDatasource() + ", primary=" + this.getPrimary() + ", dataSourceMap=" + this.getDataSourceMap() + ")";
    }
}

