/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.Entity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huimin.DTO.ConfigDTO;
import com.huimin.DTO.FieldDTO;
import com.huimin.DTO.FormDTO;
import com.huimin.DTO.FormReportDTO;
import com.huimin.common.annotation.LogOperation;
import com.huimin.common.annotation.NoNeedLogin;
import com.huimin.common.page.PageData;
import com.huimin.common.page.PageDataReport;
import com.huimin.common.result.Result;
import com.huimin.service.FormReportService;
import com.huimin.service.FormService;
import com.huimin.service.PageConfigService;
import com.huimin.service.RecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/api/form"})
@Api(tags={"\u8868\u5355\u6570\u636e\u63a5\u53e3"})
public class FormApiController {
    private static final Logger log = LoggerFactory.getLogger(FormApiController.class);
    @Resource
    private FormService formService;
    @Resource
    private FormReportService reportService;
    @Resource
    private RecordService recordService;
    @Resource
    private PageConfigService pageConfigService;

    @GetMapping(value={"/getDataValue"})
    public Result<JSONObject> getDataValue() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", (Object)"2");
        return new Result().ok((Object)jsonObject);
    }

    @GetMapping(value={"{formId}"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355")
    public Result<FormDTO> getForm(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId) {
        log.info("FormApiController-getForm-formId:" + JSON.toJSONString((Object)formId));
        FormDTO form = this.formService.get(formId);
        return new Result().ok((Object)form);
    }

    @GetMapping(value={"/report/{formId}"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355")
    public Result<FormReportDTO> getReportForm(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId) {
        log.info("FormApiController-getForm-formId:" + JSON.toJSONString((Object)formId));
        FormReportDTO form = this.reportService.get(formId);
        return new Result().ok((Object)form);
    }

    @GetMapping(value={"{formId}/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u8bb0\u5f55\u4fe1\u606f")
    public Result<Entity> getRecord(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u8bb0\u5f55\u7f16\u53f7") @PathVariable(value="id") String id) throws Exception {
        log.info("FormApiController-getRecord-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-getRecord-id:" + JSON.toJSONString((Object)id));
        Entity entity = this.recordService.get(formId, id);
        return new Result().ok((Object)entity);
    }

    @PostMapping(value={"{formId}"})
    @ApiOperation(value="\u4fdd\u5b58\u8868\u5355\u6570\u636e")
    @LogOperation(value="\u4fdd\u5b58\u8868\u5355\u6570\u636e")
    public Result save(@RequestBody Map<String, Object> params, @ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId) throws Exception {
        log.info("FormApiController-save-params:" + JSON.toJSONString(params));
        log.info("FormApiController-save-formId:" + JSON.toJSONString((Object)formId));
        this.recordService.save(formId, params);
        return new Result();
    }

    @PostMapping(value={"{formId}/page"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="orderField", value="\u6392\u5e8f\u5b57\u6bb5", paramType="query", dataType="String"), @ApiImplicitParam(name="order", value="\u6392\u5e8f\u65b9\u5f0f\uff0c\u53ef\u9009\u503c(asc\u3001desc)", paramType="query", dataType="String")})
    @ApiOperation(value="\u5206\u9875\u8868\u5355\u6570\u636e")
    public Result page(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @RequestBody @ApiIgnore Map<String, Object> params) throws Exception {
        log.info("FormApiController-page-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-page-params:" + JSON.toJSONString(params));
        PageData page = this.recordService.page(formId, params);
        return new Result().ok((Object)page);
    }

    @PostMapping(value={"{formId}/getRecordPage"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u7801\uff0c\u4ece1\u5f00\u59cb", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="limit", value="\u6bcf\u9875\u663e\u793a\u8bb0\u5f55\u6570", paramType="query", required=true, dataType="int"), @ApiImplicitParam(name="orderField", value="\u6392\u5e8f\u5b57\u6bb5", paramType="query", dataType="String")})
    @NoNeedLogin
    public Result getRecordMsg(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @RequestBody @ApiIgnore Map<String, Object> params) throws Exception {
        PageDataReport page = this.recordService.getPage(formId, params);
        return new Result().ok((Object)page);
    }

    @PostMapping(value={"/getFiledDetail"})
    @NoNeedLogin
    public Result getFiledDetail(@RequestBody @ApiIgnore Map<String, String> params) {
        return new Result().ok((Object)this.recordService.getSQLFiled(params));
    }

    @PutMapping(value={"{formId}/{id}"})
    @ApiOperation(value="\u4fee\u6539\u8868\u5355\u6570\u636e")
    @LogOperation(value="\u4fee\u6539\u8868\u5355\u6570\u636e")
    public Result update(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u8bb0\u5f55\u7f16\u53f7") @PathVariable(value="id") String id, @RequestBody Map<String, Object> params) throws Exception {
        log.info("FormApiController-update-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-update-id:" + JSON.toJSONString((Object)id));
        log.info("FormApiController-update-params:" + JSON.toJSONString(params));
        this.recordService.update(formId, id, params);
        return new Result();
    }

    @DeleteMapping(value={"{formId}"})
    @ApiOperation(value="\u5220\u9664\u8868\u5355\u6570\u636e")
    @LogOperation(value="\u5220\u9664\u8868\u5355\u6570\u636e")
    public Result delete(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u8bb0\u5f55\u7f16\u53f7") @RequestBody String[] ids) throws Exception {
        log.info("FormApiController-delete-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-delete-ids:" + JSON.toJSONString((Object)ids));
        this.recordService.delete(formId, ids);
        return new Result();
    }

    @PutMapping(value={"{formId}"})
    @ApiOperation(value="\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5ba1\u6279")
    @LogOperation(value="\u63d0\u4ea4\u5de5\u4f5c\u6d41\u5ba1\u6279")
    public Result stream(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u8bb0\u5f55\u7f16\u53f7") @RequestBody String[] ids) throws Exception {
        log.info("FormApiController-stream-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-stream-ids:" + JSON.toJSONString((Object)ids));
        return this.recordService.stream(formId, ids);
    }

    @GetMapping(value={"{formId}/{creater}/download"})
    @ApiOperation(value="\u4e0b\u8f7d")
    @NoNeedLogin
    public void download(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u5f53\u524d\u767b\u5f55\u4ebaid") @PathVariable(value="creater") String creater, HttpServletResponse response) throws Exception {
        log.info("FormApiController-download-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-download-creater:" + JSON.toJSONString((Object)creater));
        this.recordService.download(formId, creater, response);
    }

    @PostMapping(value={"{formId}/{creater}/export"})
    @ApiOperation(value="\u5bfc\u51fa")
    @NoNeedLogin
    public void export(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u5f53\u524d\u767b\u5f55\u4ebaid") @PathVariable(value="creater") String creater, HttpServletResponse response) throws Exception {
        log.info("FormApiController-getRecord-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-getRecord-creater:" + JSON.toJSONString((Object)creater));
        this.recordService.export(formId, creater, response);
    }

    @PostMapping(value={"{formId}/{creater}/report/export"})
    @ApiOperation(value="\u62a5\u8868\u5bfc\u51fa")
    @NoNeedLogin
    public void reportExport(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u5f53\u524d\u767b\u5f55\u4ebaid") @PathVariable(value="creater") String creater, @RequestBody @ApiIgnore Map<String, Object> params, HttpServletResponse response) throws Exception {
        log.info("FormApiController-getRecord-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-getRecord-creater:" + JSON.toJSONString((Object)creater));
        this.recordService.reportRxport(formId, creater, response, params);
    }

    @PostMapping(value={"{formId}/{creater}/import"})
    @ApiOperation(value="\u5bfc\u5165")
    @LogOperation(value="\u5bfc\u5165")
    public Result<Entity> imports(@ApiParam(value="\u8868\u5355\u7f16\u53f7") @PathVariable(value="formId") String formId, @ApiParam(value="\u5f53\u524d\u767b\u5f55\u4ebaid") @PathVariable(value="creater") String creater, @RequestParam(value="file", required=false) MultipartFile file) throws Exception {
        log.info("FormApiController-getRecord-formId:" + JSON.toJSONString((Object)formId));
        log.info("FormApiController-getRecord-creater:" + JSON.toJSONString((Object)creater));
        return this.recordService.imports(formId, creater, file);
    }

    @GetMapping(value={"fieldList/{formId}"})
    public Result getFields(String creater, @PathVariable(value="formId") String formId, HttpServletRequest request) {
        List pageConfigList = this.pageConfigService.getByPath(creater, request.getRequestURI());
        FormDTO data = this.formService.get(formId);
        List fieldList = data.getFieldList();
        if (pageConfigList == null || pageConfigList.isEmpty()) {
            fieldList = fieldList.stream().filter(f -> f.getIsShow()).collect(Collectors.toList());
            int sortIndex = 1;
            for (FieldDTO field : fieldList) {
                ConfigDTO dto = new ConfigDTO();
                dto.setConfig(field.getConfig());
                dto.setFieldName(field.getFieldName());
                dto.setFieldDesc(field.getFieldDesc());
                dto.setFieldType(field.getFieldType());
                dto.setIsShow(field.getIsShow());
                dto.setIsSearch(field.getIsSearch());
                dto.setSort(Integer.valueOf(sortIndex++));
                dto.setPagePath(request.getRequestURI());
                dto.setIsExport(Boolean.valueOf(true));
                dto.setTableName(field.getTableName());
                dto.setOriginalTableName(field.getOriginalTableName());
                Map config = field.getConfig();
                dto.setIsOrder((Boolean)config.get("isOrder"));
                dto.setColumnWidth(field.getColumnWidth());
                pageConfigList.add(dto);
            }
        } else {
            for (ConfigDTO configDTO : pageConfigList) {
                FieldDTO fieldDTO = fieldList.stream().filter(f -> f.getFieldName().equals(configDTO.getFieldName())).findFirst().orElse(null);
                if (!ObjectUtil.isNotEmpty((Object)fieldDTO)) continue;
                configDTO.setConfig(fieldDTO.getConfig());
            }
        }
        return new Result().ok((Object)pageConfigList);
    }

    @GetMapping(value={"report/fieldList/{formId}"})
    public Result getReportFields(String creater, @PathVariable(value="formId") String formId, HttpServletRequest request) {
        List pageConfigList = this.pageConfigService.getByPath(creater, request.getRequestURI());
        FormReportDTO data = this.reportService.get(formId);
        List fieldList = data.getFieldList();
        if (pageConfigList == null || pageConfigList.isEmpty()) {
            fieldList = fieldList.stream().filter(f -> f.getIsShow()).collect(Collectors.toList());
            int sortIndex = 1;
            for (FieldDTO field : fieldList) {
                ConfigDTO dto = new ConfigDTO();
                dto.setConfig(field.getConfig());
                dto.setFieldName(field.getFieldName());
                dto.setFieldDesc(field.getFieldDesc());
                dto.setFieldType(field.getFieldType());
                dto.setIsShow(field.getIsShow());
                dto.setIsSearch(field.getIsSearch());
                dto.setSort(Integer.valueOf(sortIndex++));
                dto.setPagePath(request.getRequestURI());
                dto.setIsExport(Boolean.valueOf(true));
                dto.setTableName(field.getTableName());
                dto.setOriginalTableName(field.getOriginalTableName());
                Map config = field.getConfig();
                dto.setIsOrder((Boolean)config.get("isOrder"));
                dto.setColumnWidth(field.getColumnWidth());
                pageConfigList.add(dto);
            }
        } else {
            for (ConfigDTO configDTO : pageConfigList) {
                FieldDTO fieldDTO = fieldList.stream().filter(f -> f.getFieldName().equals(configDTO.getFieldName())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)fieldDTO)) {
                    configDTO.setConfig(fieldDTO.getConfig());
                }
                configDTO.setFieldDesc(fieldDTO.getFieldDesc());
            }
        }
        return new Result().ok((Object)pageConfigList);
    }

    @PostMapping(value={"report/fieldList/{formId}"})
    public Result saveReportFields(@RequestBody List<ConfigDTO> configList, HttpServletRequest request) {
        String pagePath = request.getRequestURI();
        this.pageConfigService.saveByPath(pagePath, configList);
        return new Result();
    }

    @PostMapping(value={"fieldList/{formId}"})
    public Result saveFields(@RequestBody List<ConfigDTO> configList, HttpServletRequest request) {
        String pagePath = request.getRequestURI();
        this.pageConfigService.saveByPath(pagePath, configList);
        return new Result();
    }

    @DeleteMapping(value={"fieldList/{creater}"})
    public Result clearFields(@PathVariable(value="creater") String creater, HttpServletRequest request) {
        String pagePath = request.getRequestURI();
        this.pageConfigService.clearByPath(creater, pagePath);
        return new Result();
    }
}

