/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.huimin.DTO.FormReportDTO;
import com.huimin.common.exception.RenException;
import com.huimin.common.page.PageData;
import com.huimin.common.result.Result;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.ConvertUtils;
import com.huimin.entity.FormReportEntity;
import com.huimin.mapper.FormReportMapper;
import com.huimin.service.FormReportService;
import com.huimin.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormReportServiceImpl
extends BaseServiceImpl<FormReportMapper, FormReportEntity>
implements FormReportService {
    private static final Logger log = LoggerFactory.getLogger(FormReportServiceImpl.class);

    public PageData<FormReportDTO> page(Map<String, Object> params) {
        IPage page = ((FormReportMapper)this.baseDao).selectPage(this.getPage(params, "creater_date", false), (Wrapper)this.getWrapper(params));
        List records = page.getRecords();
        records.stream().forEach(f -> {
            f.setCreater(f.getCreaterName());
            f.setUpdater(f.getUpdaterName());
        });
        PageData pageData = this.getPageData(page, FormReportDTO.class);
        return pageData;
    }

    public List<FormReportDTO> list(String id) {
        List entityList = ((FormReportMapper)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)id));
        List reportDTOList = ConvertUtils.sourceToTarget((Collection)entityList, FormReportDTO.class, (String[])new String[0]);
        FormReportEntity formReportEntity = (FormReportEntity)((FormReportMapper)this.baseDao).selectById((Serializable)((Object)id));
        FormReportDTO reportDTO = (FormReportDTO)ConvertUtils.sourceToTarget((Object)formReportEntity, FormReportDTO.class, (String[])new String[0]);
        reportDTOList.add(reportDTO);
        return reportDTOList;
    }

    private QueryWrapper<FormReportEntity> getWrapper(Map<String, Object> params) {
        QueryWrapper wrapper = this.createWrapper(FormReportDTO.class, params);
        wrapper.eq((Object)"is_deleted", (Object)0);
        wrapper.eq((Object)"sql_type", (Object)0);
        return wrapper;
    }

    public FormReportDTO get(String id) {
        FormReportEntity entity = (FormReportEntity)((FormReportMapper)this.baseDao).selectById((Serializable)((Object)id));
        FormReportDTO formReportDTO = (FormReportDTO)ConvertUtils.sourceToTarget((Object)entity, FormReportDTO.class, (String[])new String[0]);
        List formReportEntityList = ((FormReportMapper)this.baseDao).selectList((Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)id));
        List formReportDTOS = ConvertUtils.sourceToTarget((Collection)formReportEntityList, FormReportDTO.class, (String[])new String[0]);
        formReportDTO.setReportDTOList(formReportDTOS);
        return formReportDTO;
    }

    public Result save(FormReportDTO dto, HttpServletRequest request) {
        String id = String.valueOf(IdWorker.getId());
        dto.setSqlType(Integer.valueOf(0));
        FormReportEntity entity = (FormReportEntity)ConvertUtils.sourceToTarget((Object)dto, FormReportEntity.class, (String[])new String[0]);
        entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
        entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
        entity.setCreaterDate(new Date());
        entity.setId(id);
        this.insert((Object)entity);
        List reportDTOList = dto.getReportDTOList();
        for (FormReportDTO reportDTO : reportDTOList) {
            reportDTO.setRelationId(id);
            reportDTO.setSqlType(Integer.valueOf(1));
            this.saveByTypeFour(reportDTO);
        }
        return new Result();
    }

    public void saveByTypeFour(FormReportDTO dto) {
        String id = String.valueOf(IdWorker.getId());
        FormReportEntity entity = (FormReportEntity)ConvertUtils.sourceToTarget((Object)dto, FormReportEntity.class, (String[])new String[0]);
        entity.setCreater(AuthUtil.getLoginUser().getUserId().toString());
        entity.setCreaterName(AuthUtil.getLoginUser().getNickName());
        entity.setCreaterDate(new Date());
        entity.setId(id);
        this.insert((Object)entity);
    }

    public void update(FormReportDTO dto) {
        try {
            FormReportEntity entity = (FormReportEntity)ConvertUtils.sourceToTarget((Object)dto, FormReportEntity.class, (String[])new String[0]);
            entity.setUpdater(AuthUtil.getLoginUser().getUserId().toString());
            entity.setUpdaterName(AuthUtil.getLoginUser().getNickName());
            entity.setUpdaterDate(new Date());
            this.updateById((Object)entity);
            ((FormReportMapper)this.baseDao).delete((Wrapper)new QueryWrapper().eq((Object)"relation_id", (Object)entity.getId()));
            List reportDTOList = dto.getReportDTOList();
            for (FormReportDTO reportDTO : reportDTOList) {
                reportDTO.setRelationId(entity.getId());
                reportDTO.setSqlType(Integer.valueOf(1));
                this.saveByTypeFour(reportDTO);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void delete(String[] ids) throws Exception {
        for (String id : ids) {
            FormReportDTO form = this.get(id);
            if (form != null && form.getStatus() != 0) {
                throw new RenException("\u8bf7\u5148\u7981\u7528\u8868\u5355!");
            }
            String userId = AuthUtil.getLoginUser().getUserId().toString();
            String nickName = AuthUtil.getLoginUser().getNickName();
            assert (form != null);
            FormReportEntity entity = new FormReportEntity();
            entity.setId(id);
            entity.setUpdater(userId);
            entity.setUpdaterName(nickName);
            entity.setUpdaterDate(new Date());
            entity.setIsDeleted(Integer.valueOf(1));
            this.updateById((Object)entity);
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void enableForm(String id) {
        ((FormReportMapper)this.baseDao).toggle(id, 1);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void disbaleForm(String id) {
        ((FormReportMapper)this.baseDao).toggle(id, 0);
    }
}

