/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.huimin.DTO.FormDTO;
import com.huimin.Enum.FlowStatusEnum;
import com.huimin.Enum.TemplateTypeEnum;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.TableUtil;
import com.huimin.config.DynamicDataSourceContextHolder;
import com.huimin.entity.FormEntity;
import com.huimin.mapper.FormMapper;
import com.huimin.service.FormTableService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FormTableServiceImpl
implements FormTableService {
    private static final Logger log = LoggerFactory.getLogger(FormTableServiceImpl.class);
    @Autowired
    private FormMapper formMapper;
    @Resource
    private DataSource dataSource;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public void deleteTables(String dbName, String tableName, List<FormEntity> formEntityList) {
        try {
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            this.formMapper.dropTable(tableName);
            for (FormEntity formEntity : formEntityList) {
                if (formEntity.getWholeTableName().equals("")) continue;
                this.formMapper.dropTable(formEntity.getWholeTableName());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u5220\u9664\u8868\u5931\u8d25", e);
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    @Transactional(transactionManager="transactionManagerA", propagation=Propagation.REQUIRED)
    public void saveFromMsg(FormDTO form, Map<String, Object> params) {
        String id = String.valueOf(IdWorker.getId());
        try {
            String dbName = form.getDbName();
            DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            String tableName = form.getWholeTableName();
            Entity entity = TableUtil.createEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", (Object)id);
            for (String key : params.keySet()) {
                if (!entity.getFieldNames().contains(key)) continue;
                String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString((Object)params.get(key)), null);
                boolean isJson = false;
                entity.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
            }
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                entity.set("creater_date", (Object)new Date()).set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("creater_name", (Object)AuthUtil.getLoginUser().getNickName()).set("is_deleted", (Object)0);
                if (form.getIsStream().booleanValue()) {
                    entity.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                }
            }
            DbUtil.use((DataSource)this.dataSource).insert(entity);
            String saveType = "1";
            String jsonString = JSON.toJSONString(params);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            String string = jsonObject.getString("formDTOList");
            List formDTOList1 = JSONObject.parseArray((String)string, FormDTO.class);
            for (FormDTO formDTO : formDTOList1) {
                List tableList = formDTO.getTableList();
                for (Map objectMap : tableList) {
                    String tableNames = formDTO.getWholeTableName();
                    String ids = String.valueOf(IdWorker.getId());
                    if (saveType.equals("1")) {
                        throw new RuntimeException();
                    }
                    Entity entitys = TableUtil.createTableEntity((String)tableNames, (FormDTO)formDTO).addFieldNames((String[])formDTO.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", (Object)ids).set("main_id", (Object)id);
                    for (String key : objectMap.keySet()) {
                        if (!entitys.getFieldNames().contains(key)) continue;
                        String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString(objectMap.get(key)), null);
                        boolean isJson = false;
                        entitys.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
                    }
                    if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                        entitys.set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("is_deleted", (Object)0);
                        if (form.getIsStream().booleanValue()) {
                            entitys.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                        }
                    }
                    DbUtil.use((DataSource)this.dataSource).insert(entitys);
                }
            }
            log.info("======test---gg");
        }
        catch (Exception e) {
            log.error("HTTP FROM SAVE DATA EEOR" + e);
            throw new RuntimeException("Failed to save data", e);
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }
}

