/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.DbUtil;
import cn.hutool.db.Entity;
import cn.hutool.db.GlobalDbConfig;
import cn.hutool.db.Page;
import cn.hutool.db.PageResult;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.huimin.DTO.ConfigDTO;
import com.huimin.DTO.FieldDTO;
import com.huimin.DTO.FormDTO;
import com.huimin.DTO.FormReportDTO;
import com.huimin.DTO.ProcessDTO;
import com.huimin.DTO.ReportStaticDTO;
import com.huimin.Enum.FlowStatusEnum;
import com.huimin.Enum.TemplateTypeEnum;
import com.huimin.common.page.PageData;
import com.huimin.common.page.PageDataReport;
import com.huimin.common.result.Result;
import com.huimin.common.utils.AuthUtil;
import com.huimin.common.utils.ConvertUtils;
import com.huimin.common.utils.PageUtil;
import com.huimin.common.utils.TableUtil;
import com.huimin.config.DynamicDataSourceContextHolder;
import com.huimin.entity.FormEntity;
import com.huimin.service.FormReportService;
import com.huimin.service.FormService;
import com.huimin.service.FormTableService;
import com.huimin.service.PageConfigService;
import com.huimin.service.RecordService;
import com.huimin.service.SysFillRuleService;
import com.huimin.service.WorkFlowService;
import com.huimin.util.ExcelUtil;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class RecordServiceImpl
implements RecordService {
    private static final Logger log = LoggerFactory.getLogger(RecordServiceImpl.class);
    @Resource
    private DataSource dataSource;
    @Resource
    private FormService formService;
    @Resource
    private FormReportService reportService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private ExcelUtil excelUtil;
    @Resource
    private PageConfigService pageConfigService;
    @Resource
    private FormTableService formTableService;
    @Resource
    private SysFillRuleService sysFillRuleService;

    public void save(String formId, Map<String, Object> params) throws Exception {
        FormDTO form = this.formService.get(formId);
        String id = this.saveFormData(form, params, "0", "");
        String jsonString = JSON.toJSONString(params);
        boolean formDTOList = params.containsKey("formDTOList");
        if (formDTOList) {
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            String string = jsonObject.getString("formDTOList");
            List formDTOList1 = JSONObject.parseArray((String)string, FormDTO.class);
            for (FormDTO formDTO : formDTOList1) {
                List tableList = formDTO.getTableList();
                for (Map objectMap : tableList) {
                    this.saveFormData(formDTO, objectMap, "1", id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFormData(FormDTO form, Map<String, Object> params, String saveType, String mainId) {
        String id = String.valueOf(IdWorker.getId());
        try {
            String dbName = form.getDbName();
            String tableName = form.getWholeTableName();
            Entity entity = null;
            entity = saveType.equals("1") ? TableUtil.createTableEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", (Object)id).set("main_id", (Object)mainId) : TableUtil.createEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", (Object)id);
            for (String key : params.keySet()) {
                if (!entity.getFieldNames().contains(key)) continue;
                String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString((Object)params.get(key)), null);
                boolean isJson = false;
                entity.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
            }
            Map<String, String> ruleMap = form.getFieldList().stream().filter(f -> ObjectUtils.isNotEmpty((Object)f.getRuleCode())).collect(Collectors.toMap(FieldDTO::getFieldName, FieldDTO::getRuleCode));
            for (Map.Entry<String, String> entry : ruleMap.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                System.out.println(key + "====" + value);
                Object o = this.sysFillRuleService.executeRule(value, null);
                entity.setIgnoreNull(key, (Object)o.toString());
            }
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            if (saveType.equals("1")) {
                if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                    entity.set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("is_deleted", (Object)0);
                    if (form.getIsStream().booleanValue()) {
                        entity.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                    }
                }
            } else if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                entity.set("creater_date", (Object)new Date()).set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("creater_name", (Object)AuthUtil.getLoginUser().getNickName()).set("is_deleted", (Object)0);
                if (form.getIsStream().booleanValue()) {
                    entity.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                }
            }
            DbUtil.use((DataSource)this.dataSource).insert(entity);
        }
        catch (Exception e) {
            log.info("========" + e.getMessage());
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String formId, String id, Map<String, Object> params) throws Exception {
        FormDTO form = this.formService.get(formId);
        try {
            String dbName = form.getDbName();
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            String tableName = form.getWholeTableName();
            Entity entity = TableUtil.createEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new));
            for (String key : params.keySet()) {
                String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString((Object)params.get(key)), null);
                if (StringUtils.isEmpty((CharSequence)value) || "null".equals(value) || !entity.getFieldNames().contains(key)) continue;
                boolean isJson = false;
                entity.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
            }
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                entity.set("updater_date", (Object)new Date()).set("updater", (Object)AuthUtil.getLoginUser().getUserId()).set("updater_name", (Object)AuthUtil.getLoginUser().getNickName());
            }
            DbUtil.use((DataSource)this.dataSource).update(entity, Entity.create().set("id", (Object)id));
            String jsonString = JSON.toJSONString(params);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            String string = jsonObject.getString("formDTOList");
            List formDTOList1 = JSONObject.parseArray((String)string, FormDTO.class);
            for (FormDTO formDTO : formDTOList1) {
                List tableList = formDTO.getTableList();
                String wholeTableName = formDTO.getWholeTableName();
                DbUtil.use((DataSource)this.dataSource).del(wholeTableName, "main_id", (Object)id);
                for (Map objectMap : tableList) {
                    boolean containsKey = objectMap.containsKey("id");
                    if (containsKey) {
                        Object idName = objectMap.get("id");
                        Entity tableEntity = TableUtil.createTableEntity((String)wholeTableName, (FormDTO)formDTO).addFieldNames((String[])formDTO.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", idName).set("main_id", (Object)id);
                        for (String key : objectMap.keySet()) {
                            if (!tableEntity.getFieldNames().contains(key)) continue;
                            String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString(objectMap.get(key)), null);
                            boolean isJson = false;
                            tableEntity.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
                        }
                        if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                            tableEntity.set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("is_deleted", (Object)0).set("updater", (Object)AuthUtil.getLoginUser().getUserId());
                            if (form.getIsStream().booleanValue()) {
                                tableEntity.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                            }
                        }
                        DbUtil.use((DataSource)this.dataSource).insert(tableEntity);
                        continue;
                    }
                    this.saveFormData(formDTO, objectMap, "1", id);
                }
            }
        }
        catch (Exception e) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String formId, String ... ids) throws Exception {
        FormDTO form = this.formService.get(formId);
        try {
            String dbName = form.getDbName();
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            String tableName = form.getWholeTableName();
            for (String id : ids) {
                if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                    Entity entity = Entity.create((String)tableName).set("is_deleted", (Object)1).set("updater_date", (Object)new Date()).set("updater", (Object)AuthUtil.getLoginUser().getUserId()).set("updater_name", (Object)AuthUtil.getLoginUser().getNickName());
                    DbUtil.use((DataSource)this.dataSource).update(entity, Entity.create().set("id", (Object)id));
                    continue;
                }
                DbUtil.use((DataSource)this.dataSource).del(tableName, "id", (Object)ids);
            }
        }
        catch (Exception e) {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result stream(String formId, String ... ids) throws Exception {
        FormDTO form = this.formService.get(formId);
        try {
            String dbName = form.getDbName();
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            String tableName = form.getWholeTableName();
            if (form.getIsStream().booleanValue()) {
                for (String id : ids) {
                    Entity ob = this.get(formId, id);
                    String businesStatus = ob.getStr("business_status");
                    Date date = ob.getDate("creater_date");
                    String format = DateUtil.format((Date)date, (String)"yyyyMMddHHmmss");
                    if (!FlowStatusEnum.P_TYPE_4.getDesc().equals(businesStatus) && !FlowStatusEnum.P_TYPE_1.getDesc().equals(businesStatus)) continue;
                    ProcessDTO processDTO = new ProcessDTO();
                    processDTO.setBusinessKey(form.getId());
                    processDTO.setAppFromUrl("/configureforms/#/dataDetail?formId=%s&id=%s");
                    processDTO.setFormUrl("/configureforms/#/dataDetail?formId=%s&id=%s");
                    HashMap params = new HashMap();
                    processDTO.setParams(params);
                    processDTO.setPushTitle(format + "-" + form.getTableName());
                    processDTO.setProcessKey(form.getRelationFlow());
                    processDTO.setStartUserId(AuthUtil.getLoginUser().getUserId().toString());
                    String processId = this.workFlowService.startProcess(processDTO, form.getRelationStream(), new Object[]{formId, id});
                    Entity entity = Entity.create((String)tableName).set("process_id", (Object)processId).set("business_status", (Object)FlowStatusEnum.P_TYPE_2.getDesc());
                    DbUtil.use((DataSource)this.dataSource).update(entity, Entity.create().set("id", (Object)id));
                }
            }
        }
        catch (Exception e) {
            log.info("======" + e);
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return new Result();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageData<Entity> page(String formId, Map<String, Object> params) throws Exception {
        PageResult pageResult = null;
        try {
            boolean orderField;
            FormDTO form = this.formService.get(formId);
            String dbName = form.getDbName();
            Map<String, String> logicMap = form.getFieldList().stream().collect(Collectors.toMap(FieldDTO::getFieldName, FieldDTO::getSearchLogic));
            boolean b = logicMap.containsKey("creater_date");
            if (b && !(orderField = params.containsKey("orderField"))) {
                params.put("orderField", "creater_date");
            }
            String tableName = form.getWholeTableName();
            Page page = PageUtil.build(params);
            Entity where = TableUtil.createEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new));
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                where.put("is_deleted", (Object)0);
            }
            for (String key : params.keySet()) {
                String logic;
                String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString((Object)params.get(key)), null);
                if (!where.getFieldNames().contains(key) || ObjectUtil.isEmpty((Object)value) || "LIKE".equals((logic = logicMap.getOrDefault(key, "LIKE")).toUpperCase())) continue;
                where.put(key, (Object)(logic + " " + value));
            }
            GlobalDbConfig.setCaseInsensitive((boolean)false);
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            pageResult = DbUtil.use((DataSource)this.dataSource).page(where, page);
        }
        catch (Exception e) {
            log.info("========" + e);
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return new PageData(pageResult, (long)pageResult.getTotal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageDataReport<Entity> getPage(String formId, Map<String, Object> params) {
        PageResult pageResult = null;
        ArrayList<ReportStaticDTO> reportStaticDTOS = new ArrayList<ReportStaticDTO>();
        try {
            String dbName;
            FormReportDTO form = this.reportService.get(formId);
            String sqlExq = form.getSqlExq();
            String sqlDtail = "";
            String orderSql = "";
            if (sqlExq.toUpperCase().contains("ORDER BY")) {
                String[] split = sqlExq.split("ORDER BY");
                sqlDtail = sqlExq = split[0];
                orderSql = " ORDER BY " + split[1];
            } else {
                sqlDtail = sqlExq;
            }
            Map<String, String> logicMap = form.getFieldList().stream().collect(Collectors.toMap(FieldDTO::getFieldName, FieldDTO::getSearchLogic));
            List staticList = form.getFieldList().stream().filter(f -> ObjectUtil.isNotEmpty((Object)f.getIsStatis())).collect(Collectors.toList());
            String jsonString = JSONObject.toJSONString(params);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonString);
            if (jsonObject.containsKey((Object)"params")) {
                JSONArray paramsData = jsonObject.getJSONArray("params");
                for (int i = 0; i < paramsData.size(); ++i) {
                    String endTime;
                    String startTime;
                    JSONArray objectTime;
                    JSONObject jsonParms = paramsData.getJSONObject(i);
                    String filedName = jsonParms.getString("filedName");
                    String filedParams = jsonParms.getString("filedParams");
                    String tableName = jsonParms.getString("tableName");
                    String tagIcon = jsonParms.getString("tagIcon");
                    String filedSeq = logicMap.get(filedName);
                    boolean timeFlag = false;
                    if (tagIcon.equals("daterange")) {
                        timeFlag = true;
                    }
                    boolean filedFlag = false;
                    if (filedParams.equals("")) continue;
                    filedParams = filedParams.equals("true") ? "1" : filedParams;
                    String string = filedParams = filedParams.equals("false") ? "0" : filedParams;
                    if (filedSeq.toLowerCase().equals("like")) {
                        filedFlag = true;
                    }
                    if (!sqlExq.toLowerCase().contains("where")) {
                        if (sqlDtail.contains("where")) {
                            if (timeFlag) {
                                objectTime = JSONArray.parseArray((String)filedParams);
                                if (objectTime.size() > 1) {
                                    startTime = objectTime.getString(0);
                                    endTime = objectTime.getString(1);
                                    sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + ">='" + startTime + "'");
                                    sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "<='" + endTime + "'");
                                    continue;
                                }
                                startTime = objectTime.getString(0);
                                sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "='" + startTime + "'");
                                continue;
                            }
                            if (!filedFlag) {
                                sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "='" + filedParams + "'");
                                continue;
                            }
                            sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + " like '%" + filedParams + "%'");
                            continue;
                        }
                        if (timeFlag) {
                            objectTime = JSONArray.parseArray((String)filedParams);
                            if (objectTime.size() > 1) {
                                startTime = objectTime.getString(0);
                                endTime = objectTime.getString(1);
                                sqlDtail = sqlDtail.concat(" where " + tableName + "." + filedName + ">='" + startTime + "'");
                                sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "<='" + endTime + "'");
                                continue;
                            }
                            startTime = objectTime.getString(0);
                            sqlDtail = sqlDtail.concat(" where " + tableName + "." + filedName + "='" + startTime + "'");
                            continue;
                        }
                        if (!filedFlag) {
                            sqlDtail = sqlDtail.concat(" where " + tableName + "." + filedName + "='" + filedParams + "'");
                            continue;
                        }
                        sqlDtail = sqlDtail.concat(" where " + tableName + "." + filedName + " like '%" + filedParams + "%'");
                        continue;
                    }
                    if (timeFlag) {
                        objectTime = JSONArray.parseArray((String)filedParams);
                        if (objectTime.size() > 1) {
                            startTime = objectTime.getString(0);
                            endTime = objectTime.getString(1);
                            sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + ">='" + startTime + "'");
                            sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "<='" + endTime + "'");
                            continue;
                        }
                        startTime = objectTime.getString(0);
                        sqlDtail = sqlDtail.concat(" and " + tableName + "." + filedName + "='" + startTime + "'");
                        continue;
                    }
                    sqlDtail = !filedFlag ? sqlDtail.concat(" and " + tableName + "." + filedName + "='" + filedParams + "'") : sqlDtail.concat(" and " + tableName + "." + filedName + " like '%" + filedParams + "%'");
                }
            }
            if (null != (dbName = form.getDbName()) && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            if (ObjectUtil.isNotEmpty(staticList)) {
                for (FieldDTO fieldDTO : staticList) {
                    Number number;
                    if (!fieldDTO.getIsStatis().booleanValue()) continue;
                    ReportStaticDTO reportStaticDTO = new ReportStaticDTO();
                    String tableName = fieldDTO.getTableName();
                    String fieldName = fieldDTO.getFieldName();
                    String fieldDesc = fieldDTO.getFieldDesc();
                    reportStaticDTO.setFiledName(fieldName);
                    String[] splitform = sqlDtail.toLowerCase().split("from");
                    String sql = splitform[1];
                    String staticSql = "";
                    if (fieldDTO.getStatisType().equals("avg")) {
                        staticSql = "select AVG(" + tableName + "." + fieldName + ") from " + sql;
                        number = DbUtil.use((DataSource)this.dataSource).queryNumber(staticSql, null);
                        double v = number.doubleValue();
                        reportStaticDTO.setStaticData((Object)v);
                        reportStaticDTO.setFiledDesc(fieldDesc);
                        reportStaticDTOS.add(reportStaticDTO);
                        continue;
                    }
                    if (fieldDTO.getStatisType().equals("sum")) {
                        staticSql = "select SUM(" + tableName + "." + fieldName + ") from " + sql;
                    } else if (fieldDTO.getStatisType().equals("max")) {
                        staticSql = "select MAX(" + tableName + "." + fieldName + ") from " + sql;
                    } else if (fieldDTO.getStatisType().equals("min")) {
                        staticSql = "select MIN(" + tableName + "." + fieldName + ") from " + sql;
                    } else if (fieldDTO.getStatisType().equals("count")) {
                        staticSql = "select count(" + tableName + "." + fieldName + ") from " + sql;
                    }
                    number = DbUtil.use((DataSource)this.dataSource).queryNumber(staticSql, null);
                    int v = number.intValue();
                    reportStaticDTO.setStaticData((Object)v);
                    reportStaticDTO.setFiledDesc(fieldDesc);
                    reportStaticDTOS.add(reportStaticDTO);
                }
            }
            sqlExq = params.containsKey("orderField") ? sqlDtail : sqlDtail.concat(orderSql);
            Page page = PageUtil.build(params);
            GlobalDbConfig.setCaseInsensitive((boolean)false);
            pageResult = DbUtil.use((DataSource)this.dataSource).page((CharSequence)sqlExq, page, null);
        }
        catch (Exception e) {
            log.info("====" + e.getMessage());
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return new PageDataReport(pageResult, (long)pageResult.getTotal(), reportStaticDTOS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FieldDTO> getSQLFiled(Map<String, String> params) {
        ArrayList<FieldDTO> fieldDTOS = new ArrayList<FieldDTO>();
        String dbName = params.get("dbName");
        try {
            String sqlMsg1 = params.get("sqlMsg");
            DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            Connection connection = this.dataSource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sqlMsg1);
            ResultSetMetaData metaData = resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String columnTypeName = metaData.getColumnTypeName(i);
                String columnName = metaData.getColumnName(i);
                String columnLabel = metaData.getColumnLabel(i);
                String tableName = metaData.getTableName(i);
                String tableExq = this.extractAlias(sqlMsg1, tableName);
                FieldDTO fieldDTO = new FieldDTO();
                fieldDTO.setFieldType(columnTypeName.toLowerCase());
                fieldDTO.setFieldName(columnName);
                fieldDTO.setFieldDesc(columnName);
                fieldDTO.setTableName(tableExq.equals("") ? tableName : tableExq);
                fieldDTO.setOriginalTableName(columnLabel);
                fieldDTOS.add(fieldDTO);
            }
        }
        catch (Exception e) {
            DynamicDataSourceContextHolder.clearDataSourceType();
            ArrayList<FieldDTO> arrayList = fieldDTOS;
            return arrayList;
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return fieldDTOS;
    }

    public String extractAlias(String sql, String tableName) {
        Pattern pattern = Pattern.compile("\\b" + tableName + "\\b\\s+(?:AS\\s+)?(\\w+)", 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String alias = matcher.group(1);
            return alias;
        }
        return "";
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity get(String formId, String id) throws Exception {
        try {
            FormDTO form = this.formService.get(formId);
            String tableName = form.getWholeTableName();
            String dbName = form.getDbName();
            List mainId = this.formService.list((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)formId));
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            Entity entity = DbUtil.use((DataSource)this.dataSource).get(tableName, "id", (Object)id);
            System.out.println("========" + entity);
            ArrayList<FormDTO> formDTOList = new ArrayList<FormDTO>();
            for (FormEntity formEntity : mainId) {
                List entityList = DbUtil.use((DataSource)this.dataSource).findBy(formEntity.getWholeTableName(), "main_id", (Object)id);
                FormDTO formDTO = (FormDTO)ConvertUtils.sourceToTarget((Object)formEntity, FormDTO.class, (String[])new String[0]);
                formDTO.setViewList(entityList);
                formDTOList.add(formDTO);
            }
            GlobalDbConfig.setCaseInsensitive((boolean)false);
            entity.put("formDTOList", formDTOList);
            Entity entity2 = entity;
            return entity2;
        }
        catch (Exception e) {
            log.info("=====" + e);
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
        return null;
    }

    public static Map<String, Object> convertToMap(Object obj) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                map.put(field.getName(), field.get(obj));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    public List<FieldDTO> isShowFieldDTO(List<FieldDTO> form, String formId, String creater) {
        List pageConfigList = this.pageConfigService.getByPath(creater, "/api/form/fieldList/" + formId);
        List<FieldDTO> isShowFieldDTO = form.stream().filter(f -> f.getIsShow()).collect(Collectors.toList());
        ArrayList<FieldDTO> isShow = new ArrayList<FieldDTO>();
        if (ObjectUtil.isNotEmpty((Object)pageConfigList)) {
            for (ConfigDTO configDTO : pageConfigList) {
                FieldDTO fieldDTO;
                if (!configDTO.getIsExport().booleanValue() || !ObjectUtil.isNotEmpty((Object)(fieldDTO = (FieldDTO)isShowFieldDTO.stream().filter(f -> f.getFieldName().equals(configDTO.getFieldName())).findFirst().orElse(null)))) continue;
                isShow.add(fieldDTO);
            }
            return isShow;
        }
        return isShowFieldDTO;
    }

    public byte[] download(String formId, String creater, HttpServletResponse response) throws Exception {
        FormDTO form = this.formService.get(formId);
        if (ObjectUtil.isEmpty((Object)form)) {
            return null;
        }
        List isShowFieldDTO = this.isShowFieldDTO(form.getFieldList(), formId, creater);
        ArrayList data = new ArrayList();
        return this.excelUtil.exportLineColumn(form.getComment(), data, isShowFieldDTO, response);
    }

    public byte[] export(String formId, String creater, HttpServletResponse response) throws Exception {
        FormDTO form = this.formService.get(formId);
        if (ObjectUtil.isEmpty((Object)form)) {
            return null;
        }
        List isShowFieldDTO = this.isShowFieldDTO(form.getFieldList(), formId, creater);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("page", "1");
        params.put("limit", "999999");
        PageDataReport page = null;
        if (form.getTemplateType() != 4) {
            PageData page1 = this.page(formId, params);
            List data = page1.getList();
            return this.excelUtil.exportLineColumn(form.getComment(), data, isShowFieldDTO, response);
        }
        page = this.getPage(formId, params);
        List data = page.getList();
        return this.excelUtil.exportLineColumn(form.getComment(), data, isShowFieldDTO, response);
    }

    public byte[] reportRxport(String formId, String creater, HttpServletResponse response, Map<String, Object> params) throws Exception {
        FormReportDTO form = this.reportService.get(formId);
        if (ObjectUtil.isEmpty((Object)form)) {
            return null;
        }
        List isShowFieldDTO = this.isShowFieldDTO(form.getFieldList(), formId, creater);
        params.put("page", "1");
        params.put("limit", "999999");
        PageDataReport page = this.getPage(formId, params);
        List data = page.getList();
        return this.excelUtil.exportLineColumn(form.getComment(), data, isShowFieldDTO, response);
    }

    public Result imports(String formId, String creater, MultipartFile file) throws Exception {
        if (StringUtils.isEmpty((CharSequence)file.getName())) {
            return new Result().error("\u6587\u4ef6\u5f02\u5e38!");
        }
        String suffix = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (StringUtils.isEmpty((CharSequence)suffix) || !"XLS".equals(suffix.toUpperCase()) && !"XLSX".equals(suffix.toUpperCase())) {
            return new Result().error("\u4e0d\u662fexcel\u6587\u4ef6\u683c\u5f0f!");
        }
        FormDTO form = this.formService.get(formId);
        if (ObjectUtil.isEmpty((Object)form)) {
            return new Result().error("\u53c2\u6570\u5f02\u5e38!");
        }
        List isShowFieldDTO = this.isShowFieldDTO(form.getFieldList(), formId, creater);
        HSSFWorkbook wookbook = null;
        try {
            wookbook = new HSSFWorkbook(file.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            wookbook = new XSSFWorkbook(file.getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (wookbook == null) {
            return new Result().error("\u4e0d\u662fexcel\u6587\u4ef6\u683c\u5f0f!");
        }
        Sheet sheet = wookbook.getSheetAt(0);
        int rows = sheet.getPhysicalNumberOfRows();
        --rows;
        try {
            for (int i = 1; i <= rows; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) continue;
                Map map = this.excelUtil.importReturnOne(isShowFieldDTO, row, i);
                this.saves(form, map);
            }
        }
        catch (Exception e) {
            return new Result().error("\u5bfc\u5165\u5931\u8d25" + e);
        }
        return new Result();
    }

    public void saves(FormDTO form, Map<String, Object> params) {
        try {
            String tableName = form.getWholeTableName();
            Entity entity = TableUtil.createEntity((String)tableName, (FormDTO)form).addFieldNames((String[])form.getFieldList().stream().map(p -> p.getFieldName()).toArray(String[]::new)).set("id", (Object)String.valueOf(IdWorker.getId()));
            String dbName = form.getDbName();
            if (null != dbName && !dbName.equals("")) {
                DynamicDataSourceContextHolder.setDataSourceType((String)dbName);
            }
            for (String key : params.keySet()) {
                if (!entity.getFieldNames().contains(key)) continue;
                String value = (String)StringUtils.defaultIfEmpty((CharSequence)ObjectUtil.toString((Object)params.get(key)), null);
                boolean isJson = false;
                entity.setIgnoreNull(key, (Object)(isJson ? JSONUtil.parseArray((String)value).join(",") : value));
            }
            if (TemplateTypeEnum.T_TYPE_1.getKey().equals(form.getTemplateType())) {
                entity.set("creater_date", (Object)new Date()).set("creater", (Object)AuthUtil.getLoginUser().getUserId()).set("creater_name", (Object)AuthUtil.getLoginUser().getNickName()).set("is_deleted", (Object)0);
                if (form.getIsStream().booleanValue()) {
                    entity.set("business_status", (Object)FlowStatusEnum.P_TYPE_1.getDesc());
                }
            }
            DbUtil.use((DataSource)this.dataSource).insert(entity);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            DynamicDataSourceContextHolder.clearDataSourceType();
        }
    }
}

