/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.StringUtils;

public class ChineseToPinyinUtils {
    public static String getFirstLetterUpper(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    System.out.println(pinyin[0]);
                    if (pinyin == null) continue;
                    sb.append(pinyin[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public static String getFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getLowFirstSpell(String chinese) {
        StringBuffer pybf = new StringBuffer();
        char[] arr = chinese.toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] > '\u0080') {
                try {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray((char)arr[i], (HanyuPinyinOutputFormat)defaultFormat);
                    if (temp == null) continue;
                    pybf.append(temp[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            pybf.append(arr[i]);
        }
        return pybf.toString().replaceAll("\\W", "").trim();
    }

    public static String getFirstLetterLower(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (Character.isLetter(ch) && !Character.isLowerCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (pinyin == null) continue;
                    sb.append(pinyin[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    public static String getAllLetterUpper(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (Character.isLetter(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (pinyin == null) continue;
                    sb.append(pinyin[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public static String getAllLetterLower(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (Character.isLetter(ch) && !Character.isLowerCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (pinyin == null) continue;
                    sb.append(pinyin[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }
}

