/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.db.Entity;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimin.DTO.FieldDTO;
import com.huimin.controller.CommonController;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);
    @Resource
    private CommonController commonController;
    private static final SimpleDateFormat date = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat time = new SimpleDateFormat("HH:mm:ss");
    private static final List<String> tongji = Arrays.asList("radio", "switch", "checkbox", "select");
    private static final List<String> jilian = Arrays.asList("cascader");
    private static final List<String> all = Stream.of(tongji, jilian).flatMap(Collection::stream).collect(Collectors.toList());

    public <T> byte[] exportLineColumn(String sheetname, List<Entity> data, List<FieldDTO> isShowFieldDTO, HttpServletResponse response) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook();
        if (StringUtils.isBlank((CharSequence)sheetname)) {
            sheetname = "sheet";
        }
        XSSFSheet sheet = workbook.createSheet(sheetname);
        Row header = sheet.createRow(0);
        for (int i = 0; i < isShowFieldDTO.size(); ++i) {
            String fieldDesc = isShowFieldDTO.get(i).getFieldDesc();
            Cell cell = header.createCell(i);
            cell.setCellValue(fieldDesc);
        }
        for (int j = 1; j < data.size() + 1; ++j) {
            header = sheet.createRow(j);
            Entity d = data.get(j - 1);
            block19: for (int i = 0; i < isShowFieldDTO.size(); ++i) {
                FieldDTO fieldDTO = isShowFieldDTO.get(i);
                Map config = fieldDTO.getConfig();
                String tagIcon = (String)config.get("tagIcon");
                Object v = d.get((Object)fieldDTO.getFieldName());
                if (all.contains(tagIcon)) {
                    Boolean multiple = (Boolean)config.get("multiple");
                    v = ObjectUtil.isNotEmpty((Object)multiple) && multiple != false ? this.duoxuan(v) : this.danxuan(v);
                }
                Cell cell = header.createCell(i);
                if (null == v) continue;
                switch (fieldDTO.getFieldType()) {
                    case "Date": {
                        cell.setCellValue(date.format(v));
                        continue block19;
                    }
                    case "DateTime": {
                        cell.setCellValue(datetime.format(v));
                        continue block19;
                    }
                    case "Time": {
                        cell.setCellValue(time.format(v));
                        continue block19;
                    }
                    case "Integer": 
                    case "Long": {
                        cell.setCellValue(((Number)v).doubleValue());
                    }
                    case "Boolean": 
                    case "String": 
                    case "Blob": {
                        cell.setCellValue(v.toString());
                    }
                    default: {
                        cell.setCellValue(v.toString());
                    }
                }
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)byteArrayOutputStream);
        byte[] fileBytes = byteArrayOutputStream.toByteArray();
        int fileSize = fileBytes.length;
        response.reset();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.addHeader("Content-Disposition", "attachment;filename=" + System.currentTimeMillis() + ".xlsx");
        response.setContentLength(fileSize);
        response.flushBuffer();
        BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
        workbook.write((OutputStream)os);
        ((OutputStream)os).flush();
        ((OutputStream)os).close();
        return fileBytes;
    }

    public Map<String, Object> importReturnOne(List<FieldDTO> isShowFieldDTO, Row row, int i) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        for (int j = 0; j < isShowFieldDTO.size(); ++j) {
            Cell cell = row.getCell(j);
            if (ObjectUtils.isEmpty((Object)cell)) continue;
            String string = null;
            FieldDTO fieldDTO = isShowFieldDTO.get(j);
            if (cell.getCellType() == 0) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date dateCellValue = cell.getDateCellValue();
                    switch (fieldDTO.getFieldType()) {
                        case "Date": {
                            string = date.format(dateCellValue);
                            break;
                        }
                        case "DateTime": {
                            string = datetime.format(dateCellValue);
                            break;
                        }
                        case "Time": {
                            string = time.format(dateCellValue);
                            break;
                        }
                    }
                } else {
                    double numericValue = cell.getNumericCellValue();
                    string = String.valueOf(numericValue);
                }
            } else {
                string = cell.getStringCellValue();
            }
            if (ObjectUtils.isEmpty((Object)string)) continue;
            Map config = fieldDTO.getConfig();
            String tagIcon = (String)config.get("tagIcon");
            String dataType = (String)config.get("dataType");
            if (all.contains(tagIcon)) {
                Boolean multiple = (Boolean)config.get("multiple");
                if (tongji.contains(tagIcon)) {
                    string = ObjectUtil.isNotEmpty((Object)multiple) && multiple.booleanValue() ? this.duoxuanImport(dataType, config, string) : this.danxuanImport(dataType, config, string);
                } else {
                    JSONObject options = (JSONObject)config.get("props");
                    String dataKey = options.getString("dataKey");
                    String children = options.getString("children");
                    String labels = options.getString("label");
                    String values = options.getString("value");
                    ArrayList list = new ArrayList();
                    String[] split = string.split(",");
                    JSONArray jsonArray = new JSONArray();
                    if ("\u9759\u6001\u6570\u636e".equals(dataType)) {
                        jsonArray = (JSONArray)config.get("options");
                    } else {
                        String action = (String)config.get("action");
                        JSONObject get = this.commonController.callback(action);
                        jsonArray = this.dataKey(dataKey, get);
                    }
                    for (String s : split) {
                        jsonArray = this.cengji(list, jsonArray, s, labels, values, children);
                    }
                    string = JSON.toJSONString(list);
                }
            }
            params.put(fieldDTO.getFieldName(), string);
        }
        return params;
    }

    public JSONArray cengji(List<String> list, JSONArray jsonArray, String s, String labels, String values, String children) {
        if (ObjectUtil.isEmpty((Object)jsonArray)) {
            return null;
        }
        for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
            JSONObject jsonObject = jsonArray.getJSONObject(i1);
            String label = jsonObject.getString(labels);
            if (!s.equals(label)) continue;
            String value = jsonObject.getString(values);
            list.add(value + "&-&" + s);
            return jsonObject.getJSONArray(children);
        }
        return null;
    }

    public Object danxuan(Object v) {
        String va = (String)v;
        String[] split = va.split("&-&");
        if (split.length == 2) {
            v = split[1];
        }
        return v;
    }

    public Object duoxuan(Object v) {
        List list = JSON.parseArray((String)JSON.toJSONString((Object)v), String.class);
        ArrayList re = new ArrayList();
        list.stream().forEach(f -> {
            String[] split = f.split("&-&");
            if (split.length == 2) {
                re.add(split[1]);
            } else {
                re.add(f);
            }
        });
        return re.stream().collect(Collectors.joining(","));
    }

    public String danxuanImport(String dataType, Map<String, Object> config, String string) throws Exception {
        if ("\u9759\u6001\u6570\u636e".equals(dataType)) {
            JSONArray jsonArray = (JSONArray)config.get("options");
            for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                JSONObject jsonObject = jsonArray.getJSONObject(i1);
                String label = jsonObject.getString("label");
                if (!string.equals(label)) continue;
                String value = jsonObject.getString("value");
                return value + "&-&" + string;
            }
        } else {
            JSONObject options = (JSONObject)config.get("props");
            String dataKey = options.getString("dataKey");
            String labels = options.getString("label");
            String values = options.getString("value");
            String action = (String)config.get("action");
            JSONObject get = this.commonController.callback(action);
            JSONArray jsonArray = this.dataKey(dataKey, get);
            for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                JSONObject jsonObject = jsonArray.getJSONObject(i1);
                String label = jsonObject.getString(labels);
                if (!string.equals(label)) continue;
                String value = jsonObject.getString(values);
                return value + "&-&" + string;
            }
        }
        return null;
    }

    public JSONArray dataKey(String dataKey, JSONObject get) {
        String[] split = dataKey.split("\\.");
        if (split.length == 1) {
            return get.getJSONArray(dataKey);
        }
        for (int i = 0; i < split.length - 1; ++i) {
            get = get.getJSONObject(split[i]);
        }
        return get.getJSONArray(split[split.length - 1]);
    }

    public String duoxuanImport(String dataType, Map<String, Object> config, String string) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        String[] split = string.split(",");
        if ("\u9759\u6001\u6570\u636e".equals(dataType)) {
            JSONArray jsonArray = (JSONArray)config.get("options");
            block0: for (String s : split) {
                for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i1);
                    String label = jsonObject.getString("label");
                    if (!s.equals(label)) continue;
                    String value = jsonObject.getString("value");
                    list.add(value + "&-&" + s);
                    continue block0;
                }
            }
        } else {
            JSONObject options = (JSONObject)config.get("props");
            String dataKey = options.getString("dataKey");
            String labels = options.getString("label");
            String values = options.getString("value");
            String action = (String)config.get("action");
            JSONObject get = this.commonController.callback(action);
            JSONArray jsonArray = this.dataKey(dataKey, get);
            block2: for (String s : split) {
                for (int i1 = 0; i1 < jsonArray.size(); ++i1) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i1);
                    String label = jsonObject.getString(labels);
                    if (!s.equals(label)) continue;
                    String value = jsonObject.getString(values);
                    list.add(value + "&-&" + s);
                    continue block2;
                }
            }
        }
        return JSON.toJSONString(list);
    }
}

