/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.util.HttpClientUtil;

import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpClientConfig {
    @Value(value="1000")
    private Integer maxTotal;
    @Value(value="1000")
    private Integer defaultMaxPerRoute;
    @Value(value="50000")
    private Integer connectTimeout;
    @Value(value="50000")
    private Integer connectionRequestTimeout;
    @Value(value="50000")
    private Integer socketTimeout;
    @Value(value="true")
    private boolean staleConnectionCheckEnabled;

    @Bean(name={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getPoolingHttpClientConnectionManager() {
        PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager();
        manager.setMaxTotal(this.maxTotal.intValue());
        manager.setDefaultMaxPerRoute(this.defaultMaxPerRoute.intValue());
        return manager;
    }

    @Bean(name={"httpClientBuilder"})
    public HttpClientBuilder getHttpClientBuilder(@Qualifier(value="httpClientConnectionManager") PoolingHttpClientConnectionManager httpClientConnectionManager) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        httpClientBuilder.setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
        return httpClientBuilder;
    }

    @Bean
    public CloseableHttpClient getCloseableHttpClient(@Qualifier(value="httpClientBuilder") HttpClientBuilder httpClientBuilder) {
        return httpClientBuilder.build();
    }

    @Bean(name={"builder"})
    public RequestConfig.Builder getBuilder() {
        RequestConfig.Builder builder = RequestConfig.custom();
        return builder.setConnectTimeout(this.connectTimeout.intValue()).setConnectionRequestTimeout(this.connectionRequestTimeout.intValue()).setSocketTimeout(this.socketTimeout.intValue()).setStaleConnectionCheckEnabled(this.staleConnectionCheckEnabled);
    }

    @Bean
    public RequestConfig getRequestConfig(@Qualifier(value="builder") RequestConfig.Builder builder) {
        return builder.build();
    }
}

