/*
 * Decompiled with CFR 0.152.
 */
package com.huimin.util.HttpClientUtil;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.huimin.common.utils.HttpContextUtils;
import com.huimin.util.HttpClientUtil.RequestParam;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HttpClientService {
    private static Logger logger = LoggerFactory.getLogger(HttpClientService.class);
    @Resource
    private CloseableHttpClient httpClient;
    @Resource
    private RequestConfig requestConfig;
    private CloseableHttpResponse response = null;
    private JSONObject jsonObject = null;

    public JSONObject httpPost(RequestParam param) throws Exception {
        String sinomaauth;
        String token;
        logger.info("url====================" + param.getUrl());
        HttpPost httpPost = new HttpPost(param.getUrl());
        httpPost.setConfig(this.requestConfig);
        String postParam = param.getPostParam();
        if (StringUtils.isBlank((CharSequence)postParam)) {
            postParam = "{}";
        } else {
            try {
                JSONObject.parseObject((String)postParam);
            }
            catch (Exception e) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", (Object)500);
                jsonObject.put("msg", (Object)"\u56de\u8c03\u5931\u8d25,\u8bf7\u6c42\u53c2\u6570\u683c\u5f0f\u5f02\u5e38");
                return jsonObject;
            }
        }
        StringEntity entity = new StringEntity(postParam, "UTF-8");
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setHeader("Content-Type", "application/json");
        String auth = HttpContextUtils.getHttpServletRequest().getHeader("Authorization");
        if (null != auth && !auth.equals("")) {
            httpPost.setHeader("Authorization", auth);
        }
        if (null != (token = HttpContextUtils.getHttpServletRequest().getHeader("X-Token")) && !token.equals("")) {
            httpPost.setHeader("X-Token", token);
        }
        if (null != (sinomaauth = HttpContextUtils.getHttpServletRequest().getHeader("Sinoma-Auth")) && !sinomaauth.equals("")) {
            httpPost.setHeader("Sinoma-Auth", sinomaauth);
        }
        this.response = this.httpClient.execute((HttpUriRequest)httpPost);
        this.jsonObject = this.httpPublicMethod((Object)httpPost, "post");
        return this.jsonObject;
    }

    public JSONObject httpGetHaveParameter(RequestParam param) throws Exception {
        logger.info("url====================" + param.getUrl());
        URIBuilder uriBuilder = new URIBuilder(param.getUrl());
        URI build = uriBuilder.build();
        HttpGet httpGet = new HttpGet(build);
        httpGet.setConfig(this.requestConfig);
        this.response = this.httpClient.execute((HttpUriRequest)httpGet);
        this.jsonObject = this.httpPublicMethod((Object)httpGet, "get");
        return this.jsonObject;
    }

    public JSONObject httpGetNoParameter(String url) throws Exception {
        String sinomaauth;
        String token;
        logger.info("url====================" + url);
        HttpGet httpGet = new HttpGet(url);
        httpGet.setConfig(this.requestConfig);
        String auth = HttpContextUtils.getHttpServletRequest().getHeader("Authorization");
        if (null != auth && !auth.equals("")) {
            httpGet.setHeader("Authorization", auth);
        }
        if (null != (token = HttpContextUtils.getHttpServletRequest().getHeader("X-Token")) && !token.equals("")) {
            httpGet.setHeader("X-Token", token);
        }
        if (null != (sinomaauth = HttpContextUtils.getHttpServletRequest().getHeader("Sinoma-Auth")) && !sinomaauth.equals("")) {
            httpGet.setHeader("Sinoma-Auth", sinomaauth);
        }
        this.response = this.httpClient.execute((HttpUriRequest)httpGet);
        this.jsonObject = this.httpPublicMethod((Object)httpGet, "get");
        return this.jsonObject;
    }

    public JSONObject httpPublicMethod(Object httpPost, String request) throws Exception {
        if ("get".equals(request)) {
            this.response = this.httpClient.execute((HttpUriRequest)((HttpGet)httpPost));
        } else if ("post".equals(request)) {
            this.response = this.httpClient.execute((HttpUriRequest)((HttpPost)httpPost));
        } else {
            logger.error("-----\u8bf7\u6c42\u65b9\u5f0f\u9519\u8bef-----");
            throw new RuntimeException();
        }
        if (this.response == null || this.response.getEntity() == null) {
            logger.error("\u64cd\u4f5c\u5931\u8d25,\u8bf7\u6c42\u8fd4\u56deresponse\u4e3a\u7a7a");
            throw new RuntimeException();
        }
        InputStream inStream = this.response.getEntity().getContent();
        this.jsonObject = JSONObject.parseObject((String)IOUtils.toString((InputStream)inStream, (String)"UTF-8"));
        inStream.close();
        return this.jsonObject;
    }
}

