/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.contract;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.controller.contract.ContractProjectController;
import com.ruoyi.dto.contract.ContractDTO;
import com.ruoyi.dto.contract.ContractFromTaskDTO;
import com.ruoyi.dto.contract.ContractNumberDTO;
import com.ruoyi.dto.contract.ContractProjectExporDTO;
import com.ruoyi.dto.contract.ContractProjectHandleDTO;
import com.ruoyi.dto.contract.SupplementarySignatureContractDTO;
import com.ruoyi.entity.contract.ContractDetailEntity;
import com.ruoyi.entity.contract.ContractEntity;
import com.ruoyi.enums.ContractStatusEnum;
import com.ruoyi.query.contract.ContractProjectQuery;
import com.ruoyi.service.contract.ContractService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.contract.FlowNoticeEvent;
import com.ruoyi.vo.contract.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9879\u76ee\u5408\u540c")
@RequestMapping(value={"/contractproject"})
@RestController
public class ContractProjectController {
    private static final Logger log = LoggerFactory.getLogger(ContractProjectController.class);
    @Autowired
    private ContractService contractService;

    @PostMapping(value={"/getContractNumber"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u8868\u9875\u9762")
    public R<String> getContractNumber(@RequestBody ContractNumberDTO contractNumber) {
        try {
            if (ObjectUtil.isEmpty((Object)contractNumber)) {
                return R.failed((String)"\u53c2\u6570\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)contractNumber.getOurContractingUnit())) {
                return R.failed((String)"\u6211\u65b9\u7b7e\u7ea6\u5355\u4f4d");
            }
            if (StringUtils.isEmpty((CharSequence)contractNumber.getContractType())) {
                return R.failed((String)"\u5408\u540c\u7c7b\u578b");
            }
            if (contractNumber.getContractSigningTime() == null) {
                return R.failed((String)"\u7b7e\u8ba2\u65e5\u671f");
            }
            return R.ok((Object)this.contractService.getContractNumber(contractNumber));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getContractProjectsListPage"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ContractDTO>> getContractProjectsListPage(@RequestBody ContractProjectQuery query) {
        try {
            PageResultVo contractDTOListPage = this.contractService.getContractProjectListPage(query);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getContractByProjectCode"})
    @ApiOperation(value="\u6839\u636e\u9879\u76ee\u7f16\u7801\u67e5\u8be2\u5408\u540c\u4fe1\u606f")
    public R<List<ContractDetailEntity>> getContractByProjectCode(String projectCode) {
        try {
            return R.ok((Object)this.contractService.getContractByProjectCode(projectCode));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getSupplementarySignatureContract"})
    @ApiOperation(value="\u83b7\u53d6\u8865\u7b7e\u4fe1\u606f")
    public R<List<SupplementarySignatureContractDTO>> getSupplementarySignatureContract(String contractNo) {
        try {
            return R.ok((Object)this.contractService.getSupplementarySignatureContract(contractNo));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportContractProjectsList"})
    @ApiOperation(value="\u5bfc\u51fa\u9879\u76ee\u5408\u540c")
    public void exportContractProjectsList(@RequestBody ContractProjectQuery query, HttpServletResponse response) {
        try {
            List contractProjectList = this.contractService.getContractProjectList(query);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u9879\u76ee\u5408\u540c", "\u9879\u76ee\u5408\u540c", ExcelType.XSSF), ContractProjectExporDTO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9879\u76ee\u5408\u540c");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getContractProjectHandleDTOById"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c-\u8be6\u60c5", response=ContractProjectHandleDTO.class)
    public R<ContractProjectHandleDTO> getContractProjectHandleDTOById(Long id) {
        log.info("getContractProjectHandleDTOById-id:" + id);
        try {
            ContractProjectHandleDTO detailVo = this.contractService.getContractProjectHandleDTOById(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/createContractProject"})
    @ApiOperation(value="\u521b\u5efa\u9879\u76ee\u5408\u540c\u4fe1\u606f")
    public R<String> createContractProject(@RequestBody ContractProjectHandleDTO contractProjectHandleDTO) {
        try {
            return R.ok((Object)this.contractService.createContractProject(contractProjectHandleDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/updateContractProject"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u5408\u540c\u4fe1\u606f")
    public R<Boolean> updateContractProject(@RequestBody ContractProjectHandleDTO contractProjectHandleDTO) {
        try {
            return R.ok((Object)this.contractService.updateContractProject(contractProjectHandleDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/updateContractFromTaskId"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u5408\u540c\u4fe1\u606f-\u63d2\u5165\u5de5\u4f5c\u6d41\u53d1\u8d77\u6d41\u7a0bID")
    public R<Boolean> updateContractFromTaskId(@RequestBody ContractFromTaskDTO contractFromTaskDTO) {
        try {
            return R.ok((Object)this.contractService.updateContractFromTaskId(contractFromTaskDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u4fe1\u606f-\u5220\u9664")
    public R<Boolean> deleteById(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.contractService.deleteContractProject(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFromCallBackProjectContractAll"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackProjectContractAll(@RequestBody FlowNoticeEvent vo) {
        try {
            log.info("workFromCallBackProjectContractAll:" + JSON.toJSON((Object)vo));
            String event = vo.getEvent();
            String businessKey = vo.getBody().getBusinessKey();
            String businessStatus = vo.getBody().getBusinessStatus();
            Map map = vo.getBody().getTaskVariables();
            String approveStatus = null;
            if (map.get("approveStatus") != null) {
                approveStatus = map.get("approveStatus").toString();
            }
            ContractEntity contractEntity = (ContractEntity)this.contractService.getById((Serializable)Long.valueOf(Long.parseLong(businessKey)));
            contractEntity.setContractStatus(ContractStatusEnum.SHZ.getCode());
            if ("2".equals(approveStatus)) {
                contractEntity.setContractStatus(ContractStatusEnum.BH.getCode());
                contractEntity.setContractFormStatus("7");
                this.contractService.updateById((Object)contractEntity);
            } else {
                contractEntity.setContractStatus(ContractStatusEnum.SHZ.getCode());
                contractEntity.setContractFormStatus("2");
                this.contractService.updateById((Object)contractEntity);
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFromCallBackProjectContract"})
    @ApiOperation(value="\u9879\u76ee\u5408\u540c\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackProjectContract(@RequestBody FlowNoticeEvent vo) {
        try {
            log.info("workFromCallBackProjectContract:" + JSON.toJSON((Object)vo));
            String event = vo.getEvent();
            String businessKey = vo.getBody().getBusinessKey();
            String businessStatus = vo.getBody().getBusinessStatus();
            Map map = vo.getBody().getTaskVariables();
            String approveStatus = null;
            if (map.get("approveStatus") != null) {
                approveStatus = map.get("approveStatus").toString();
            }
            ContractEntity contractEntity = (ContractEntity)this.contractService.getById((Serializable)Long.valueOf(Long.parseLong(businessKey)));
            contractEntity.setContractStatus(ContractStatusEnum.SHZ.getCode());
            switch (1.$SwitchMap$com$ruoyi$vo$contract$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this.handleContractEntity(approveStatus, contractEntity);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.handleContractEntityCancellation(approveStatus, contractEntity);
                }
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    private void handleContractEntity(String businessStatus, ContractEntity contractEntity) {
        if ("2".equals(businessStatus)) {
            contractEntity.setContractStatus(ContractStatusEnum.BH.getCode());
            contractEntity.setContractFormStatus("7");
        } else {
            contractEntity.setContractStatus(ContractStatusEnum.ZC.getCode());
            contractEntity.setContractFormStatus("0");
        }
        log.info("workFromCallBackProjectContract:3" + JSON.toJSON((Object)contractEntity));
        this.contractService.updateById((Object)contractEntity);
    }

    private void handleContractEntityCancellation(String businessStatus, ContractEntity contractEntity) {
        contractEntity.setContractFormStatus("0");
        this.contractService.updateById((Object)contractEntity);
    }
}

