/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.AdoptionReturnDTO;
import com.ruoyi.dto.supply.AdoptionReturnItemListDTO;
import com.ruoyi.entity.supply.AdoptionReturnDO;
import com.ruoyi.entity.supply.AdoptionReturnItemListDO;
import com.ruoyi.entity.supply.EquipmentProfitLossDO;
import com.ruoyi.entity.supply.EquipmentProfitLossMaterialListDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.enums.supply.AdoptionReturnStatusEnum;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.query.supply.AdoptionReturnQuery;
import com.ruoyi.service.supply.AdoptionReturnItemListService;
import com.ruoyi.service.supply.AdoptionReturnService;
import com.ruoyi.service.supply.EquipmentProfitLossMaterialListService;
import com.ruoyi.service.supply.EquipmentProfitLossService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.AdoptionReturnVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/adoptionReturn"})
@RestController
@Api(tags={"\u9886\u7528\u5f52\u8fd8"})
public class AdoptionReturnController {
    private static final Logger log = LoggerFactory.getLogger(AdoptionReturnController.class);
    @Resource
    private AdoptionReturnService adoptionReturnService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private EquipmentProfitLossService equipmentProfitLossService;
    @Resource
    private EquipmentProfitLossMaterialListService equipmentProfitLossMaterialListService;
    @Resource
    private MaterialCodeService materialCodeService;
    @Resource
    private StockListService stockListService;
    @Resource
    private AdoptionReturnItemListService adoptionReturnItemListService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private WorkFlowService workFlowService;

    @PostMapping(value={"/queryPageAdoptionReturn"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u9886\u7528\u5217\u8868")
    public R<PageResultVo<AdoptionReturnVO>> queryPageAdoptionReturn(@RequestBody AdoptionReturnQuery adoptionReturnQuery) {
        try {
            PageResultVo adoptionReturnVOPageResultVo = this.adoptionReturnService.queryPageAdoptionReturn(adoptionReturnQuery);
            return R.ok((Object)adoptionReturnVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/addAdoptionReturn"})
    @ApiOperation(value="\u65b0\u5efa\u9886\u7528")
    public R<String> addAdoptionReturn(@RequestBody AdoptionReturnDTO adoptionReturnDTO) {
        try {
            return this.adoptionReturnService.addAdoptionReturn(adoptionReturnDTO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/updateAdoptionReturnItemList"})
    @ApiOperation(value="\u4fee\u6539\u5b50\u8868\u5f52\u8fd8")
    public R<String> updateAdoptionReturnItemList(@RequestBody AdoptionReturnItemListDTO adoptionReturnItemListDTO) {
        try {
            AdoptionReturnItemListDO adoptionReturnItemListDO = (AdoptionReturnItemListDO)this.adoptionReturnItemListService.getById((Serializable)adoptionReturnItemListDTO.getId());
            Long id = adoptionReturnItemListDO.getMainId();
            AdoptionReturnDO adoptionReturnDO = (AdoptionReturnDO)this.adoptionReturnService.getById((Serializable)id);
            adoptionReturnDO.setStatus(Integer.valueOf(1));
            this.adoptionReturnService.updateById((Object)adoptionReturnDO);
            adoptionReturnItemListDO.setStatus(Integer.valueOf(1));
            ProcessDTO processDTO = new ProcessDTO();
            processDTO.setProcessInstanceName("\u5f52\u8fd8\u6d41\u7a0b");
            processDTO.setProjectName(adoptionReturnDO.getProjectName());
            processDTO.setBusinessKey(adoptionReturnItemListDTO.getId().toString());
            String processId = this.workFlowService.startProcess(ProcessEnum.construction_return, processDTO, new Object[]{adoptionReturnItemListDTO.getId().toString()});
            System.out.println(processId);
            adoptionReturnItemListDO.setProcessInstId(processId);
            this.adoptionReturnItemListService.updateById((Object)adoptionReturnItemListDO);
            return R.ok((Object)"true");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/returnItem"})
    @ApiOperation(value="\u5f52\u8fd8\u7269\u54c1")
    public R<String> returnItem(@RequestBody AdoptionReturnItemListDTO adoptionReturnItemListDTO) {
        try {
            int returnedCount;
            LambdaQueryWrapper wrapper1;
            List adoptionReturnItemListDOS;
            int totalCount;
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdoptionReturnDO::getId, (Object)adoptionReturnItemListDTO.getId());
            AdoptionReturnDO adoptionReturnDO = (AdoptionReturnDO)this.adoptionReturnService.getOne((Wrapper)wrapper);
            if (ObjectUtil.isNotEmpty((Object)adoptionReturnDO) && (totalCount = (adoptionReturnItemListDOS = this.adoptionReturnItemListService.list((Wrapper)(wrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)adoptionReturnDO.getId())))).size()) == (returnedCount = adoptionReturnItemListDOS.stream().filter(f -> null != f.getReturnStatus() && f.getReturnStatus().equals(0)).collect(Collectors.toList()).size())) {
                adoptionReturnDO.setReturnStatus(AdoptionReturnStatusEnum.returned.getMsg());
                adoptionReturnDO.setUpdateTime(new Date());
                this.adoptionReturnService.updateById((Object)adoptionReturnDO);
            }
            return R.ok((Object)"\u5f52\u8fd8\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/clickProfitAndLoss"})
    @ApiOperation(value="\u70b9\u51fb\u635f\u76ca")
    public R<String> clickProfitAndLoss(@RequestBody AdoptionReturnItemListDTO adoptionReturnItemListDTO) {
        try {
            AdoptionReturnItemListDO byId = (AdoptionReturnItemListDO)this.adoptionReturnItemListService.getById((Serializable)adoptionReturnItemListDTO.getId());
            byId.setStatus(Integer.valueOf(1));
            this.adoptionReturnItemListService.updateById((Object)byId);
            AdoptionReturnVO adoptionReturnVO = this.adoptionReturnService.selectAdoptionReturnDetail(byId.getMainId());
            ArrayList<AdoptionReturnItemListDO> adoptionReturnItemListVOList = new ArrayList<AdoptionReturnItemListDO>();
            adoptionReturnItemListVOList.add(byId);
            if (ObjectUtil.isNotEmpty((Object)adoptionReturnVO)) {
                EquipmentProfitLossDO equipmentProfitLossDO = new EquipmentProfitLossDO();
                equipmentProfitLossDO.setSubjectName(adoptionReturnVO.getSubjectName());
                equipmentProfitLossDO.setLossProfitType("\u8c03\u5355\u635f\u76ca");
                String generateEquipmentProfitLossNumber = this.getGenerateEquipmentProfitLossNumber();
                equipmentProfitLossDO.setNumber(generateEquipmentProfitLossNumber);
                equipmentProfitLossDO.setCreateTime(new Date());
                equipmentProfitLossDO.setAttn(adoptionReturnVO.getApplicants());
                equipmentProfitLossDO.setDepartment(adoptionReturnVO.getDepartment());
                ArrayList equipmentProfitLossMaterialListDOList = new ArrayList();
                adoptionReturnItemListVOList.forEach(a -> {
                    StockListDO one = (StockListDO)this.stockListService.getOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)a.getMaterialId()));
                    EquipmentProfitLossMaterialListDO equipmentProfitLossMaterialListDO = new EquipmentProfitLossMaterialListDO();
                    BeanUtils.copyProperties((Object)one, (Object)equipmentProfitLossMaterialListDO);
                    equipmentProfitLossMaterialListDO.setLossProfitQuantity(a.getAdoptionCount());
                    equipmentProfitLossMaterialListDO.setCreateTime(new Date());
                    equipmentProfitLossMaterialListDO.setUpdateTime(new Date());
                    equipmentProfitLossMaterialListDO.setMainId(adoptionReturnVO.getId());
                    equipmentProfitLossMaterialListDO.setIsDeleted(Integer.valueOf(0));
                    equipmentProfitLossMaterialListDO.setId(null);
                    equipmentProfitLossMaterialListDOList.add(equipmentProfitLossMaterialListDO);
                });
                this.equipmentProfitLossService.clickProfitAndLoss(equipmentProfitLossDO, equipmentProfitLossMaterialListDOList, adoptionReturnItemListVOList);
            }
            return R.ok((Object)"\u751f\u6210\u635f\u76ca\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/queryAdoptionReturnDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<AdoptionReturnVO> queryAdoptionReturnDetail(@RequestBody AdoptionReturnDTO adoptionReturnDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)adoptionReturnDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AdoptionReturnVO adoptionReturnVO = this.adoptionReturnService.selectAdoptionReturnDetail(adoptionReturnDTO.getId());
            return R.ok((Object)adoptionReturnVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getAdoptionReturnItemList"})
    @ApiOperation(value="\u67e5\u770b\u5b50\u5f52\u8fd8\u8be6\u60c5")
    public R<AdoptionReturnVO> getAdoptionReturnItemList(@RequestBody AdoptionReturnDTO adoptionReturnDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)adoptionReturnDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AdoptionReturnVO adoptionReturnItemList = this.adoptionReturnService.getAdoptionReturnItemList(adoptionReturnDTO.getId());
            return R.ok((Object)adoptionReturnItemList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/selectAdoptionReturnItemList"})
    @ApiOperation(value="\u5b50\u5f52\u8fd8\u8be6\u60c5")
    public R<AdoptionReturnVO> selectAdoptionReturnItemList(@RequestBody AdoptionReturnDTO adoptionReturnDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)adoptionReturnDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            AdoptionReturnVO adoptionReturnVO = this.adoptionReturnService.selectAdoptionReturnItemList(adoptionReturnDTO.getId());
            return R.ok((Object)adoptionReturnVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportAdoptionReturn"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportAdoptionReturn(@RequestBody AdoptionReturnQuery adoptionReturnQuery, HttpServletResponse response) {
        try {
            this.adoptionReturnService.exportAdoptionReturn(adoptionReturnQuery, response);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25:{}", (Object)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u9886\u7528-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.adoptionReturnService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackReturn"})
    @ApiOperation(value="\u5f52\u8fd8-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackReturn(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.adoptionReturnService.workFromCallBackReturn(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    public String getGenerateEquipmentProfitLossNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(EquipmentProfitLossDO::getNumber, (Object)"SBSY-")).orderByDesc(EquipmentProfitLossDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.equipmentProfitLossService.list((Wrapper)wrapper))) {
            return "SBSY-" + simpleDateFormat.format(date) + "-001";
        }
        String recentEquipmentProfitLossNumber = ((EquipmentProfitLossDO)this.equipmentProfitLossService.list((Wrapper)wrapper).get(0)).getNumber();
        String substring = recentEquipmentProfitLossNumber.substring(recentEquipmentProfitLossNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "SBSY-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }
}

