/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.HandlelnvoicingDto;
import com.ruoyi.dto.supply.InWarehouseManagementDTO;
import com.ruoyi.dto.supply.InWarehouseManagementDetailDTO;
import com.ruoyi.dto.supply.ProjectInformationDTO;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.entity.supply.MaterialCodeDo;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.query.supply.InWarehouseManagementQuery;
import com.ruoyi.service.supply.InWarehouseManagementService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.PurchaseOrderService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.InWarehouseManagementDetailVO;
import com.ruoyi.vo.supply.InWarehouseManagementVO;
import com.ruoyi.vo.supply.MaterialApplicationOrderUnderListVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/inWarehouseManagement"})
@RestController
@Api(tags={"\u5165\u5e93\u7ba1\u7406"})
public class InWarehouseManagementController {
    private static final Logger log = LoggerFactory.getLogger(InWarehouseManagementController.class);
    @Resource
    private InWarehouseManagementService inWarehouseManagementService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private MaterialCodeService materialCodeService;

    @ApiOperation(value="\u5165\u5e93\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/pageQueryInWarehouseManagement"})
    public R<PageResultVo<InWarehouseManagementVO>> pageQueryInWarehouseManagement(@RequestBody InWarehouseManagementQuery inWarehouseManagementQuery) {
        try {
            PageResultVo inWarehouseManagementVOPageResultVo = this.inWarehouseManagementService.pageQueryInWarehouseManagement(inWarehouseManagementQuery);
            return R.ok((Object)inWarehouseManagementVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u5165\u5e93\u7ba1\u7406\uff1a\u5bfc\u51fa")
    @PostMapping(value={"/exportInWarehouseManagement"})
    public void exportInWarehouseManagement(@RequestBody InWarehouseManagementQuery inWarehouseManagementQuery, HttpServletResponse response) {
        try {
            this.inWarehouseManagementService.exportInWarehouseManagement(inWarehouseManagementQuery, response);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u5165\u5e93")
    @PostMapping(value={"/addInWarehouseManagement"})
    public R<String> addInWarehouseManagement(@RequestBody InWarehouseManagementDTO inWarehouseManagementDTO) {
        try {
            List inWarehouseManagementDetailDTOLists = inWarehouseManagementDTO.getInWarehouseManagementDetailDTOList();
            if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDetailDTOLists)) {
                inWarehouseManagementDetailDTOLists = inWarehouseManagementDetailDTOLists.stream().filter(f -> "\u542f\u7528".equals(f.getOneYardPerObject())).collect(Collectors.toList());
                for (InWarehouseManagementDetailDTO a2 : inWarehouseManagementDetailDTOLists) {
                    if (StringUtils.isEmpty((CharSequence)a2.getUniqueCodeCollection())) {
                        return R.fail((String)"\u65b0\u589e\u5165\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    List<String> strings = Arrays.asList(a2.getUniqueCodeCollection().split(","));
                    if (ObjectUtil.isEmpty(strings)) {
                        return R.fail((String)"\u65b0\u589e\u5165\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    HashSet<String> set = new HashSet<String>(strings);
                    if (strings.size() != set.size()) {
                        return R.fail((String)"\u65b0\u589e\u5165\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u5b58\u5728\u91cd\u590d\u6570\u636e");
                    }
                    if (a2.getActualWarehouseingQuantity() != (long)strings.size()) {
                        return R.fail((String)"\u65b0\u589e\u5165\u5e93\u5931\u8d25,\u5b9e\u9645\u5165\u5e93\u6570\u4e0e\u552f\u4e00\u7801\u91c7\u96c6\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    List materialCode = this.materialCodeService.list((Wrapper)new QueryWrapper().in((Object)"material_code", strings));
                    if (ObjectUtil.isNotEmpty((Object)materialCode)) {
                        String collect = materialCode.stream().map(MaterialCodeDo::getMaterialCode).collect(Collectors.joining(","));
                        return R.fail((String)("\u65b0\u589e\u5165\u5e93\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a2.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + collect + ",\u5df2\u5b58\u5728"));
                    }
                    if (null == a2.getPurchaseCount() || a2.getPurchaseCount() >= a2.getActualWarehouseingQuantity()) continue;
                    return R.fail((String)"\u5165\u5e93\u91cf\u5927\u4e8e\u91c7\u8d2d\u91cf\uff0c\u5165\u5e93\u5931\u8d25");
                }
            }
            this.inWarehouseManagementService.addInWarehouseManagement(inWarehouseManagementDTO);
            if (inWarehouseManagementDTO.getInWarehouseType().equals("\u8bbe\u5907\u56de\u6536")) {
                try {
                    ArrayList handlelnvoicingDtoList = new ArrayList();
                    List inWarehouseManagementDetailDTOList = inWarehouseManagementDTO.getInWarehouseManagementDetailDTOList();
                    if (inWarehouseManagementDetailDTOList.size() > 0) {
                        inWarehouseManagementDTO.getInWarehouseManagementDetailDTOList().forEach(a -> {
                            HandlelnvoicingDto handlelnvoicingDto = new HandlelnvoicingDto();
                            handlelnvoicingDto.setCount(a.getActualWarehouseingQuantity());
                            handlelnvoicingDto.setMaterialId(a.getMaterialId());
                            handlelnvoicingDto.setType(6);
                            handlelnvoicingDtoList.add(handlelnvoicingDto);
                        });
                        this.handleInvoicingStatistics.updateOutWarehouseDataHandle(handlelnvoicingDtoList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u9879\u76ee\u4e0b\u7684\u91c7\u8d2d\u8ba2\u5355\u5217\u8868")
    @PostMapping(value={"/getLinkProjectPurchaseOrder"})
    public R<List<PurchaseOrderDO>> getLinkProjectPurchaseOrder(@RequestBody ProjectInformationDTO projectInformationDTO) {
        try {
            log.info("\u9879\u76ee\u540d\u79f0:{}", (Object)projectInformationDTO.getProjectName());
            List purchaseOrderUnderListVOList = this.supplyUtils.getLinkProjectPurchaseOrder(projectInformationDTO.getProjectCode());
            return R.ok((Object)purchaseOrderUnderListVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u7533\u8bf7\u5355\u5217\u8868")
    @PostMapping(value={"/getMaterialApplicationOrder"})
    public R<List<MaterialApplicationOrderUnderListVO>> getMaterialApplicationOrder() {
        try {
            List materialApplicationOrderUnderListVOList = this.supplyUtils.getMaterialApplicationOrder();
            return R.ok((Object)materialApplicationOrderUnderListVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5165\u5e93\u660e\u7ec6")
    @PostMapping(value={"/getInWarehouseDetail"})
    public R<List<InWarehouseManagementDetailVO>> getInWarehouseDetail(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getId())) {
                log.info("\u91c7\u8d2d\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
                return null;
            }
            List inWarehouseManagementDetailVOList = this.supplyUtils.getInWarehouseDetail(purchaseOrderDTO.getId());
            return R.ok((Object)inWarehouseManagementDetailVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u5165\u5e93\u7ba1\u7406\uff1a\u5165\u5e93\u660e\u7ec6\u5bfc\u51fa")
    @PostMapping(value={"/exportGetInWarehouseDetail"})
    public void exportGetInWarehouseDetail(@RequestBody InWarehouseManagementDTO inWarehouseManagementDTO, HttpServletResponse response) {
        try {
            InWarehouseManagementVO inWarehouseManagementVO = this.inWarehouseManagementService.selectDetail(inWarehouseManagementDTO.getId());
            List inWarehouseManagementDetailVOList = inWarehouseManagementVO.getInWarehouseManagementDetailVOList();
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5165\u5e93\u7ba1\u7406\uff1a\u5165\u5e93\u660e\u7ec6", "\u5165\u5e93\u660e\u7ec6", ExcelType.XSSF), InWarehouseManagementDetailVO.class, (Collection)inWarehouseManagementDetailVOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5165\u5e93\u660e\u7ec6-" + dateFormat.format(date)));
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u70b9\u51fb\u6253\u5370\u589e\u52a0\u6253\u5370\u6b21\u6570")
    @PostMapping(value={"/clickToPrint"})
    public R<String> clickToPrint(@RequestBody InWarehouseManagementDTO inWarehouseManagementDTO) {
        try {
            this.inWarehouseManagementService.clickToPrint(inWarehouseManagementDTO.getIds());
            return R.ok((Object)"\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.ok((Object)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u7ecf\u529e\u4eba\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"/getTheHandlers"})
    public R<List<String>> getTheHandlers() {
        try {
            List attnNameList = this.inWarehouseManagementService.getTheHandlers();
            return R.ok((Object)attnNameList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    @PostMapping(value={"/selectDetail"})
    public R<InWarehouseManagementVO> selectDetail(@RequestBody InWarehouseManagementDTO inWarehouseManagementDTO) {
        try {
            InWarehouseManagementVO inWarehouseManagementVO = this.inWarehouseManagementService.selectDetail(inWarehouseManagementDTO.getId());
            return R.ok((Object)inWarehouseManagementVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u5165\u5e93\u7ba1\u7406-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.inWarehouseManagementService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public R downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.inWarehouseManagementService.downloadTemplate(request, response, "\u552f\u4e00\u7801\u91c7\u96c6\u5bfc\u5165\u6a21\u677f.xls");
            return R.ok((Object)"\u4e0b\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/uniqueCodeStock"})
    @ApiOperation(value="\u552f\u4e00\u7801\u5bfc\u5165")
    public R<List<String>> uniqueCodeStock(MultipartFile file) {
        try {
            List uniqueCodeList = this.inWarehouseManagementService.importStock(file);
            HashSet uniqueSet = new HashSet(uniqueCodeList);
            if (uniqueSet.size() < uniqueCodeList.size()) {
                return R.fail((String)"\u552f\u4e00\u7801\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            return R.ok((Object)uniqueCodeList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/uniqueCodeCollection"})
    @ApiOperation(value="\u552f\u4e00\u7801\u91c7\u96c6")
    public R<String> uniqueCodeCollection(@RequestParam String uniqueCode) {
        try {
            int length = uniqueCode.length();
            return R.ok((Object)uniqueCode.substring(length - 12));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

