/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.InventoryManagementDTO;
import com.ruoyi.dto.supply.InventoryManagementListDTO;
import com.ruoyi.entity.supply.InventoryManagementDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.query.supply.InventoryManagementQuery;
import com.ruoyi.service.supply.InventoryManagementService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.InventoryManagementDetailVO;
import com.ruoyi.vo.supply.InventoryManagementVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/inventoryManagement"})
@RestController
@Api(tags={"\u76d8\u70b9\u7ba1\u7406"})
public class InventoryManagementController {
    private static final Logger log = LoggerFactory.getLogger(InventoryManagementController.class);
    @Resource
    private InventoryManagementService inventoryManagementService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private MaterialCodeService materialCodeService;
    @Resource
    private SupplyUtils supplyUtils;

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u76d8\u70b9\u7ba1\u7406\u5206\u9875\u67e5\u8be2")
    public R<PageResultVo<InventoryManagementVO>> inventoryManagementPageList(@RequestBody InventoryManagementQuery inventoryManagementQuery) {
        try {
            PageResultVo inventoryManagementVOPageResultVo = this.inventoryManagementService.pageList(inventoryManagementQuery);
            return R.ok((Object)inventoryManagementVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportInventoryManagement"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportInventoryManagement(@RequestBody InventoryManagementQuery inventoryManagementQuery, HttpServletResponse response) {
        try {
            this.inventoryManagementService.exportInventoryManagement(inventoryManagementQuery, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/queryDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<InventoryManagementVO> queryDetail(@RequestBody InventoryManagementDTO inventoryManagementDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)inventoryManagementDTO.getId())) {
                R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            InventoryManagementVO inventoryManagementVO = this.inventoryManagementService.queryDetail(inventoryManagementDTO.getId());
            return R.ok((Object)inventoryManagementVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/continueInput"})
    @ApiOperation(value="\u7ee7\u7eed\u5f55\u5165")
    public R<String> continueInput(@RequestBody InventoryManagementDTO inventoryManagementDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)inventoryManagementDTO.getId())) {
                return R.fail((String)"\u5f55\u5165\u5931\u8d25\uff0cID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (((InventoryManagementDO)this.inventoryManagementService.getById((Serializable)inventoryManagementDTO.getId())).getInventoryStatus().equals("\u4fdd\u5b58")) {
                this.inventoryManagementService.continueInput(inventoryManagementDTO);
                return R.ok((Object)"\u5f55\u5165\u6210\u529f");
            }
            return R.fail((String)"\u5df2\u5b8c\u6210\u72b6\u6001\u4e0d\u652f\u6301\u5f55\u5165");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u76d8\u70b9")
    public R<String> add(@RequestBody InventoryManagementDTO inventoryManagementDTO) {
        try {
            List inventoryManagementListDTOS = inventoryManagementDTO.getInventoryManagementListDTOS();
            if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTOS)) {
                inventoryManagementListDTOS = inventoryManagementListDTOS.stream().filter(f -> "\u542f\u7528".equals(f.getOneThingOneCode())).collect(Collectors.toList());
                for (InventoryManagementListDTO a : inventoryManagementListDTOS) {
                    if (!ObjectUtil.isNotEmpty((Object)a.getInventoryCount()) || a.getInventoryCount() == 0L) continue;
                    if (StringUtils.isNotEmpty((CharSequence)a.getUniqueCode())) {
                        List<String> strings = Arrays.asList(a.getUniqueCode().split(","));
                        HashSet<String> set = new HashSet<String>(strings);
                        if (strings.size() != set.size()) {
                            return R.fail((String)"\u65b0\u589e\u76d8\u70b9\u5931\u8d25,\u552f\u4e00\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
                        }
                        if (a.getInventoryCount() == (long)strings.size()) continue;
                        return R.fail((String)"\u65b0\u589e\u76d8\u70b9\u5931\u8d25,\u76d8\u70b9\u6570\u91cf\u4e0e\u552f\u4e00\u7801\u91c7\u96c6\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    return R.fail((String)"\u65b0\u589e\u76d8\u70b9\u5931\u8d25,\u76d8\u70b9\u6570\u91cf\u4e0e\u552f\u4e00\u7801\u91c7\u96c6\u6570\u91cf\u4e0d\u4e00\u81f4");
                }
            }
            this.inventoryManagementService.add(inventoryManagementDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/preservation"})
    @ApiOperation(value="\u4fdd\u5b58\u4fee\u6539\u76d8\u70b9")
    public R<String> preservation(@RequestBody InventoryManagementDTO inventoryManagementDTO) {
        try {
            this.inventoryManagementService.updatePreservation(inventoryManagementDTO);
            return R.ok((Object)"\u4fdd\u5b58\u4fee\u6539\u76d8\u70b9\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/autoGenerateNumber"})
    @ApiOperation(value="\u81ea\u52a8\u751f\u6210\u4e3b\u9898\u540d\u79f0")
    public R<String> autoGenerateNumber() {
        try {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return R.ok((Object)(simpleDateFormat.format(date) + "\u7269\u8d44\u76d8\u70b9"));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getInventoryList"})
    @ApiOperation(value="\u83b7\u53d6\u76d8\u70b9\u5217\u8868")
    public R<InventoryManagementDetailVO> getInventoryList(@RequestBody InventoryManagementDTO inventoryManagementDTO) {
        try {
            InventoryManagementDetailVO inventoryManagementListDTOS = this.supplyUtils.getInventoryList(inventoryManagementDTO.getInventoryContent());
            return R.ok((Object)inventoryManagementListDTOS);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

