/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.query.supply.InventoryStatisticsQuery;
import com.ruoyi.service.supply.InventoryManagementListService;
import com.ruoyi.vo.supply.InventoryStatisticsVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/inventoryStatistics"})
@RestController
@Api(tags={"\u76d8\u70b9\u7ba1\u7406\u7edf\u8ba1"})
public class InventoryStatisticsController {
    private static final Logger log = LoggerFactory.getLogger(InventoryStatisticsController.class);
    @Resource
    private InventoryManagementListService inventoryManagementListService;

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2")
    public R<List<InventoryStatisticsVO>> query(@RequestBody InventoryStatisticsQuery inventoryStatisticsQuery) {
        try {
            if (ObjectUtil.isEmpty((Object)inventoryStatisticsQuery.getSummaryType())) {
                inventoryStatisticsQuery.setSummaryType("materialAndDate");
            }
            if (ObjectUtil.isEmpty((Object)inventoryStatisticsQuery.getStartTime()) || ObjectUtil.isEmpty((Object)inventoryStatisticsQuery.getEndTime())) {
                ArrayList inventoryStatisticsVOList = new ArrayList();
                return R.ok(inventoryStatisticsVOList);
            }
            List inventoryStatisticsVO = this.inventoryManagementListService.query(inventoryStatisticsQuery);
            return R.ok((Object)inventoryStatisticsVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/selectMaterial"})
    @ApiOperation(value="\u7269\u8d44\u9009\u62e9")
    public R<List<String>> selectMaterial() {
        try {
            List inventoryManagementListDOS = this.inventoryManagementListService.list();
            if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDOS)) {
                List materialName = inventoryManagementListDOS.stream().map(m -> m.getItemName()).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
                return R.ok(materialName);
            }
            return null;
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportExcel"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportExcel(@RequestBody InventoryStatisticsQuery inventoryStatisticsQuery, HttpServletResponse response) {
        try {
            this.inventoryManagementListService.exportExcel(inventoryStatisticsQuery, response);
        }
        catch (Exception e) {
            e.getMessage();
            log.info("\u5bfc\u51fa\u5931\u8d25\uff1a{}", (Object)e.getLocalizedMessage());
        }
    }
}

