/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.ItemCategoryDTO;
import com.ruoyi.service.supply.ItemCategoryService;
import com.ruoyi.vo.supply.ItemCategoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/itemCategory"})
@RestController
@Api(tags={"\u7269\u8d44\u5206\u7c7b"})
public class ItemCategoryController {
    private static final Logger log = LoggerFactory.getLogger(ItemCategoryController.class);
    @Resource
    private ItemCategoryService itemCategoryService;

    @GetMapping(value={"/searchMenu"})
    @ApiOperation(value="\u641c\u7d22\u5206\u7c7b")
    public R<List<ItemCategoryVO>> searchMenu() {
        try {
            return R.ok((Object)this.itemCategoryService.getSearchMenu());
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PutMapping(value={"/updateMenuName"})
    @ApiOperation(value="\u4fee\u6539\u5206\u7c7b\u540d\u79f0")
    public R updateMenuName(@RequestBody ItemCategoryDTO itemCategoryDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)itemCategoryDTO.getId()) || ObjectUtil.isEmpty((Object)itemCategoryDTO.getMenuName())) {
                return R.fail((String)"id\u6216\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemCategoryDTO.getMenuName().contains(">>")) {
                return R.fail((String)"\u5206\u7c7b\u540d\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a>>");
            }
            if (this.itemCategoryService.updateMenuName(itemCategoryDTO.getId(), itemCategoryDTO.getMenuName()).booleanValue()) {
                return R.ok((Object)"\u4fee\u6539\u6210\u529f");
            }
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
        return R.fail((String)"\u4fee\u6539\u5931\u8d25");
    }

    @PostMapping(value={"/addMenu"})
    @ApiOperation(value="\u65b0\u589e\u5206\u7c7b")
    public R addMenu(@RequestBody ItemCategoryDTO itemCategoryDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)itemCategoryDTO.getMenuName())) {
                return R.fail((String)"\u5206\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (itemCategoryDTO.getMenuName().contains(">>")) {
                return R.fail((String)"\u5206\u7c7b\u540d\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a>>");
            }
            this.itemCategoryService.addMenu(itemCategoryDTO.getMenuName(), itemCategoryDTO.getParentId());
            return R.ok((Object)"\u65b0\u589e\u5206\u7c7b\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/deleteMenu"})
    @ApiOperation(value="\u5220\u9664\u5206\u7c7b")
    public R deleteMenu(@RequestBody ItemCategoryDTO itemCategoryDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)itemCategoryDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String s = this.itemCategoryService.deleteMenu(itemCategoryDTO.getId());
            if (s.equals("true")) {
                return R.ok((Object)"\u5220\u9664\u6210\u529f");
            }
            return R.fail((String)s);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

