/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.hutool.core.util.ObjectUtil;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.MaterialArchivesDTO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.query.supply.MaterialArchivesQuery;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.SupplierArchiveService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.supply.MaterialArchivesVO;
import com.ruoyi.vo.supply.SupplierArchiveVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/materialArchives"})
@RestController
@Api(tags={"\u7269\u8d44\u6863\u6848"})
public class MaterialArchivesController {
    private static final Logger log = LoggerFactory.getLogger(MaterialArchivesController.class);
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private SupplierArchiveService supplierArchiveService;

    @PostMapping(value={"/getMaterialArchivesList"})
    @ApiOperation(value="\u7269\u8d44\u6863\u6848\u5217\u8868\u663e\u793a")
    public R<PageResultVo<MaterialArchivesVO>> getMaterialArchivesList(@RequestBody MaterialArchivesQuery materialArchivesQuery) {
        try {
            PageResultVo materialArchivesListPage = this.materialArchivesService.getMaterialArchivesListPage(materialArchivesQuery);
            return R.ok((Object)materialArchivesListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialArchiveDetail"})
    @ApiOperation(value="\u7269\u8d44\u6863\u6848\u8be6\u60c5")
    public R<MaterialArchivesVO> getMaterialArchiveDetail(@RequestBody MaterialArchivesDTO materialArchivesDTO) {
        try {
            MaterialArchivesVO materialArchivesVO = this.materialArchivesService.getMaterialArchiveDetail(materialArchivesDTO.getId());
            return R.ok((Object)materialArchivesVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/batchMoveMaterials"})
    @ApiOperation(value="\u6279\u91cf\u79fb\u52a8\u7269\u8d44")
    public R<String> batchMoveMaterials(@RequestBody MaterialArchivesDTO materialArchivesDTO) {
        try {
            if (this.materialArchivesService.moveMaterials(materialArchivesDTO).booleanValue()) {
                return R.ok((Object)"\u79fb\u52a8\u6210\u529f");
            }
            return R.fail((String)"\u79fb\u52a8\u5931\u8d25");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/addMaterialArchives"})
    @ApiOperation(value="\u65b0\u589e\u7269\u8d44\u6863\u6848")
    public R<String> addMaterialArchives(@RequestBody MaterialArchivesDTO materialArchivesDTO) {
        try {
            if (materialArchivesDTO.getMaterialName().contains(">>")) {
                return R.fail((String)"\u7269\u8d44\u540d\u79f0\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a>>");
            }
            this.materialArchivesService.addMaterialArchives(materialArchivesDTO);
            return R.ok((Object)"\u65b0\u589e\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PutMapping(value={"/updateMaterialArchives"})
    @ApiOperation(value="\u66f4\u65b0\u7269\u8d44\u6863\u6848")
    public R<String> updateMaterialArchives(@RequestBody MaterialArchivesDTO materialArchivesDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialArchivesDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (materialArchivesDTO.getMaterialName().contains(">>")) {
                return R.fail((String)"\u7269\u8d44\u540d\u79f0\u5305\u542b\u7279\u6b8a\u5b57\u7b26\uff1a>>");
            }
            this.materialArchivesService.updateMaterialArchives(materialArchivesDTO);
            return R.ok((Object)"\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportMaterialArchives"})
    @ApiOperation(value="\u5bfc\u51fa\u7269\u8d44\u6863\u6848")
    public void exportMaterialArchives(HttpServletResponse response) {
        try {
            this.materialArchivesService.exportMaterialArchives(response);
        }
        catch (Exception e) {
            e.getMessage();
            log.info("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/importMaterialArchives"})
    @ApiOperation(value="\u5bfc\u5165\u7269\u8d44\u6863\u6848")
    public R importMaterialArchives(MultipartFile file) {
        try {
            String s = this.materialArchivesService.importMaterialArchives(file);
            if (s.equals("true")) {
                return R.ok((Object)"\u5bfc\u5165\u6210\u529f");
            }
            return R.fail((String)s);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getUnitMeasure"})
    @ApiOperation(value="\u83b7\u53d6\u8ba1\u91cf\u5355\u4f4d")
    public R getUnitMeasure() {
        try {
            List unitMeasureList = this.materialArchivesService.getUnitMeasure();
            return R.ok((Object)unitMeasureList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getSupplier"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u4f9b\u5e94\u5546")
    public R<List<SupplierArchiveVO>> getSupplier() {
        try {
            List supplierNameList = this.supplierArchiveService.getSupplier();
            return R.ok((Object)supplierNameList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public R downloadTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.materialArchivesService.downloadTemplate(request, response, "\u7269\u8d44\u6863\u6848\u5bfc\u5165\u6a21\u677f.xls");
            return R.ok((Object)"\u4e0b\u8f7d\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getId"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public String getId(String id) {
        MaterialArchivesDO byId = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)((Object)id));
        return byId.getOneYardPerObject();
    }

    @GetMapping(value={"/chulishuju"})
    @ApiOperation(value="\u4e0b\u8f7d\u6a21\u677f")
    public void chulishuju() {
        this.materialArchivesService.chulishuju();
    }
}

