/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.InWarehouseManagementDTO;
import com.ruoyi.dto.supply.MaterialsApplicationDemandDetailDTO;
import com.ruoyi.dto.supply.MaterialsApplicationMaterialOrderDTO;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.entity.supply.InWarehouseManagementDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationDemandDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationMaterialOrderDO;
import com.ruoyi.entity.supply.PurchaseOrderDemandDetailDO;
import com.ruoyi.query.supply.MaterialApplicationQuery;
import com.ruoyi.service.supply.InWarehouseManagementService;
import com.ruoyi.service.supply.MaterialsApplicationDemandDetailService;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.ItemCategoryVO;
import com.ruoyi.vo.supply.LogisticsTrackingVO;
import com.ruoyi.vo.supply.MaterialArchivesVO;
import com.ruoyi.vo.supply.MaterialNameListVO;
import com.ruoyi.vo.supply.MaterialsApplicationDetailVO;
import com.ruoyi.vo.supply.OutWarehouseManagementDemandDetailVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/materialsApplicationMaterialOrder"})
@RestController
@Api(tags={"\u7269\u8d44\u7533\u8bf7"})
public class MaterialsApplicationMaterialOrderController {
    private static final Logger log = LoggerFactory.getLogger(MaterialsApplicationMaterialOrderController.class);
    @Resource
    private MaterialsApplicationMaterialOrderService materialsApplicationMaterialOrderService;
    @Resource
    private MaterialsApplicationDemandDetailService materialsApplicationDemandDetailService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private InWarehouseManagementService inWarehouseManagementService;

    @PostMapping(value={"/materialsApplication"})
    @ApiOperation(value="\u5b9e\u7269\u7269\u8d44\u7533\u8bf7")
    public R materialsApplication(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO)) {
                return R.fail((String)"\u7533\u8bf7\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO.getDemandDetailDTOList())) {
                return R.fail((String)"\u9700\u6c42\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return this.materialsApplicationMaterialOrderService.addMaterialsApplication(materialsApplicationMaterialOrderDTO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getApplicationDepartment"})
    @ApiOperation(value="\u83b7\u53d6\u7533\u8bf7\u90e8\u95e8\u4fe1\u606f")
    public R<List<String>> getApplicationDepartment() {
        try {
            List applicationDepartmentList = this.materialsApplicationMaterialOrderService.getApplicationDepartment();
            if (ObjectUtil.isNotEmpty((Object)applicationDepartmentList) && applicationDepartmentList.size() > 0) {
                List collect = applicationDepartmentList.stream().distinct().collect(Collectors.toList());
                return R.ok(collect);
            }
            return R.ok(null);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialsApplicationDetail"})
    @ApiOperation(value="\u5b9e\u7269\u7269\u8d44\u7533\u8bf7\u8be6\u60c5")
    public R<MaterialsApplicationDetailVO> getMaterialsApplicationDetail(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO.getId())) {
                return R.fail((String)"\u7269\u8d44id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MaterialsApplicationDetailVO materialsApplicationDetailVO = this.materialsApplicationMaterialOrderService.getMaterialsApplicationDetail(materialsApplicationMaterialOrderDTO.getId());
            return R.ok((Object)materialsApplicationDetailVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialsApplicationDetailNew"})
    @ApiOperation(value="\u5b9e\u7269\u7269\u8d44\u7533\u8bf7\u8be6\u60c52")
    public R<MaterialsApplicationDetailVO> getMaterialsApplicationDetailNew(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO.getId())) {
                return R.fail((String)"\u7269\u8d44id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            MaterialsApplicationDetailVO materialsApplicationDetailVO = this.materialsApplicationMaterialOrderService.getMaterialsApplicationDetailNew(materialsApplicationMaterialOrderDTO.getId());
            return R.ok((Object)materialsApplicationDetailVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/selcetExportMaterialsApplicationList"})
    @ApiOperation(value="\u7269\u8d44\u7533\u8bf7\u660e\u7ec6\u5bfc\u51fa")
    public void selcetExportMaterialsApplicationList(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO, HttpServletResponse response) {
        try {
            MaterialsApplicationDetailVO materialsApplicationDetailVO = this.materialsApplicationMaterialOrderService.getMaterialsApplicationDetailNew(materialsApplicationMaterialOrderDTO.getId());
            List materialsApplicationDemandDetailDOList = materialsApplicationDetailVO.getMaterialsApplicationDemandDetailDOList();
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), MaterialsApplicationDemandDetailDO.class, (Collection)materialsApplicationDemandDetailDOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5b9e\u7269\u7269\u8d44\u7533\u8bf7-" + dateFormat.format(date)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/selcetExportMaterialsApplicationListByAdd"})
    @ApiOperation(value="\u65b0\u589e-\u7269\u8d44\u7533\u8bf7\u660e\u7ec6\u5bfc\u51fa")
    public void selcetExportMaterialsApplicationListByAdd(@RequestBody List<MaterialsApplicationDemandDetailDO> materialsApplicationMaterialOrderDTO, HttpServletResponse response) {
        try {
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), MaterialsApplicationDemandDetailDO.class, materialsApplicationMaterialOrderDTO);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5b9e\u7269\u7269\u8d44\u7533\u8bf7-" + dateFormat.format(date)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/importMaterialsApplication"})
    @ApiOperation(value="\u65b0\u589e-\u5bfc\u5165\u7269\u8d44\u7533\u8bf7\u660e\u7ec6")
    public R importMaterialsApplication(MultipartFile file) {
        try {
            return this.materialsApplicationDemandDetailService.importMaterialsApplication(file, this.supplyUtils);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate"})
    @ApiOperation(value="\u65b0\u589e-\u7269\u8d44\u7533\u8bf7\u6a21\u7248\u4e0b\u8f7d")
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u7269\u8d44\u7533\u8bf7-\u9700\u6c42\u660e\u7ec6\u6a21\u7248.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource("\u7269\u8d44\u7533\u8bf7-\u9700\u6c42\u660e\u7ec6\u6a21\u7248.xls");
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/getMaterialsApplicationListPage"})
    @ApiOperation(value="\u5b9e\u7269\u7269\u8d44\u5217\u8868\u5206\u9875\u67e5\u8be2")
    public R<PageResultVo<MaterialsApplicationDetailVO>> getMaterialsApplicationListPage(@RequestBody MaterialApplicationQuery materialApplicationQuery) {
        try {
            PageResultVo materialsApplicationDetailVO = this.materialsApplicationMaterialOrderService.getMaterialsApplicationListPage(materialApplicationQuery);
            return R.ok((Object)materialsApplicationDetailVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/materialsApplicationMaterialOrderDOs"})
    @ApiOperation(value="\u83b7\u53d6\u6700\u65b0\u7684\u6536\u4ef6\u4eba\u4fe1\u606f")
    public R<MaterialsApplicationMaterialOrderDO> materialsApplicationMaterialOrderDOs(@RequestBody MaterialApplicationQuery materialApplicationQuery) {
        try {
            MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = this.materialsApplicationMaterialOrderService.materialsApplicationMaterialOrderDO(materialApplicationQuery);
            return R.ok((Object)materialsApplicationMaterialOrderDO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportMaterialsApplicationList"})
    @ApiOperation(value="\u5b9e\u7269\u7269\u8d44\u5217\u8868\u5bfc\u51fa")
    public void exportMaterialsApplicationList(@RequestBody MaterialApplicationQuery materialApplicationQuery, HttpServletResponse response) {
        try {
            this.materialsApplicationMaterialOrderService.exportMaterialsApplicationList(materialApplicationQuery, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/getSubjectName"})
    @ApiOperation(value="\u81ea\u52a8\u83b7\u53d6\u4e3b\u9898\u540d\u79f0")
    public R getSubjectName(@RequestParam String projectName) {
        try {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return R.ok((Object)(simpleDateFormat.format(date) + "-" + projectName));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialsApplicationDemandCount"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u7533\u8bf7\u5355\u9700\u6c42\u6570\u91cf")
    public R getMaterialsApplicationDemandCount(@RequestParam Long id) {
        try {
            Long count = this.materialsApplicationDemandDetailService.getMaterialsApplicationDemandCount(id);
            return R.ok((Object)count);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialNameList"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u540d\u79f0\u4e0b\u62c9\u5217\u8868")
    public R<List<MaterialNameListVO>> getMaterialNameList() {
        try {
            List materialNameListVOList = this.supplyUtils.getThreeLevelMaterialNameList();
            return R.ok((Object)materialNameListVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialList"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u4e0b\u62c9\u5217\u8868")
    public R<List<ItemCategoryVO>> getMaterialList() {
        try {
            List materialNameListVOList = this.supplyUtils.getThreeLevelMaterialList();
            return R.ok((Object)materialNameListVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/cancelApplication"})
    @ApiOperation(value="\u53d6\u6d88\u7533\u8bf7")
    public R cancelApplication(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.materialsApplicationMaterialOrderService.cancelApplication(materialsApplicationMaterialOrderDTO.getId());
            return R.ok((Object)"\u53d6\u6d88\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getLinkProject"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u9879\u76ee")
    public R<List<String>> getLinkProject() {
        try {
            List linkProjectList = this.materialsApplicationMaterialOrderService.getLinkProject();
            return R.ok((Object)linkProjectList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executiveApproval"})
    @ApiOperation(value="\u5ba1\u6279")
    public R<String> executiveApproval(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)materialsApplicationMaterialOrderDTO.getId())) {
                return R.fail((String)"id\u4e3a\u7a7a!");
            }
            this.materialsApplicationMaterialOrderService.executiveApproval(materialsApplicationMaterialOrderDTO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getOutWarehouseDetail"})
    @ApiOperation(value="\u83b7\u53d6\u51fa\u5e93\u660e\u7ec6")
    public R<List<OutWarehouseManagementDemandDetailVO>> getOutWarehouseDetail(@RequestParam String outWarehouseNumber) {
        try {
            if (ObjectUtil.isEmpty((Object)outWarehouseNumber)) {
                return R.fail((String)"\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            List outWarehouseManagementDemandDetailVOList = this.supplyUtils.getOutWarehouseDetail(outWarehouseNumber);
            return R.ok((Object)outWarehouseManagementDemandDetailVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getMaterialSpecificationAndUnit"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u89c4\u683c\u3001\u5355\u4f4d\u3001\u5f53\u524d\u6570\u91cf\u3001\u5355\u4ef7,\u51fa\u5e93\u91cf\u3001\u662f\u5426\u4e00\u7269\u4e00\u7801")
    public R<MaterialArchivesVO> getMaterialSpecificationAndUnit(@RequestBody MaterialsApplicationDemandDetailDTO materialsApplicationDemandDetailDTO) {
        try {
            MaterialArchivesVO materialArchivesVO = this.supplyUtils.getMaterialSpecificationAndUnitAndCount(materialsApplicationDemandDetailDTO);
            return R.ok((Object)materialArchivesVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/edtiorMaterialsApplication"})
    @ApiOperation(value="\u7f16\u8f91\u5b9e\u7269\u7269\u8d44\u7533\u8bf7")
    public R<String> edtiorMaterialsApplication(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            this.materialsApplicationMaterialOrderService.edtiorMaterialsApplication(materialsApplicationMaterialOrderDTO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getPurchaseDetail"})
    @ApiOperation(value="\u83b7\u53d6\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6")
    public R<List<PurchaseOrderDemandDetailDO>> getPurchaseDetail(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            List purchaseOrderDemandDetailDOList = this.supplyUtils.getPurchaseDetail(purchaseOrderDTO);
            return R.ok((Object)purchaseOrderDemandDetailDOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getInWarehouseDetail"})
    @ApiOperation(value="\u83b7\u53d6\u5165\u5e93\u660e\u7ec6")
    public R<List<InWarehouseManagementDetailDO>> getInWarehouseDetail(@RequestBody InWarehouseManagementDTO inWarehouseManagementDTO) {
        try {
            List inWarehouseManagementDetailDOList = this.inWarehouseManagementService.getInWarehouseDetail(inWarehouseManagementDTO);
            return R.ok((Object)inWarehouseManagementDetailDOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getLogisticsInformation"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u6d41\u4fe1\u606f")
    public R<List<LogisticsTrackingVO>> getLogisticsInformation(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            List logisticsTrackingVOList = this.supplyUtils.getLogisticsInformation(materialsApplicationMaterialOrderDTO.getPurchaseOrOutWarehouseNumber());
            return R.ok((Object)logisticsTrackingVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u7269\u8d44\u7533\u8bf7-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.materialsApplicationMaterialOrderService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/test"})
    @ApiOperation(value="\u83b7\u53d6\u7269\u8d44\u89c4\u683c\u3001\u5355\u4f4d\u3001\u5f53\u524d\u6570\u91cf\u3001\u5355\u4ef7,\u51fa\u5e93\u91cf\u3001\u662f\u5426\u4e00\u7269\u4e00\u7801")
    public R<MaterialArchivesVO> test() {
        try {
            this.supplyUtils.test();
            return R.ok();
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

