/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.MaterialsApplicationMaterialOrderDTO;
import com.ruoyi.dto.supply.OutWarehouseManagementDTO;
import com.ruoyi.dto.supply.OutWarehouseManagementDemandDetailDTO;
import com.ruoyi.entity.supply.MaterialCodeDo;
import com.ruoyi.entity.supply.MaterialsApplicationDemandDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationMaterialOrderDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDO;
import com.ruoyi.entity.supply.PurchaseOrderLogisticsInformationDO;
import com.ruoyi.query.supply.OutWarehouseManagementQuery;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.MaterialsApplicationDemandDetailService;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.service.supply.OutWarehouseManagementService;
import com.ruoyi.service.supply.PurchaseOrderLogisticsInformationService;
import com.ruoyi.service.supply.PurchaseOrderService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.OutWarehouseManagementDemandDetailVO;
import com.ruoyi.vo.supply.OutWarehouseManagementLogisticsInformationVO;
import com.ruoyi.vo.supply.OutWarehouseManagementVO;
import com.ruoyi.vo.supply.RelatedMaterialApplicationFormVO;
import com.ruoyi.vo.supply.RelatedPurchaseFormVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/outWarehouseManagement"})
@RestController
@Api(tags={"\u51fa\u5e93\u7ba1\u7406"})
public class OutWarehouseManagementController {
    private static final Logger log = LoggerFactory.getLogger(OutWarehouseManagementController.class);
    @Resource
    private OutWarehouseManagementService outWarehouseManagementService;
    @Resource
    private PurchaseOrderLogisticsInformationService purchaseOrderLogisticsInformationService;
    @Resource
    private MaterialsApplicationMaterialOrderService materialsApplicationMaterialOrderService;
    @Resource
    private MaterialsApplicationDemandDetailService materialsApplicationDemandDetailService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private MaterialCodeService materialCodeService;
    @Resource
    private StockListService stockListService;

    @PostMapping(value={"/outOfStock"})
    @ApiOperation(value="\u65b0\u589e\u51fa\u5e93\uff1a\u65e0\u8d27")
    public R<String> outOfStock(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            outWarehouseManagementDTO = this.outWarehouseManagementService.outOfStock(outWarehouseManagementDTO);
            if (ObjectUtil.isNotEmpty((Object)outWarehouseManagementDTO.getRelatedMaterialApplicationFormId())) {
                this.materialsApplicationMaterialOrderService.updateCurrentProgress(outWarehouseManagementDTO.getRelatedMaterialApplicationFormId(), "\u65e0\u8d27\uff08\u91c7\u8d2d\u4e2d\uff09");
            }
            this.supplyUtils.autoGeneratePurchaseOrder(outWarehouseManagementDTO);
            return R.ok((Object)"\u81ea\u52a8\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\u6210\u529f\uff01");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/deliveryFromStorage"})
    @ApiOperation(value="\u65b0\u589e\u51fa\u5e93\uff1a\u51fa\u5e93")
    public R<String> deliveryFromStorage(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            List outWarehouseManagementDemandDetailDTOList = outWarehouseManagementDTO.getOutWarehouseManagementDemandDetailDTOList();
            if (ObjectUtil.isNotEmpty((Object)outWarehouseManagementDemandDetailDTOList)) {
                outWarehouseManagementDemandDetailDTOList = outWarehouseManagementDemandDetailDTOList.stream().filter(f -> "\u542f\u7528".equals(f.getOneYardPerObject())).collect(Collectors.toList());
                for (OutWarehouseManagementDemandDetailDTO a : outWarehouseManagementDemandDetailDTOList) {
                    if (!ObjectUtil.isNotEmpty((Object)a.getInventoryCount()) || a.getInventoryCount() == 0L) continue;
                    if (StringUtils.isEmpty((CharSequence)a.getUniqueCodeCollection())) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    List<String> strings = Arrays.asList(a.getUniqueCodeCollection().split(","));
                    if (ObjectUtil.isEmpty(strings)) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    HashSet<String> set = new HashSet<String>(strings);
                    if (strings.size() != set.size()) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
                    }
                    if (a.getDeliveryFromStorageCount() != (long)strings.size()) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u51fa\u5e93\u6570\u91cf\u4e0e\u552f\u4e00\u7801\u91c7\u96c6\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    List materialCode = this.materialCodeService.list((Wrapper)new QueryWrapper().in((Object)"material_code", strings));
                    List materialCodes = materialCode.stream().map(MaterialCodeDo::getMaterialCode).collect(Collectors.toList());
                    List collect1 = strings.stream().filter(f -> !materialCodes.contains(f)).collect(Collectors.toList());
                    if (!ObjectUtil.isNotEmpty(collect1)) continue;
                    String collect = collect1.stream().collect(Collectors.joining(","));
                    return R.fail((String)("\u65b0\u589e\u51fa\u5e93\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + collect + ",\u4e0d\u5b58\u5728"));
                }
            }
            this.outWarehouseManagementService.deliveryFromStorage(outWarehouseManagementDTO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getRelationProject"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u9879\u76ee")
    public R<List<OutWarehouseManagementVO>> getRelationProject() {
        try {
            List projectNameList = this.outWarehouseManagementService.getRelationProject();
            return R.ok((Object)projectNameList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/partialDeliveryWarehouse"})
    @ApiOperation(value="\u65b0\u589e\u51fa\u5e93\uff1a\u90e8\u5206\u51fa\u5e93")
    public R<String> partialDeliveryWarehouse(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            List outWarehouseManagementDemandDetailDTOList = outWarehouseManagementDTO.getOutWarehouseManagementDemandDetailDTOList();
            if (ObjectUtil.isNotEmpty((Object)outWarehouseManagementDemandDetailDTOList)) {
                outWarehouseManagementDemandDetailDTOList = outWarehouseManagementDemandDetailDTOList.stream().filter(f -> "\u542f\u7528".equals(f.getOneYardPerObject())).collect(Collectors.toList());
                for (OutWarehouseManagementDemandDetailDTO a : outWarehouseManagementDemandDetailDTOList) {
                    if (!ObjectUtil.isNotEmpty((Object)a.getInventoryCount()) || a.getInventoryCount() == 0L) continue;
                    if (StringUtils.isEmpty((CharSequence)a.getUniqueCodeCollection())) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    List<String> strings = Arrays.asList(a.getUniqueCodeCollection().split(","));
                    if (ObjectUtil.isEmpty(strings)) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u91c7\u96c6\u6570\u636e\u4e3a\u7a7a");
                    }
                    HashSet<String> set = new HashSet<String>(strings);
                    if (strings.size() != set.size()) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u552f\u4e00\u7801\u5b58\u5728\u91cd\u590d\u6570\u636e");
                    }
                    if (a.getDeliveryFromStorageCount() != (long)strings.size()) {
                        return R.fail((String)"\u65b0\u589e\u51fa\u5e93\u5931\u8d25,\u51fa\u5e93\u6570\u91cf\u4e0e\u552f\u4e00\u7801\u91c7\u96c6\u6570\u91cf\u4e0d\u4e00\u81f4");
                    }
                    List materialCode = this.materialCodeService.list((Wrapper)new QueryWrapper().in((Object)"material_code", strings));
                    List materialCodes = materialCode.stream().map(MaterialCodeDo::getMaterialCode).collect(Collectors.toList());
                    List collect1 = strings.stream().filter(f -> !materialCodes.contains(f)).collect(Collectors.toList());
                    if (!ObjectUtil.isNotEmpty(collect1)) continue;
                    String collect = collect1.stream().collect(Collectors.joining(","));
                    return R.fail((String)("\u65b0\u589e\u51fa\u5e93\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + a.getMaterialName() + ",\u552f\u4e00\u91c7\u96c6\u7801\uff1a" + collect + ",\u4e0d\u5b58\u5728"));
                }
            }
            this.outWarehouseManagementService.deliveryFromStorage(outWarehouseManagementDTO);
            if (ObjectUtil.isNotEmpty((Object)outWarehouseManagementDTO.getRelatedMaterialApplicationFormId())) {
                this.materialsApplicationMaterialOrderService.updateCurrentProgress(outWarehouseManagementDTO.getRelatedMaterialApplicationFormId(), "\u90e8\u5206\u51fa\u5e93\uff08\u91c7\u8d2d\u4e2d\uff09");
            }
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getRelatedMaterialApplicationFormList"})
    @ApiOperation(value="\u5173\u8054\u7269\u8d44\u7533\u8bf7\u5355\u4e0b\u62c9\u5217\u8868\u4ee5\u53ca\u76f8\u5173\u7533\u8bf7\u5355\u4fe1\u606f")
    public R<List<RelatedMaterialApplicationFormVO>> getRelatedMaterialApplicationFormList(@RequestBody MaterialsApplicationMaterialOrderDO materialOrderDO) {
        try {
            List relatedMaterialApplicationFormVOList = this.materialsApplicationMaterialOrderService.getRelatedMaterialApplicationFormList(materialOrderDO);
            return R.ok((Object)relatedMaterialApplicationFormVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportRelatedMaterialApplicationFormList"})
    @ApiOperation(value="\u5bfc\u51fa\u51fa\u5e93\u9700\u6c42\u660e\u7ec6")
    public void exportRelatedMaterialApplicationFormList(@RequestBody OutWarehouseManagementQuery outWarehouseManagementQuery, HttpServletResponse response) {
        try {
            OutWarehouseManagementVO outWarehouseManagementVO = this.outWarehouseManagementService.queryDetail(outWarehouseManagementQuery.getId());
            List outWarehouseManagementDemandDetailVOList = outWarehouseManagementVO.getOutWarehouseManagementDemandDetailVOList();
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u51fa\u5e93\u9700\u6c42\u660e\u7ec6", "\u51fa\u5e93\u9700\u6c42\u660e\u7ec6", ExcelType.XSSF), OutWarehouseManagementDemandDetailVO.class, (Collection)outWarehouseManagementDemandDetailVOList);
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u51fa\u5e93\u9700\u6c42\u660e\u7ec6-" + dateFormat.format(date)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/getRelatedPurchaseFormList"})
    @ApiOperation(value="\u5173\u8054\u91c7\u8d2d\u5355\u4e0b\u62c9\u5217\u8868")
    public R<List<RelatedPurchaseFormVO>> getRelatedPurchaseFormList() {
        try {
            List relatedPurchaseFormList = this.purchaseOrderService.getRelatedPurchaseFormList();
            return R.ok((Object)relatedPurchaseFormList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getOrderLogisticsInformation"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u91c7\u8d2d\u8ba2\u5355\u7269\u6d41\u4fe1\u606f")
    public R<List<OutWarehouseManagementLogisticsInformationVO>> getOrderLogisticsInformation(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)outWarehouseManagementDTO.getAssociatedPurchaseOrdersId()), PurchaseOrderLogisticsInformationDO::getMainId, (Object)outWarehouseManagementDTO.getAssociatedPurchaseOrdersId());
        List logisticsInformationDOList = this.purchaseOrderLogisticsInformationService.list((Wrapper)wrapper);
        List purchaseOrderLogisticsInformationVOS = logisticsInformationDOList.stream().map(m -> {
            OutWarehouseManagementLogisticsInformationVO outWarehouseManagementLogisticsInformationVO = new OutWarehouseManagementLogisticsInformationVO();
            BeanUtils.copyProperties((Object)m, (Object)outWarehouseManagementLogisticsInformationVO);
            return outWarehouseManagementLogisticsInformationVO;
        }).collect(Collectors.toList());
        return R.ok(purchaseOrderLogisticsInformationVOS);
    }

    @PostMapping(value={"/pageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u51fa\u5e93\u5217\u8868")
    public R<PageResultVo<OutWarehouseManagementVO>> pageList(@RequestBody OutWarehouseManagementQuery outWarehouseManagementQuery) {
        try {
            PageResultVo outWarehouseManagementVOPageResultVo = this.outWarehouseManagementService.pageList(outWarehouseManagementQuery);
            return R.ok((Object)outWarehouseManagementVOPageResultVo);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/queryDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<OutWarehouseManagementVO> queryDetail(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)outWarehouseManagementDTO.getId())) {
                R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            OutWarehouseManagementVO outWarehouseManagementVO = this.outWarehouseManagementService.queryDetail(outWarehouseManagementDTO.getId());
            return R.ok((Object)outWarehouseManagementVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getDeliveryDate"})
    @ApiOperation(value="\u83b7\u53d6\u53d1\u8d27\u65e5\u671f")
    public R getDeliveryDate() {
        try {
            Date deliveryDate = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return R.ok((Object)simpleDateFormat.format(deliveryDate));
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportList"})
    @ApiOperation(value="\u5bfc\u51fa")
    public void exportList(@RequestBody OutWarehouseManagementQuery outWarehouseManagementQuery, HttpServletResponse response) {
        try {
            this.outWarehouseManagementService.exportList(outWarehouseManagementQuery, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/cancelDelivery"})
    @ApiOperation(value="\u53d6\u6d88\u51fa\u5e93")
    public R cancelDelivery(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            Boolean isSuccess = this.outWarehouseManagementService.cancelDelivery(outWarehouseManagementDTO.getId());
            if (isSuccess.booleanValue()) {
                return R.ok((Object)"\u53d6\u6d88\u6210\u529f");
            }
            return R.fail((String)"\u53d6\u6d88\u5931\u8d25");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executiveEditor"})
    @ApiOperation(value="\u7f16\u8f91")
    public R<String> executiveEditor(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            OutWarehouseManagementDO outWarehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getById((Serializable)outWarehouseManagementDTO.getId());
            if (outWarehouseManagementDO.getOutWarehouseStatus().equals("\u5df2\u53d6\u6d88") || outWarehouseManagementDO.getOutWarehouseStatus().equals("\u5df2\u9a73\u56de")) {
                this.outWarehouseManagementService.executiveEditor(outWarehouseManagementDTO);
                return R.ok((Object)"\u7f16\u8f91\u6210\u529f");
            }
            return R.fail((String)"\u8be5\u72b6\u6001\u4e0d\u652f\u6301\u7f16\u8f91");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/haveBeenSigned"})
    @ApiOperation(value="\u9879\u76ee\u8d1f\u8d23\u4eba\u6267\u884c\u5df2\u7b7e\u6536\u64cd\u4f5c")
    public R haveBeenSigned(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            OutWarehouseManagementDO outWarehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getById((Serializable)outWarehouseManagementDTO.getId());
            if (!outWarehouseManagementDO.getOutWarehouseStatus().equals("\u5df2\u51fa\u5e93")) {
                return R.fail((String)"\u72b6\u6001\u4e0d\u662f\u5df2\u51fa\u5e93\uff0c\u7b7e\u6536\u5931\u8d25");
            }
            outWarehouseManagementDO.setOutWarehouseStatus("\u5df2\u7b7e\u6536");
            this.outWarehouseManagementService.updateById((Object)outWarehouseManagementDO);
            return R.ok((Object)"\u7b7e\u6536\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u70b9\u51fb\u6253\u5370\u589e\u52a0\u6253\u5370\u6b21\u6570")
    @PostMapping(value={"/clickToPrint"})
    public R clickToPrint(@RequestBody OutWarehouseManagementDO outWarehouseManagementDTO) {
        try {
            this.outWarehouseManagementService.clickToPrint(outWarehouseManagementDTO.getId());
            return R.ok((Object)"\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.ok((Object)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7269\u8d44\u7533\u8bf7\u5355\u5e26\u51fa\u76f8\u5173\u4fe1\u606f\u4ee5\u53ca\u9700\u6c42\u660e\u7ec6(\u9700\u6c42\u91cf\u3001\u5355\u4f4d\u3001\u5907\u6ce8\u3001\u7269\u8d44\u540d\u79f0)")
    @PostMapping(value={"/getMaterialApplicationRelationInformation"})
    public R<OutWarehouseManagementDTO> getMaterialApplicationRelationInformation(@RequestBody MaterialsApplicationMaterialOrderDTO materialsApplicationMaterialOrderDTO) {
        try {
            MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.materialsApplicationMaterialOrderService.getById((Serializable)materialsApplicationMaterialOrderDTO.getId());
            List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)materialsApplicationMaterialOrderDTO.getId()), MaterialsApplicationDemandDetailDO::getMainId, (Object)materialsApplicationMaterialOrderDTO.getId()));
            OutWarehouseManagementDTO outWarehouseManagementDTO = this.outWarehouseManagementService.getMaterialApplicationRelationInformation(materialsApplicationMaterialOrderDO, materialsApplicationDemandDetailDOList);
            return R.ok((Object)outWarehouseManagementDTO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @ApiOperation(value="\u9879\u76ee\u8d1f\u8d23\u4eba\u70b9\u51fb\u5df2\u7b7e\u6536")
    @PostMapping(value={"/executionBeenSigned"})
    public R<String> executionBeenSigned(@RequestBody OutWarehouseManagementDTO outWarehouseManagementDTO) {
        try {
            OutWarehouseManagementDO outWarehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getById((Serializable)outWarehouseManagementDTO.getId());
            if (ObjectUtil.isNotEmpty((Object)outWarehouseManagementDO.getProjectLeader()) && outWarehouseManagementDO.getProjectLeader().contains(outWarehouseManagementDTO.getProjectLeader())) {
                this.outWarehouseManagementService.executionBeenSigned(outWarehouseManagementDTO);
                return R.ok((Object)"\u6210\u529f");
            }
            return R.fail((String)"\u53ea\u6709\u9879\u76ee\u8d1f\u8d23\u4eba\u624d\u80fd\u6267\u884c\u5df2\u5b8c\u6210\u64cd\u4f5c");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/workFromCallBack"})
    @ApiOperation(value="\u51fa\u5e93\u7ba1\u7406-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.outWarehouseManagementService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

