/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.supply;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.MaterialsApplicationMaterialOrderDTO;
import com.ruoyi.dto.supply.ProjectInformationDTO;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.dto.supply.PurchaseOrderDemandDetailDTO;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.entity.supply.PurchaseOrderDemandDetailDO;
import com.ruoyi.query.supply.PurchaseOrderQuery;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.service.supply.PurchaseOrderService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.PaymentDetailsVO;
import com.ruoyi.vo.supply.PurchaseOrderDemandExportDO;
import com.ruoyi.vo.supply.PurchaseOrderDemandTwoExportDO;
import com.ruoyi.vo.supply.PurchaseOrderVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RequestMapping(value={"/purchaseOrder"})
@RestController
@Api(tags={"\u91c7\u8d2d\u8ba2\u5355"})
public class PurchaseOrderController {
    private static final Logger log = LoggerFactory.getLogger(PurchaseOrderController.class);
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private MaterialsApplicationMaterialOrderService materialsApplicationMaterialOrderService;

    @PostMapping(value={"/getPurchaseOrderPageQuery"})
    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355\u5217\u8868\u5206\u9875\u663e\u793a")
    public R<PageResultVo<PurchaseOrderVO>> getPurchaseOrderPageQuery(@RequestBody PurchaseOrderQuery purchaseOrderQuery) {
        try {
            PageResultVo purchaseOrderVOList = this.purchaseOrderService.getPurchaseOrderPageQuery(purchaseOrderQuery);
            return R.ok((Object)purchaseOrderVOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/exportPurchaseOrder"})
    @ApiOperation(value="\u5bfc\u51fa\u91c7\u8d2d\u8ba2\u5355")
    public void exportPurchaseOrder(@RequestBody PurchaseOrderQuery purchaseOrderQuery, HttpServletResponse response) {
        try {
            this.purchaseOrderService.exportPurchaseOrder(purchaseOrderQuery, response);
        }
        catch (Exception e) {
            log.info("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/getDetailExport/{type}"})
    @ApiOperation(value="\u5bfc\u51fa\u7269\u8d44\u660e\u7ec6")
    public void getDetailExport(@RequestBody PurchaseOrderDTO purchaseOrderDTO, HttpServletResponse response, @PathVariable(value="type") Integer type) {
        try {
            Workbook workbook;
            PurchaseOrderVO purchaseOrderVO = this.purchaseOrderService.getDetail(purchaseOrderDTO.getId());
            List purchaseOrderDemandDetailDOList = purchaseOrderVO.getPurchaseOrderDemandDetailDOList();
            if (type == 1) {
                List purchaseOrderDemandExportDOS = JSON.parseArray((String)JSON.toJSONString((Object)purchaseOrderDemandDetailDOList), PurchaseOrderDemandExportDO.class);
                workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PurchaseOrderDemandExportDO.class, (Collection)purchaseOrderDemandExportDOS);
            } else if (type == 2) {
                workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PurchaseOrderDemandDetailDO.class, (Collection)purchaseOrderDemandDetailDOList);
            } else {
                List purchaseOrderDemandExportDOS = JSON.parseArray((String)JSON.toJSONString((Object)purchaseOrderDemandDetailDOList), PurchaseOrderDemandTwoExportDO.class);
                workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PurchaseOrderDemandTwoExportDO.class, (Collection)purchaseOrderDemandExportDOS);
            }
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9700\u6c42\u660e\u7ec6");
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    @PostMapping(value={"/getDetailExportByAdd/{type}"})
    @ApiOperation(value="\u65b0\u589e-\u7269\u8d44\u7533\u8bf7\u660e\u7ec6\u5bfc\u51fa")
    public void selcetExportMaterialsApplicationListByAdd(@RequestBody List<PurchaseOrderDemandDetailDO> purchaseOrderDemandDetailDOList, HttpServletResponse response, @PathVariable(value="type") Integer type) {
        try {
            Workbook workbook;
            if (type == 1) {
                List purchaseOrderDemandExportDOS = JSON.parseArray((String)JSON.toJSONString(purchaseOrderDemandDetailDOList), PurchaseOrderDemandExportDO.class);
                workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PurchaseOrderDemandExportDO.class, (Collection)purchaseOrderDemandExportDOS);
            } else {
                workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams(), PurchaseOrderDemandDetailDO.class, purchaseOrderDemandDetailDOList);
            }
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9700\u6c42\u660e\u7ec6");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PostMapping(value={"/importMaterialsApplication/{type}"})
    @ApiOperation(value="\u65b0\u589e-\u5bfc\u5165\u7269\u8d44\u7533\u8bf7\u660e\u7ec6")
    public R importMaterialsApplication(MultipartFile file, @PathVariable(value="type") Integer type) {
        try {
            return this.purchaseOrderService.importMaterialsApplication(file, this.supplyUtils);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/downloadTemplate/{type}"})
    @ApiOperation(value="\u65b0\u589e-\u7269\u8d44\u7533\u8bf7\u660e\u7ec6\u6a21\u7248\u4e0b\u8f7d")
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="type") Integer type) throws Exception {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u91c7\u8d2d\u8ba2\u5355-\u9700\u6c42\u660e\u7ec6\u6a21\u7248.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = type == 1 ? new ClassPathResource("\u91c7\u8d2d\u8ba2\u5355-\u9700\u6c42\u660e\u7ec6\u6a21\u72481.xls") : new ClassPathResource("\u91c7\u8d2d\u8ba2\u5355-\u9700\u6c42\u660e\u7ec6\u6a21\u72482.xls");
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/purchaseApplication"})
    @ApiOperation(value="\u91c7\u8d2d\u7533\u8bf7")
    public R<String> purchaseApplication(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getPurchaseOrderDemandDetailDTOList())) {
                R.fail((String)"\u9700\u6c42\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.purchaseOrderService.purchaseApplication(purchaseOrderDTO);
            return R.ok((Object)"\u7533\u8bf7\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executiveApproval"})
    @ApiOperation(value="\u6267\u884c\u5ba1\u6279")
    public R<String> executiveApproval(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)this.purchaseOrderService.getById((Serializable)purchaseOrderDTO.getId()))) {
                return R.fail((String)"\u8be5\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            this.purchaseOrderService.executiveApproval(purchaseOrderDTO);
            return R.ok((Object)"\u5ba1\u6279\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getDetail"})
    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    public R<PurchaseOrderVO> getDetail(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getById((Serializable)purchaseOrderDTO.getId());
            if (ObjectUtil.isEmpty((Object)purchaseOrderDO)) {
                return R.fail((String)"\u8be5\u91c7\u8d2d\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            if (purchaseOrderDO.getPurchaseStatus().equals("\u5ba1\u6279\u4e2d") || purchaseOrderDO.getPurchaseStatus().equals("\u5f85\u91c7\u8d2d") || purchaseOrderDO.getPurchaseStatus().equals("\u5df2\u9a73\u56de")) {
                return R.fail((String)"\u6b64\u72b6\u6001\u4e0b\u7684\u91c7\u8d2d\u8ba2\u5355\u4e0d\u652f\u6301\u67e5\u770b\u8be6\u60c5");
            }
            PurchaseOrderVO purchaseOrderVO = this.purchaseOrderService.getDetail(purchaseOrderDTO.getId());
            return R.ok((Object)purchaseOrderVO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/executiveEditor"})
    @ApiOperation(value="\u7f16\u8f91")
    public R<String> executiveEditor(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.purchaseOrderService.executiveEditor(purchaseOrderDTO);
            return R.ok((Object)"\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackEditor"})
    @ApiOperation(value="\u5de5\u4f5c\u6d41\u7f16\u8f91")
    public R<String> callBackEditor(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            if (ObjectUtil.isEmpty((Object)purchaseOrderDTO.getId())) {
                return R.fail((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            PurchaseOrderDO purchaseOrderDO = new PurchaseOrderDO();
            purchaseOrderDO.setId(purchaseOrderDTO.getId());
            purchaseOrderDO.setEngineerId(purchaseOrderDTO.getEngineerId());
            purchaseOrderDO.setEngineerName(purchaseOrderDTO.getEngineerName());
            purchaseOrderDO.setEnclosures(purchaseOrderDTO.getEnclosures());
            purchaseOrderDO.setUpdateTime(new Date());
            this.purchaseOrderService.updateById((Object)purchaseOrderDO);
            return R.ok((Object)"\u7f16\u8f91\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getRelationMaterialApplication"})
    @ApiOperation(value="\u83b7\u53d6\u5173\u8054\u7269\u8d44\u7533\u8bf7\u5355\u4fe1\u606f")
    public R<List<MaterialsApplicationMaterialOrderDTO>> getRelationMaterialApplication(@RequestBody ProjectInformationDTO projectInformationDTO) {
        try {
            List materialsApplicationMaterialOrderDTOList = this.materialsApplicationMaterialOrderService.getRelationMaterialApplication(projectInformationDTO);
            return R.ok((Object)materialsApplicationMaterialOrderDTOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/initiatingOperation"})
    @ApiOperation(value="\u53d1\u8d77")
    public R<String> initiatingOperation(@RequestParam Long id) {
        try {
            this.purchaseOrderService.initiatingOperation(id);
            return R.ok((Object)"\u53d1\u8d77\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getProjectMaterialDemandDetail"})
    @ApiOperation(value="\u83b7\u53d6\u9879\u76ee\u7269\u8d44\u9700\u6c42\u660e\u7ec6")
    public R<List<PurchaseOrderDemandDetailDTO>> getProjectMaterialDemandDetail(@RequestParam Long associatedMaterialApplicationOrderId, @RequestParam String outWarehouseNumber) {
        try {
            List purchaseOrderDemandDetailDTO = this.supplyUtils.getProjectMaterialDemandDetail(associatedMaterialApplicationOrderId, outWarehouseNumber);
            return R.ok((Object)purchaseOrderDemandDetailDTO);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getPurchaseNameList"})
    @ApiOperation(value="\u83b7\u53d6\u91c7\u8d2d\u8ba2\u5355\u4e0b\u62c9\u5217\u8868")
    public R<Map<Long, String>> getPurchaseNameList() {
        try {
            Map purchaseName = this.purchaseOrderService.getPurchaseList();
            return R.ok((Object)purchaseName);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/getPaymentDetails"})
    @ApiOperation(value="\u83b7\u53d6\u4ed8\u6b3e\u660e\u7ec6")
    public R<List<PaymentDetailsVO>> getPaymentDetails(@RequestBody PurchaseOrderDTO purchaseOrderDTO) {
        try {
            List purchaseOrderDemandDetailDTOList = this.supplyUtils.getPaymentDetails(purchaseOrderDTO.getId());
            return R.ok((Object)purchaseOrderDemandDetailDTOList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getPurchaseOrderDepartment"})
    @ApiOperation(value="\u83b7\u53d6\u90e8\u95e8\u5217\u8868")
    public R<List<String>> getPurchaseOrderDepartment() {
        try {
            List purchaseOrderDOList = this.purchaseOrderService.list();
            List departmanetList = purchaseOrderDOList.stream().map(m -> m.getDepartment()).distinct().collect(Collectors.toList());
            return R.ok(departmanetList);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"/getPurchaseOrderProject"})
    @ApiOperation(value="\u83b7\u53d6\u91c7\u8d2d\u8ba2\u5355\u5173\u8054\u9879\u76ee")
    public R<List<String>> getPurchaseOrderProject() {
        try {
            List purchaseOrderDOList = this.purchaseOrderService.list();
            List linkProject = purchaseOrderDOList.stream().filter(m -> m.getProjectName() != null && !m.getProjectName().isEmpty()).map(PurchaseOrderDO::getProjectName).distinct().collect(Collectors.toList());
            return R.ok(linkProject);
        }
        catch (Exception e) {
            e.getMessage();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBack(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.purchaseOrderService.workFromCallBack(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackTwo"})
    @ApiOperation(value="\u91c7\u8d2d\u8ba2\u5355-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackTwo(@RequestBody WorkFlowCallBackVO vo) {
        try {
            this.purchaseOrderService.workFromCallBackTwo(vo);
            return R.ok((Object)"\u64cd\u4f5c\u6210\u529f!");
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.fail((String)e.getLocalizedMessage());
        }
    }
}

