/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.contract.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.core.ISystemService;
import com.ruoyi.dto.SystemRoleUser;
import com.ruoyi.dto.contract.ContractBusinessInformationDTO;
import com.ruoyi.dto.contract.ContractDTO;
import com.ruoyi.dto.contract.ContractDetailDTO;
import com.ruoyi.dto.contract.ContractFileDTO;
import com.ruoyi.dto.contract.ContractFromTaskDTO;
import com.ruoyi.dto.contract.ContractNumberDTO;
import com.ruoyi.dto.contract.ContractPackageSalesDTO;
import com.ruoyi.dto.contract.ContractProjectExporDTO;
import com.ruoyi.dto.contract.ContractProjectHandleDTO;
import com.ruoyi.dto.contract.ContractProjecyConstructionDTO;
import com.ruoyi.dto.contract.ContractProjecyTariffStandardsDTO;
import com.ruoyi.dto.contract.ContractRevenueSharingDTO;
import com.ruoyi.dto.contract.ContractSettlementInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineADedicatedLineDTO;
import com.ruoyi.dto.contract.ContractSupplineAccountOpeningInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineApplicationInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineBasicBroadbandInformationDTO;
import com.ruoyi.dto.contract.ContractSupplineExporDTO;
import com.ruoyi.dto.contract.ContractSupplineHandleDTO;
import com.ruoyi.dto.contract.ContractSupplineOtherDTO;
import com.ruoyi.dto.contract.ContractSupplineRegularBroadbandDTO;
import com.ruoyi.dto.contract.ContractSupplineTariffInformationDTO;
import com.ruoyi.dto.contract.ContractTerminationDTO;
import com.ruoyi.dto.contract.ContractTotalPriceDTO;
import com.ruoyi.dto.contract.SupplementarySignatureContractDTO;
import com.ruoyi.entity.contract.ContractBusinessInformationEntity;
import com.ruoyi.entity.contract.ContractDetailEntity;
import com.ruoyi.entity.contract.ContractEntity;
import com.ruoyi.entity.contract.ContractFileEntity;
import com.ruoyi.entity.contract.ContractPackageSalesEntity;
import com.ruoyi.entity.contract.ContractProjecyConstructionEntity;
import com.ruoyi.entity.contract.ContractProjecyTariffStandardsEntity;
import com.ruoyi.entity.contract.ContractRevenueSharingEntity;
import com.ruoyi.entity.contract.ContractSettlementInformationEntity;
import com.ruoyi.entity.contract.ContractSupplineADedicatedLineEntity;
import com.ruoyi.entity.contract.ContractSupplineAccountOpeningInformationEntity;
import com.ruoyi.entity.contract.ContractSupplineApplicationInformationEntity;
import com.ruoyi.entity.contract.ContractSupplineBasicBroadbandInformationEntity;
import com.ruoyi.entity.contract.ContractSupplineOtherEntity;
import com.ruoyi.entity.contract.ContractSupplineRegularBroadbandEntity;
import com.ruoyi.entity.contract.ContractSupplineTariffInformationEntity;
import com.ruoyi.entity.contract.ContractTotalPriceEntity;
import com.ruoyi.enums.ContractParentCategorEnum;
import com.ruoyi.enums.ContractStatusEnum;
import com.ruoyi.enums.DataStatusEnum;
import com.ruoyi.mapper.contract.ContractMapper;
import com.ruoyi.query.contract.ContractProjectQuery;
import com.ruoyi.query.contract.ContractSupplierQuery;
import com.ruoyi.service.contract.ContractBusinessInformationService;
import com.ruoyi.service.contract.ContractDetailService;
import com.ruoyi.service.contract.ContractFileService;
import com.ruoyi.service.contract.ContractPackageSalesService;
import com.ruoyi.service.contract.ContractProjecyConstructionService;
import com.ruoyi.service.contract.ContractProjecyTariffStandardsService;
import com.ruoyi.service.contract.ContractRevenueSharingService;
import com.ruoyi.service.contract.ContractService;
import com.ruoyi.service.contract.ContractSettlementInformationService;
import com.ruoyi.service.contract.ContractSupplineADedicatedLineService;
import com.ruoyi.service.contract.ContractSupplineAccountOpeningInformationService;
import com.ruoyi.service.contract.ContractSupplineApplicationInformationService;
import com.ruoyi.service.contract.ContractSupplineBasicBroadbandInformationService;
import com.ruoyi.service.contract.ContractSupplineOtherService;
import com.ruoyi.service.contract.ContractSupplineRegularBroadbandService;
import com.ruoyi.service.contract.ContractSupplineTariffInformationService;
import com.ruoyi.service.contract.ContractTotalPriceService;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChinesePinyin;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ContractServiceImpl
extends ServiceImpl<ContractMapper, ContractEntity>
implements ContractService {
    private static final Logger log = LoggerFactory.getLogger(ContractServiceImpl.class);
    @Autowired
    private ContractDetailService contractDetailService;
    @Autowired
    private ContractBusinessInformationService contractBusinessInformationService;
    @Autowired
    private ContractFileService contractFileService;
    @Autowired
    private ContractPackageSalesService contractPackageSalesService;
    @Autowired
    private ContractProjecyConstructionService contractProjecyConstructionService;
    @Autowired
    private ContractProjecyTariffStandardsService contractProjecyTariffStandardsService;
    @Autowired
    private ContractRevenueSharingService contractRevenueSharingService;
    @Autowired
    private ContractSettlementInformationService contractSettlementInformationService;
    @Autowired
    private ContractTotalPriceService contractTotalPriceService;
    @Autowired
    private ContractSupplineRegularBroadbandService contractSupplineRegularBroadbandService;
    @Autowired
    private ContractSupplineADedicatedLineService contractSupplineADedicatedLineService;
    @Autowired
    private ContractSupplineOtherService contractSupplineOtherService;
    @Autowired
    private ContractSupplineApplicationInformationService contractSupplineApplicationInformationService;
    @Autowired
    private ContractSupplineBasicBroadbandInformationService contractSupplineBasicBroadbandInformationService;
    @Autowired
    private ContractSupplineAccountOpeningInformationService contractSupplineAccountOpeningInformationService;
    @Autowired
    private ContractSupplineTariffInformationService contractSupplineTariffInformationService;
    @Autowired
    private ISystemService systemService;
    @Resource
    private WorkFlowService workFlowService;

    public List<ContractDetailEntity> getContractByProjectCode(String projectCode) {
        LambdaQueryWrapper wrapperContract = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractDetailEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractDetailEntity::getCustomerCode, (Object)projectCode);
        List contractDetailEntityList = this.contractDetailService.list((Wrapper)wrapperContract);
        return contractDetailEntityList;
    }

    public List<SupplementarySignatureContractDTO> getSupplementarySignatureContract(String contractNo) {
        LambdaQueryWrapper wrapperContract = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractEntity::getContractNo, (Object)contractNo);
        List contractDetailEntityList = this.list((Wrapper)wrapperContract);
        ArrayList<SupplementarySignatureContractDTO> list = new ArrayList<SupplementarySignatureContractDTO>();
        contractDetailEntityList.stream().forEach(entity -> {
            SupplementarySignatureContractDTO dto = new SupplementarySignatureContractDTO();
            dto.setId(entity.getId() + "");
            dto.setContractSupplementarySignatureNumber(entity.getContractSupplementarySignatureNumber());
            dto.setContractSigningDate(entity.getContractSigningDate());
            list.add(dto);
        });
        return list;
    }

    public String getContractNumber(ContractNumberDTO contractNumber) {
        String ourContractingUnit = ChinesePinyin.getInitials((String)contractNumber.getOurContractingUnit());
        String contractType = ChinesePinyin.getInitials((String)contractNumber.getContractType());
        String contractSigningTime = DateUtils.getDateToString((Date)contractNumber.getContractSigningTime());
        String contractNumberPingyin = ourContractingUnit + contractType + contractSigningTime;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode());
        int count = this.count((Wrapper)wrapper);
        if (count > 0) {
            if (count + 1 < 10) {
                return contractNumberPingyin + "000" + (count + 1);
            }
            if (count + 1 < 100) {
                return contractNumberPingyin + "00" + (count + 1);
            }
            if (count + 1 < 1000) {
                return contractNumberPingyin + "0" + (count + 1);
            }
            return contractNumberPingyin + (count + 1);
        }
        return contractNumberPingyin + "1000";
    }

    public PageResultVo<ContractDTO> getContractProjectListPage(ContractProjectQuery query) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(query);
        Page page = (Page)this.page((IPage)new Page((long)query.getPageNum(), (long)query.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        ArrayList<ContractDTO> contractDTOList = new ArrayList<ContractDTO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (ContractEntity contractEntity : resultVo.getData()) {
                ContractDTO contractDTO = new ContractDTO();
                BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
                contractDTO.setContractStatus(ContractStatusEnum.getName((String)contractDTO.getContractStatus()));
                contractDTOList.add(contractDTO);
            }
        }
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    public PageResultVo<ContractDTO> getContractSupplierListPage(ContractSupplierQuery query) {
        LambdaQueryWrapper wrapper = this.getWrapperSupplier(query);
        Page page = (Page)this.page((IPage)new Page((long)query.getPageNum(), (long)query.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        ArrayList<ContractDTO> contractDTOList = new ArrayList<ContractDTO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (ContractEntity contractEntity : resultVo.getData()) {
                ContractDTO contractDTO = new ContractDTO();
                BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
                contractDTO.setContractStatus(ContractStatusEnum.getName((String)contractDTO.getContractStatus()));
                contractDTOList.add(contractDTO);
            }
        }
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    public List<ContractProjectExporDTO> getContractProjectList(ContractProjectQuery query) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(query);
        List contractEntityList = this.list((Wrapper)wrapper);
        ArrayList<ContractProjectExporDTO> contractDTOList = new ArrayList<ContractProjectExporDTO>();
        if (ObjectUtil.isNotEmpty((Object)contractEntityList)) {
            for (ContractEntity contractEntity : contractEntityList) {
                ContractProjectExporDTO contractDTO = new ContractProjectExporDTO();
                BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
                contractDTO.setContractStatus(ContractStatusEnum.getName((String)contractDTO.getContractStatus()));
                contractDTO.setContractCategory("\u9879\u76ee\u5408\u540c");
                contractDTOList.add(contractDTO);
            }
        }
        return contractDTOList;
    }

    public List<ContractSupplineExporDTO> getContractSupplineList(ContractSupplierQuery query) {
        LambdaQueryWrapper wrapper = this.getWrapperSupplier(query);
        List contractEntityList = this.list((Wrapper)wrapper);
        ArrayList<ContractSupplineExporDTO> contractDTOList = new ArrayList<ContractSupplineExporDTO>();
        if (ObjectUtil.isNotEmpty((Object)contractEntityList)) {
            for (ContractEntity contractEntity : contractEntityList) {
                ContractSupplineExporDTO contractDTO = new ContractSupplineExporDTO();
                BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
                contractDTO.setContractStatus(ContractStatusEnum.getName((String)contractDTO.getContractStatus()));
                contractDTO.setContractCategory("\u4f9b\u5e94\u5546\u5408\u540c");
                contractDTOList.add(contractDTO);
            }
        }
        return contractDTOList;
    }

    public ContractEntity getContractProjectHandleDTOByProcessInstanceld(String processInstanceld) {
        ContractDTO dto = new ContractDTO();
        Object contractEntity = null;
        LambdaQueryWrapper wrapperContract = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getContractFormTaskId, (Object)processInstanceld);
        List contractDetailEntityList = this.list((Wrapper)wrapperContract);
        if (ObjectUtil.isNotEmpty((Object)contractDetailEntityList) && contractDetailEntityList.size() > 0) {
            return (ContractEntity)contractDetailEntityList.get(0);
        }
        return null;
    }

    public ContractProjectHandleDTO getContractProjectHandleDTOById(Long id) {
        LambdaQueryWrapper wrapperContractTotalPrice;
        List contractTotalPriceEntityList;
        LambdaQueryWrapper wrapperContractSettlementInformation;
        List contractSettlementInformationEntityList;
        LambdaQueryWrapper wrapperContractRevenueSharing;
        List contractRevenueSharingEntityList;
        LambdaQueryWrapper wrapperContractProjecyConstruction;
        List contractProjecyConstructionEntityList;
        ContractProjectHandleDTO dto = new ContractProjectHandleDTO();
        ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)id);
        if (contractEntity == null) {
            return dto;
        }
        ContractDTO contractDTO = new ContractDTO();
        BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
        dto.setContractDTO(contractDTO);
        LambdaQueryWrapper wrapperContractDetail = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractDetailEntity::getContactId, (Object)id);
        List contractDetailEntityList = this.contractDetailService.list((Wrapper)wrapperContractDetail);
        if (ObjectUtil.isNotEmpty((Object)contractDetailEntityList) && contractDetailEntityList.size() > 0) {
            ContractDetailDTO contractDetailDTO = new ContractDetailDTO();
            BeanUtils.copyProperties(contractDetailEntityList.get(0), (Object)contractDetailDTO);
            dto.setContractDetailDTO(contractDetailDTO);
        }
        LambdaQueryWrapper wrapperContractFile = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractFileEntity::getContactId, (Object)id);
        List contractFileEntityList = this.contractFileService.list((Wrapper)wrapperContractFile);
        ArrayList listContractFileDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractFileEntityList) && contractFileEntityList.size() > 0) {
            contractFileEntityList.forEach(entity -> {
                ContractFileDTO contractFileDTO = new ContractFileDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractFileDTO);
                listContractFileDTOS.add(contractFileDTO);
            });
            dto.setListContractFileDTOS(listContractFileDTOS);
        }
        LambdaQueryWrapper wrapperContractBusinessInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractBusinessInformationEntity::getContactId, (Object)id);
        List contractBusinessInformationEntityList = this.contractBusinessInformationService.list((Wrapper)wrapperContractBusinessInformation);
        ArrayList listContractBusinessInformationDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractBusinessInformationEntityList) && contractBusinessInformationEntityList.size() > 0) {
            contractBusinessInformationEntityList.forEach(entity -> {
                ContractBusinessInformationDTO contractBusinessInformationDTO = new ContractBusinessInformationDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractBusinessInformationDTO);
                listContractBusinessInformationDTOS.add(contractBusinessInformationDTO);
            });
            dto.setListContractBusinessInformationDTOS(listContractBusinessInformationDTOS);
        }
        LambdaQueryWrapper wrapperContractPackageSales = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractPackageSalesEntity::getContactId, (Object)id);
        List contractPackageSalesEntityList = this.contractPackageSalesService.list((Wrapper)wrapperContractPackageSales);
        ArrayList listContractPackageSalesDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractPackageSalesEntityList) && contractPackageSalesEntityList.size() > 0) {
            contractPackageSalesEntityList.forEach(entity -> {
                ContractPackageSalesDTO contractPackageSalesDTO = new ContractPackageSalesDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractPackageSalesDTO);
                listContractPackageSalesDTOS.add(contractPackageSalesDTO);
            });
            dto.setListContractPackageSalesDTOS(listContractPackageSalesDTOS);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractProjecyConstructionEntityList = this.contractProjecyConstructionService.list((Wrapper)(wrapperContractProjecyConstruction = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractProjecyConstructionEntity::getContactId, (Object)id))))) && contractProjecyConstructionEntityList.size() > 0) {
            ContractProjecyConstructionDTO contractProjecyConstructionDTO = new ContractProjecyConstructionDTO();
            BeanUtils.copyProperties(contractProjecyConstructionEntityList.get(0), (Object)contractProjecyConstructionDTO);
            dto.setContractProjecyConstructionDTO(contractProjecyConstructionDTO);
        }
        LambdaQueryWrapper wrapperContractProjecyTariffStandards = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractProjecyTariffStandardsEntity::getContactId, (Object)id);
        List ContractProjecyTariffStandardsEntityList = this.contractProjecyTariffStandardsService.list((Wrapper)wrapperContractProjecyTariffStandards);
        ArrayList listContractProjecyTariffStandardsDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)ContractProjecyTariffStandardsEntityList) && ContractProjecyTariffStandardsEntityList.size() > 0) {
            ContractProjecyTariffStandardsEntityList.forEach(entity -> {
                ContractProjecyTariffStandardsDTO contractProjecyTariffStandardsDTO = new ContractProjecyTariffStandardsDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractProjecyTariffStandardsDTO);
                listContractProjecyTariffStandardsDTOS.add(contractProjecyTariffStandardsDTO);
            });
            dto.setListContractProjecyTariffStandardsDTOS(listContractProjecyTariffStandardsDTOS);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractRevenueSharingEntityList = this.contractRevenueSharingService.list((Wrapper)(wrapperContractRevenueSharing = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractRevenueSharingEntity::getContactId, (Object)id))))) && contractRevenueSharingEntityList.size() > 0) {
            ContractRevenueSharingDTO contractRevenueSharingDTO = new ContractRevenueSharingDTO();
            BeanUtils.copyProperties(contractRevenueSharingEntityList.get(0), (Object)contractRevenueSharingDTO);
            dto.setContractRevenueSharingDTO(contractRevenueSharingDTO);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractSettlementInformationEntityList = this.contractSettlementInformationService.list((Wrapper)(wrapperContractSettlementInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSettlementInformationEntity::getContactId, (Object)id))))) && contractSettlementInformationEntityList.size() > 0) {
            ContractSettlementInformationDTO contractSettlementInformationDTO = new ContractSettlementInformationDTO();
            BeanUtils.copyProperties(contractSettlementInformationEntityList.get(0), (Object)contractSettlementInformationDTO);
            dto.setContractSettlementInformationDTO(contractSettlementInformationDTO);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractTotalPriceEntityList = this.contractTotalPriceService.list((Wrapper)(wrapperContractTotalPrice = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractTotalPriceEntity::getContactId, (Object)id))))) && contractTotalPriceEntityList.size() > 0) {
            ContractTotalPriceDTO contractTotalPriceDTO = new ContractTotalPriceDTO();
            BeanUtils.copyProperties(contractTotalPriceEntityList.get(0), (Object)contractTotalPriceDTO);
            dto.setContractTotalPriceDTO(contractTotalPriceDTO);
        }
        return dto;
    }

    public ContractSupplineHandleDTO getContractSupplineHandleDTOById(Long id) {
        LambdaQueryWrapper wrapperContractSupplineAccountOpeningInformation;
        List contractSupplineAccountOpeningInformationEntityList;
        LambdaQueryWrapper wrapperContractSupplineApplicationInformation;
        List contractSupplineApplicationInformationEntityList;
        LambdaQueryWrapper wrapperContractSettlementInformation;
        List contractSettlementInformationEntityList;
        ContractSupplineHandleDTO dto = new ContractSupplineHandleDTO();
        ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)id);
        if (contractEntity == null) {
            return dto;
        }
        ContractDTO contractDTO = new ContractDTO();
        BeanUtils.copyProperties((Object)contractEntity, (Object)contractDTO);
        dto.setContractDTO(contractDTO);
        LambdaQueryWrapper wrapperContractDetail = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractDetailEntity::getContactId, (Object)id);
        List contractDetailEntityList = this.contractDetailService.list((Wrapper)wrapperContractDetail);
        if (ObjectUtil.isNotEmpty((Object)contractDetailEntityList) && contractDetailEntityList.size() > 0) {
            ContractDetailDTO contractDetailDTO = new ContractDetailDTO();
            BeanUtils.copyProperties(contractDetailEntityList.get(0), (Object)contractDetailDTO);
            dto.setContractDetailDTO(contractDetailDTO);
        }
        LambdaQueryWrapper wrapperContractFile = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractFileEntity::getContactId, (Object)id);
        List contractFileEntityList = this.contractFileService.list((Wrapper)wrapperContractFile);
        ArrayList listContractFileDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractFileEntityList) && contractFileEntityList.size() > 0) {
            contractFileEntityList.forEach(entity -> {
                ContractFileDTO contractFileDTO = new ContractFileDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractFileDTO);
                listContractFileDTOS.add(contractFileDTO);
            });
            dto.setListContractFileDTOS(listContractFileDTOS);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractSettlementInformationEntityList = this.contractSettlementInformationService.list((Wrapper)(wrapperContractSettlementInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSettlementInformationEntity::getContactId, (Object)id))))) && contractSettlementInformationEntityList.size() > 0) {
            ContractSettlementInformationDTO contractSettlementInformationDTO = new ContractSettlementInformationDTO();
            BeanUtils.copyProperties(contractSettlementInformationEntityList.get(0), (Object)contractSettlementInformationDTO);
            dto.setContractSettlementInformationDTO(contractSettlementInformationDTO);
        }
        LambdaQueryWrapper wrapperContractSupplineRegularBroadband = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineRegularBroadbandEntity::getContactId, (Object)id);
        List contractSupplineRegularBroadbandEntityList = this.contractSupplineRegularBroadbandService.list((Wrapper)wrapperContractSupplineRegularBroadband);
        ArrayList listContractSupplineRegularBroadbandDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractSupplineRegularBroadbandEntityList) && contractSupplineRegularBroadbandEntityList.size() > 0) {
            contractSupplineRegularBroadbandEntityList.forEach(entity -> {
                ContractSupplineRegularBroadbandDTO contractSupplineRegularBroadbandDTO = new ContractSupplineRegularBroadbandDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractSupplineRegularBroadbandDTO);
                listContractSupplineRegularBroadbandDTOS.add(contractSupplineRegularBroadbandDTO);
            });
            dto.setListContractSupplineRegularBroadbandDTOS(listContractSupplineRegularBroadbandDTOS);
        }
        LambdaQueryWrapper wrapperContractSupplineADedicatedLine = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineADedicatedLineEntity::getContactId, (Object)id);
        List contractSupplineADedicatedLineEntityList = this.contractSupplineADedicatedLineService.list((Wrapper)wrapperContractSupplineADedicatedLine);
        ArrayList listContractSupplineADedicatedLineDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractSupplineADedicatedLineEntityList) && contractSupplineADedicatedLineEntityList.size() > 0) {
            contractSupplineADedicatedLineEntityList.forEach(entity -> {
                ContractSupplineADedicatedLineDTO contractSupplineADedicatedLineDTO = new ContractSupplineADedicatedLineDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractSupplineADedicatedLineDTO);
                listContractSupplineADedicatedLineDTOS.add(contractSupplineADedicatedLineDTO);
            });
            dto.setListContractSupplineADedicatedLineDTOS(listContractSupplineADedicatedLineDTOS);
        }
        LambdaQueryWrapper wrapperContractSupplineOther = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineOtherEntity::getContactId, (Object)id);
        List contractSupplineOtherEntityList = this.contractSupplineOtherService.list((Wrapper)wrapperContractSupplineOther);
        ArrayList listContractSupplineOtherDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractSupplineOtherEntityList) && contractSupplineOtherEntityList.size() > 0) {
            contractSupplineOtherEntityList.forEach(entity -> {
                ContractSupplineOtherDTO contractSupplineOtherDTO = new ContractSupplineOtherDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractSupplineOtherDTO);
                listContractSupplineOtherDTOS.add(contractSupplineOtherDTO);
            });
            dto.setListContractSupplineOtherDTOS(listContractSupplineOtherDTOS);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractSupplineApplicationInformationEntityList = this.contractSupplineApplicationInformationService.list((Wrapper)(wrapperContractSupplineApplicationInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineApplicationInformationEntity::getContactId, (Object)id))))) && contractSupplineApplicationInformationEntityList.size() > 0) {
            ContractSupplineApplicationInformationDTO contractSupplineApplicationInformation = new ContractSupplineApplicationInformationDTO();
            BeanUtils.copyProperties(contractSupplineApplicationInformationEntityList.get(0), (Object)contractSupplineApplicationInformation);
            dto.setContractSupplineApplicationInformation(contractSupplineApplicationInformation);
        }
        LambdaQueryWrapper wrapperContractSupplineBasicBroadbandInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineBasicBroadbandInformationEntity::getContactId, (Object)id);
        List contractSupplineBasicBroadbandInformationEntityList = this.contractSupplineBasicBroadbandInformationService.list((Wrapper)wrapperContractSupplineBasicBroadbandInformation);
        ArrayList listContractSupplineApplicationInformationDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)contractSupplineBasicBroadbandInformationEntityList) && contractSupplineBasicBroadbandInformationEntityList.size() > 0) {
            contractSupplineBasicBroadbandInformationEntityList.forEach(entity -> {
                ContractSupplineBasicBroadbandInformationDTO contractSupplineBasicBroadbandInformationDTO = new ContractSupplineBasicBroadbandInformationDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractSupplineBasicBroadbandInformationDTO);
                listContractSupplineApplicationInformationDTOS.add(contractSupplineBasicBroadbandInformationDTO);
            });
            dto.setListContractSupplineApplicationInformationDTOS(listContractSupplineApplicationInformationDTOS);
        }
        if (ObjectUtil.isNotEmpty((Object)(contractSupplineAccountOpeningInformationEntityList = this.contractSupplineAccountOpeningInformationService.list((Wrapper)(wrapperContractSupplineAccountOpeningInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineAccountOpeningInformationEntity::getContactId, (Object)id))))) && contractSupplineAccountOpeningInformationEntityList.size() > 0) {
            ContractSupplineAccountOpeningInformationDTO contractSupplineAccountOpeningInformation = new ContractSupplineAccountOpeningInformationDTO();
            BeanUtils.copyProperties(contractSupplineAccountOpeningInformationEntityList.get(0), (Object)contractSupplineAccountOpeningInformation);
            dto.setContractSupplineAccountOpeningInformation(contractSupplineAccountOpeningInformation);
        }
        LambdaQueryWrapper wrapperContractSupplineTariffInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineTariffInformationEntity::getContactId, (Object)id);
        List ContractSupplineTariffInformationEntityList = this.contractSupplineTariffInformationService.list((Wrapper)wrapperContractSupplineTariffInformation);
        ArrayList listContractSupplineTariffInformationDTOS = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)ContractSupplineTariffInformationEntityList) && ContractSupplineTariffInformationEntityList.size() > 0) {
            ContractSupplineTariffInformationEntityList.forEach(entity -> {
                ContractSupplineTariffInformationDTO contractSupplineTariffInformationDTO = new ContractSupplineTariffInformationDTO();
                BeanUtils.copyProperties((Object)entity, (Object)contractSupplineTariffInformationDTO);
                listContractSupplineTariffInformationDTOS.add(contractSupplineTariffInformationDTO);
            });
            dto.setListContractSupplineTariffInformationDTOS(listContractSupplineTariffInformationDTOS);
        }
        return dto;
    }

    public String createContractSuppline(ContractSupplineHandleDTO contractSupplineHandleDTO) {
        try {
            ContractEntity contractEntity = new ContractEntity();
            BeanUtils.copyProperties((Object)contractSupplineHandleDTO.getContractDetailDTO(), (Object)contractEntity);
            contractEntity.setContractCategory(ContractParentCategorEnum.suppline.name());
            contractEntity.setId(null);
            contractEntity.setCreateTime(new Date());
            contractEntity.setUpdateTime(new Date());
            contractEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractEntity.setContractEndTime(contractSupplineHandleDTO.getContractDetailDTO().getContactsEndTime());
            contractEntity.setContractStatus(contractSupplineHandleDTO.getContractDTO().getContractStatus());
            contractEntity.setContractSupplementarySignatureNumber(this.getContractSupplementarySignatureNumber(contractSupplineHandleDTO.getContractDetailDTO().getContractNo()) + "");
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            contractEntity.setCreateId(UserUtils.getLongUserId());
            this.save((Object)contractEntity);
            this.handleContractSuppline(contractSupplineHandleDTO, contractEntity.getId());
            String message = this.startContractWorkFrom(contractEntity.getId());
            if (message == null) {
                return contractEntity.getId().toString();
            }
            throw new RuntimeException(message);
        }
        catch (Exception e) {
            log.error("createContractSuppline:" + JSON.toJSON((Object)e));
            return null;
        }
    }

    public Boolean updateContractSuppline(ContractSupplineHandleDTO contractSupplineHandleDTO) {
        try {
            ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)contractSupplineHandleDTO.getContractDTO().getId());
            if (contractEntity == null) {
                throw new RuntimeException("\u5165\u53c2Id\u9519\u8bef\uff0c\u672a\u67e5\u5230\u5f85\u4fee\u6539\u6570\u636e\uff01");
            }
            Long id = contractSupplineHandleDTO.getContractDTO().getId();
            BeanUtils.copyProperties((Object)contractSupplineHandleDTO.getContractDetailDTO(), (Object)contractEntity);
            contractEntity.setContractCategory(ContractParentCategorEnum.suppline.name());
            contractEntity.setUpdateTime(new Date());
            contractEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractEntity.setContractStatus(contractSupplineHandleDTO.getContractDTO().getContractStatus());
            contractEntity.setContractEndTime(contractSupplineHandleDTO.getContractDetailDTO().getContactsEndTime());
            contractEntity.setId(id);
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            this.updateById((Object)contractEntity);
            this.deleteProjectByContractId(id);
            this.handleContractSuppline(contractSupplineHandleDTO, id);
            return true;
        }
        catch (Exception e) {
            log.error("updateContractSuppline:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public String createContractProject(ContractProjectHandleDTO contractProjectHandleDTO) {
        try {
            ContractEntity contractEntity = new ContractEntity();
            BeanUtils.copyProperties((Object)contractProjectHandleDTO.getContractDetailDTO(), (Object)contractEntity);
            contractEntity.setContractCategory(ContractParentCategorEnum.project.name());
            contractEntity.setId(null);
            contractEntity.setCreateTime(new Date());
            contractEntity.setUpdateTime(new Date());
            contractEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractEntity.setContractStatus(contractProjectHandleDTO.getContractDTO().getContractStatus());
            contractEntity.setContractEndTime(contractProjectHandleDTO.getContractDetailDTO().getContactsEndTime());
            contractEntity.setContractSupplementarySignatureNumber(this.getContractSupplementarySignatureNumber(contractProjectHandleDTO.getContractDetailDTO().getContractNo()) + "");
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            contractEntity.setCreateId(UserUtils.getLongUserId());
            this.save((Object)contractEntity);
            this.handleContractProject(contractProjectHandleDTO, contractEntity.getId());
            String message = this.startContractWorkFrom(contractEntity.getId());
            if (message == null) {
                return contractEntity.getId().toString();
            }
            throw new RuntimeException(message);
        }
        catch (Exception e) {
            log.error("createContractProject:" + JSON.toJSON((Object)e));
            return null;
        }
    }

    public String getContractSupplementarySignatureNumber(String contractNo) {
        LambdaQueryWrapper wrapperContract = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractEntity::getContractNo, (Object)contractNo);
        List contractDetailEntityList = this.list((Wrapper)wrapperContract);
        if (ObjectUtil.isEmpty((Object)contractDetailEntityList)) {
            return "0";
        }
        return String.valueOf(contractDetailEntityList.size());
    }

    public Boolean updateContractProject(ContractProjectHandleDTO contractProjectHandleDTO) {
        try {
            ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)contractProjectHandleDTO.getContractDTO().getId());
            if (contractEntity == null) {
                throw new RuntimeException("\u5165\u53c2Id\u9519\u8bef\uff0c\u672a\u67e5\u5230\u5f85\u4fee\u6539\u6570\u636e\uff01");
            }
            Long id = contractEntity.getId();
            BeanUtils.copyProperties((Object)contractProjectHandleDTO.getContractDetailDTO(), (Object)contractEntity);
            contractEntity.setContractCategory(ContractParentCategorEnum.project.name());
            contractEntity.setUpdateTime(new Date());
            contractEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractEntity.setContractStatus(contractProjectHandleDTO.getContractDTO().getContractStatus());
            contractEntity.setContractEndTime(contractProjectHandleDTO.getContractDetailDTO().getContactsEndTime());
            contractEntity.setId(id);
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            this.updateById((Object)contractEntity);
            this.deleteProjectByContractId(id);
            this.handleContractProject(contractProjectHandleDTO, id);
            return true;
        }
        catch (Exception e) {
            log.error("updateContractProject:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public Boolean updateContractFromTaskId(ContractFromTaskDTO contractFromTaskDTO) {
        try {
            ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)contractFromTaskDTO.getId());
            if (contractEntity == null) {
                throw new RuntimeException("\u5165\u53c2Id\u9519\u8bef\uff0c\u672a\u67e5\u5230\u5f85\u4fee\u6539\u6570\u636e\uff01");
            }
            contractEntity.setContractFormTaskId(contractFromTaskDTO.getContractFormTaskId());
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            this.updateById((Object)contractEntity);
            return true;
        }
        catch (Exception e) {
            log.error("updateContractProject:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public Boolean updateContractFromTaskStatus(Long id, String businessStatus) {
        try {
            ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)id);
            if (contractEntity == null) {
                throw new RuntimeException("\u5165\u53c2Id\u9519\u8bef\uff0c\u672a\u67e5\u5230\u5f85\u4fee\u6539\u6570\u636e\uff01");
            }
            contractEntity.setContractStatus(businessStatus);
            contractEntity.setUpdateId(UserUtils.getLongUserId());
            this.updateById((Object)contractEntity);
            return true;
        }
        catch (Exception e) {
            log.error("updateContractProject:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public Boolean updateContractFromTaskStatusAndContractStatus(ContractEntity entity) {
        return null;
    }

    public Boolean terminationContractSuppline(ContractTerminationDTO contractTerminationDTO) {
        try {
            if (StringUtils.isEmpty((CharSequence)contractTerminationDTO.getContractNo())) {
                ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)contractTerminationDTO.getId());
                if (StringUtil.isNotEmpty((String)contractTerminationDTO.getContractReasonTermination())) {
                    contractEntity.setContractReasonTermination(contractTerminationDTO.getContractReasonTermination());
                }
                if (StringUtil.isNotEmpty((String)contractTerminationDTO.getContractReasonTerminationRemark())) {
                    contractEntity.setContractReasonTerminationRemark(contractTerminationDTO.getContractReasonTerminationRemark());
                }
                contractEntity.setContractFormStatus(ContractStatusEnum.YZZ.getCode());
                contractEntity.setContractStatus(ContractStatusEnum.YZZ.getCode());
                this.updateById((Object)contractEntity);
            } else {
                LambdaQueryWrapper wrapperContract = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractEntity::getContractNo, (Object)contractTerminationDTO.getContractNo());
                List list = this.list((Wrapper)wrapperContract);
                if (ObjectUtil.isNotEmpty((Object)list)) {
                    list.stream().forEach(entity -> {
                        if (StringUtil.isNotEmpty((String)contractTerminationDTO.getContractReasonTermination())) {
                            entity.setContractReasonTermination(contractTerminationDTO.getContractReasonTermination());
                        }
                        if (StringUtil.isNotEmpty((String)contractTerminationDTO.getContractReasonTerminationRemark())) {
                            entity.setContractReasonTerminationRemark(contractTerminationDTO.getContractReasonTerminationRemark());
                        }
                        entity.setContractFormStatus(ContractStatusEnum.YZZ.getCode());
                        entity.setContractStatus(ContractStatusEnum.YZZ.getCode());
                        this.updateById(entity);
                    });
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error("terminationContractSuppline:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public Boolean deleteContractProject(Long id) {
        try {
            Optional.ofNullable((ContractEntity)this.getById((Serializable)id)).ifPresent(t -> {
                t.setStatus(DataStatusEnum.VALID.getCode());
                this.updateById(t);
            });
            this.removeById((Serializable)id);
            this.deleteProjectByContractId(id);
            return true;
        }
        catch (Exception e) {
            log.error("deleteContractProject:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    public Boolean deleteContractSuppline(Long id) {
        try {
            Optional.ofNullable((ContractEntity)this.getById((Serializable)id)).ifPresent(t -> {
                t.setStatus(DataStatusEnum.VALID.getCode());
                this.updateById(t);
            });
            this.removeById((Serializable)id);
            this.deleteSupplineByContractId(id);
            return true;
        }
        catch (Exception e) {
            log.error("deleteContractProject:" + JSON.toJSON((Object)e));
            return false;
        }
    }

    @Async
    public void handleContractSuppline(ContractSupplineHandleDTO contractSupplineHandleDTO, Long id) {
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getContractDetailDTO())) {
            ContractDetailEntity contractDetailEntity = new ContractDetailEntity();
            ContractDetailDTO contractDetailDTO = contractSupplineHandleDTO.getContractDetailDTO();
            BeanUtils.copyProperties((Object)contractDetailDTO, (Object)contractDetailEntity);
            contractDetailEntity.setContactId(id);
            contractDetailEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractDetailEntity.setUpdateId(UserUtils.getLongUserId());
            contractDetailEntity.setCreateId(UserUtils.getLongUserId());
            this.contractDetailService.save((Object)contractDetailEntity);
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractFileDTOS())) {
            List listContractFileDTOS = contractSupplineHandleDTO.getListContractFileDTOS();
            listContractFileDTOS.forEach(dto -> {
                ContractFileEntity contractFile = new ContractFileEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractFile);
                contractFile.setContactId(id);
                contractFile.setStatus(DataStatusEnum.INVALID.getCode());
                contractFile.setUpdateId(UserUtils.getLongUserId());
                contractFile.setCreateId(UserUtils.getLongUserId());
                this.contractFileService.save((Object)contractFile);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getContractSettlementInformationDTO())) {
            ContractSettlementInformationDTO contractSettlementInformationDTO = contractSupplineHandleDTO.getContractSettlementInformationDTO();
            ContractSettlementInformationEntity contractSettlementInformation = new ContractSettlementInformationEntity();
            BeanUtils.copyProperties((Object)contractSettlementInformationDTO, (Object)contractSettlementInformation);
            contractSettlementInformation.setContactId(id);
            contractSettlementInformation.setStatus(DataStatusEnum.INVALID.getCode());
            contractSettlementInformation.setUpdateId(UserUtils.getLongUserId());
            contractSettlementInformation.setCreateId(UserUtils.getLongUserId());
            this.contractSettlementInformationService.save((Object)contractSettlementInformation);
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractSupplineRegularBroadbandDTOS())) {
            List listContractSupplineRegularBroadbandDTOS = contractSupplineHandleDTO.getListContractSupplineRegularBroadbandDTOS();
            listContractSupplineRegularBroadbandDTOS.forEach(dto -> {
                ContractSupplineRegularBroadbandEntity contractSupplineRegularBroadband = new ContractSupplineRegularBroadbandEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractSupplineRegularBroadband);
                contractSupplineRegularBroadband.setContactId(id);
                contractSupplineRegularBroadband.setStatus(DataStatusEnum.INVALID.getCode());
                contractSupplineRegularBroadband.setUpdateId(UserUtils.getLongUserId());
                contractSupplineRegularBroadband.setCreateId(UserUtils.getLongUserId());
                this.contractSupplineRegularBroadbandService.save((Object)contractSupplineRegularBroadband);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractSupplineADedicatedLineDTOS())) {
            List listContractSupplineADedicatedLineDTOS = contractSupplineHandleDTO.getListContractSupplineADedicatedLineDTOS();
            listContractSupplineADedicatedLineDTOS.forEach(dto -> {
                ContractSupplineADedicatedLineEntity contractSupplineADedicatedLine = new ContractSupplineADedicatedLineEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractSupplineADedicatedLine);
                contractSupplineADedicatedLine.setContactId(id);
                contractSupplineADedicatedLine.setStatus(DataStatusEnum.INVALID.getCode());
                contractSupplineADedicatedLine.setUpdateId(UserUtils.getLongUserId());
                contractSupplineADedicatedLine.setCreateId(UserUtils.getLongUserId());
                this.contractSupplineADedicatedLineService.save((Object)contractSupplineADedicatedLine);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractSupplineOtherDTOS())) {
            List listContractSupplineOtherDTOS = contractSupplineHandleDTO.getListContractSupplineOtherDTOS();
            listContractSupplineOtherDTOS.forEach(dto -> {
                ContractSupplineOtherEntity contractSupplineOther = new ContractSupplineOtherEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractSupplineOther);
                contractSupplineOther.setContactId(id);
                contractSupplineOther.setStatus(DataStatusEnum.INVALID.getCode());
                contractSupplineOther.setUpdateId(UserUtils.getLongUserId());
                contractSupplineOther.setCreateId(UserUtils.getLongUserId());
                this.contractSupplineOtherService.save((Object)contractSupplineOther);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getContractSupplineApplicationInformation())) {
            ContractSupplineApplicationInformationDTO ontractSupplineApplicationInformationDTO = contractSupplineHandleDTO.getContractSupplineApplicationInformation();
            ContractSupplineApplicationInformationEntity contractSupplineApplicationInformation = new ContractSupplineApplicationInformationEntity();
            BeanUtils.copyProperties((Object)ontractSupplineApplicationInformationDTO, (Object)contractSupplineApplicationInformation);
            contractSupplineApplicationInformation.setContactId(id);
            contractSupplineApplicationInformation.setStatus(DataStatusEnum.INVALID.getCode());
            contractSupplineApplicationInformation.setUpdateId(UserUtils.getLongUserId());
            contractSupplineApplicationInformation.setCreateId(UserUtils.getLongUserId());
            this.contractSupplineApplicationInformationService.save((Object)contractSupplineApplicationInformation);
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractSupplineApplicationInformationDTOS())) {
            List listContractSupplineApplicationInformationDTOS = contractSupplineHandleDTO.getListContractSupplineApplicationInformationDTOS();
            listContractSupplineApplicationInformationDTOS.forEach(dto -> {
                ContractSupplineBasicBroadbandInformationEntity contractSupplineBasicBroadbandInformation = new ContractSupplineBasicBroadbandInformationEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractSupplineBasicBroadbandInformation);
                contractSupplineBasicBroadbandInformation.setContactId(id);
                contractSupplineBasicBroadbandInformation.setStatus(DataStatusEnum.INVALID.getCode());
                contractSupplineBasicBroadbandInformation.setUpdateId(UserUtils.getLongUserId());
                contractSupplineBasicBroadbandInformation.setCreateId(UserUtils.getLongUserId());
                this.contractSupplineBasicBroadbandInformationService.save((Object)contractSupplineBasicBroadbandInformation);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getContractSupplineAccountOpeningInformation())) {
            ContractSupplineAccountOpeningInformationDTO contractSupplineAccountOpeningInformationDTO = contractSupplineHandleDTO.getContractSupplineAccountOpeningInformation();
            ContractSupplineAccountOpeningInformationEntity contractSupplineAccountOpeningInformation = new ContractSupplineAccountOpeningInformationEntity();
            BeanUtils.copyProperties((Object)contractSupplineAccountOpeningInformationDTO, (Object)contractSupplineAccountOpeningInformation);
            contractSupplineAccountOpeningInformation.setContactId(id);
            contractSupplineAccountOpeningInformation.setStatus(DataStatusEnum.INVALID.getCode());
            contractSupplineAccountOpeningInformation.setUpdateId(UserUtils.getLongUserId());
            contractSupplineAccountOpeningInformation.setCreateId(UserUtils.getLongUserId());
            this.contractSupplineAccountOpeningInformationService.save((Object)contractSupplineAccountOpeningInformation);
        }
        if (ObjectUtil.isNotEmpty((Object)contractSupplineHandleDTO.getListContractSupplineTariffInformationDTOS())) {
            List listContractSupplineTariffInformationDTOS = contractSupplineHandleDTO.getListContractSupplineTariffInformationDTOS();
            listContractSupplineTariffInformationDTOS.forEach(dto -> {
                ContractSupplineTariffInformationEntity contractSupplineTariffInformation = new ContractSupplineTariffInformationEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractSupplineTariffInformation);
                contractSupplineTariffInformation.setContactId(id);
                contractSupplineTariffInformation.setStatus(DataStatusEnum.INVALID.getCode());
                contractSupplineTariffInformation.setUpdateId(UserUtils.getLongUserId());
                contractSupplineTariffInformation.setCreateId(UserUtils.getLongUserId());
                this.contractSupplineTariffInformationService.save((Object)contractSupplineTariffInformation);
            });
        }
    }

    @Async
    public void handleContractProject(ContractProjectHandleDTO contractProjectHandleDTO, Long id) {
        List listContractFileDTOS;
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getContractDetailDTO())) {
            ContractDetailEntity contractDetailEntity = new ContractDetailEntity();
            ContractDetailDTO contractDetailDTO = contractProjectHandleDTO.getContractDetailDTO();
            BeanUtils.copyProperties((Object)contractDetailDTO, (Object)contractDetailEntity);
            contractDetailEntity.setContactId(id);
            contractDetailEntity.setStatus(DataStatusEnum.INVALID.getCode());
            contractDetailEntity.setUpdateId(UserUtils.getLongUserId());
            contractDetailEntity.setCreateId(UserUtils.getLongUserId());
            this.contractDetailService.save((Object)contractDetailEntity);
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getListContractBusinessInformationDTOS())) {
            List contractBusinessInformationDTOList = contractProjectHandleDTO.getListContractBusinessInformationDTOS();
            contractBusinessInformationDTOList.forEach(dto -> {
                ContractBusinessInformationEntity contractBusinessInformation = new ContractBusinessInformationEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractBusinessInformation);
                contractBusinessInformation.setContactId(id);
                contractBusinessInformation.setStatus(DataStatusEnum.INVALID.getCode());
                contractBusinessInformation.setUpdateId(UserUtils.getLongUserId());
                contractBusinessInformation.setCreateId(UserUtils.getLongUserId());
                this.contractBusinessInformationService.save((Object)contractBusinessInformation);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getListContractFileDTOS())) {
            listContractFileDTOS = contractProjectHandleDTO.getListContractFileDTOS();
            listContractFileDTOS.forEach(dto -> {
                ContractFileEntity contractFile = new ContractFileEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractFile);
                contractFile.setContactId(id);
                contractFile.setStatus(DataStatusEnum.INVALID.getCode());
                contractFile.setUpdateId(UserUtils.getLongUserId());
                contractFile.setCreateId(UserUtils.getLongUserId());
                this.contractFileService.save((Object)contractFile);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getListContractPackageSalesDTOS())) {
            List listContractPackageSalesDTOS = contractProjectHandleDTO.getListContractPackageSalesDTOS();
            listContractPackageSalesDTOS.forEach(dto -> {
                ContractPackageSalesEntity contractFile = new ContractPackageSalesEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractFile);
                contractFile.setContactId(id);
                contractFile.setStatus(DataStatusEnum.INVALID.getCode());
                contractFile.setUpdateId(UserUtils.getLongUserId());
                contractFile.setCreateId(UserUtils.getLongUserId());
                this.contractPackageSalesService.save((Object)contractFile);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getContractProjecyConstructionDTO())) {
            ContractProjecyConstructionDTO contractProjecyConstructionDTO = contractProjectHandleDTO.getContractProjecyConstructionDTO();
            ContractProjecyConstructionEntity contractProjecyConstruction = new ContractProjecyConstructionEntity();
            BeanUtils.copyProperties((Object)contractProjecyConstructionDTO, (Object)contractProjecyConstruction);
            contractProjecyConstruction.setContactId(id);
            contractProjecyConstruction.setStatus(DataStatusEnum.INVALID.getCode());
            contractProjecyConstruction.setUpdateId(UserUtils.getLongUserId());
            contractProjecyConstruction.setCreateId(UserUtils.getLongUserId());
            this.contractProjecyConstructionService.save((Object)contractProjecyConstruction);
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getListContractProjecyTariffStandardsDTOS())) {
            listContractFileDTOS = contractProjectHandleDTO.getListContractProjecyTariffStandardsDTOS();
            listContractFileDTOS.forEach(dto -> {
                ContractProjecyTariffStandardsEntity contractProjecyTariffStandardsEntity = new ContractProjecyTariffStandardsEntity();
                BeanUtils.copyProperties((Object)dto, (Object)contractProjecyTariffStandardsEntity);
                contractProjecyTariffStandardsEntity.setContactId(id);
                contractProjecyTariffStandardsEntity.setStatus(DataStatusEnum.INVALID.getCode());
                contractProjecyTariffStandardsEntity.setUpdateId(UserUtils.getLongUserId());
                contractProjecyTariffStandardsEntity.setCreateId(UserUtils.getLongUserId());
                this.contractProjecyTariffStandardsService.save((Object)contractProjecyTariffStandardsEntity);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getContractRevenueSharingDTO())) {
            ContractRevenueSharingDTO contractRevenueSharingDTO = contractProjectHandleDTO.getContractRevenueSharingDTO();
            ContractRevenueSharingEntity contractRevenueSharing = new ContractRevenueSharingEntity();
            BeanUtils.copyProperties((Object)contractRevenueSharingDTO, (Object)contractRevenueSharing);
            contractRevenueSharing.setContactId(id);
            contractRevenueSharing.setStatus(DataStatusEnum.INVALID.getCode());
            contractRevenueSharing.setUpdateId(UserUtils.getLongUserId());
            contractRevenueSharing.setCreateId(UserUtils.getLongUserId());
            this.contractRevenueSharingService.save((Object)contractRevenueSharing);
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getContractSettlementInformationDTO())) {
            ContractSettlementInformationDTO contractSettlementInformationDTO = contractProjectHandleDTO.getContractSettlementInformationDTO();
            ContractSettlementInformationEntity contractSettlementInformation = new ContractSettlementInformationEntity();
            BeanUtils.copyProperties((Object)contractSettlementInformationDTO, (Object)contractSettlementInformation);
            contractSettlementInformation.setContactId(id);
            contractSettlementInformation.setStatus(DataStatusEnum.INVALID.getCode());
            contractSettlementInformation.setUpdateId(UserUtils.getLongUserId());
            contractSettlementInformation.setCreateId(UserUtils.getLongUserId());
            this.contractSettlementInformationService.save((Object)contractSettlementInformation);
        }
        if (ObjectUtil.isNotEmpty((Object)contractProjectHandleDTO.getContractTotalPriceDTO())) {
            ContractTotalPriceDTO contractTotalPriceDTO = contractProjectHandleDTO.getContractTotalPriceDTO();
            ContractTotalPriceEntity contractTotalPrice = new ContractTotalPriceEntity();
            BeanUtils.copyProperties((Object)contractTotalPriceDTO, (Object)contractTotalPrice);
            contractTotalPrice.setContactId(id);
            contractTotalPrice.setStatus(DataStatusEnum.INVALID.getCode());
            contractTotalPrice.setUpdateId(UserUtils.getLongUserId());
            contractTotalPrice.setCreateId(UserUtils.getLongUserId());
            this.contractTotalPriceService.save((Object)contractTotalPrice);
        }
    }

    private LambdaQueryWrapper getWrapperSupplier(ContractSupplierQuery query) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractEntity::getContractCategory, (Object)ContractParentCategorEnum.suppline.name())).like(ObjectUtil.isNotEmpty((Object)query.getContractNo()), ContractEntity::getContractNo, (Object)query.getContractNo())).like(ObjectUtil.isNotEmpty((Object)query.getContractName()), ContractEntity::getContractName, (Object)query.getContractName())).eq(ObjectUtil.isNotEmpty((Object)query.getContractStatus()), ContractEntity::getContractStatus, (Object)ContractStatusEnum.getCode((String)query.getContractStatus()))).eq(ObjectUtil.isNotEmpty((Object)query.getContractType()), ContractEntity::getContractType, (Object)query.getContractType())).like(ObjectUtil.isNotEmpty((Object)query.getContractSigningPerson()), ContractEntity::getContractSignPerson, (Object)query.getContractSigningPerson())).eq(ObjectUtil.isNotEmpty((Object)query.getContractSupplementarySignatureNumber()), ContractEntity::getContractSupplementarySignatureNumber, (Object)query.getContractSupplementarySignatureNumber())).eq(ObjectUtil.isNotEmpty((Object)query.getSigningType()), ContractEntity::getSigningType, (Object)query.getSigningType())).ge(ObjectUtil.isNotEmpty((Object)query.getContractSigningTimeStart()), ContractEntity::getContractSigningDate, (Object)query.getContractSigningTimeStart())).le(ObjectUtil.isNotEmpty((Object)query.getContractSigningTimeEnd()), ContractEntity::getContractSigningDate, (Object)query.getContractSigningTimeEnd())).orderByDesc(ContractEntity::getCreateTime);
        return wrapper;
    }

    private LambdaQueryWrapper getWrapperProject(ContractProjectQuery query) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractEntity::getStatus, (Object)DataStatusEnum.INVALID.getCode())).eq(ContractEntity::getContractCategory, (Object)ContractParentCategorEnum.project.name())).like(ObjectUtil.isNotEmpty((Object)query.getContractNo()), ContractEntity::getContractNo, (Object)query.getContractNo())).like(ObjectUtil.isNotEmpty((Object)query.getContractName()), ContractEntity::getContractName, (Object)query.getContractName())).eq(ObjectUtil.isNotEmpty((Object)query.getContractStatus()), ContractEntity::getContractStatus, (Object)ContractStatusEnum.getCode((String)query.getContractStatus()))).eq(ObjectUtil.isNotEmpty((Object)query.getContractType()), ContractEntity::getContractType, (Object)query.getContractType())).like(ObjectUtil.isNotEmpty((Object)query.getContractSigningPerson()), ContractEntity::getContractSignPerson, (Object)query.getContractSigningPerson())).eq(ObjectUtil.isNotEmpty((Object)query.getContractSupplementarySignatureNumber()), ContractEntity::getContractSupplementarySignatureNumber, (Object)query.getContractSupplementarySignatureNumber())).eq(ObjectUtil.isNotEmpty((Object)query.getSigningType()), ContractEntity::getSigningType, (Object)query.getSigningType())).ge(ObjectUtil.isNotEmpty((Object)query.getContractSigningTimeStart()), ContractEntity::getContractSigningDate, (Object)query.getContractSigningTimeStart())).le(ObjectUtil.isNotEmpty((Object)query.getContractSigningTimeEnd()), ContractEntity::getContractSigningDate, (Object)query.getContractSigningTimeEnd())).orderByDesc(ContractEntity::getCreateTime);
        return wrapper;
    }

    @Async
    public void deleteSupplineByContractId(Long id) {
        LambdaQueryWrapper wrapperContractDetail = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractDetailEntity::getContactId, (Object)id);
        this.contractDetailService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractDetailService.lambdaUpdate().set(ContractDetailEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractDetailEntity::getContactId, (Object)id));
        this.contractDetailService.remove((Wrapper)wrapperContractDetail);
        LambdaQueryWrapper wrapperContractFile = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractFileEntity::getContactId, (Object)id);
        this.contractFileService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractFileService.lambdaUpdate().set(ContractFileEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractFileEntity::getContactId, (Object)id));
        this.contractFileService.remove((Wrapper)wrapperContractFile);
        LambdaQueryWrapper wrapperContractSettlementInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSettlementInformationEntity::getContactId, (Object)id);
        this.contractSettlementInformationService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSettlementInformationService.lambdaUpdate().set(ContractSettlementInformationEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSettlementInformationEntity::getContactId, (Object)id));
        this.contractSettlementInformationService.remove((Wrapper)wrapperContractSettlementInformation);
        LambdaQueryWrapper wrapperContractSupplineRegularBroadband = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineRegularBroadbandEntity::getContactId, (Object)id);
        this.contractSupplineRegularBroadbandService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineRegularBroadbandService.lambdaUpdate().set(ContractSupplineRegularBroadbandEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineRegularBroadbandEntity::getContactId, (Object)id));
        this.contractSupplineRegularBroadbandService.remove((Wrapper)wrapperContractSupplineRegularBroadband);
        LambdaQueryWrapper wrapperContractSupplineADedicatedLine = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineADedicatedLineEntity::getContactId, (Object)id);
        this.contractSupplineADedicatedLineService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineADedicatedLineService.lambdaUpdate().set(ContractSupplineADedicatedLineEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineADedicatedLineEntity::getContactId, (Object)id));
        this.contractSupplineADedicatedLineService.remove((Wrapper)wrapperContractSupplineADedicatedLine);
        LambdaQueryWrapper wrapperContractSupplineOther = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineOtherEntity::getContactId, (Object)id);
        this.contractSupplineOtherService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineOtherService.lambdaUpdate().set(ContractSupplineOtherEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineOtherEntity::getContactId, (Object)id));
        this.contractSupplineOtherService.remove((Wrapper)wrapperContractSupplineOther);
        LambdaQueryWrapper wrapperContractSupplineApplicationInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineApplicationInformationEntity::getContactId, (Object)id);
        this.contractSupplineApplicationInformationService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineApplicationInformationService.lambdaUpdate().set(ContractSupplineApplicationInformationEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineApplicationInformationEntity::getContactId, (Object)id));
        this.contractSupplineApplicationInformationService.remove((Wrapper)wrapperContractSupplineApplicationInformation);
        LambdaQueryWrapper wrapperContractSupplineBasicBroadbandInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineBasicBroadbandInformationEntity::getContactId, (Object)id);
        this.contractSupplineBasicBroadbandInformationService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineBasicBroadbandInformationService.lambdaUpdate().set(ContractSupplineBasicBroadbandInformationEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineBasicBroadbandInformationEntity::getContactId, (Object)id));
        this.contractSupplineBasicBroadbandInformationService.remove((Wrapper)wrapperContractSupplineBasicBroadbandInformation);
        LambdaQueryWrapper wrapperContractSupplineAccountOpeningInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineAccountOpeningInformationEntity::getContactId, (Object)id);
        this.contractSupplineAccountOpeningInformationService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineAccountOpeningInformationService.lambdaUpdate().set(ContractSupplineAccountOpeningInformationEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineAccountOpeningInformationEntity::getContactId, (Object)id));
        this.contractSupplineAccountOpeningInformationService.remove((Wrapper)wrapperContractSupplineAccountOpeningInformation);
        LambdaQueryWrapper wrapperContractSupplineTariffInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSupplineTariffInformationEntity::getContactId, (Object)id);
        this.contractSupplineTariffInformationService.update((Wrapper)((LambdaUpdateChainWrapper)this.contractSupplineTariffInformationService.lambdaUpdate().set(ContractSupplineTariffInformationEntity::getStatus, (Object)DataStatusEnum.VALID.getCode())).eq(ContractSupplineTariffInformationEntity::getContactId, (Object)id));
        this.contractSupplineTariffInformationService.remove((Wrapper)wrapperContractSupplineTariffInformation);
    }

    @Async
    public void deleteProjectByContractId(Long id) {
        LambdaQueryWrapper wrapperContractDetail = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractDetailEntity::getContactId, (Object)id);
        this.contractDetailService.remove((Wrapper)wrapperContractDetail);
        LambdaQueryWrapper wrapperContractFile = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractFileEntity::getContactId, (Object)id);
        this.contractFileService.remove((Wrapper)wrapperContractFile);
        LambdaQueryWrapper wrapperContractBusinessInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractBusinessInformationEntity::getContactId, (Object)id);
        this.contractBusinessInformationService.remove((Wrapper)wrapperContractBusinessInformation);
        LambdaQueryWrapper wrapperContractPackageSales = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractPackageSalesEntity::getContactId, (Object)id);
        this.contractPackageSalesService.remove((Wrapper)wrapperContractPackageSales);
        LambdaQueryWrapper wrapperContractProjecyConstruction = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractProjecyConstructionEntity::getContactId, (Object)id);
        this.contractProjecyConstructionService.remove((Wrapper)wrapperContractProjecyConstruction);
        LambdaQueryWrapper wrapperContractProjecyTariffStandards = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractProjecyTariffStandardsEntity::getContactId, (Object)id);
        this.contractProjecyTariffStandardsService.remove((Wrapper)wrapperContractProjecyTariffStandards);
        LambdaQueryWrapper wrapperContractRevenueSharing = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractRevenueSharingEntity::getContactId, (Object)id);
        this.contractRevenueSharingService.remove((Wrapper)wrapperContractRevenueSharing);
        LambdaQueryWrapper wrapperContractSettlementInformation = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractSettlementInformationEntity::getContactId, (Object)id);
        this.contractSettlementInformationService.remove((Wrapper)wrapperContractSettlementInformation);
        LambdaQueryWrapper wrapperContractTotalPrice = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContractTotalPriceEntity::getContactId, (Object)id);
        this.contractTotalPriceService.remove((Wrapper)wrapperContractTotalPrice);
    }

    public String startContractWorkFrom(Long id) {
        try {
            ContractEntity contractEntity = (ContractEntity)this.getById((Serializable)id);
            if (!"7,2".contains(contractEntity.getContractStatus())) {
                return null;
            }
            ProcessDTO processDTO = new ProcessDTO();
            processDTO.setBusinessKey(id + "");
            if ("project".equals(contractEntity.getContractCategory())) {
                processDTO.setFormUrl("/backend/#/projectcontract/projcet/approve?id=" + id);
                processDTO.setProcessInstanceName("\u9879\u76ee\u5408\u540c");
            }
            if ("suppline".equals(contractEntity.getContractCategory())) {
                processDTO.setFormUrl("/backend/#/projectcontract/supplier/approve?id=" + id);
                processDTO.setProcessInstanceName("\u4f9b\u5e94\u5546\u5408\u540c");
            }
            processDTO.setProcessDefinitionKey("process_1d1arh4s");
            processDTO.setProjectName(contractEntity.getContractName());
            String startUserId = "1";
            String deptId = "";
            if (SecurityUtils.getLoginUser() != null) {
                startUserId = SecurityUtils.getLoginUser().getUserid() + "";
                deptId = SecurityUtils.getLoginUser().getSysUser().getDeptId() + "";
            } else {
                LoginUser loginUser = UserUtils.getLoginUser();
                if (loginUser != null) {
                    startUserId = loginUser.getUserid() + "";
                    if (loginUser.getSysUser() != null) {
                        deptId = loginUser.getSysUser().getDeptId() + "";
                    }
                }
            }
            JSONObject jSONObject = this.systemService.getUserList(deptId, "121");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("dept_name_1", this.getUserId(jSONObject, startUserId));
            processDTO.setVariables(map);
            String processInstId = this.workFlowService.startProcessTwo(processDTO);
            if (ObjectUtils.isNotEmpty((Object)processInstId)) {
                contractEntity.setProcessInstId(processInstId);
                this.updateById((Object)contractEntity);
            }
            return null;
        }
        catch (Exception e) {
            log.error("startContractWorkFrom:" + JSON.toJSONString((Object)e));
            return e.getLocalizedMessage();
        }
    }

    private String getUserId(JSONObject jSONObjectRS, String startUserId) {
        try {
            String userId = "";
            log.info("getUserId-jSONObjectRS:" + JSON.toJSONString((Object)jSONObjectRS));
            log.info("getUserId-jSONObjectRS:" + jSONObjectRS.getJSONArray("data"));
            List list = JSON.parseArray((String)jSONObjectRS.getJSONArray("data").toJSONString(), SystemRoleUser.class);
            userId = ((SystemRoleUser)list.get(0)).getId() == null ? ((SystemRoleUser)list.get(0)).getUserId() : ((SystemRoleUser)list.get(0)).getId();
            return userId;
        }
        catch (Exception e) {
            log.error("getUserId:" + JSON.toJSONString((Object)e));
            return startUserId;
        }
    }
}

