/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.HandlelnvoicingDto;
import com.ruoyi.dto.supply.AdoptionReturnDTO;
import com.ruoyi.dto.supply.AdoptionReturnItemListDTO;
import com.ruoyi.entity.supply.AdoptionReturnDO;
import com.ruoyi.entity.supply.AdoptionReturnItemListDO;
import com.ruoyi.entity.supply.EquipmentProfitLossDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.mapper.supply.AdoptionReturnMapper;
import com.ruoyi.query.supply.AdoptionReturnQuery;
import com.ruoyi.service.supply.AdoptionReturnItemListService;
import com.ruoyi.service.supply.AdoptionReturnService;
import com.ruoyi.service.supply.EquipmentProfitLossService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.supply.impl.AdoptionReturnServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.vo.supply.AdoptionReturnExportVO;
import com.ruoyi.vo.supply.AdoptionReturnItemListVO;
import com.ruoyi.vo.supply.AdoptionReturnVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AdoptionReturnServiceImpl
extends ServiceImpl<AdoptionReturnMapper, AdoptionReturnDO>
implements AdoptionReturnService {
    private static final Logger log = LoggerFactory.getLogger(AdoptionReturnServiceImpl.class);
    @Resource
    private AdoptionReturnItemListService adoptionReturnItemListService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private EquipmentProfitLossService equipmentProfitLossService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private StockListService stockListService;

    public PageResultVo<AdoptionReturnVO> queryPageAdoptionReturn(AdoptionReturnQuery adoptionReturnQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(adoptionReturnQuery);
        Page page = (Page)this.page((IPage)new Page((long)adoptionReturnQuery.getPageNum(), (long)adoptionReturnQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo adoptionReturnVOPageResultVo = new PageResultVo();
        ArrayList<AdoptionReturnVO> adoptionReturnVOList = new ArrayList<AdoptionReturnVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (AdoptionReturnDO adoptionReturnDO : resultVo.getData()) {
                AdoptionReturnVO adoptionReturnVO = new AdoptionReturnVO();
                BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)adoptionReturnVO);
                adoptionReturnVOList.add(adoptionReturnVO);
            }
        }
        adoptionReturnVOPageResultVo.setData(adoptionReturnVOList);
        adoptionReturnVOPageResultVo.setPageSize(resultVo.getPageSize());
        adoptionReturnVOPageResultVo.setPageNum(resultVo.getPageNum());
        adoptionReturnVOPageResultVo.setTotal(resultVo.getTotal());
        adoptionReturnVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return adoptionReturnVOPageResultVo;
    }

    public R<String> addAdoptionReturn(AdoptionReturnDTO adoptionReturnDTO) throws Exception {
        List adoptionReturnItemListDTOList = adoptionReturnDTO.getAdoptionReturnItemListDTOList();
        if (ObjectUtil.isEmpty((Object)adoptionReturnItemListDTOList)) {
            return R.fail((String)"\u65b0\u5efa\u5931\u8d25\uff0c\u7269\u54c1\u5217\u8868\u4e3a\u7a7a");
        }
        Map<Long, List<AdoptionReturnItemListDTO>> map = adoptionReturnItemListDTOList.stream().filter(f -> f.getMaterialId() != null).collect(Collectors.groupingBy(AdoptionReturnItemListDTO::getMaterialId));
        for (Long aLong : map.keySet()) {
            List<AdoptionReturnItemListDTO> adoptionReturnItemListDTOS = map.get(aLong);
            long adoptionCount = adoptionReturnItemListDTOS.stream().mapToLong(AdoptionReturnItemListDTO::getAdoptionCount).sum();
            if (((AdoptionReturnItemListDTO)adoptionReturnItemListDTOS.get(0)).getCurrentCount() >= adoptionCount) continue;
            return R.fail((String)("\u65b0\u5efa\u5931\u8d25\uff0c\u7269\u8d44\u540d\u79f0\uff1a" + ((AdoptionReturnItemListDTO)adoptionReturnItemListDTOS.get(0)).getMaterialName() + ",\u9886\u7528\u7d2f\u8ba1\u6570\u91cf\u5927\u4e8e\u5f53\u524d\u6570\u91cf"));
        }
        boolean hasInsufficientStock = false;
        String insufficientStockMessage = "";
        for (AdoptionReturnItemListDTO a : adoptionReturnDTO.getAdoptionReturnItemListDTOList()) {
            LambdaQueryWrapper wrappers = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)a.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrappers);
            if (!ObjectUtil.isNotEmpty((Object)stockListDO) || stockListDO.getCurrentStock() >= a.getAdoptionCount()) continue;
            hasInsufficientStock = true;
            insufficientStockMessage = "\u7269\u8d44\u5e93\u5b58\u5c11\u4e8e\u9886\u53d6\u6570\uff0c\u9886\u53d6\u5931\u8d25";
            break;
        }
        if (hasInsufficientStock) {
            return R.fail((String)insufficientStockMessage);
        }
        AdoptionReturnDO adoptionReturnDO = new AdoptionReturnDO();
        BeanUtils.copyProperties((Object)adoptionReturnDTO, (Object)adoptionReturnDO);
        adoptionReturnDO.setCreateTime(new Date());
        adoptionReturnDO.setUpdateTime(new Date());
        adoptionReturnDO.setIsDeleted(Integer.valueOf(0));
        adoptionReturnDO.setReturnStatus("\u5ba1\u6838\u4e2d");
        String adoptionReturnNumber = this.getAdoptionReturnNumber();
        adoptionReturnDO.setNumber(adoptionReturnNumber);
        adoptionReturnDO.setIsDeleted(Integer.valueOf(0));
        ThemeUtils themes = new ThemeUtils();
        adoptionReturnDO.setSubjectName(ThemeUtils.getThemeName((String)"\u9886\u7528\u7533\u8bf7"));
        this.save((Object)adoptionReturnDO);
        this.saveAdoptionItem(adoptionReturnDTO.getAdoptionReturnItemListDTOList(), adoptionReturnNumber);
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(adoptionReturnDO.getSubjectName());
        HashMap<String, Integer> stringStringHashMap = new HashMap<String, Integer>();
        stringStringHashMap.put("mold", adoptionReturnDTO.getMold());
        processDTO.setFormData(stringStringHashMap);
        processDTO.setProjectName(adoptionReturnDO.getProjectName());
        processDTO.setBusinessKey(adoptionReturnDO.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.construction_log, processDTO, new Object[]{adoptionReturnDO.getId()});
        if (ObjectUtil.isNotEmpty((Object)processId)) {
            adoptionReturnDO.setProcessInstId(processId);
            this.updateById((Object)adoptionReturnDO);
        }
        System.out.println(processId);
        return R.ok((Object)"\u65b0\u5efa\u6210\u529f");
    }

    public AdoptionReturnVO selectAdoptionReturnDetail(Long id) {
        List list = this.adoptionReturnItemListService.list((Wrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)id));
        AdoptionReturnDO adoptionReturnDO = (AdoptionReturnDO)this.getById((Serializable)id);
        AdoptionReturnVO adoptionReturnVO = new AdoptionReturnVO();
        BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)adoptionReturnVO);
        ArrayList<AdoptionReturnItemListVO> adoptionReturnItemListVOList = new ArrayList<AdoptionReturnItemListVO>();
        for (AdoptionReturnItemListDO adoptionReturnItemListDO : list) {
            AdoptionReturnItemListVO adoptionReturnItemListVO = new AdoptionReturnItemListVO();
            BeanUtils.copyProperties((Object)adoptionReturnItemListDO, (Object)adoptionReturnItemListVO);
            adoptionReturnItemListVOList.add(adoptionReturnItemListVO);
        }
        adoptionReturnVO.setAdoptionReturnItemListVOList(adoptionReturnItemListVOList);
        return adoptionReturnVO;
    }

    public AdoptionReturnVO selectAdoptionReturnItemList(Long id) {
        AdoptionReturnVO adoptionReturnVO = new AdoptionReturnVO();
        AdoptionReturnDO adoptionReturnDO = (AdoptionReturnDO)this.getById((Serializable)id);
        BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)adoptionReturnVO);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getId, (Object)id);
        List adoptionReturnItemListDOS = this.adoptionReturnItemListService.list((Wrapper)wrapper);
        List adoptionReturnItemListVOList = adoptionReturnItemListDOS.stream().map(m -> {
            AdoptionReturnItemListVO adoptionReturnItemListVO = new AdoptionReturnItemListVO();
            BeanUtils.copyProperties((Object)m, (Object)adoptionReturnItemListVO);
            return adoptionReturnItemListVO;
        }).collect(Collectors.toList());
        adoptionReturnVO.setAdoptionReturnItemListVOList(adoptionReturnItemListVOList);
        return adoptionReturnVO;
    }

    public AdoptionReturnVO getAdoptionReturnItemList(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getId, (Object)id);
        List list = this.adoptionReturnItemListService.list((Wrapper)wrapper);
        AdoptionReturnVO adoptionReturnVO = new AdoptionReturnVO();
        if (ObjectUtil.isNotEmpty((Object)list) && null != ((AdoptionReturnItemListDO)list.get(0)).getMainId()) {
            AdoptionReturnDO byId = (AdoptionReturnDO)this.getById((Serializable)((AdoptionReturnItemListDO)list.get(0)).getMainId());
            BeanUtils.copyProperties((Object)byId, (Object)adoptionReturnVO);
        }
        adoptionReturnVO.setAdoptionReturnItemListDOList(list);
        return adoptionReturnVO;
    }

    public void exportAdoptionReturn(AdoptionReturnQuery adoptionReturnQuery, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper wrapper = this.getWrapper(adoptionReturnQuery);
        List adoptionReturnDOList = this.list((Wrapper)wrapper);
        List<Object> adoptionReturnExportVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)adoptionReturnDOList)) {
            adoptionReturnExportVOList = adoptionReturnDOList.stream().map(adoptionReturnDO -> {
                AdoptionReturnExportVO adoptionReturnExportVO = new AdoptionReturnExportVO();
                BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)adoptionReturnExportVO);
                return adoptionReturnExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u9886\u7528\u5f52\u8fd8", "\u9886\u7528\u5f52\u8fd8", ExcelType.XSSF), AdoptionReturnExportVO.class, adoptionReturnExportVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u9886\u7528\u5f52\u8fd8-" + dateFormat.format(date)));
    }

    public void workFromCallBackReturn(WorkFlowCallBackVO callBackVO) throws Exception {
        String event = callBackVO.getEvent();
        AdoptionReturnItemListDO byId = (AdoptionReturnItemListDO)this.adoptionReturnItemListService.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Integer approveStatus;
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                if (taskVariables.size() <= 0 || 2 != (approveStatus = (Integer)taskVariables.get("approveStatus"))) break;
                byId.setReturnStatus(Integer.valueOf(1));
                this.adoptionReturnItemListService.updateById((Object)byId);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                LambdaQueryWrapper wrapper;
                StockListDO stockListDO;
                byId.setReturnStatus(Integer.valueOf(0));
                byId.setCurrentCount(Long.valueOf(byId.getCurrentCount() + byId.getAdoptionCount()));
                boolean b = this.adoptionReturnItemListService.updateById((Object)byId);
                if (b) {
                    LambdaQueryWrapper adoptionReturnItemListDOLambdaQueryWrapper = new LambdaQueryWrapper();
                    adoptionReturnItemListDOLambdaQueryWrapper.eq(AdoptionReturnItemListDO::getReturnStatus, (Object)1);
                    adoptionReturnItemListDOLambdaQueryWrapper.eq(AdoptionReturnItemListDO::getMainId, (Object)byId.getMainId());
                    List list = this.adoptionReturnItemListService.list((Wrapper)adoptionReturnItemListDOLambdaQueryWrapper);
                    if (ObjectUtil.isEmpty((Object)list)) {
                        AdoptionReturnDO byId1 = (AdoptionReturnDO)this.getById((Serializable)byId.getMainId());
                        byId1.setReturnStatus("\u5df2\u5f52\u8fd8");
                        this.updateById((Object)byId1);
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)byId.getMaterialId())))))) {
                    stockListDO.setCurrentStock(Long.valueOf(stockListDO.getCurrentStock() + byId.getAdoptionCount()));
                    this.stockListService.updateById((Object)stockListDO);
                }
                try {
                    ArrayList<HandlelnvoicingDto> handlelnvoicingDtoList = new ArrayList<HandlelnvoicingDto>();
                    HandlelnvoicingDto handlelnvoicingDto = new HandlelnvoicingDto();
                    handlelnvoicingDto.setCount(byId.getAdoptionCount());
                    handlelnvoicingDto.setMaterialId(byId.getMaterialId());
                    handlelnvoicingDto.setType(4);
                    handlelnvoicingDtoList.add(handlelnvoicingDto);
                    this.handleInvoicingStatistics.updateOutWarehouseDataHandle(handlelnvoicingDtoList);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void inStockCount(Long id) {
        List adoptionReturnItemListDOS = this.adoptionReturnItemListService.list((Wrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)id));
        if (ObjectUtil.isEmpty((Object)adoptionReturnItemListDOS)) {
            return;
        }
        ArrayList stockListDOList = new ArrayList();
        adoptionReturnItemListDOS.stream().map(m -> {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)m.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrapper);
            stockListDO.setCurrentStock(Long.valueOf(stockListDO.getCurrentStock() + m.getAdoptionCount()));
            stockListDOList.add(stockListDO);
            return m;
        }).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(stockListDOList)) {
            this.stockListService.updateBatchById(stockListDOList);
        }
    }

    public void outStockCount(Long id) {
        List adoptionReturnItemListDOS = this.adoptionReturnItemListService.list((Wrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)id));
        if (ObjectUtil.isEmpty((Object)adoptionReturnItemListDOS)) {
            return;
        }
    }

    public void addStockCount(Long id) {
        List adoptionReturnItemListDOS = this.adoptionReturnItemListService.list((Wrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)id));
        if (ObjectUtil.isEmpty((Object)adoptionReturnItemListDOS)) {
            return;
        }
        ArrayList stockListDOList = new ArrayList();
        adoptionReturnItemListDOS.stream().map(m -> {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)m.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrapper);
            stockListDO.setCurrentStock(Long.valueOf(stockListDO.getCurrentStock() + m.getAdoptionCount()));
            stockListDOList.add(stockListDO);
            return m;
        }).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(stockListDOList)) {
            this.stockListService.updateBatchById(stockListDOList);
        }
    }

    public void workFromCallBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        AdoptionReturnDO byId = (AdoptionReturnDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Integer approveStatus;
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                if (taskVariables.size() <= 0 || 2 != (approveStatus = (Integer)taskVariables.get("approveStatus"))) break;
                byId.setReturnStatus("\u5ba1\u6838\u4e2d");
                this.updateById((Object)byId);
                break;
            }
            case 3: {
                byId.setReturnStatus("\u5ba1\u6838\u4e2d");
                this.updateById((Object)byId);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                List list = this.adoptionReturnItemListService.list((Wrapper)new LambdaQueryWrapper().eq(AdoptionReturnItemListDO::getMainId, (Object)byId.getId()));
                byId.setReturnStatus("\u672a\u5f52\u8fd8");
                this.updateById((Object)byId);
                try {
                    ArrayList handlelnvoicingDtoList = new ArrayList();
                    list.forEach(a -> {
                        HandlelnvoicingDto handlelnvoicingDto = new HandlelnvoicingDto();
                        handlelnvoicingDto.setCount(a.getAdoptionCount());
                        handlelnvoicingDto.setMaterialId(a.getMaterialId());
                        handlelnvoicingDto.setType(3);
                        handlelnvoicingDtoList.add(handlelnvoicingDto);
                    });
                    this.handleInvoicingStatistics.updateOutWarehouseDataHandle(handlelnvoicingDtoList);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private LambdaQueryWrapper getWrapper(AdoptionReturnQuery adoptionReturnQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getIds()), AdoptionReturnDO::getId, (Collection)adoptionReturnQuery.getIds())).like(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getNumber()), AdoptionReturnDO::getNumber, (Object)adoptionReturnQuery.getNumber())).like(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getApplicants()), AdoptionReturnDO::getApplicants, (Object)adoptionReturnQuery.getApplicants())).like(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getSubjectName()), AdoptionReturnDO::getSubjectName, (Object)adoptionReturnQuery.getSubjectName())).eq(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getProjectName()), AdoptionReturnDO::getProjectName, (Object)adoptionReturnQuery.getProjectName())).eq(ObjectUtil.isNotEmpty((Object)adoptionReturnQuery.getReturnStatus()), AdoptionReturnDO::getReturnStatus, (Object)adoptionReturnQuery.getReturnStatus())).orderByDesc(AdoptionReturnDO::getCreateTime);
        return wrapper;
    }

    public String getAdoptionReturnNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(AdoptionReturnDO::getNumber, (Object)"LYGH-")).orderByDesc(AdoptionReturnDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.list((Wrapper)wrapper))) {
            return "LYGH-" + simpleDateFormat.format(date) + "-001";
        }
        String recentAdoptionReturnNumber = ((AdoptionReturnDO)this.list((Wrapper)wrapper).get(0)).getNumber();
        String substring = recentAdoptionReturnNumber.substring(recentAdoptionReturnNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "LYGH-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }

    private Long saveAdoptionItem(List<AdoptionReturnItemListDTO> adoptionReturnItemListDTOList, String adoptionReturnNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(AdoptionReturnDO::getNumber, (Object)adoptionReturnNumber);
        Long mainId = ((AdoptionReturnDO)this.getOne((Wrapper)wrapper)).getId();
        List adoptionReturnItemListDOS = adoptionReturnItemListDTOList.stream().map(m -> {
            AdoptionReturnItemListDO adoptionReturnItemListDO = new AdoptionReturnItemListDO();
            BeanUtils.copyProperties((Object)m, (Object)adoptionReturnItemListDO);
            if (adoptionReturnItemListDO.getCurrentCount() >= adoptionReturnItemListDO.getAdoptionCount()) {
                adoptionReturnItemListDO.setCurrentCount(Long.valueOf(adoptionReturnItemListDO.getCurrentCount() - adoptionReturnItemListDO.getAdoptionCount()));
            }
            adoptionReturnItemListDO.setUpdateTime(new Date());
            adoptionReturnItemListDO.setMainId(mainId);
            adoptionReturnItemListDO.setIsDeleted(Integer.valueOf(0));
            adoptionReturnItemListDO.setReturnStatus(Integer.valueOf(1));
            adoptionReturnItemListDO.setUnitMeasurement(m.getUnit());
            LambdaQueryWrapper wrappers = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)adoptionReturnItemListDO.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrappers);
            if (ObjectUtil.isNotEmpty((Object)stockListDO) && stockListDO.getCurrentStock() >= adoptionReturnItemListDO.getAdoptionCount()) {
                stockListDO.setCurrentStock(Long.valueOf(stockListDO.getCurrentStock() - adoptionReturnItemListDO.getAdoptionCount()));
                this.stockListService.updateById((Object)stockListDO);
            }
            return adoptionReturnItemListDO;
        }).collect(Collectors.toList());
        this.adoptionReturnItemListService.saveBatch(adoptionReturnItemListDOS);
        return mainId;
    }

    public String getEquipmentProfitLossNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(EquipmentProfitLossDO::getNumber, (Object)"SBSY-")).orderByDesc(EquipmentProfitLossDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)this.equipmentProfitLossService.list((Wrapper)wrapper))) {
            return "SBSY-" + simpleDateFormat.format(date) + "-001";
        }
        String recentNumber = ((EquipmentProfitLossDO)this.equipmentProfitLossService.list((Wrapper)wrapper).get(0)).getNumber();
        String substring = recentNumber.substring(recentNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "SBSY-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }
}

