/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.HandlelnvoicingDto;
import com.ruoyi.dto.supply.EquipmentProfitLossMaterialListDTO;
import com.ruoyi.dto.supply.InWarehouseManagementDTO;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.entity.supply.InWarehouseManagementDO;
import com.ruoyi.entity.supply.InWarehouseManagementDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationHandleDetailDO;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.enums.supply.InWarhouseTypeEnum;
import com.ruoyi.handle.supply.HandleInvoicingStatistics;
import com.ruoyi.mapper.supply.InWarehouseManagementMapper;
import com.ruoyi.mapper.supply.PurchaseOrderMapper;
import com.ruoyi.query.supply.InWarehouseManagementQuery;
import com.ruoyi.service.supply.InWarehouseManagementDetailService;
import com.ruoyi.service.supply.InWarehouseManagementService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.MaterialsApplicationHandleDetailService;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.supply.impl.InWarehouseManagementServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.InWarehouseManagementDetailVO;
import com.ruoyi.vo.supply.InWarehouseManagementExportVO;
import com.ruoyi.vo.supply.InWarehouseManagementVO;
import com.ruoyi.vo.supply.UniqueCodeVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class InWarehouseManagementServiceImpl
extends ServiceImpl<InWarehouseManagementMapper, InWarehouseManagementDO>
implements InWarehouseManagementService {
    private static final Logger log = LoggerFactory.getLogger(InWarehouseManagementServiceImpl.class);
    @Resource
    private InWarehouseManagementDetailService inWarehouseManagementDetailService;
    @Resource
    private SupplyUtils supplyUtils;
    @Resource
    private MaterialsApplicationHandleDetailService materialsApplicationHandleDetailService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private HandleInvoicingStatistics handleInvoicingStatistics;
    @Resource
    private PurchaseOrderMapper purchaseOrderMapper;
    @Resource
    private MaterialsApplicationMaterialOrderService materialsApplicationMaterialOrderService;
    @Resource
    private MaterialCodeService materialCodeService;
    @Resource
    private StockListService stockListService;

    public PageResultVo<InWarehouseManagementVO> pageQueryInWarehouseManagement(InWarehouseManagementQuery inWarehouseManagementQuery) {
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getInWarehouseType()) && inWarehouseManagementQuery.getInWarehouseType().equals(InWarhouseTypeEnum.totalType.getMsg())) {
            inWarehouseManagementQuery.setInWarehouseType(null);
        }
        LambdaQueryWrapper wrapper = this.getWrapper(inWarehouseManagementQuery);
        Page page = (Page)this.page((IPage)new Page((long)inWarehouseManagementQuery.getPageNum(), (long)inWarehouseManagementQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo inWarehouseManagementVOPageResultVo = new PageResultVo();
        ArrayList<InWarehouseManagementVO> inWarehouseManagementVOList = new ArrayList<InWarehouseManagementVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (InWarehouseManagementDO inWarehouseManagementDO : resultVo.getData()) {
                InWarehouseManagementVO inWarehouseManagementVO = new InWarehouseManagementVO();
                BeanUtils.copyProperties((Object)inWarehouseManagementDO, (Object)inWarehouseManagementVO);
                inWarehouseManagementVOList.add(inWarehouseManagementVO);
            }
        }
        inWarehouseManagementVOPageResultVo.setData(inWarehouseManagementVOList);
        inWarehouseManagementVOPageResultVo.setPageSize(resultVo.getPageSize());
        inWarehouseManagementVOPageResultVo.setPageNum(resultVo.getPageNum());
        inWarehouseManagementVOPageResultVo.setTotal(resultVo.getTotal());
        inWarehouseManagementVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return inWarehouseManagementVOPageResultVo;
    }

    public void exportInWarehouseManagement(InWarehouseManagementQuery inWarehouseManagementQuery, HttpServletResponse response) throws IOException {
        List inWarehouseManagementDOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery)) {
            LambdaQueryWrapper wrapper = this.getWrapper(inWarehouseManagementQuery);
            inWarehouseManagementDOList = this.list((Wrapper)wrapper);
        } else {
            inWarehouseManagementDOList = this.list();
        }
        List<Object> inWarehouseManagementExportVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty(inWarehouseManagementDOList)) {
            inWarehouseManagementExportVOList = inWarehouseManagementDOList.stream().map(inWarehouseManagementDO -> {
                InWarehouseManagementExportVO inWarehouseManagementExportVO = new InWarehouseManagementExportVO();
                BeanUtils.copyProperties((Object)inWarehouseManagementDO, (Object)inWarehouseManagementExportVO);
                return inWarehouseManagementExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u5165\u5e93\u7ba1\u7406\uff1a\u5165\u5e93\u5217\u8868", "\u5165\u5e93\u5217\u8868", ExcelType.XSSF), InWarehouseManagementExportVO.class, inWarehouseManagementExportVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u5165\u5e93\u7ba1\u7406-" + dateFormat.format(date)));
    }

    @Transactional(rollbackFor={Exception.class})
    public void addInWarehouseManagement(InWarehouseManagementDTO inWarehouseManagementDTO) throws Exception {
        String username;
        InWarehouseManagementDO inWarehouseManagementDO = new InWarehouseManagementDO();
        BeanUtils.copyProperties((Object)inWarehouseManagementDTO, (Object)inWarehouseManagementDO);
        inWarehouseManagementDO.setCreateTime(new Date());
        inWarehouseManagementDO.setUpdateTime(new Date());
        inWarehouseManagementDO.setIsDeleted(Integer.valueOf(0));
        inWarehouseManagementDO.setPrintsCount(Integer.valueOf(0));
        ThemeUtils themes = new ThemeUtils();
        inWarehouseManagementDO.setSubjectName(ThemeUtils.getThemeName((String)"\u5165\u5e93\u7533\u8bf7"));
        LoginUser loginUser = UserUtils.getLoginUser();
        if (ObjectUtil.isNotEmpty((Object)loginUser) && StringUtils.isNotBlank((CharSequence)(username = loginUser.getUsername()))) {
            inWarehouseManagementDO.setCreateName(username);
        }
        inWarehouseManagementDO.setInWarehouseDate(new Date());
        String inWarehouseManagementNumber = this.getInWarehouseManagementNumber();
        inWarehouseManagementDO.setInWarehouseNumber(inWarehouseManagementNumber);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderMapper.selectById((Serializable)inWarehouseManagementDO.getPurchaseOrderId());
        inWarehouseManagementDO.setMaterialOrderId(purchaseOrderDO.getAssociatedMaterialApplicationOrderId());
        this.save((Object)inWarehouseManagementDO);
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDTO.getInWarehouseManagementDetailDTOList())) {
            Long mainId = this.storageDetails(inWarehouseManagementDTO, inWarehouseManagementNumber);
            inWarehouseManagementDTO.setId(mainId);
        }
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDTO.getMaterialOrderId()) || ObjectUtil.isNotEmpty((Object)inWarehouseManagementDTO.getPurchaseOrderId())) {
            inWarehouseManagementDTO.setInWarehouseNumber(inWarehouseManagementNumber);
            this.updateMaterialHandleDetail(inWarehouseManagementDTO);
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO)) {
            purchaseOrderDO.setStatus(1);
            this.purchaseOrderMapper.updateById((Object)purchaseOrderDO);
        }
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(inWarehouseManagementDO.getSubjectName());
        processDTO.setProjectName(inWarehouseManagementDTO.getProjectName());
        processDTO.setBusinessKey(inWarehouseManagementDTO.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.management, processDTO, new Object[]{inWarehouseManagementDTO.getId().toString()});
        System.out.println(processId);
        if (ObjectUtil.isNotEmpty((Object)processId)) {
            inWarehouseManagementDO.setProcessInstId(processId);
            this.updateById((Object)inWarehouseManagementDO);
        }
    }

    private void updateMaterialHandleDetail(InWarehouseManagementDTO inWarehouseManagementDTO) {
        MaterialsApplicationHandleDetailDO materialsApplicationHandleDetailDO = new MaterialsApplicationHandleDetailDO();
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDTO.getPurchaseOrderId())) {
            PurchaseOrderDTO purchaseOrderDTO = this.supplyUtils.getPurchaseNumberNew(inWarehouseManagementDTO.getPurchaseOrderId());
            if (ObjectUtil.isNotEmpty((Object)purchaseOrderDTO.getPurchaseNumber())) {
                materialsApplicationHandleDetailDO.setPurchaseNumber(purchaseOrderDTO.getPurchaseNumber());
            }
            if (ObjectUtil.isNotEmpty((Object)purchaseOrderDTO.getAssociatedMaterialApplicationOrderId())) {
                materialsApplicationHandleDetailDO.setMainId(purchaseOrderDTO.getAssociatedMaterialApplicationOrderId());
            }
        }
        materialsApplicationHandleDetailDO.setInWarehouseNumber(inWarehouseManagementDTO.getInWarehouseNumber());
        materialsApplicationHandleDetailDO.setHandleTime(new Date());
        materialsApplicationHandleDetailDO.setHandleInformation("\u4ed3\u5e93\u5165\u5e93\uff0c\u5165\u5e93\u4eba\uff1asssss ");
        materialsApplicationHandleDetailDO.setUpdateTime(new Date());
        materialsApplicationHandleDetailDO.setCreateTime(new Date());
        materialsApplicationHandleDetailDO.setIsDeleted(Integer.valueOf(0));
        this.materialsApplicationHandleDetailService.save((Object)materialsApplicationHandleDetailDO);
    }

    private Long storageDetails(InWarehouseManagementDTO inWarehouseManagementDTO, String inWarehouseManagementNumber) throws ParseException {
        LambdaQueryWrapper inWarehouseManagementDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)inWarehouseManagementNumber), InWarehouseManagementDO::getInWarehouseNumber, (Object)inWarehouseManagementNumber);
        InWarehouseManagementDO warehouseManagementDO = (InWarehouseManagementDO)this.getOne((Wrapper)inWarehouseManagementDOLambdaQueryWrapper);
        Long mainId = warehouseManagementDO.getId();
        List inWarehouseManagementDetailDTOList = inWarehouseManagementDTO.getInWarehouseManagementDetailDTOList();
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDetailDTOList)) {
            List inWarehouseManagementDetailDOList = inWarehouseManagementDetailDTOList.stream().map(m -> {
                InWarehouseManagementDetailDO inWarehouseManagementDetailDO = new InWarehouseManagementDetailDO();
                BeanUtils.copyProperties((Object)m, (Object)inWarehouseManagementDetailDO);
                if (ObjectUtil.isNotEmpty((Object)m.getRecoveryNumber())) {
                    inWarehouseManagementDetailDO.setRecoveryNumber(m.getRecoveryNumber());
                    inWarehouseManagementDetailDO.setMaterialName(m.getMaterialsName());
                    inWarehouseManagementDetailDO.setMaterialSpecifications(m.getMaterialsSpecifications());
                    inWarehouseManagementDetailDO.setMaterialSpecifications(m.getUnit());
                    inWarehouseManagementDetailDO.setPrice(new BigDecimal(m.getUnitPrice()));
                }
                inWarehouseManagementDetailDO.setCreateTime(new Date());
                inWarehouseManagementDetailDO.setUpdateTime(new Date());
                inWarehouseManagementDetailDO.setIsDeleted(Integer.valueOf(0));
                if (ObjectUtil.isNotEmpty((Object)warehouseManagementDO.getId())) {
                    inWarehouseManagementDetailDO.setMainId(warehouseManagementDO.getId());
                }
                return inWarehouseManagementDetailDO;
            }).collect(Collectors.toList());
            this.inWarehouseManagementDetailService.saveBatch(inWarehouseManagementDetailDOList);
        }
        return mainId;
    }

    public void clickToPrint(List<Long> ids) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty(ids), InWarehouseManagementDO::getId, ids);
        List inWarehouseManagementDOList = this.list((Wrapper)wrapper);
        inWarehouseManagementDOList = inWarehouseManagementDOList.stream().map(m -> {
            Integer printsCount = m.getPrintsCount() + 1;
            m.setPrintsCount(printsCount);
            m.setUpdateTime(new Date());
            return m;
        }).collect(Collectors.toList());
        this.updateBatchById(inWarehouseManagementDOList);
    }

    public List<String> getTheHandlers() {
        List inWarehouseManagementDOList = this.list();
        List<String> attnNameList = inWarehouseManagementDOList.stream().map(m -> m.getAttn()).distinct().collect(Collectors.toList());
        return attnNameList;
    }

    public InWarehouseManagementVO selectDetail(Long id) {
        InWarehouseManagementVO inWarehouseManagementVO = new InWarehouseManagementVO();
        InWarehouseManagementDO inWarehouseManagementDO = (InWarehouseManagementDO)this.getById((Serializable)id);
        if (ObjectUtil.isEmpty((Object)inWarehouseManagementDO)) {
            return new InWarehouseManagementVO();
        }
        BeanUtils.copyProperties((Object)inWarehouseManagementDO, (Object)inWarehouseManagementVO);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderMapper.selectById((Serializable)inWarehouseManagementVO.getPurchaseOrderId());
        if (StringUtils.isNotBlank((CharSequence)purchaseOrderDO.getPurchaseNumber())) {
            inWarehouseManagementVO.setPurchaseOrder(purchaseOrderDO.getPurchaseNumber());
        }
        List inWarehouseManagementDetailDOS = this.inWarehouseManagementDetailService.list((Wrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)id), InWarehouseManagementDetailDO::getMainId, (Object)id));
        List inWarehouseManagementDetailVOList = inWarehouseManagementDetailDOS.stream().map(m -> {
            InWarehouseManagementDetailVO inWarehouseManagementDetailVO = new InWarehouseManagementDetailVO();
            BeanUtils.copyProperties((Object)m, (Object)inWarehouseManagementDetailVO);
            return inWarehouseManagementDetailVO;
        }).collect(Collectors.toList());
        inWarehouseManagementVO.setInWarehouseManagementDetailVOList(inWarehouseManagementDetailVOList);
        return inWarehouseManagementVO;
    }

    public List<EquipmentProfitLossMaterialListDTO> getMaterialList(Long id) {
        if (ObjectUtil.isEmpty((Object)id)) {
            log.error("id\u4e3a\u7a7a");
            return null;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)id), InWarehouseManagementDetailDO::getMainId, (Object)id);
        List inWarehouseManagementDetailDOList = this.inWarehouseManagementDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)inWarehouseManagementDetailDOList)) {
            log.info("\u7269\u54c1\u5217\u8868\u4e3a\u7a7a!");
            return null;
        }
        List<EquipmentProfitLossMaterialListDTO> equipmentProfitLossMaterialListDTOS = inWarehouseManagementDetailDOList.stream().map(m -> {
            EquipmentProfitLossMaterialListDTO equipmentProfitLossMaterialListDTO = new EquipmentProfitLossMaterialListDTO();
            StockListDO one = (StockListDO)this.stockListService.getOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)m.getMaterialId()));
            BeanUtils.copyProperties((Object)m, (Object)equipmentProfitLossMaterialListDTO);
            equipmentProfitLossMaterialListDTO.setCurrentStock(one.getCurrentStock());
            return equipmentProfitLossMaterialListDTO;
        }).collect(Collectors.toList());
        return equipmentProfitLossMaterialListDTOS;
    }

    public List<InWarehouseManagementVO> getInWarehouseManagementOrder() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -2);
        Date twoMonthsAgo = calendar.getTime();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(ObjectUtil.isNotEmpty((Object)twoMonthsAgo), InWarehouseManagementDO::getCreateTime, (Object)twoMonthsAgo)).le(InWarehouseManagementDO::getCreateTime, (Object)new Date())).orderByDesc(InWarehouseManagementDO::getCreateTime);
        List inWarehouseManagementDOList = this.list((Wrapper)wrapper);
        List<InWarehouseManagementVO> inWarehouseManagementVOList = inWarehouseManagementDOList.stream().map(m -> {
            InWarehouseManagementVO inWarehouseManagementVO = new InWarehouseManagementVO();
            inWarehouseManagementVO.setId(m.getId());
            inWarehouseManagementVO.setSubjectName(m.getSubjectName());
            return inWarehouseManagementVO;
        }).collect(Collectors.toList());
        return inWarehouseManagementVOList;
    }

    public InWarehouseManagementDO getInWarehouseProjectHandleDTOByProcessInstanceId(String processInstanceId) {
        InWarehouseManagementDTO inWarehouseManagementDTO = new InWarehouseManagementDTO();
        Object inWarehouseManagementDO = null;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InWarehouseManagementDO::getInWarehouseFormTaskId, (Object)processInstanceId);
        List inWarehouseManagementDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)inWarehouseManagementDOList) && inWarehouseManagementDOList.size() > 0) {
            return (InWarehouseManagementDO)inWarehouseManagementDOList.get(0);
        }
        return null;
    }

    public List<InWarehouseManagementDetailDO> getInWarehouseDetail(InWarehouseManagementDTO inWarehouseManagementDTO) {
        LambdaQueryWrapper inWarehouseManagementDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InWarehouseManagementDO::getInWarehouseNumber, (Object)inWarehouseManagementDTO.getInWarehouseNumber());
        InWarehouseManagementDO inWarehouseManagementDO = (InWarehouseManagementDO)this.getOne((Wrapper)inWarehouseManagementDOLambdaQueryWrapper);
        Long mainId = inWarehouseManagementDO.getId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(InWarehouseManagementDetailDO::getMainId, (Object)mainId);
        List inWarehouseManagementDetailDOS = this.inWarehouseManagementDetailService.list((Wrapper)wrapper);
        return inWarehouseManagementDetailDOS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u552f\u4e00\u7801\u91c7\u96c6\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource(fileName);
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<String> importStock(MultipartFile file) {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), UniqueCodeVO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            log.error("\u552f\u4e00\u7801\u5bfc\u5165\u51fa\u9519\uff1a" + JSON.toJSON((Object)e));
            return new ArrayList<String>();
        }
        List uniqueCodeVOList = importResult.getList();
        if (ObjectUtil.isNotEmpty((Object)uniqueCodeVOList)) {
            ArrayList<String> uniqueCodeList = new ArrayList<String>();
            for (UniqueCodeVO uniqueCodeVO : uniqueCodeVOList) {
                if (!ObjectUtil.isNotEmpty((Object)uniqueCodeVO.getUniqueCode())) continue;
                uniqueCodeList.add(uniqueCodeVO.getUniqueCode());
            }
            return uniqueCodeList;
        }
        return new ArrayList<String>();
    }

    public void workFromCallBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        InWarehouseManagementDO byId = (InWarehouseManagementDO)this.getById((Serializable)((Object)callBackVO.getBody().getBusinessKey()));
        Map taskVariables = callBackVO.getBody().getTaskVariables();
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Integer approveStatus;
                if (taskVariables.size() <= 0 || 2 != (approveStatus = (Integer)taskVariables.get("approveStatus"))) break;
                byId.setInWarehouseFormStatus(Integer.valueOf(2));
                this.updateById((Object)byId);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                byId.setInWarehouseFormStatus(Integer.valueOf(1));
                this.updateById((Object)byId);
                List inWarehouseManagementDetailDOS = this.inWarehouseManagementDetailService.list((Wrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)byId.getId()), InWarehouseManagementDetailDO::getMainId, (Object)byId.getId()));
                Long purchaseOrderId = byId.getPurchaseOrderId();
                PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderMapper.selectById((Serializable)purchaseOrderId);
                if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO)) {
                    purchaseOrderDO.setStatus(1);
                    this.purchaseOrderMapper.updateById((Object)purchaseOrderDO);
                }
                this.supplyUtils.inStocks(inWarehouseManagementDetailDOS, purchaseOrderDO.getProjectCode(), purchaseOrderDO);
                try {
                    ArrayList handlelnvoicingDtoList = new ArrayList();
                    inWarehouseManagementDetailDOS.forEach(a -> {
                        HandlelnvoicingDto handlelnvoicingDto = new HandlelnvoicingDto();
                        handlelnvoicingDto.setCount(a.getActualWarehouseingQuantity());
                        handlelnvoicingDto.setMaterialId(a.getMaterialId());
                        handlelnvoicingDto.setType(1);
                        handlelnvoicingDtoList.add(handlelnvoicingDto);
                    });
                    this.handleInvoicingStatistics.updateOutWarehouseDataHandle(handlelnvoicingDtoList);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public LambdaQueryWrapper getWrapper(InWarehouseManagementQuery inWarehouseManagementQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getIds()), InWarehouseManagementDO::getId, (Collection)inWarehouseManagementQuery.getIds())).like(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getInWarehouseNumber()), InWarehouseManagementDO::getInWarehouseNumber, (Object)inWarehouseManagementQuery.getInWarehouseNumber())).like(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getSubjectName()), InWarehouseManagementDO::getSubjectName, (Object)inWarehouseManagementQuery.getSubjectName())).eq(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getAttn()), InWarehouseManagementDO::getAttn, (Object)inWarehouseManagementQuery.getAttn())).eq(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getInWarehouseType()), InWarehouseManagementDO::getInWarehouseType, (Object)inWarehouseManagementQuery.getInWarehouseType())).ge(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getInWarehouseDate()), InWarehouseManagementDO::getInWarehouseDate, (Object)(inWarehouseManagementQuery.getInWarehouseDate() + " 00:00:00"))).le(ObjectUtil.isNotEmpty((Object)inWarehouseManagementQuery.getInWarehouseDate()), InWarehouseManagementDO::getInWarehouseDate, (Object)(inWarehouseManagementQuery.getInWarehouseDate() + " 23:59:59"))).orderByDesc(InWarehouseManagementDO::getCreateTime);
        return wrapper;
    }

    public String getInWarehouseManagementNumber() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(InWarehouseManagementDO::getInWarehouseNumber, (Object)"WZRK-")).orderByDesc(InWarehouseManagementDO::getCreateTime);
        List inWarehouseManagementDOList = this.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)inWarehouseManagementDOList)) {
            return "WZRK-" + simpleDateFormat.format(date) + "-001";
        }
        String recentInWarehouseNumber = ((InWarehouseManagementDO)this.list((Wrapper)wrapper).get(0)).getInWarehouseNumber();
        String substring = recentInWarehouseNumber.substring(recentInWarehouseNumber.length() - 3);
        String threeNumber = this.incrementString(substring);
        return "WZRK-" + simpleDateFormat.format(date) + "-" + threeNumber;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }
}

