/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.StringUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.core.domain.R;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.dto.supply.PurchaseOrderDemandDetailDTO;
import com.ruoyi.dto.supply.PurchaseOrderLogisticsInformationDTO;
import com.ruoyi.entity.supply.MaterialsApplicationHandleDetailDO;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.entity.supply.PurchaseOrderDemandDetailDO;
import com.ruoyi.entity.supply.PurchaseOrderLogisticsInformationDO;
import com.ruoyi.mapper.supply.OutWarehouseManagementMapper;
import com.ruoyi.mapper.supply.PurchaseOrderMapper;
import com.ruoyi.query.supply.PurchaseOrderQuery;
import com.ruoyi.service.supply.MaterialsApplicationHandleDetailService;
import com.ruoyi.service.supply.OutWarehouseManagementService;
import com.ruoyi.service.supply.PurchaseOrderDemandDetailService;
import com.ruoyi.service.supply.PurchaseOrderLogisticsInformationService;
import com.ruoyi.service.supply.PurchaseOrderService;
import com.ruoyi.service.supply.impl.PurchaseOrderServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.supply.MaterialNameListVO;
import com.ruoyi.vo.supply.PurchaseOrderExportVO;
import com.ruoyi.vo.supply.PurchaseOrderVO;
import com.ruoyi.vo.supply.RelatedPurchaseFormVO;
import com.ruoyi.vo.supply.WorkFlowCallBackVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PurchaseOrderServiceImpl
extends ServiceImpl<PurchaseOrderMapper, PurchaseOrderDO>
implements PurchaseOrderService {
    @Resource
    private PurchaseOrderLogisticsInformationService purchaseOrderLogisticsInformationService;
    @Resource
    private PurchaseOrderDemandDetailService purchaseOrderDemandDetailService;
    @Resource
    private MaterialsApplicationHandleDetailService materialsApplicationHandleDetailService;
    @Resource
    private OutWarehouseManagementMapper outWarehouseManagementMapper;
    @Resource
    private OutWarehouseManagementService outWarehouseManagementService;
    @Resource
    private WorkFlowService workFlowService;

    public PageResultVo<PurchaseOrderVO> getPurchaseOrderPageQuery(PurchaseOrderQuery purchaseOrderQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(purchaseOrderQuery);
        Page page = (Page)this.page((IPage)new Page((long)purchaseOrderQuery.getPageNum(), (long)purchaseOrderQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo purchaseOrderVOPageResultVo = new PageResultVo();
        ArrayList<PurchaseOrderVO> purchaseOrderVOList = new ArrayList<PurchaseOrderVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (PurchaseOrderDO purchaseOrderDO : resultVo.getData()) {
                PurchaseOrderVO purchaseOrderVO = new PurchaseOrderVO();
                BeanUtils.copyProperties((Object)purchaseOrderDO, (Object)purchaseOrderVO);
                purchaseOrderVOList.add(purchaseOrderVO);
            }
        }
        purchaseOrderVOPageResultVo.setData(purchaseOrderVOList);
        purchaseOrderVOPageResultVo.setPageSize(resultVo.getPageSize());
        purchaseOrderVOPageResultVo.setPageNum(resultVo.getPageNum());
        purchaseOrderVOPageResultVo.setTotal(resultVo.getTotal());
        purchaseOrderVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return purchaseOrderVOPageResultVo;
    }

    public void exportPurchaseOrder(PurchaseOrderQuery purchaseOrderQuery, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper wrapper = this.getWrapper(purchaseOrderQuery);
        List purchaseOrderDOList = this.list((Wrapper)wrapper);
        List<Object> purchaseOrderExportVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDOList)) {
            purchaseOrderExportVOList = purchaseOrderDOList.stream().map(m -> {
                PurchaseOrderExportVO purchaseOrderExportVO = new PurchaseOrderExportVO();
                BeanUtils.copyProperties((Object)m, (Object)purchaseOrderExportVO);
                if (m.getPurchaseStatus() == 0) {
                    purchaseOrderExportVO.setPurchaseStatus("\u5f85\u91c7\u8d2d");
                }
                if (m.getPurchaseStatus() == 1) {
                    purchaseOrderExportVO.setPurchaseStatus("\u5ba1\u6279\u4e2d");
                }
                if (m.getPurchaseStatus() == 2) {
                    purchaseOrderExportVO.setPurchaseStatus("\u91c7\u8d2d\u4e2d");
                }
                if (m.getPurchaseStatus() == 3) {
                    purchaseOrderExportVO.setPurchaseStatus("\u5df2\u5b8c\u6210");
                }
                if (m.getPurchaseType() == 0) {
                    purchaseOrderExportVO.setPurchaseType("\u529e\u516c\u7528\u54c1");
                }
                if (m.getPurchaseType() == 1) {
                    purchaseOrderExportVO.setPurchaseType("\u5e02\u573a\u6d3b\u52a8");
                }
                if (m.getPurchaseType() == 2) {
                    purchaseOrderExportVO.setPurchaseType("\u5bbd\u5e26\u91c7\u8d2d");
                }
                if (m.getPurchaseType() == 3) {
                    purchaseOrderExportVO.setPurchaseType("\u9879\u76ee\u91c7\u8d2d");
                }
                return purchaseOrderExportVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u91c7\u8d2d\u8ba2\u5355", "\u91c7\u8d2d\u8ba2\u5355", ExcelType.XSSF), PurchaseOrderExportVO.class, purchaseOrderExportVOList);
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u91c7\u8d2d\u8ba2\u5355");
    }

    public void purchaseApplication(PurchaseOrderDTO purchaseOrderDTO) throws Exception {
        PurchaseOrderDO purchaseOrderDO = new PurchaseOrderDO();
        BeanUtils.copyProperties((Object)purchaseOrderDTO, (Object)purchaseOrderDO);
        purchaseOrderDO.setCreateTime(new Date());
        purchaseOrderDO.setUpdateTime(new Date());
        purchaseOrderDO.setPurchaser(UserUtils.getLoginUser().getUsername());
        purchaseOrderDO.setCreateName(UserUtils.getLoginUser().getUsername());
        String generatePurchaseNumber = this.getGeneratePurchaseNumber();
        purchaseOrderDO.setPurchaseNumber(generatePurchaseNumber);
        purchaseOrderDO.setIsDeleted(Integer.valueOf(0));
        purchaseOrderDO.setPurchaseStatus(Integer.valueOf(0));
        ThemeUtils themes = new ThemeUtils();
        String s = ThemeUtils.getThemeName((String)"\u91c7\u8d2d\u7533\u8bf7");
        purchaseOrderDO.setSubjectName(s);
        this.save((Object)purchaseOrderDO);
        this.addPurchaseOrderLogisticsInformation(purchaseOrderDTO.getPurchaseOrderLogisticsInformationDTOList(), generatePurchaseNumber);
        this.addPurchaseOrderDemandDetail(purchaseOrderDTO.getPurchaseOrderDemandDetailDTOList(), generatePurchaseNumber);
        if (purchaseOrderDO.getPurchaseType() == 2) {
            ProcessDTO processDTO = new ProcessDTO();
            HashMap<String, Integer> stringStringHashMap = new HashMap<String, Integer>();
            stringStringHashMap.put("type", 0);
            processDTO.setFormData(stringStringHashMap);
            processDTO.setProcessInstanceName(s);
            processDTO.setProjectName(purchaseOrderDO.getProjectName());
            processDTO.setBusinessKey(purchaseOrderDO.getId().toString());
            String processId = this.workFlowService.startProcess(ProcessEnum.purchasing_requisition_broadband, processDTO, new Object[]{purchaseOrderDO.getId().toString()});
            System.out.println(processId);
            if (ObjectUtil.isNotEmpty((Object)processId)) {
                purchaseOrderDO.setProcessInstId(processId);
                this.updateById((Object)purchaseOrderDO);
            }
        } else {
            ProcessDTO processDTO = new ProcessDTO();
            processDTO.setProcessInstanceName(s);
            processDTO.setProjectName(purchaseOrderDO.getProjectName());
            processDTO.setBusinessKey(purchaseOrderDO.getId().toString());
            String processId = this.workFlowService.startProcess(ProcessEnum.purchasing_requisition, processDTO, new Object[]{purchaseOrderDO.getId().toString()});
            System.out.println(processId);
            if (ObjectUtil.isNotEmpty((Object)processId)) {
                purchaseOrderDO.setProcessInstId(processId);
                this.updateById((Object)purchaseOrderDO);
            }
        }
    }

    public void executiveApproval(PurchaseOrderDTO purchaseOrderDTO) {
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getById((Serializable)purchaseOrderDTO.getId());
        purchaseOrderDO.setPurchaseStatus(purchaseOrderDTO.getPurchaseStatus());
        purchaseOrderDO.setUpdateTime(new Date());
        purchaseOrderDO.setRejectReason(purchaseOrderDTO.getRejectReason());
        this.updateById((Object)purchaseOrderDO);
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO.getAssociatedMaterialApplicationOrderId())) {
            MaterialsApplicationHandleDetailDO materialsApplicationHandleDetailDO = new MaterialsApplicationHandleDetailDO();
            materialsApplicationHandleDetailDO.setMainId(purchaseOrderDO.getAssociatedMaterialApplicationOrderId());
            materialsApplicationHandleDetailDO.setPurchaseNumber(purchaseOrderDO.getPurchaseNumber());
            materialsApplicationHandleDetailDO.setHandleTime(new Date());
            materialsApplicationHandleDetailDO.setHandleInformation("\u91c7\u8d2d\u8ba2\u5355\u5df2\u63d0\u4ea4\uff0c\u91c7\u8d2d\u4eba\uff1a\u54d2\u54d2;");
            materialsApplicationHandleDetailDO.setCreateTime(new Date());
            materialsApplicationHandleDetailDO.setUpdateTime(new Date());
            materialsApplicationHandleDetailDO.setIsDeleted(Integer.valueOf(0));
            this.materialsApplicationHandleDetailService.save((Object)materialsApplicationHandleDetailDO);
        }
    }

    public PurchaseOrderVO getDetail(Long id) {
        PurchaseOrderVO purchaseOrderVO = new PurchaseOrderVO();
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getById((Serializable)id);
        BeanUtils.copyProperties((Object)purchaseOrderDO, (Object)purchaseOrderVO);
        List purchaseOrderLogisticsInformationDOList = this.getPurchaseOrderLogisticsInformation(id);
        purchaseOrderVO.setPurchaseOrderLogisticsInformationDOList(purchaseOrderLogisticsInformationDOList);
        List purchaseOrderDemandDetailDOList = this.getPurchaseOrderDemandDetail(id);
        purchaseOrderVO.setPurchaseOrderDemandDetailDOList(purchaseOrderDemandDetailDOList);
        return purchaseOrderVO;
    }

    public void executiveEditor(PurchaseOrderDTO purchaseOrderDTO) {
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getById((Serializable)purchaseOrderDTO.getId());
        BeanUtils.copyProperties((Object)purchaseOrderDTO, (Object)purchaseOrderDO);
        purchaseOrderDO.setUpdateTime(new Date());
        this.updateById((Object)purchaseOrderDO);
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDTO.getPurchaseOrderLogisticsInformationDTOList())) {
            this.editorPurchaseOrderLogisticsInformation(purchaseOrderDTO.getPurchaseOrderLogisticsInformationDTOList(), purchaseOrderDTO.getId());
        }
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDTO.getPurchaseOrderDemandDetailDTOList())) {
            this.editorPurchaseOrderDemandDetail(purchaseOrderDTO.getPurchaseOrderDemandDetailDTOList(), purchaseOrderDTO.getId());
        }
    }

    public void initiatingOperation(Long id) {
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getById((Serializable)id);
        purchaseOrderDO.setPurchaseStatus(Integer.valueOf(0));
        purchaseOrderDO.setUpdateTime(new Date());
        this.updateById((Object)purchaseOrderDO);
    }

    public Map<Long, String> getPurchaseList() {
        List purchaseOrderDOList = this.list();
        if (ObjectUtil.isEmpty((Object)purchaseOrderDOList)) {
            return null;
        }
        Map<Long, String> purchaseNameList = purchaseOrderDOList.stream().filter(purchaseOrderDO -> purchaseOrderDO.getSubjectName() != null && !purchaseOrderDO.getSubjectName().isEmpty()).collect(Collectors.toMap(PurchaseOrderDO::getId, PurchaseOrderDO::getSubjectName, (existing, replacement) -> existing));
        return purchaseNameList;
    }

    public List<RelatedPurchaseFormVO> getRelatedPurchaseFormList() {
        List purchaseOrderDOList = this.list((Wrapper)new LambdaQueryWrapper().orderByDesc(PurchaseOrderDO::getCreateTime));
        List<RelatedPurchaseFormVO> relatedPurchaseFormVOList = purchaseOrderDOList.stream().map(m -> {
            RelatedPurchaseFormVO relatedPurchaseFormVO = new RelatedPurchaseFormVO();
            relatedPurchaseFormVO.setAssociatedPurchaseOrdersId(m.getId());
            relatedPurchaseFormVO.setAssociatedPurchaseOrders(m.getSubjectName());
            relatedPurchaseFormVO.setPurchaseNumber(m.getPurchaseNumber());
            return relatedPurchaseFormVO;
        }).collect(Collectors.toList());
        return relatedPurchaseFormVOList;
    }

    public void workFromCallBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        String businessKey = callBackVO.getBody().getBusinessKey();
        PurchaseOrderDO purchaseOrder = (PurchaseOrderDO)this.getById((Serializable)((Object)businessKey));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                String string1 = taskVariables.get("approveStatus").toString();
                if (string1.equals("2")) {
                    String string = (String)taskVariables.get("targetNode");
                    if (string.toString().equals("Activity_0onlffm")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(0));
                    }
                    if (string.toString().equals("Activity_1szw46j")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    this.updateById((Object)purchaseOrder);
                    break;
                }
                long l = purchaseOrder.getPurchaseStatus() + 1;
                purchaseOrder.setPurchaseStatus(Integer.valueOf((int)l));
                this.updateById((Object)purchaseOrder);
                break;
            }
            case 3: {
                purchaseOrder.setPurchaseStatus(Integer.valueOf(3));
                this.updateById((Object)purchaseOrder);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public void workFromCallBackTwo(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        String businessKey = callBackVO.getBody().getBusinessKey();
        PurchaseOrderDO purchaseOrder = (PurchaseOrderDO)this.getById((Serializable)((Object)businessKey));
        switch (1.$SwitchMap$com$ruoyi$vo$supply$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                Map taskVariables = callBackVO.getBody().getTaskVariables();
                String string1 = taskVariables.get("approveStatus").toString();
                if (string1.equals("2")) {
                    String string = (String)taskVariables.get("targetNode");
                    if (string.toString().equals("Activity_1grnf27")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(0));
                    }
                    if (string.toString().equals("Activity_1873bl3")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (string.toString().equals("Activity_14t41qp")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (string.toString().equals("Activity_040d77q")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (string.toString().equals("Activity_11fqrtm")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (string.toString().equals("Activity_1xgddrb")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (string.toString().equals("Activity_0ck3jvy")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (string.toString().equals("Activity_1gnpvd6")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    this.updateById((Object)purchaseOrder);
                    break;
                }
                String fromUrl = JSONObject.toJSONString(callBackVO.getBody().getProcessVariables().get("fromUrl"));
                if (StringUtils.isNotBlank((String)fromUrl)) {
                    String[] taskKey = fromUrl.split("taskKey=");
                    String jiedian = taskKey[1].split("&")[0];
                    if (jiedian.equals("Activity_1grnf27")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(0));
                    }
                    if (jiedian.equals("Activity_1873bl3")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (jiedian.equals("Activity_14t41qp")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (jiedian.equals("Activity_040d77q")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(1));
                    }
                    if (jiedian.equals("Activity_11fqrtm")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (jiedian.equals("Activity_1xgddrb")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (jiedian.equals("Activity_0ck3jvy")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                    if (jiedian.equals("Activity_1gnpvd6")) {
                        purchaseOrder.setPurchaseStatus(Integer.valueOf(2));
                    }
                }
                this.updateById((Object)purchaseOrder);
                break;
            }
            case 3: {
                purchaseOrder.setPurchaseStatus(Integer.valueOf(3));
                this.updateById((Object)purchaseOrder);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void editorPurchaseOrderDemandDetail(List<PurchaseOrderDemandDetailDTO> purchaseOrderDemandDetailDTOList, Long id) {
        this.purchaseOrderDemandDetailService.remove((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
        List purchaseOrderLogisticsInformationDOList = purchaseOrderDemandDetailDTOList.stream().map(m -> {
            PurchaseOrderDemandDetailDO purchaseOrderDemandDetailDO = new PurchaseOrderDemandDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)purchaseOrderDemandDetailDO);
            purchaseOrderDemandDetailDO.setCreateTime(new Date());
            purchaseOrderDemandDetailDO.setMainId(id);
            return purchaseOrderDemandDetailDO;
        }).collect(Collectors.toList());
        this.purchaseOrderDemandDetailService.saveBatch(purchaseOrderLogisticsInformationDOList);
    }

    private void editorPurchaseOrderLogisticsInformation(List<PurchaseOrderLogisticsInformationDTO> purchaseOrderLogisticsInformationDTOList, Long id) {
        this.purchaseOrderLogisticsInformationService.remove((Wrapper)new QueryWrapper().eq((Object)"main_id", (Object)id));
        List purchaseOrderLogisticsInformationDOList = purchaseOrderLogisticsInformationDTOList.stream().map(m -> {
            PurchaseOrderLogisticsInformationDO purchaseOrderLogisticsInformationDO = new PurchaseOrderLogisticsInformationDO();
            BeanUtils.copyProperties((Object)m, (Object)purchaseOrderLogisticsInformationDO);
            purchaseOrderLogisticsInformationDO.setCreateTime(new Date());
            purchaseOrderLogisticsInformationDO.setMainId(id);
            return purchaseOrderLogisticsInformationDO;
        }).collect(Collectors.toList());
        this.purchaseOrderLogisticsInformationService.saveBatch(purchaseOrderLogisticsInformationDOList);
    }

    private List<PurchaseOrderDemandDetailDO> getPurchaseOrderDemandDetail(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderDemandDetailDO::getMainId, (Object)id);
        return this.purchaseOrderDemandDetailService.list((Wrapper)wrapper);
    }

    private List<PurchaseOrderLogisticsInformationDO> getPurchaseOrderLogisticsInformation(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderLogisticsInformationDO::getMainId, (Object)id);
        return this.purchaseOrderLogisticsInformationService.list((Wrapper)wrapper);
    }

    private LambdaQueryWrapper getWrapper(PurchaseOrderQuery purchaseOrderQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().ge(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseStartDate()), PurchaseOrderDO::getPurchaseDate, (Object)purchaseOrderQuery.getPurchaseStartDate())).le(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseEndDate()), PurchaseOrderDO::getPurchaseDate, (Object)purchaseOrderQuery.getPurchaseEndDate())).in(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getIds()), PurchaseOrderDO::getId, (Collection)purchaseOrderQuery.getIds())).like(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaser()), PurchaseOrderDO::getPurchaser, (Object)purchaseOrderQuery.getPurchaser())).like(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseNumber()), PurchaseOrderDO::getPurchaseNumber, (Object)purchaseOrderQuery.getPurchaseNumber())).eq(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseType()), PurchaseOrderDO::getPurchaseType, (Object)purchaseOrderQuery.getPurchaseType())).eq(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseStatus()), PurchaseOrderDO::getPurchaseStatus, (Object)purchaseOrderQuery.getPurchaseStatus())).eq(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getAssociatedProjects()), PurchaseOrderDO::getProjectName, (Object)purchaseOrderQuery.getAssociatedProjects())).eq(ObjectUtil.isNotEmpty((Object)purchaseOrderQuery.getPurchaseStatus()), PurchaseOrderDO::getPurchaseStatus, (Object)purchaseOrderQuery.getPurchaseStatus())).orderByDesc(PurchaseOrderDO::getCreateTime);
        return wrapper;
    }

    private void addPurchaseOrderLogisticsInformation(List<PurchaseOrderLogisticsInformationDTO> purchaseOrderLogisticsInformationDTO, String purchaseNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)purchaseNumber), PurchaseOrderDO::getPurchaseNumber, (Object)purchaseNumber);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getOne((Wrapper)wrapper);
        List purchaseOrderLogisticsInformationDOList = purchaseOrderLogisticsInformationDTO.stream().map(m -> {
            PurchaseOrderLogisticsInformationDO purchaseOrderLogisticsInformationDO = new PurchaseOrderLogisticsInformationDO();
            BeanUtils.copyProperties((Object)m, (Object)purchaseOrderLogisticsInformationDO);
            purchaseOrderLogisticsInformationDO.setCreateTime(new Date());
            purchaseOrderLogisticsInformationDO.setUpdateTime(new Date());
            purchaseOrderLogisticsInformationDO.setIsDeleted(Integer.valueOf(0));
            if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO)) {
                purchaseOrderLogisticsInformationDO.setMainId(purchaseOrderDO.getId());
            }
            return purchaseOrderLogisticsInformationDO;
        }).collect(Collectors.toList());
        this.purchaseOrderLogisticsInformationService.saveBatch(purchaseOrderLogisticsInformationDOList);
    }

    private void addPurchaseOrderDemandDetail(List<PurchaseOrderDemandDetailDTO> purchaseOrderDemandDetailDTOList, String purchaseNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)purchaseNumber), PurchaseOrderDO::getPurchaseNumber, (Object)purchaseNumber);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.getOne((Wrapper)wrapper);
        List purchaseOrderDemandDetailDOList = purchaseOrderDemandDetailDTOList.stream().map(m -> {
            PurchaseOrderDemandDetailDO purchaseOrderDemandDetailDO = new PurchaseOrderDemandDetailDO();
            BeanUtils.copyProperties((Object)m, (Object)purchaseOrderDemandDetailDO);
            purchaseOrderDemandDetailDO.setIsDeleted(Integer.valueOf(0));
            purchaseOrderDemandDetailDO.setCreateTime(new Date());
            purchaseOrderDemandDetailDO.setUpdateTime(new Date());
            if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO)) {
                purchaseOrderDemandDetailDO.setMainId(purchaseOrderDO.getId());
            }
            return purchaseOrderDemandDetailDO;
        }).collect(Collectors.toList());
        this.purchaseOrderDemandDetailService.saveBatch(purchaseOrderDemandDetailDOList);
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }

    public String getGeneratePurchaseNumber() {
        Integer count = ((PurchaseOrderMapper)this.baseMapper).selectCountInToday();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return "CGDD-" + dateFormat.format(new Date()) + "-" + String.format("%03d", count + 1);
    }

    public R importMaterialsApplication(MultipartFile file, SupplyUtils supplyUtils) {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), PurchaseOrderDemandDetailDO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        List demandImportList = importResult.getList();
        ArrayList<PurchaseOrderDemandDetailDO> list = new ArrayList<PurchaseOrderDemandDetailDO>();
        if (ObjectUtil.isNotEmpty((Object)demandImportList)) {
            List materialNameListVOList = supplyUtils.getThreeLevelMaterialNameList();
            long count = demandImportList.stream().map(PurchaseOrderDemandDetailDO::getMaterialName).distinct().count();
            if (count != (long)demandImportList.size()) {
                return R.fail((String)"\u5b58\u5728\u7269\u8d44\u540d\u79f0\u91cd\u590d");
            }
            for (int i = 0; i < demandImportList.size(); ++i) {
                PurchaseOrderDemandDetailDO detailDO = new PurchaseOrderDemandDetailDO();
                PurchaseOrderDemandDetailDO demandImport = (PurchaseOrderDemandDetailDO)demandImportList.get(i);
                if (com.alibaba.cloud.commons.lang.StringUtils.isBlank((CharSequence)demandImport.getMaterialName())) {
                    return R.fail((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u65e0\u6570\u636e"));
                }
                String[] materialName = demandImport.getMaterialName().split(">>");
                List<String> materialNames = Arrays.asList(materialName);
                List materialList = materialNameListVOList;
                ArrayList<String> ids = new ArrayList<String>();
                for (int j = 0; j < materialNames.size(); ++j) {
                    int finalJ = j;
                    MaterialNameListVO materialNameListVO = materialList.stream().filter(f -> ((String)materialNames.get(finalJ)).equals(f.getMaterialName())).findFirst().orElse(null);
                    if (ObjectUtil.isEmpty((Object)materialNameListVO)) {
                        return R.fail((String)("\u7b2c" + (i + 2) + "\u884c\u7269\u8d44\u540d\u79f0\u672a\u914d\u7f6e\u7cfb\u7edf\u6570\u636e"));
                    }
                    ids.add(materialNameListVO.getMaterialId().toString());
                    materialList = materialNameListVO.getMaterialNameListVOList();
                    if (j != materialNames.size() - 1) continue;
                    detailDO.setMaterialId(materialNameListVO.getMaterialId());
                    detailDO.setMaterialIdLevel(JSON.toJSONString(ids));
                    detailDO.setMaterialName(demandImport.getMaterialName());
                    detailDO.setUnit(materialNameListVO.getUnitMeasurement());
                }
                detailDO.setDemandCount(demandImport.getDemandCount());
                detailDO.setPurchaseCount(demandImport.getPurchaseCount());
                detailDO.setPrice(demandImport.getPrice());
                detailDO.setSupplier(demandImport.getSupplier());
                detailDO.setRemark(demandImport.getRemark());
                list.add(detailDO);
            }
            return R.ok(list);
        }
        return R.fail((String)"\u5bfc\u5165\u5931\u8d25");
    }
}

