/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.supply.OutWarehouseManagementDemandDetailDTO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.mapper.supply.StockListMapper;
import com.ruoyi.query.supply.StockListQuery;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.supply.StockExportVO;
import com.ruoyi.vo.supply.StockListVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class StockListServiceImpl
extends ServiceImpl<StockListMapper, StockListDO>
implements StockListService {
    @Resource
    private MaterialArchivesService materialArchivesService;

    public PageResultVo<StockListVO> getStockListVoPage(StockListQuery stockListQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(stockListQuery);
        Page page = (Page)this.page((IPage)new Page((long)stockListQuery.getPageNum(), (long)stockListQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo stockListVOPageResultVo = new PageResultVo();
        ArrayList<StockListVO> stockListVOList = new ArrayList<StockListVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (StockListDO stockListDO : resultVo.getData()) {
                StockListVO stockListVO = new StockListVO();
                BeanUtils.copyProperties((Object)stockListDO, (Object)stockListVO);
                stockListVO.setReferencePrice(stockListDO.getReferencePrice());
                stockListVOList.add(stockListVO);
            }
        }
        stockListVOPageResultVo.setData(stockListVOList);
        stockListVOPageResultVo.setPageSize(resultVo.getPageSize());
        stockListVOPageResultVo.setPageNum(resultVo.getPageNum());
        stockListVOPageResultVo.setTotal(resultVo.getTotal());
        stockListVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return stockListVOPageResultVo;
    }

    public List<StockExportVO> exportStock(StockListQuery stockListQuery, HttpServletResponse response) {
        LambdaQueryWrapper wrapper = this.getWrapper(stockListQuery);
        List stockListDOList = this.list((Wrapper)wrapper);
        List<Object> stockListExport = new ArrayList<StockExportVO>();
        if (ObjectUtil.isNotEmpty((Object)stockListDOList)) {
            stockListExport = stockListDOList.stream().map(m -> {
                StockExportVO stockExportVO = new StockExportVO();
                BeanUtils.copyProperties((Object)m, (Object)stockExportVO);
                return stockExportVO;
            }).collect(Collectors.toList());
        }
        return stockListExport;
    }

    public Long getMaterialStockCount(String materialName) {
        LambdaQueryWrapper stockListDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)materialName), StockListDO::getMaterialName, (Object)materialName);
        Long currentMaterialStockCount = ((StockListDO)this.getOne((Wrapper)stockListDOLambdaQueryWrapper)).getCurrentStock();
        return currentMaterialStockCount;
    }

    public List<String> getMaterialName(Long materialTypeId) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialCategoryId, (Object)materialTypeId);
        List<String> materialName = this.list((Wrapper)wrapper).stream().map(m -> m.getMaterialName()).collect(Collectors.toList());
        return materialName;
    }

    public StockListVO getDemandDetail(String materialName) {
        String name = materialName.split("-")[2];
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialName, (Object)name);
        StockListDO stockListDO = (StockListDO)this.getOne((Wrapper)wrapper);
        StockListVO stockListVO = new StockListVO();
        BeanUtils.copyProperties((Object)stockListDO, (Object)stockListVO);
        return stockListVO;
    }

    private LambdaQueryWrapper getWrapper(StockListQuery stockListQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)stockListQuery.getId()), StockListDO::getId, (Object)stockListQuery.getId())).eq(ObjectUtil.isNotEmpty((Object)stockListQuery.getMaterialCategoryId()), StockListDO::getMaterialCategoryId, (Object)stockListQuery.getMaterialCategoryId())).like(ObjectUtil.isNotEmpty((Object)stockListQuery.getMaterialNumber()), StockListDO::getMaterialNumber, (Object)stockListQuery.getMaterialNumber())).like(ObjectUtil.isNotEmpty((Object)stockListQuery.getMaterialName()), StockListDO::getMaterialName, (Object)stockListQuery.getMaterialName())).orderByDesc(StockListDO::getCreateTime);
        return wrapper;
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%04d", ++number);
    }

    public void updateStockCount(List<OutWarehouseManagementDemandDetailDTO> outWarehouseManagementDemandDetailDTOList) {
        if (ObjectUtil.isEmpty(outWarehouseManagementDemandDetailDTOList)) {
            return;
        }
        ArrayList<StockListDO> stockListDOList = new ArrayList<StockListDO>();
        for (OutWarehouseManagementDemandDetailDTO outWarehouseManagementDemandDetailDTO : outWarehouseManagementDemandDetailDTOList) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)outWarehouseManagementDemandDetailDTO.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.getOne((Wrapper)wrapper);
            if (!ObjectUtil.isNotEmpty((Object)stockListDO)) continue;
            Long currentStock = stockListDO.getCurrentStock();
            stockListDO.setCurrentStock(Long.valueOf(currentStock - outWarehouseManagementDemandDetailDTO.getDeliveryFromStorageCount()));
            stockListDO.setUpdateTime(new Date());
            stockListDOList.add(stockListDO);
        }
        this.updateBatchById(stockListDOList);
    }

    public String updates(StockListDO stockListDO) {
        MaterialArchivesDO byId = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)stockListDO.getMaterialId());
        if (stockListDO.getMaterialName() != null) {
            byId.setMaterialName(stockListDO.getMaterialName());
        }
        if (stockListDO.getMaterialNumber() != null) {
            byId.setMaterialNumber(stockListDO.getMaterialNumber());
        }
        if (stockListDO.getReferencePrice() != null) {
            byId.setReferencePrice(stockListDO.getReferencePrice());
        }
        if (stockListDO.getUnitMeasurement() != null) {
            byId.setUnitMeasurement(stockListDO.getUnitMeasurement());
        }
        if (stockListDO.getAssociatedSupplier() != null) {
            byId.setAssociatedSupplier(stockListDO.getAssociatedSupplier());
        }
        byId.setUpdateTime(new Date());
        this.materialArchivesService.updateById((Object)byId);
        stockListDO.setUpdateTime(new Date());
        boolean b = this.updateById((Object)stockListDO);
        if (b) {
            return "true";
        }
        return "\u4fee\u6539\u5931\u8d25";
    }

    public Long getStockCount(Long materialId) {
        StockListDO stockListDO = (StockListDO)this.getOne((Wrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)materialId));
        return stockListDO.getCurrentStock();
    }
}

