/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.supply.impl;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.ExcelImportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.ImportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.result.ExcelImportResult;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.nacos.common.packagescan.resource.ClassPathResource;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.supply.SupplierArchiveDTO;
import com.ruoyi.entity.supply.SupplierArchiveDO;
import com.ruoyi.mapper.supply.SupplierArchiveMapper;
import com.ruoyi.query.supply.SupplierArchiveQuery;
import com.ruoyi.service.supply.SupplierArchiveService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SupplyUtils;
import com.ruoyi.vo.supply.SupplierArchiveVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SupplierArchiveServiceImpl
extends ServiceImpl<SupplierArchiveMapper, SupplierArchiveDO>
implements SupplierArchiveService {
    private static final Logger log = LoggerFactory.getLogger(SupplierArchiveServiceImpl.class);
    @Resource
    private SupplyUtils supplyUtils;

    public PageResultVo<SupplierArchiveVO> pageList(SupplierArchiveQuery supplierArchiveQuery) {
        LambdaQueryWrapper wrapper = this.getWrapper(supplierArchiveQuery);
        Page page = (Page)this.page((IPage)new Page((long)supplierArchiveQuery.getPageNum(), (long)supplierArchiveQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo supplierArchiveVOPageResultVo = new PageResultVo();
        ArrayList<SupplierArchiveVO> supplierArchiveVOList = new ArrayList<SupplierArchiveVO>();
        if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
            for (SupplierArchiveDO supplierArchiveDO : resultVo.getData()) {
                SupplierArchiveVO supplierArchiveVO = new SupplierArchiveVO();
                BeanUtils.copyProperties((Object)supplierArchiveDO, (Object)supplierArchiveVO);
                supplierArchiveVOList.add(supplierArchiveVO);
            }
        }
        supplierArchiveVOPageResultVo.setData(supplierArchiveVOList);
        supplierArchiveVOPageResultVo.setPageSize(resultVo.getPageSize());
        supplierArchiveVOPageResultVo.setPageNum(resultVo.getPageNum());
        supplierArchiveVOPageResultVo.setTotal(resultVo.getTotal());
        supplierArchiveVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return supplierArchiveVOPageResultVo;
    }

    public void updateStatus(SupplierArchiveDTO supplierArchiveDTO) {
        try {
            SupplierArchiveDO supplierArchiveDO = (SupplierArchiveDO)this.getById((Serializable)supplierArchiveDTO.getId());
            if (ObjectUtil.isNotEmpty((Object)supplierArchiveDO)) {
                supplierArchiveDO.setStatus(supplierArchiveDTO.getStatus());
                this.updateById((Object)supplierArchiveDO);
            }
        }
        catch (Exception e) {
            log.info("\u4fee\u6539\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }

    public void add(SupplierArchiveDTO supplierArchiveDTO) {
        SupplierArchiveDO supplierArchiveDO = new SupplierArchiveDO();
        BeanUtils.copyProperties((Object)supplierArchiveDTO, (Object)supplierArchiveDO);
        supplierArchiveDO.setCreateTime(new Date());
        supplierArchiveDO.setUpdateTime(new Date());
        supplierArchiveDO.setStatus(Integer.valueOf(0));
        supplierArchiveDO.setIsDeleted(Integer.valueOf(0));
        supplierArchiveDO.setSupplierNumber(this.getSupplierArchiveNumber(supplierArchiveDTO.getCity()));
        this.save((Object)supplierArchiveDO);
    }

    public void exportExcel(SupplierArchiveQuery supplierArchiveQuery, HttpServletResponse response) throws IOException {
        LambdaQueryWrapper wrapper = this.getWrapper(supplierArchiveQuery);
        List supplierArchiveDOList = this.list((Wrapper)wrapper);
        List<Object> supplierArchiveVOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)supplierArchiveDOList)) {
            supplierArchiveVOList = supplierArchiveDOList.stream().map(supplierArchiveDO -> {
                SupplierArchiveVO supplierArchiveVO = new SupplierArchiveVO();
                BeanUtils.copyProperties((Object)supplierArchiveDO, (Object)supplierArchiveVO);
                return supplierArchiveVO;
            }).collect(Collectors.toList());
        }
        Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u4f9b\u5e94\u5546\u6863\u6848", "\u4f9b\u5e94\u5546\u6863\u6848", ExcelType.XSSF), SupplierArchiveVO.class, supplierArchiveVOList);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)("\u4f9b\u5e94\u5546\u6863\u6848-" + dateFormat.format(date)));
    }

    public List<SupplierArchiveVO> getSupplierNameList() {
        List supplierArchiveDOList = this.list();
        if (ObjectUtil.isEmpty((Object)supplierArchiveDOList)) {
            return new ArrayList<SupplierArchiveVO>();
        }
        List<SupplierArchiveVO> supplierNameList = supplierArchiveDOList.stream().map(m -> {
            Long id = m.getId();
            String supplierName = m.getSupplierName();
            String detailAddress = m.getDetailAddress();
            SupplierArchiveVO supplierArchiveVO = new SupplierArchiveVO();
            supplierArchiveVO.setId(id);
            supplierArchiveVO.setSupplierName(supplierName);
            supplierArchiveVO.setDetailAddress(detailAddress);
            return supplierArchiveVO;
        }).collect(Collectors.toList());
        return supplierNameList;
    }

    public String importSupplierArchive(MultipartFile file) {
        ExcelImportResult importResult;
        ImportParams importParams = new ImportParams();
        importParams.setNeedVerify(true);
        try {
            importResult = ExcelImportUtil.importExcelMore((InputStream)file.getInputStream(), SupplierArchiveVO.class, (ImportParams)importParams);
        }
        catch (Exception e) {
            return "\u5bfc\u5165\u5931\u8d25\uff0c\u8868\u683c\u683c\u5f0f\u4e0d\u5bf9";
        }
        List supplierArchiveVOList = importResult.getList();
        ArrayList<SupplierArchiveDO> supplierArchiveDOList = new ArrayList<SupplierArchiveDO>();
        for (SupplierArchiveVO supplierArchiveVO : supplierArchiveVOList) {
            if (StringUtils.isEmpty((CharSequence)supplierArchiveVO.getSupplierName())) {
                return "\u4f9b\u5e94\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a";
            }
            if (StringUtils.isEmpty((CharSequence)supplierArchiveVO.getSupplierType())) {
                return "\u4f9b\u5e94\u5546\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a";
            }
            SupplierArchiveDO supplierArchiveDO = new SupplierArchiveDO();
            BeanUtils.copyProperties((Object)supplierArchiveVO, (Object)supplierArchiveDO);
            String supplierType = supplierArchiveDO.getSupplierType();
            if (!supplierType.equals("\u5b9e\u7269") && !supplierType.equals("\u865a\u62df")) {
                return "\u4f9b\u5e94\u5546\u7c7b\u578b\u4e0d\u662f\u5b9e\u7269\u548c\u865a\u62df";
            }
            supplierArchiveDO.setStatus(Integer.valueOf(0));
            supplierArchiveDOList.add(supplierArchiveDO);
        }
        for (SupplierArchiveDO supplierArchiveDO : supplierArchiveDOList) {
            String supplierArchiveNumber = this.getSupplierArchiveNumber(supplierArchiveDO.getCity());
            supplierArchiveDO.setSupplierNumber(supplierArchiveNumber);
            supplierArchiveDO.setCreateTime(new Date());
            supplierArchiveDO.setUpdateTime(new Date());
            supplierArchiveDO.setIsDeleted(Integer.valueOf(0));
            this.save((Object)supplierArchiveDO);
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, String fileName) throws UnsupportedEncodingException {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u4f9b\u5e94\u5546\u6863\u6848\u5bfc\u5165\u6a21\u677f.xls", "UTF-8"));
        InputStream input = null;
        OutputStream output = null;
        try {
            InputStream inputStream;
            ClassPathResource classPathResource = new ClassPathResource(fileName);
            input = inputStream = classPathResource.getInputStream();
            output = response.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<SupplierArchiveVO> getSupplier() {
        List supplierArchiveDOList = this.list((Wrapper)new LambdaQueryWrapper().eq(SupplierArchiveDO::getStatus, (Object)0));
        supplierArchiveDOList = supplierArchiveDOList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SupplierArchiveDO>(Comparator.comparing(SupplierArchiveDO::getSupplierName))), ArrayList::new));
        List<SupplierArchiveVO> supplierArchiveVOList = supplierArchiveDOList.stream().map(m -> {
            SupplierArchiveVO supplierArchiveVO = new SupplierArchiveVO();
            supplierArchiveVO.setId(m.getId());
            supplierArchiveVO.setSupplierName(m.getSupplierName());
            return supplierArchiveVO;
        }).collect(Collectors.toList());
        return supplierArchiveVOList;
    }

    public void editor(SupplierArchiveDTO supplierArchiveDTO) {
        SupplierArchiveDO supplierArchiveDO = (SupplierArchiveDO)this.getById((Serializable)supplierArchiveDTO.getId());
        BeanUtils.copyProperties((Object)supplierArchiveDTO, (Object)supplierArchiveDO);
        supplierArchiveDO.setUpdateTime(new Date());
        this.updateById((Object)supplierArchiveDO);
    }

    public SupplierArchiveDO queryDetail(SupplierArchiveDTO supplierArchiveDTO) {
        return (SupplierArchiveDO)this.getById((Serializable)supplierArchiveDTO.getId());
    }

    public LambdaQueryWrapper<SupplierArchiveDO> getWrapper(SupplierArchiveQuery supplierArchiveQuery) {
        LambdaQueryWrapper supplierArchiveDOLambdaQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)supplierArchiveQuery.getSupplierName()), SupplierArchiveDO::getSupplierName, (Object)supplierArchiveQuery.getSupplierName())).like(ObjectUtil.isNotEmpty((Object)supplierArchiveQuery.getSupplierNumber()), SupplierArchiveDO::getSupplierNumber, (Object)supplierArchiveQuery.getSupplierNumber())).eq(ObjectUtil.isNotEmpty((Object)supplierArchiveQuery.getCity()), SupplierArchiveDO::getCity, (Object)supplierArchiveQuery.getCity())).like(ObjectUtil.isNotEmpty((Object)supplierArchiveQuery.getContactPerson()), SupplierArchiveDO::getContactPerson, (Object)supplierArchiveQuery.getContactPerson())).like(ObjectUtil.isNotEmpty((Object)supplierArchiveQuery.getDetailAddress()), SupplierArchiveDO::getDetailAddress, (Object)supplierArchiveQuery.getDetailAddress())).orderByDesc(SupplierArchiveDO::getId);
        return supplierArchiveDOLambdaQueryWrapper;
    }

    public String getSupplierArchiveNumber(String city) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(SupplierArchiveDO::getSupplierNumber, (Object)"YYGYS-")).orderByDesc(SupplierArchiveDO::getCreateTime);
        if (ObjectUtil.isEmpty((Object)city)) {
            Integer count = ((SupplierArchiveMapper)this.baseMapper).selectCountInToday();
            return "YYGYS-" + String.format("%04d", count + 1);
        }
        String cityCode = this.supplyUtils.getCityCode(city);
        if (ObjectUtil.isEmpty((Object)this.list((Wrapper)wrapper))) {
            return "YYGYS-" + cityCode + "-001";
        }
        Integer count = ((SupplierArchiveMapper)this.baseMapper).selectCountInToday();
        return "YYGYS-" + cityCode + "-" + String.format("%04d", count + 1);
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%04d", ++number);
    }
}

